<?php

/**
 * This is the model class for table "{{transfers}}".
 *
 * The followings are the available columns in table '{{transfers}}':
 * @property integer $id
 * @property string $delivery_notes
 * @property string $bill_of_exit
 * @property integer $ta_no
 * @property string $isInernal
 * @property integer $created_by
 * @property string $created_datetime
 */
class Transfers extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{transfers}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('delivery_notes, bill_of_exit, ta_no, created_by, created_datetime', 'required'),
			array('ta_no, created_by', 'numerical', 'integerOnly'=>true),
			array('bill_of_exit', 'length', 'max'=>255),
			array('isInernal', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, delivery_notes, bill_of_exit, ta_no, isInernal, created_by, created_datetime', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'delivery_notes' => 'Delivery Notes',
			'bill_of_exit' => 'Bill Of Exit',
			'ta_no' => 'Ta No',
			'isInernal' => 'Is Inernal',
			'created_by' => 'Created By',
			'created_datetime' => 'Created Datetime',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('delivery_notes',$this->delivery_notes,true);
		$criteria->compare('bill_of_exit',$this->bill_of_exit,true);
		$criteria->compare('ta_no',$this->ta_no);
		$criteria->compare('isInernal',$this->isInernal,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_datetime',$this->created_datetime,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Transfers the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
