<?php

/**
 * This is the model class for table "{{current_stock}}".
 *
 * The followings are the available columns in table '{{current_stock}}':
 * @property string $part_number
 * @property string $description
 * @property string $quantity
 * @property string $deliverynote
 * @property integer $deliverynote_item_id
 * @property string $bill_of_entry
 * @property string $bill_of_entry_date
 */
class Stock extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{current_stock}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('part_number, description, quantity, deliverynote, deliverynote_item_id, bill_of_entry, bill_of_entry_date', 'required'),
			array('deliverynote_item_id', 'numerical', 'integerOnly'=>true),
			array('part_number, deliverynote, bill_of_entry', 'length', 'max'=>255),
			array('quantity', 'length', 'max'=>15),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('part_number, description, quantity, deliverynote, deliverynote_item_id, bill_of_entry, bill_of_entry_date', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'deliverynote' => array(self::BELONGS_TO, 'Inbound', 'deliverynote_id'),
			'inboundRelation' => array(self::BELONGS_TO, 'InboundItems', 'deliverynote_item_id'),
			'warehouseDetails' => array(self::BELONGS_TO, 'Warehouses', 'warehouse'),
			// please use the relation
			'deliverynoteMain' => array(self::BELONGS_TO, 'Inbound', 'deliverynote_id'),
			//code added by mereena on 19/07/2024
			'item_master' => array(self::BELONGS_TO, 'ItemMaster', 'part_number'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'part_number' => 'Part Number',
			'description' => 'Description',
			'quantity' => 'Quantity',
			'deliverynote' => 'Deliverynote',
			'deliverynote_item_id' => 'Deliverynote Item',
			'bill_of_entry' => 'Bill Of Entry',
			'bill_of_entry_date' => 'Bill Of Entry Date',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('part_number',$this->part_number,true);
		$criteria->compare('description',$this->description,true);
		$criteria->compare('quantity',$this->quantity,true);
		$criteria->compare('deliverynote',$this->deliverynote,true);
		$criteria->compare('deliverynote_item_id',$this->deliverynote_item_id);
		$criteria->compare('bill_of_entry',$this->bill_of_entry,true);
		$criteria->compare('bill_of_entry_date',$this->bill_of_entry_date,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Stock the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
