<?php

/**
 * This is the model class for table "{{user}}".
 *
 * The followings are the available columns in table '{{user}}':
 * @property integer $id
 * @property string $title
 * @property string $first_name
 * @property string $last_name
 * @property string $address
 * @property string $contact_number
 * @property string $mobile_number
 * @property integer $country_id
 * @property integer $user_group_id
 * @property string $isActive
 * @property string $username
 * @property string $password
 * @property string $level
 *
 * The followings are the available model relations:
 * @property UserGroup $userGroup
 */
class User extends CActiveRecord {

    public $repeat_password;
    public $old_password;
    public $rememberMe;
    private $_identity;
    private $last_login;

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{user}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('username, password,user_type first_name, last_name, email', 'required', 'on' => 'register'),
            //array('username, password, first_name, last_name, email', 'required'),
            array(' first_name, last_name', 'length', 'max' => 255, 'on' => 'register'),
            array('username, password, first_name, last_name, email,telephone', 'required', 'on' => 'signup'),
            array(' first_name,username,password last_name,email,telephone', 'length', 'max' => 255, 'on' => 'signup'),
            array('username', 'unique', 'on' => 'signup'),
             array('email', 'email', 'on' => 'signup'),
            array('username, password,user_type first_name, last_name, email', 'required', 'on' => 'update'),
            //lines by toby ands
            array('isActive, level', 'length', 'max' => 1),
            array('username, password', 'length', 'max' => 50),
            array('password, username', 'required', 'on' => 'login'),
            array('password, username',  'required', 'on'=>'login1'),
            array('password', 'authenticate', 'on'=>'login1'),
            array('password, repeat_password', 'required', 'on' => 'change_password'),
            array('repeat_password', 'compare', 'compareAttribute' => 'password', 'on' => 'change_password'),
            array('password', 'authenticate', 'on' => 'login'),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, username, password,user_type first_name, last_name, house_no, street, phone_no, email, isActive, level', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
                //'userGroup' => array(self::BELONGS_TO, 'UserGroup', 'user_group_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'username' => 'Username',
            'password' => 'Password',
            'first_name' => 'First Name',
            'last_name' => 'Last Name',
            'user_type' => 'User Type',
            'email' => 'Email',
            'isActive' => 'Is Active',
            'level' => 'Level',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        //$criteria->compare('title',$this->title,true);
        $criteria->compare('first_name', $this->first_name, true);
        $criteria->compare('last_name', $this->last_name, true);
        $criteria->compare('user_type', $this->user_type);
        $criteria->compare('email', $this->email);
        //$criteria->compare('user_group_id',$this->user_group_id);
        $criteria->compare('isActive', $this->isActive, true);
        $criteria->compare('username', $this->username, true);
        $criteria->compare('password', $this->password, true);
        $criteria->compare('level', $this->level, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.id DESC',
            ),
            'pagination' => array('pageSize' => Yii::app()->params['defaultPageSize'])
        ));
    }

    public function authenticate($attribute, $params) {
        //  die($attribute);
        // print_r($params);
        // die();
        if (!$this->hasErrors()) {
            //die($this->password);
            $this->_identity = new UserIdentity($this->username, $this->password);
            if (!$this->_identity->authenticate())
                $this->addError('password', 'Incorrect username or password.');
        }
    }

    public function login() {
        if ($this->_identity === null) {
            $this->_identity = new UserIdentity($this->username, $this->password);
            $this->_identity->authenticate();
        }
        if ($this->_identity->errorCode === UserIdentity::ERROR_NONE) {
            $duration = $this->rememberMe ? 3600 * 24 * 30 : 0; // 30 days
            Yii::app()->user->login($this->_identity, $duration);
            return true;
        } else {
            return false;
        }
    }

    public function getFullname() {
        return ($this->first_name . ' ' . $this->last_name);
    }

    /* bfeore save function for password enecryption 
     * 
     */
//	function beforeSave()
//	{
//		if(isset($_POST['User']['password']) && $_POST['User']['password']!='')
//			$this->password	=	crypt($_POST['User']['password'],$_POST['User']['password']);
//		return true;
//	}

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return User the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

}
