<?php

/**
 * This is the model class for table "{{outbound}}".
 *
 * The followings are the available columns in table '{{outbound}}':
 * @property string $outb_delivery_note_no
 * @property string $outb_bill_of_exit_no
 * @property string $outb_ta_number
 * @property string $outb_bill_of_exit_date
 * @property string $outb_added_date
 * @property string $outb_doc_no
 * @property string $outb_file_name
 * @property string $outb_delivery_note_posted
 */
class Outbound extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	
	 public $outb_customer_name;

	public function tableName()
	{
		return '{{outbound}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('outb_added_date, outb_customer, outb_customer_original, outb_currency, outb_unit_label', 'required'),
                        array('tax_percentage', 'numerical'),
			array('outb_bill_of_exit_no, outb_ta_number', 'length', 'max'=>100),
			// array('outb_doc_no', 'length', 'max'=>50),
			array('outb_total_weight', 'length', 'max'=>15),
                        array('price_type', 'numerical', 'integerOnly'=>true),
			array('outb_file_name, outb_tracking_no, outb_awb_no, outb_packed_by, outb_shipping_by, outb_invoice_no, outb_description_of_goods,outb_customs_bill,outb_inco_terms,outb_payment_method', 'length', 'max'=>255),
			array('outb_delivery_note_posted', 'length', 'max'=>1),
			//Added by Smrithy 10072024//
			array('outb_packed_by', 'unique'),
			//Added by Smrithy 10072024//
			// array('outb_shipping_address, outb_billing_address, outb_shipping_condition, outb_terms_and_conditions', 'length', 'max'=>1000),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('outb_delivery_note_no, outb_bill_of_exit_no, outb_ta_number, outb_bill_of_exit_date, outb_added_date, outb_doc_no, outb_file_name, outb_delivery_note_posted, outb_invoice_no, outb_description_of_goods', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'items' => array(self::HAS_MANY, 'OutboundItems', 'outb_delivery_note_no', 'order' => 'items.id ASC'),
			'items_group_by' => array(self::HAS_MANY, 'OutboundItems', 'outb_delivery_note_no', 'group' => 'items_group_by.brand_id, items_group_by.category_id,items_group_by.outb_part_number, items_group_by.id'),
			'cus' => array(self::BELONGS_TO, 'Customers', 'outb_customer'), //Transferee
			'cus_original' => array(self::BELONGS_TO, 'CustomersOriginal', 'outb_customer_original'), //customer
			'currentStock' => array(self::BELONGS_TO, 'Stock', 'outb_stock_id'),
			'totalWeight' => array(self::STAT, 'OutboundItems', 'outb_delivery_note_no', 'select' => 'SUM(outb_gross_wt)'),
			'totalQuantity' => array(self::STAT, 'OutboundItems', 'outb_delivery_note_no', 'select' => 'SUM(outb_quantity)'),
			'totalVolume' => array(self::STAT, 'OutboundItems', 'outb_delivery_note_no', 'select' => 'SUM(outb_cbm)'),
			'totalValue' => array(self::STAT, 'OutboundItems', 'outb_delivery_note_no', 'select' => 'SUM(outb_invoice_rate)'),
			'totalCtns' => array(self::STAT, 'OutboundItems', 'outb_delivery_note_no', 'select' => 'SUM(outb_remarks)'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'outb_delivery_note_no' => 'Outb Delivery Note No',
			'outb_bill_of_exit_no' => 'Outb Bill Of Exit No',
			'outb_ta_number' => 'Outb Ta Number',
			'outb_bill_of_exit_date' => 'Outb Bill Of Exit Date',
			'outb_added_date' => 'Outb Added Date',
			'outb_doc_no' => 'Outb Doc No',
			'outb_file_name' => 'Outb File Name',
			'outb_delivery_note_posted' => 'Outb Delivery Note Posted',
			'outb_customer' => 'Customer',
			'outb_currency' => 'Currency',
			//Added by Smrithy 10072024//
			'outb_packed_by' => 'LPO',
			//Added by Smrithy 10072024//
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('outb_delivery_note_no',$this->outb_delivery_note_no,true);
		$criteria->compare('outb_bill_of_exit_no',$this->outb_bill_of_exit_no,true);
		$criteria->compare('outb_ta_number',$this->outb_ta_number,true);
		$criteria->compare('outb_bill_of_exit_date',$this->outb_bill_of_exit_date,true);
		$criteria->compare('outb_added_date',$this->outb_added_date,true);
		$criteria->compare('outb_doc_no',$this->outb_doc_no,true);
		$criteria->compare('outb_file_name',$this->outb_file_name,true);
		$criteria->compare('outb_delivery_note_posted',$this->outb_delivery_note_posted,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Outbound the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
	public function getDetailed(){
		return $this->outb_delivery_note_no.' | '.$this->cus->name;
	}
	public static function getDeliverylist( $delivery_type ){
		if( $delivery_type == 'third_party' )
			$model = self::model()->with('cus')->findAll( array('condition'=>'cus.internalCustomer = "N" AND t.outb_delivery_note_posted="N"') );
		else
			$model = self::model()->with('cus')->findAll( array('condition'=>'cus.internalCustomer = "Y" AND t.outb_delivery_note_posted="N"') );
		return CHtml::listData($model, 'outb_delivery_note_no', 'Detailed');
		
	}

	public function bill_of_entries(){
		$boe =array();
		foreach( $this->items as $each ) :	
			$boe[] = $each->currentStock->bill_of_entry;
		endforeach;
		return implode(', ', array_unique($boe));
	}

	public function country_codes(){
		$boe =array();
		foreach( $this->items as $each ) :	
			$boe[] = $each->currentStock->inboundRelation->inb_contry_of_origin_code;
		endforeach;
		return implode(', ', array_unique($boe));
	}

	public function hscodes(){
		$hscodes =array();
		foreach( $this->items as $each ) :	
			$hscodes[] = $each->outb_hs_code;
		endforeach;
		return implode(', ', array_unique($hscodes));
	}
}
