<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("load", '
        $(document).ready(function() {
            var table_id ="#tbl_outbound_invoice_details";
            var table = $(table_id).on("preXhr.dt", function (e, settings, data) {
                data.from_date = $("#start_date").val();
                data.to_date = $("#end_date").val();
                return data;
            }).DataTable({
                scrollY         : "100vh",
                pageLength      : 50,
                ajax: {
                    url: "' . Yii::app()->createUrl('outboundinvoice/getinvoicelist') . '",
                    type: "POST",
                    cache : false,
                },
                serverSide:     true,
                fixedColumns:   true,
                processing: true,
                order: [[ 1, "desc" ]],
            
            });
            $(".dataTables_scrollFoot").hide();
    });', CClientScript::POS_HEAD);

?>

    <section class="panel">
        <header class="panel-heading clearfix panel-theame">
            <i class="fa fa-file"></i> Final Invoice
            <div class="pull-right">
                <?php echo CHtml::textfield('start_date',date('01/m/Y'),array('class' => 'datepicker form-control')); ?>
                <?php echo CHtml::textfield('end_date',date('t/m/Y'),array('class' => 'datepicker form-control')); ?>
                <button class="btn btn-sm btn-theme" title="Search" onclick="reloadTable('#tbl_outbound_invoice_details');"><i class="fa fa-search"></i></button>
            </div>
        </header>
        <div class="panel-body">
            <div class="custom-data-table">
                <table class="table table-hover table-bordered personal-task" id="tbl_outbound_invoice_details">
                    <thead>
                        <tr>
                            <th>SI#</th>
                            <th>Outbound #</th>
                            <th>Customer</th>
                            <th>Invoice#</th>
                            <th>Invoice Date</th>
                            <th>Invoice Note</th>
                            <th>Logo</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tfoot>
                         <tr>
                            <th>SI#</th>
                            <th>Outbound #</th>
                            <th>Customer</th>
                            <th>Invoice#</th>
                            <th>Invoice Date</th>
                            <th>Invoice Note</th>
                            <th>Logo</th>
                            <th>Actions</th>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </section>
    
    <?php 
        $cs = Yii::app()->getClientScript();
        $cs->registerScript('print_pdf', 'function print_pdf(id, view) {
            var logo = $("#logo_id_"+id).val();
            window.open("index.php?r=outbound/print&id="+id+"&view="+view+"&logo="+logo);
        };', CClientScript::POS_HEAD); 
    ?>
