<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("load", '
        $(document).ready(function() {
            var table_id ="#tbl_transfers";
            var table = $(table_id).on("preXhr.dt", function (e, settings, data) {
                data.from_date = $("#start_date").val();
                data.to_date = $("#end_date").val();
                return data;
            }).DataTable({
                scrollY         : "380px",
                pageLength      : 50,
                ajax: {
                    url: "' . Yii::app()->createUrl('inbound/gettransfers') . '",
                    type: "POST",
                    cache : false,
                },
                serverSide:     true,
                fixedColumns:   true,
                processing: true,
                order: [[ 1, "desc" ]],
            
            });
            $(".dataTables_scrollFoot").hide();
    });', CClientScript::POS_HEAD);

?>

    <section class="panel">
        <header class="panel-heading clearfix panel-theame">
            <i class="fa fa-file"></i> Warehouse Transfers
            <div class="pull-right">
                <button class="btn btn-sm btn-theme" title="Import inbound data" onclick="loadPopupModal('inbound/addtransfer','Transfer Items - Single','xl')"><i class="fa fa-plus"></i>Add Single</button>
                <button class="btn btn-sm btn-theme" title="Import inbound data" onclick="loadPopupModal('inbound/addmultipletransfer','Transfer Items - Multiple','xl')"><i class="fa fa-plus"></i> Add Multiple</button>
            </div>
        </header>
        <div class="panel-body">
            <div class="custom-data-table">
                <table class="table table-hover table-bordered personal-task" id="tbl_transfers">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Date</th>
                            <th>BOE</th>
                            <th>Part No</th>
                            <th>Quantity</th>
                            <th>REF #</th>
                            <th>Notes</th>
                        </tr>
                    </thead>
                    <tfoot>
                        <tr>
                            <th>#</th>
                            <th>Date</th>
                            <th>BOE</th>
                            <th>Part No</th>
                            <th>Quantity</th>
                            <th>REF #</th>
                            <th>Notes</th>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </section>
