<?php

/**
 * This is the model class for table "{{inbound_container_details}}".
 *
 * The followings are the available columns in table '{{inbound_container_details}}':
 * @property integer $id
 * @property integer $inbound_id
 * @property string $container_type
 * @property integer $container_quantity
 * @property string $frieght_per_container
 * @property integer $currency
 * @property string $total_frieght
 * @property string $container_pol
 * @property string $container_pod
 */
class InboundContainerDetails extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{inbound_container_details}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			//array('inbound_id, container_type, container_quantity, frieght_per_container, currency, total_frieght, container_pol, container_pod', 'required'),
			array('inbound_id, container_quantity, currency', 'numerical', 'integerOnly'=>true),
			array('container_type, shipping_agent,container_pol, container_pod', 'length', 'max'=>255),
			array('frieght_per_container, total_frieght', 'length', 'max'=>15),
			array('eta_arrival_date', 'length', 'max'=>10),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, inbound_id, container_type, container_quantity, frieght_per_container, currency, total_frieght, container_pol, container_pod', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'inbound_id' => 'Inbound',
			'container_type' => 'Container Type',
			'container_quantity' => 'Container Quantity',
			'frieght_per_container' => 'Frieght Per Container',
			'currency' => 'Currency',
			'total_frieght' => 'Total Frieght',
			'container_pol' => 'Container Pol',
			'container_pod' => 'Container Pod',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('inbound_id',$this->inbound_id);
		$criteria->compare('container_type',$this->container_type,true);
		$criteria->compare('container_quantity',$this->container_quantity);
		$criteria->compare('frieght_per_container',$this->frieght_per_container,true);
		$criteria->compare('currency',$this->currency);
		$criteria->compare('total_frieght',$this->total_frieght,true);
		$criteria->compare('container_pol',$this->container_pol,true);
		$criteria->compare('container_pod',$this->container_pod,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return InboundContainerDetails the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
