<?php

/**
 * This is the model class for table "{{customers}}".
 *
 * The followings are the available columns in table '{{customers}}':
 * @property integer $id
 * @property string $name
 * @property string $email
 * @property string $billing_adds
 * @property string $shipping_adds
 * @property string $trn_no
 * @property string $isActive
 */
class Customers extends CActiveRecord
{
    /**
     * @return string the associated database table name
     */

    public function tableName()
    {
        return '{{customers}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules()
    {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('name, email, billing_adds', 'required'),
            array('name, email, trn_no', 'length', 'max' => 255),
            array('shipping_adds', 'length', 'max'=>500),
            array('isActive', 'length', 'max' => 1),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, name, email, billing_adds, shipping_adds, trn_no, isActive', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations()
    {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels()
    {
        return array(
            'id' => 'ID',
            'name' => 'Name',
            'email' => 'Email',
            'billing_adds' => 'Billing Adds',
            'shipping_adds' => 'Shipping Adds',
            'trn_no' => 'Trn No',
            'isActive' => 'Is Active',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search()
    {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('name', $this->name, true);
        $criteria->compare('email', $this->email, true);
        $criteria->compare('billing_adds', $this->billing_adds, true);
        $criteria->compare('shipping_adds', $this->shipping_adds, true);
        $criteria->compare('trn_no', $this->trn_no, true);
        $criteria->compare('isActive', $this->isActive, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return Customers the static model class
     */
    public static function model($className = __CLASS__)
    {
        return parent::model($className);
    }

    public function getAddress()
    {
        $address = '';
        if ($this->billing_adds != '') {
            $address .= $this->billing_adds . '<br>';
        }

        if ($this->email != '') {
            $address .= $this->email;
        }

        return $address;
    }
}
