<?php

class OutboundinvoiceController extends Controller
{
    public function accessRules()
    {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('index', 'GetInvoiceList', 'Create', 'Save', 'Addbankdetails', 'Exportinvoice', 'Products'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters()
    {
        return array('accessControl'); // perform access control for CRUD operations
    }

    public function actionIndex()
    {
        $this->render('index');
    }

    public function actionGetInvoiceList()
    {
        $model = new OutboundInvoice();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 't.outbound_id',
            2 => 'customer.name',
            3 => 't.invoice_no',
            4 => 't.invoice_date',
            5 => 't.invoice_note',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $from_date = (count(explode('/', $_POST['from_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from_date']))) : date('Y-m-01');
        $to_date = (count(explode('/', $_POST['to_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to_date']))) : date('Y-m-t');
        $condition = 't.invoice_date BETWEEN "' . $from_date . '" AND "' . $to_date . '"';
        if (isset($_POST['search']['value']) && trim($_POST['search']['value']) != "") {
            $searchString = trim($_POST['search']['value']);
            $condition .= " AND (customer.name LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('customer')->count(array('condition' => $condition));
        $model = $model->with('customer')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 't.id desc'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $eachItemData = array();
        $m = 1;

        $arr_logos = array(
            0 => 'None',
            1 => Yii::app()->user->footer_line_one_1,
            2 => Yii::app()->user->footer_line_two_1,
            3 => Yii::app()->user->footer_line_three_1,
            // 4 => Yii::app()->user->footer_line_four_1
        );

        foreach ($model as $i => $eachItem) {
            $div = '<div class="btn-wrap text-center">';
            $div .= ' <button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'outboundinvoice/create&invoice_id=' . $eachItem['id'] . '\',\'REF : ' . $eachItem['id'] . '\',\'xl\')", title="Final Docs"><i class="fa fa-pencil"></i></button>';
            /* if($eachItem['outb_delivery_note_posted'] == "N"){
            $div .= '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'outbound/create&dn='.$eachItem['outb_delivery_note_no'].'\',\'REF : '.$eachItem['outb_delivery_note_no'].'\',\'xl\')"><i class="fa fa-pencil"></i></button>';
            }*/
            // $div .= '<button title="Add Bank details" class="btn btn-primary btn-xs" onclick="loadPopupModal(\'outboundinvoice/addbankdetails&id='.$eachItem['id'].'\',\'Bank Details\',\'lg\')"><i class="fa fa-pencil"></i></button>';
            $div .= ' <a class="btn btn-primary btn-xs" onclick="print_pdf(' . $eachItem['id'] . ',\'final_invoice\');" title="Final Invoice"><i class="fa fa-file-pdf-o"></i></a>';
            $div .= ' <a class="btn btn-primary btn-xs" onclick="window.open($(\'#liveSite\').val()+\'index.php?r=outboundinvoice/exportinvoice&id=' . $eachItem['id'] . '\', \'_blank\')" title="Final Invoice Excel"><i class="fa fa-file"></i></a>';
            $div .= ' <a class="btn btn-primary btn-xs" onclick="print_pdf(' . $eachItem['id'] . ',\'final_packing\');" title="Final Packinglist"><i class="fa fa-file-pdf-o"></i></a>';
            $div .= '</div>';
            $eachItemData[] = array(($i + 1), $eachItem['outbound_id'], $eachItem['customer']['name'], $eachItem['invoice_no'], ($eachItem['invoice_date'] != '0000-00-00') ? date('d/m/Y', strtotime($eachItem['invoice_date'])) : '', $eachItem['invoice_note'], CHtml::dropDownList('logo_id_' . $eachItem['id'], '', $arr_logos, array('class' => '', 'style' => 'width:80px')), $div);

        }
        $data['data'] = $eachItemData;
        echo json_encode($data);
    }

    public function actionCreate()
    {
        $out_bound_id = (int) Yii::app()->request->getParam('id');
        $invoice_id = (int) Yii::app()->request->getParam('invoice_id');
        $model = new OutboundInvoice;
        $modelInvoiceItems = array(new OutboundInvoiceItems);
        $modelOutbound = new Outbound;
        $items = array(new OutboundItems);
        if ($out_bound_id > 0) {
            $modelOutbound = Outbound::model()->findByPk($out_bound_id);
            $items = OutboundItems::model()->findAll(array('condition' => 'outb_delivery_note_no=' . $out_bound_id));
            $model->customer_name = $modelOutbound->cus->name;
            $model->customer_id = $modelOutbound->outb_customer;
            $model->invoice_no = $modelOutbound->outb_invoice_no;
            $model->unit_label = $modelOutbound->outb_unit_label;
            $model->outbound_id = $out_bound_id;
            $model->invoice_date = date('d/m/Y');

            foreach ($items as $i => $eachItem) {
                $modelInvoiceItems[$i] = new OutboundInvoiceItems;
                $modelInvoiceItems[$i]->attributes = $eachItem->attributes;
                $modelInvoiceItems[$i]->outb_remarks = $eachItem->outb_remarks;
            }

        }

        if ($invoice_id > 0) {
            $model = OutboundInvoice::model()->findBypk($invoice_id);
            $modelInvoiceItems = OutboundInvoiceItems::model()->findAll(array('condition' => 'invoice_id=' . $invoice_id, 'order' => 'id ASC'));
            $modelOutbound = Outbound::model()->findByPk($model->outbound_id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.js' => false);
        $this->render('create', array('model' => $model, 'modelOutbound' => $modelOutbound, 'items' => $modelInvoiceItems));
    }

    public function actionSave()
    {
        if (isset($_POST['OutboundInvoice'])) {
            $mainModel = new OutboundInvoice;
            if( $_POST['OutboundInvoice']['id'] > 0 )
                $mainModel = $mainModel->findByPk( $_POST['OutboundInvoice']['id'] );
            $mainModel->attributes = $_POST['OutboundInvoice'];
            $mainModel->bank_details = $_POST['OutboundInvoice']['bank_details'];
            $mainModel->invoice_note = $_POST['OutboundInvoice']['invoice_note'];
            $mainModel->invoice_date = (count(explode('/', $_POST['OutboundInvoice']['invoice_date'])) == 3) ? date('Y-m-d', strtotime(str_replace('/', '-', $_POST['OutboundInvoice']['invoice_date']))) : date('Y-m-d');
            $mainModel->created_by = Yii::app()->user->id;
            $mainModel->created_date_time = date("Y-m-d h:i:s");
            $valid = $mainModel->validate();
            $itemsModel = array();
            $i = 0;
            $total_wt = 0;
            foreach ($_POST['OutboundInvoiceItems'] as $each) {
                if ($each['outb_stock_id'] > 0) {
                    $itemsModel[$i] = new OutboundInvoiceItems;
                    $itemsModel[$i]->attributes = $each;
                    $itemsModel[$i]->outb_quantity = ((float) $itemsModel[$i]->outb_quantity > 0) ? $itemsModel[$i]->outb_quantity : '';
                    $itemsModel[$i]->outb_net_amount = $itemsModel[$i]->outb_quantity * $itemsModel[$i]->outb_invoice_rate;
                    $itemsModel[$i]->outb_net_amount_bc = $itemsModel[$i]->outb_quantity * $itemsModel[$i]->outb_invoice_rate;
                    $itemsModel[$i]->invoice_id = 0;
                    $itemsModel[$i]->outb_stock_id = $each['outb_stock_id'];
                    $valid = $valid && $itemsModel[$i]->validate();
                    $total_wt += (float) $each['outb_gross_wt'];
                    $i++;
                }
            }
            if ($valid && count($itemsModel) > 0) {
                echo json_encode(array('status' => 'success'));
                $mainModel->save(false);
                OutboundInvoiceItems::model()->deleteAll('invoice_id =:refer_id', array( ':refer_id' => $mainModel->id ));
                foreach ($itemsModel as $eachItem) {
                    $eachItem->invoice_id = $mainModel->id;
                    $eachItem->save(false);
                }
            } else {
                $error2 = array();
                $error1 = json_decode(CActiveForm::validate($mainModel, '', false), true);
                if (count($itemsModel) > 0) {
                    $error2 = json_decode(CActiveForm::validateTabular($itemsModel, '', false), true);
                } else {
                    $error2[] = "Please add atleast one line item";
                }

                echo CJSON::encode(array_merge_recursive($error1, $error2));
            }
        }
    }

    public function actionAddbankdetails()
    {
        $id = (int) Yii::app()->request->getParam('id');
        $model = OutboundInvoice::model()->findBypk($id);
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.js' => false);
        $this->render('bank_details', array('id' => $id, 'model' => $model));
    }

    public function actionExportinvoice()
    {
        $id = (int) Yii::app()->request->getParam('id');
        $invoice = OutboundInvoice::model()->with('items')->findByPk($id);
        $outbound = Outbound::model()->findByPk($invoice->outbound_id);
        $filename = "finalinvoice.xls";

        $data = '<html>
                    <head>
                        <style>
                            table{
                                width:100%;
                            }
                            .head{
                                background-color : #CCCCCC;
                                font-weight: bold;
                                font-size: 14px;
                            }
                            .brand{
                                text-align:center;
                                font-size:11px;
                                background-color : #CCCCCC;
                            }
                            .total{
                                text-align: right;
                                font-weight: bold;
                                font-size: 14px;
                            }
                            .in{
                                background-color: #d5d5d5;
                            }
                            .out{
                                background-color: #f5f4f5;
                            }
                            .footer{
                                text-align: right;
                                font-weight: bold;
                                font-size: 14px;
                                background-color: #a5b997 ;
                            }
                        </style>
                    </head>
                    <body>
                    <table  border=1>
                        <thead>
                            <tr>
                                <th class="head" style="width:8%;">SL.<br>NO</th>
                                <th class="head" style="width:25%">CATEGORY</th>
                                <th class="head" style="width:16%;">MODEL</th>
                                <th class="head" style="width:13%;">ORIGIN</th>
                                <th class="head" style="width:13%;">QTY.<br>SETS.</th>
                                <th class="head" style="width:17%;">U/PRICE<br>' . $invoice->currency() . '</th>
                                <th class="head" style="width:17%;">Amount<br>' . $invoice->currency() . '</th>
                            </tr>
                        </thead>
                        <tbody>';

        $grand_total_qty = 0;
        $grand_total_amount = 0;

        $x = 1;
        $query = 'SELECT B.id, B.brand_name FROM nia_outbound_invoice_items OI LEFT JOIN nia_mas_brand B ON B.id = OI.brand_id WHERE OI.invoice_id=' . $id . ' AND B.brand_name IS NOT NULL GROUP BY OI.brand_id ORDER BY B.brand_name';
        $outbound_brands = Yii::app()->db->createCommand($query)->queryAll();
        foreach ($outbound_brands as $i => $each) {
            $data .= '<tr><td class="brand" colspan="7"><b>' . $each['brand_name'] . '</b></td></tr>';

            $query_of_category = 'SELECT CA.category_name, CA.id AS category, GROUP_CONCAT(OI.id) AS item_ids FROM nia_outbound_invoice_items OI LEFT JOIN nia_mas_category CA ON OI.category_id = CA.id WHERE OI.invoice_id=' . $id . ' AND CA.category_name IS NOT NULL AND  OI.brand_id=' . (int) $each['id'] . ' GROUP BY CA.id ORDER BY CA.category_name';
            $outbound_categories = Yii::app()->db->createCommand($query_of_category)->queryAll();
            foreach ($outbound_categories as $eachCat):
                $query_products = 'SELECT * FROM nia_outbound_invoice_items OI LEFT JOIN nia_outbound_invoice O ON O.id = OI.invoice_id WHERE OI.id IN (' . $eachCat['item_ids'] . ') ORDER BY OI.outb_part_number';
                $query_products_count = 'SELECT COUNT(id) AS value FROM nia_outbound_invoice_items WHERE id IN (' . $eachCat['item_ids'] . ')';
                $items = Yii::app()->db->createCommand($query_products)->queryAll();
                $count = Yii::app()->db->createCommand($query_products_count)->queryScalar();

                $total_qty = 0;
                $total_amount = 0;

                foreach ($items as $c => $eachItem):

                    $total_qty += $eachItem['outb_quantity'];
                    $total_amount += $eachItem['outb_invoice_rate'];

                    $grand_total_qty += $eachItem['outb_quantity'];
                    $grand_total_amount += $eachItem['outb_invoice_rate'];

                    $data .= '<tr>
		                                            <td style="text-align:center;font-size:11px;">' . $x . '</td>';
                    if ($c == 0):
                        $data .= '<td style="text-align:left;font-size:11px;" rowspan="' . $count . '">' . $eachCat['category_name'] . '</td>';
                    endif;
                    $data .= '<td style="text-align:center;font-size:11px;">' . $eachItem['outb_part_number'] . '</td>
		                                                <td style="text-align:center;font-size:11px;">' . $eachItem['outb_contry_of_origin'] . '</td>
		                                                <td style="text-align:center;font-size:11px;">' . (float) $eachItem['outb_quantity'] . '</td>
		                                                <td style="text-align:right;font-size:11px;">' . Yii::app()->numberFormatter->formatCurrency($eachItem['outb_unit_price'], "") . '</td>
		                                                <td style="text-align:right;font-size:11px;">' . Yii::app()->numberFormatter->formatCurrency($eachItem['outb_invoice_rate'], "") . '</td>
		                                            </tr>';
                    $x++;
                endforeach;
                $data .= '<tr><td colspan="4" class="total"><b>Total</b></td><td style="text-align:center;font-size:11px;"><b>' . (float) $total_qty . '</b></td><td></td><td style="text-align:right;"><b>' . Yii::app()->numberFormatter->formatCurrency($total_amount, "") . '</b></td></tr>';
            endforeach;
        }
        $data .= '<tr>
                <td height="20" colspan="4" valign="top" style="text-align:right;"><b>TOTAL<br>FRIEGHT</b></td>
                <td height="20" style="text-align:center;"><b>' . $grand_total_qty . '<br>SETS</b></td>
                <td height="20" colspan="2" style="padding-left:88px;"><b>' . $invoice->currency() . '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . Yii::app()->numberFormatter->formatCurrency($grand_total_amount, "") . '<br>&nbsp;</b><b>' . $invoice->currency() . '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . Yii::app()->numberFormatter->formatCurrency($invoice->freight_charge, "") . '</b></td>
                </tr>
                <tr>
                <td height="20" colspan="6" valign="top"><b>' . $invoice->destination . '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</b></td><td class="total"><b>' . $invoice->currency() . '&nbsp;' . Yii::app()->numberFormatter->formatCurrency(($grand_total_amount + $invoice->freight_charge), "") . '</b></td>
                </tr>
            </tbody>
        </table>
        </body>
        </html>';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        echo $data;
        Yii::app()->end();
        return;
    }

    public function actionProducts(){
        $existance = Yii::app()->request->getParam('exist');
        $response = array();
        if( $existance != '' ){
            $productList = Stock::model()->findAll( array( 'select' => 'deliverynote_item_id, part_number, deliverynote, id, description, net_wt, gross_wt, cbm', 'condition'=>'id IN('.$existance.') AND ( description LIKE "%'.$term.'%" OR part_number LIKE "%'.$term.'%" )', 'limit' => 200) );
            foreach ( $productList as $i => $each ){
                $response[$i]['label'] = $each->part_number.' | '.$each->deliverynote;
                $response[$i]['value'] = $each->part_number;
                $response[$i]['stock_id'] = $each->id;
                $response[$i]['description'] = $each->description;
                $response[$i]['unit'] = $each->inboundRelation->inb_quantity_unit;
                $response[$i]['coo'] = $each->inboundRelation->inb_contry_of_origin;
                $response[$i]['hsc'] = $each->inboundRelation->inb_hs_code;
                $response[$i]['nt_weight'] = $each->net_wt;
                $response[$i]['gr_weight'] = $each->gross_wt;
                $response[$i]['cbm'] = $each->cbm;
            }
        }
        echo json_encode($response);
    }
}
