<?php

class BrandController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Create', 'GetList', 'Save', 'Delete'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex() {
        $this->render('index');
    }

    // Uncomment the following methods and override them if needed

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionGetList() {
        $model = new MasBrand();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'brand_name',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.isActive="Y"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " and (brand_name LIKE '%" . $searchString . "%' OR id LIKE '%" . $searchString . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $div = '';
            //if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["master_brand_edit"])) {
                 $div .=   '<div class="btn-wrap text-center"><button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'brand/create&id='.$row['id'].'\',\'Edit Brand\',\'lg\')"><i class="fa fa-pencil"></i></button>';
            //}
            /*/*if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["mas_brand_delete"])) {
                 $div .=  '<a href ="#" class="btn btn-danger btn-xs" onclick="deleteBrand('.$row['id'].')"><i class="fa fa-trash-o "></i></a>';
            }*/
            $rowData[] = array($m,
                $row['brand_name'],
                '<div class="btn-wrap text-center">' . $div . '</div>');

            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate() {
        $model = new MasBrand();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.js' => false);
        $this->render('create', array('model' => $model), false, false);
    }

    public function actionSave() {
        $model = new MasBrand();
        if (isset($_POST['MasBrand'])) {
            if ((int) @$_POST['MasBrand']['id'] > 0) {
                $id = (int) @$_POST['MasBrand']['id'];
                $model = $model->findByPk($id);
            }
            $model->attributes = $_POST['MasBrand'];
            if ($model->save()) {
                $jsonData['status'] = 'success';
                $jsonData['frm'] = $_POST['MasBrand'];
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    /*public function actionDelete() {

        $id = $_POST['id'];
        $model_c = Customer::model()->findAll(array('condition' => 'customer_country = ' . $id . ' '));
        $model_com = Company::model()->findAll(array('condition' => 'shipping_country = ' . $id . ' '));
        if (empty($model_c) && empty($model_com)) {
            $model = new MasBrand();
            $model->deleteByPk($id);
            echo "success";
        } else {
            echo "fail";
        }
    }*/


}
