<div class="panel">
    <div class="panel-heading panel-theme">
        <p>Warehouse Stock Report - Horizontal </p>
    </div>
    <div class="panel-body">
        <div >
            <label>Page Size </label>
            <select name='spg' id ="pagesize">
                <option value="20" <?php if ($page_size == 20) echo ' selected="selected" '; ?> >20</option>
                <option value="50" <?php if ($page_size == 50) echo 'selected="selected" '; ?>>50</option>
                <option value="100" <?php if ($page_size == 100) echo 'selected="selected" '; ?>>100</option>
            </select>
        </div>
        <div class="table-responsive"> 
            <input type="hidden" id="type" name="type" value="<?php echo $type; ?>" />
            <input type="hidden" id="part_number" name="part_number" value="<?php echo $part_no; ?>" />
            <input type="hidden" id="generic_name" name="generic_name" value="<?php echo $generic_name; ?>" />

            <table id="tbl_inventory_table" class="table table-fixed table-bordered table-primary dataTable">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Customer</th>
                        <th>Part Number</th>
                        <th>Brand</th>
                        <?php
                        $total = array();
                        $model_warehouse = new MasInventoryWarehouse();
                        $model_warehouse_param = null;
                        if ($loc == '' || $loc == 'null') {
                            $model_warehouse_param = array('condition' => 't.isActive="Y"', 'order' => 'warehouse_name asc');
                        } else {
                            $model_warehouse_param = array('condition' => ' t.id in (' . $loc . ')', 'order' => 'warehouse_name asc');
                        }

                        $model_warehouse = $model_warehouse->findAll($model_warehouse_param);
                        if (!empty($model_warehouse)) {
                            foreach ($model_warehouse as $k => $each) {
                                $total[$k] = 0;
                                ?>
                                <th><?php echo $each->warehouse_name; ?></th>
                                <th>Rack</th>
                                <th>Bin</th>
                                <?php
                            }
                        }
                        ?>
                        <th>Total</th>        
                    </tr>
                </thead>
                <tbody>       
                    <?php
                    $toalval = 0;
                    $offset = ($page_no - 1) * $page_size;
                    $condition = '1=1';
                    ;
                    if ($part_no != '') {
                        $condition .= ' AND t.id="' . $part_no . '"';
                    }
                    if ($brand_id != '') {
                        $condition .= ' AND t.brand="' . $brand_id . '"';
                    }
                     if ($customer_id != '') {
                        $condition .= ' AND t.customer_id="' . $customer_id . '"';
                    }
                    $condition .= ' AND t.type="I"';
                    $criteria = new CDbCriteria();
                    $criteria->condition = $condition;
                    $criteria->order = 'part_number asc';
                    $item_count = Inventory::model()->count($criteria);

                    $criteria->offset = $offset;
                    $criteria->limit = $page_size;

                    $pageCounts = $item_count / $page_size;


                    $model_inventory = Inventory::model()->findAll($criteria);

                    foreach ($model_inventory as $i => $model) {
                        ?>

                        <tr>      
                            <td><?php echo $offset + $i + 1; ?></td>
                             <td><?php echo $model->customer->customer_name; ?></td>
                            <td><?php echo $model->part_number; ?></td>
                            <td><?php echo $model->brands->brand_name; ?></td> 
                            <?php
                            if (!empty($model_warehouse)) {
                                $toalval = 0;
                                foreach ($model_warehouse as $n => $each) {
                                    $warehouse_id = $each->id;
                                    $location_qty = Yii::app()->db->createCommand('SELECT IFNULL(SUM(quantity),0)  as quantity FROM view_stock_ledger_details WHERE warehouse_id = ' . $warehouse_id . ' AND  product_id='.$model->id.' AND stock_updated="Y" GROUP BY warehouse_id')->queryScalar();
                                    $total[$n]+=$location_qty;
                                    $toalval+=$location_qty;
                                    ?>
                                    <td class="text-right"><?php echo number_format($location_qty,2); ?></td>
                                    
                                    <?php
                                        $SQL = 'SELECT CONCAT(rack_name," : ",ROUND(SUM(quantity))) AS rack_name FROM `view_stock_ledger_details` AS ST 
                                                WHERE product_id='.$model->id.' AND ST.warehouse_id=' . $warehouse_id . ' GROUP By ST.rack_id';
                                        $arr_rack_name = Yii::app()->db->createCommand($SQL)->queryAll();
                                        $str_rack_name='';
                                        foreach($arr_rack_name as $eachRack){
                                            $str_rack_name.=$eachRack['rack_name'].'<br>';
                                        }
                                        
                                        $SQL1 = 'SELECT CONCAT(bin_name," : ",ROUND(SUM(quantity))) AS bin_name FROM `view_stock_ledger_details` AS ST 
                                                WHERE product_id='.$model->id.' AND ST.warehouse_id=' . $warehouse_id . ' GROUP By ST.bin_id';
                                        
                                        $arr_bin_name = Yii::app()->db->createCommand($SQL1)->queryAll();
                                        
                                        $str_bin_name='';
                                        foreach($arr_bin_name as $eachBin){
                                            $str_bin_name.=$eachBin['bin_name'].'<br>';
                                        }
                                        
                                        
                                       /* $SQL = 'SELECT CONCAT(RA.name," : ",SUM(quantity)) AS rack_name,CONCAT(BIN.name," : ",SUM(quantity)) AS bin_name FROM `erp_stock_ledger` AS ST 
                                                INNER JOIN erp_mas_inv_rack AS RA ON ST.rack_id=RA.id  
                                                INNER JOIN erp_mas_inv_bin AS BIN ON bin_id=BIN.id 
                                                WHERE product_id='.$model->id.' AND ST.warehouse_id=' . $warehouse_id . ' GROUP By ST.rack_id,ST.bin_id';*/
                                        
                                        
                                        
                                        ?>
                                    
                                    <td><?php echo $str_rack_name;?></td>
                                    <td><?php echo $str_bin_name;?></td>
                                    <?php
                                }
                            }
                            ?>
                            <td class="text-right"><?php echo number_format($toalval,2); ?></td>        
                        </tr>
                    <?php } ?>   
                </tbody>
            </table>
            <div class ="text-center">
                <input type="hidden" value="<?= $page_no ?>" name ="pgcount" id ="pagecount">

                <ul class="pagination">
                    <?php for ($index = 0; $index < $pageCounts; $index++) {
                        ?>
                        <li class="<?php if ($page_no == ($index + 1)) echo "active"; ?>" ><a href="#"  onclick="SetPage(<?= $index + 1 ?>)"  ><?php echo $index + 1; ?></a></li>
                    <?php }
                    ?>


                </ul> 
            </div>
            <br>
            <div class="btn-wrap text-center"> 
            
                <a title="Export Pdf" class="btn btn-theme" onclick="loadWarehousePDF();"><i class="fa fa-file-pdf-o"></i> &nbsp;PDF</a> 
                <a title="Export Excel" class="btn btn-theme" onclick="excelInvoiceList();"><i class="fa fa-file-excel-o"></i> &nbsp;Excel</a>

                <?php //echo CHtml::link('Export PDF',array('invreports/PrintWarehouseStockReportPDF','part_number'=>$part_no,'brand_id'=> $brand_id ,'loc' => $loc), array('title'=>'Print Lead List','target'=>'_blank','class' =>  'btn btn-theme'));     ?>    
                <!--<button type="button" class="btn btn-theme" onclick="excelInvoiceList();">Export Excel</button>-->
            </div>    
        </div>
    </div>
</div>
<script>
    function SetPage(pg)
    {
        $("#pagecount").val(pg);
        loadMasterReport();
        return false;
    }
</script>

<?php $cs = Yii::app()->getClientScript(); 



    $cs->registerScript("loadWarehousePDF", "function loadWarehousePDF(){
                           
            var url= '" . Yii::app()->createUrl('reports/PrintexcelInvoiceList') . "';
            var part_no = $('#warehouse_part_no').val(); 
            var type = $('#warehouse_report_type').val(); 
            var brand_id = $('#inv_warehouse_brand_name').val();
            var page_size =$('#pagesize').val();
            var page_no =$('#pagecount').val();
            var loc = $('#inv_warehouse_warehouse').val();
            var customer_id = $('#customer_id').val();
            window.open($('#liveSite').val()+'index.php?r=invreports/PrintWarehouseStockReportPDF&part_number='+part_no+'&type='+type+'&brand_id='+brand_id+'&loc='+loc+'&customer_id='+customer_id, '_blank'); 
            return false;
                
    }", CClientScript::POS_HEAD);
    

$cs->registerScript("excelInvoiceList", "function excelInvoiceList(){

            var url= '" . Yii::app()->createUrl('reports/PrintexcelInvoiceList') . "';
            var part_no = $('#warehouse_part_no').val(); 
            var type = $('#warehouse_report_type').val(); 
            var brand_id = $('#inv_warehouse_brand_name').val();
            var page_size =$('#pagesize').val();
            var page_no =$('#pagecount').val();
            var loc = $('#inv_warehouse_warehouse').val();
            var customer_id = $('#customer_id').val();
    window.open($('#liveSite').val()+'index.php?r=invreports/PrintWarehouseStockReportList&part_no='+part_no+'&type='+type+'&brand_id='+brand_id+'&loc='+loc+'&customer_id='+customer_id, '_blank');

}", CClientScript::POS_HEAD);
