<div class="panel">
    <div class="panel-heading panel-theme clearfix report-head">
        Detailed Provisional Report
        <div class="pull-right">
            <div class="filter_details">
                <?php if ($provisional_from_date != '') { ?>
                    <div class="filter-item">
                        <label>Provisional From :</label>
                        <?php echo $provisional_from_date; ?>
                    </div>
                    <?php
                }
                if ($provisional_to_date != '') {
                    ?>
                    <div class="filter-item">
                        <label>Provisional To :</label>
                        <?php echo $provisional_to_date; ?>
                    </div>


                <?php } if ($provisional_customer_id != '') { ?>
                    <div class="filter-item">
                        <label>Customer</label>
                        <?php echo Customer::model()->findByPK($provisional_customer_id)->customer_name; ?>
                    </div>
                <?php }
                ?>
            </div>
        </div>
    </div>
    <?php //if(Yii::app()->user->level==0){?>
    <div class="panel-body">
        <div class="table-responsive">
            <table id="tbl_invoice_table" class="table table-fixed table-bordered table-primary dataTable" style="font-size:12px;">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Job No</th>
                        <th>Customer</th>
                        <th>Lead Owner</th>
                         <th>Transport Type</th>
                        <th>Forwarder</th>
                        <th>AWB No</th>
                        <th>Activity Type</th>
                        <th>Invoice Date</th>
                        <th>Invoice No</th>
                        <th>Planned S.P</th>
                        <th>Planned Cost</th>
                        <th>Planned Profit</th>
                        <th>Invoice Amount</th>
                        <th>Commision Amount</th>
                        <th>Actual Cost</th>
                        <th>Actual Profit</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $condition = 'joborder.job_order_status!="CN"';


                    if ($provisional_from_date != '') {
                        $provisional_from_date = str_replace('/', '-', $provisional_from_date);
                        $provisional_from_date = date('Y-m-d', strtotime($provisional_from_date));
                        $condition .= ' AND joborder.job_date >="' . $provisional_from_date . '"';
                    }
                    if ($provisional_to_date != '') {
                        $provisional_to_date = str_replace('/', '-', $provisional_to_date);
                        $provisional_to_date = date('Y-m-d', strtotime($provisional_to_date));
                        $condition .= ' AND joborder.job_date <="' . $provisional_to_date . '"';
                    }


                    if ($provisional_customer_id > 0) {

                        $condition .= ' AND joborder.customer_id ="' . $provisional_customer_id . '"';
                    }
                    if ($provisional_leadowner_id > 0) {

                        $condition .= ' AND joborder.lead_owner_id ="' . $provisional_leadowner_id . '"';
                    }


                    if ($job_order_id != "") {

                        $condition .= ' AND job_order_id ="' . $job_order_id . '"';
                    }
                    if ($provisional_vendor_id != "") {

                        $condition .= ' AND t.shipper_id ="' . $provisional_vendor_id . '"';
                    }
                    if ($provisional_transport_type != "") {

                        $condition .= ' AND t.activity_type ="' . $provisional_transport_type . '"';
                    }
                    if ($provisional_awb_no != "") {

                        $condition .= ' AND t.awb_no ="' . $provisional_awb_no . '"';
                    }
                     if ($transport_type > 0) {

                        $condition .= ' AND joborder.transport_type ="' . $transport_type . '"';
                    }

                    /* if ($activity != '') {

                      $condition .= ' AND t.type_of_activity ="' . $activity . '"';
                      }
                      if ($activity_type != '') {

                      $condition .= ' AND t.activity_id ="' . $activity_type . '"';
                      }

                      if ($added_from != '') {

                      $condition .= ' AND t.added_from ="' . $added_from . '"';
                      }

                      /* if($activity_user != ''){

                      $condition .= ' AND t.crm_user_id ="'.$activity_user.'"';
                      } */
                    //echo $condition;
                    //$model_provisional = JobOrder::model()->with('customer', 'invoice')->findAll(array('condition' => $condition));
                    $model_provisional_detailed = JobOrderAgentDetails::model()->with('joborder')->findAll(array('condition' => $condition, 'order' => 'job_order_id DESC'));

                    $total = 0;
                    $actual_cost = 0;
                    $total_selling_price = 0;
                    $total_planned_cost = 0;
                    $total_planned_profit = 0;
                    $total_invoice_amount = 0;
                    $total_actual_cost = 0;
                    $total_actual_profit = 0;
                    $total_commision_amount=0;

                    foreach ($model_provisional_detailed as $i => $model) {

                        $arr_invoice_item_details = InvoiceItem::model()->find(array('condition' => 'order_item_id=' . $model->id));
                        $credited_amount=0;
                        //$arr_credited_amount=CreditnoteItem::model()->with('parent')->find(array('select'=>'SUM(net_amount)','condition' => 'invoice_item_id=' . $arr_invoice_item_details['id'].' AND parent.invoice_id='.$arr_invoice_item_details['invoice_id']));
                        if((int) $arr_invoice_item_details['id'] > 0 && (int) $arr_invoice_item_details['invoice_id'] > 0){
                            $SQL='SELECT SUM(net_amount) AS returned_amount FROM `erp_creditnote_item` INNER JOIN erp_creditnote AS CR ON creditnote_id=CR.id WHERE invoice_item_id=' . $arr_invoice_item_details['id'].' AND invoice_id='.$arr_invoice_item_details['invoice_id'];
                            $arr_credited_amount = Yii::app()->db->createCommand($SQL)->queryRow();
                            
                            $credited_amount = $arr_credited_amount['returned_amount'];
                        }

                        $invoice_amount = ($arr_invoice_item_details['quantity'] * $arr_invoice_item_details['rate']) - $credited_amount;
                        
                        
                        
                        ?>

                        <tr>

                            <td width="2%"><?php echo $i + 1; ?></td>

                            <td width="5%"><?php echo $model->joborder->id; ?></td>
                            <td width="15%"><?php echo $model->joborder->customer->customer_name; ?></td>
                            <td width="10%">
                                <?php echo $model->joborder->leadowner->first_name . ' ' . $model->joborder->leadowner->last_name; ?>
                            </td>
                            <td width="8%"><?php echo  $model->joborder->transporttype->transport_type; ?></td>
                            <td width="8%"><?php echo $model->shipper->vendor_name; ?></td>
                            <td width="10%"><?php echo $model->awb_no; ?></td>
                            <td width="8%"><?php echo $model->activitytype->activity_type; ?></td>
                            <?php if ($model->joborder->invoice->invoice_date != "" && $model->joborder->invoice->invoice_date != '0000-00-00') { ?>
                                <td width="5%"><?php echo date("d/m/Y", strtotime($model->joborder->invoice->invoice_date)); ?></td>
                            <?php } else { ?>
                                <td> </td>

                            <?php } ?>
                            <td width="5%"><?php
                                echo $model->joborder->invoice->id;
                                $planned_profit = $model->planned_selling_price - $model->planned_cost;
                                
                                
                                //code added by mereena on 06/01/2023 to get commision cost
                                $commision_amount = 0;
                                if($model->activity_type==40){//if commission
                                    if((int) $model->actual_cost==0){
                                        //$model->actual_cost+=$model->planned_cost;
                                        $commision_amount=$model->planned_cost;
                                    }
                                    else{
                                        $commision_amount=$model->actual_cost;
                                    }
                                    
                                }
                                $total_commision_amount+=$commision_amount;
                                //end
                                
                                
                                $actual_profit = $invoice_amount - $model->actual_cost;

                                $planned_profit_style = "";
                                if ($planned_profit < 0) {
                                    $planned_profit_style = "color:red";
                                }

                                $actual_profit_style = "";
                                if ($planned_profit > $actual_profit && $model->activity_type!=40) {
                                    $actual_profit_style = "color:red";
                                } else if ($planned_profit < $actual_profit) {
                                    $actual_profit_style = "color:green";
                                }
                                
                                
                                ?></td>
                            <td width="5%" class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($model->planned_selling_price, ""); ?></td>
                            <td width="5%" class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($model->planned_cost, ""); ?></td>
                            <td width="5%" class="text-right" style="<?php echo $planned_profit_style; ?>"><?php echo Yii::app()->numberFormatter->formatCurrency($planned_profit, ""); ?></td>
                            <td width="5%" class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($invoice_amount, ""); ?></td>
                            <td width="5%" class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($commision_amount, ""); ?></td>
                            <td width="5%" class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($model->actual_cost, ""); ?></td>
                            <td width="5%" class="text-right" style="<?php echo $actual_profit_style; ?>"><?php echo Yii::app()->numberFormatter->formatCurrency($actual_profit, ""); ?></td>
                            <?php
                            $grand_total = $invoice_amount;
                            $total_planned_cost += $model->planned_cost;
                            $actulcost = $model->actual_cost;
                            $total_invoice_amount += $grand_total;
                            $total_actual_cost += $actulcost;
                            $total_selling_price += $model->planned_selling_price;
                            $total_planned_profit += $planned_profit;
                            $total_actual_profit += $actual_profit;
                            ?>

                        </tr>
                    <?php } ?>

                    <tr>
                        <td colspan="10"> </td>
                        <td class="text-right"><b><?php echo Yii::app()->numberFormatter->formatCurrency($total_selling_price, " "); ?></b></td>
                        <td class="text-right"><b><?php echo Yii::app()->numberFormatter->formatCurrency($total_planned_cost, " "); ?></b></td>
                        <td class="text-right"><b><?php echo Yii::app()->numberFormatter->formatCurrency($total_planned_profit, " "); ?></b></td>
                        <td class="text-right"><b><?php echo Yii::app()->numberFormatter->formatCurrency($total_invoice_amount, " "); ?></b></td>
                        <td class="text-right"><b><?php echo Yii::app()->numberFormatter->formatCurrency($total_commision_amount, " "); ?></b></td>
                        <td class="text-right"><b><?php echo Yii::app()->numberFormatter->formatCurrency($total_actual_cost, " "); ?></b></td>
                        <td class="text-right"><b> <?php echo Yii::app()->numberFormatter->formatCurrency($total_actual_profit, " "); ?></b> </td>
                    </tr>
                </tbody>
            </table>
            <br>
            <div class="btn-wrap text-center">
                <?php
                echo CHtml::link('Export PDF', array('reports/PrintProvisionaldetailedPdf', 'provisional_from_date' => $provisional_from_date, 'provisional_to_date' => $provisional_to_date, 'provisional_customer_id' => $provisional_customer_id, 'provisional_leadowner_id' => $provisional_leadowner_id,'job_order_id' => $job_order_id,'type' => $type ,'title' => $title,'provisional_transport_type' => $provisional_transport_type,'provisional_awb_no' => $provisional_awb_no,'provisional_vendor_id' => $provisional_vendor_id,'transport_type' => $transport_type), array('title' => 'Print Provisional List', 'target' => '_blank', 'class' => 'btn btn-theme'));
                ?>

                <button type="button" class="btn btn-theme" onclick="excelProvisionalList();">Export Excel</button> 


            </div>
        </div>
    </div>
</div>
<?php /* }
  else{
  echo "<span style='color:red;text-align:center;'>Work in Progress....</span>";
  } */
?>
<?php
$cs = Yii::app()->getClientScript();

$cs->registerScript("excelProvisionalList", "function excelProvisionalList(){

    
    var provisional_customer_id = $('#provisional_customer_id').val();
    var provisional_leadowner_id = $('#provisional_leadowner_id').val();
    var provisional_from_date = $('#provisional_from_date').val();
    var provisional_to_date = $('#provisional_to_date').val();
    var provisional_type = $('#provisional_type').val();
    var provisional_job_order_id =$('#provisional_job_order_id').val();
    var provisional_vendor_id =$('#provisional_vendor_id').val();
    var provisional_awb_no =$('#provisional_awb_no').val();
    var provisional_transport_type =$('#provisional_transport_type').val();
    var transport_type = $('#transport_type').val();
        var pars = 'provisional_from_date='+provisional_from_date+'&provisional_to_date='+provisional_to_date+'&provisional_customer_id='+provisional_customer_id+'&provisional_leadowner_id='+provisional_leadowner_id+'&type='+provisional_type+'&job_order_id='+provisional_job_order_id+'&provisional_vendor_id='+provisional_vendor_id+'&provisional_awb_no='+provisional_awb_no+'&provisional_transport_type='+provisional_transport_type+'&transport_type='+transport_type;
        window.open($('#liveSite').val()+'index.php?r=reports/ProvisionaldetailedListExcel&'+pars, '_blank');

}", CClientScript::POS_HEAD);
?>