<div class="panel">
    <div class="panel-heading panel-theme clearfix report-head ">
        List of CreditNote
        <div class="pull-right">
            <div class="filter_details">

                <?php
                if ($from_date != '') {
                    ?>
                    <div class="filter-item">
                        <label>CreditNote From :</label>
                        <?php echo $from_date ?>
                    </div>
                    <?php
                }
                ?>
                <?php
                if ($to_date != '') {
                    ?>
                    <div class="filter-item">
                        <label>CreditNote To :</label>
                        <?php echo $to_date ?>
                    </div>
                    <?php
                }
                ?>
                <?php
                if ($customer_id != '') {
                    ?>
                    <div class="filter-item">
                        <label>Customer :</label>
                        <?php
                        $c = Customer::model()->findByPK($customer_id);
                        echo $c->customer_name;
                        ?>
                    </div>
                    <?php
                }
                ?>
                <?php
                if ($inv_type > 0) {
                    ?>
                    <div class="filter-item">
                        <label>Invoice Type :</label>
                        <?php
                        $l = MasInvoiceType::model()->findByPK($inv_type);
                        echo $l->inv_name;
                        ?>
                    </div>

                    <?php
                }
                ?>    

            </div>
        </div>
    </div>
    <div class="panel-body">
        <div class="table-responsive">
            <table id="tbl_invoice_table" class="table table-fixed table-bordered table-primary dataTable">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>CN Date</th>
                        <th>File No</th>
                        <th>Inv.No</th>
                        <th>CN No</th>
                        <th>Customer Name</th>
                        <th>Created By</th>
                        <th>Reason</th>
                        <th>Inv.Amount</th>
                        <th>VAT</th>                        
                        <th>Credit Amount</th>
                        <th>Grand Total(BC)</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $condition = "t.isActive='Y' AND invoice_id!=''";

                    if ($from_date != '') {
                        $from_date1 = str_replace('/', '-', $from_date);
                        $from_date1 = date('Y-m-d', strtotime($from_date1));
                        $condition .= ' AND t.credited_date >="' . $from_date1 . '"';
                    }
                    if ($to_date != '') {
                        $to_date1 = str_replace('/', '-', $to_date);
                        $to_date1 = date('Y-m-d', strtotime($to_date1));
                        $condition .= ' AND t.credited_date <="' . $to_date1 . '"';
                    }

                    if ($customer_id != '') {

                        $condition .= ' AND t.customer_id ="' . $customer_id . '"';
                    }
                    if ($inv_type > 0) {

                        $condition .= ' AND invoice.invoice_type ="' . $inv_type . '"';
                    }
                    if ($created_by != "") {
                        $condition .= " AND t.created_by = " . $created_by;
                    }
                    $total = 0;
                    $model_invoice = Creditnote::model()->with('customer', 'file', 'invoice')->findAll(array('condition' => $condition));
                    foreach ($model_invoice as $i => $model) {

                        $invoice_type = $model->invoice->invoice_type;
                        /* $invoice_no   = $model->invoice->invoice_no;
                          if((int) $invoice_type > 0){
                          $modelInvoiceType         = new MasInvoiceType();
                          $arr_invoice_type_details = $modelInvoiceType->findByPk((int) $invoice_type);
                          $inv_code                 = $arr_invoice_type_details->inv_code;
                          $invoice_no               = $inv_code.'-'.$invoice_no;
                          } */
                        $invoice_no = $model->invoice->id;
                        ?>
                        <tr>
                            <td>
                            <?php echo $i + 1; ?>
                            </td>
                                <?php if ($model->credited_date != '0000-00-00') { ?>
                                <td>
                                <?php echo date("d/m/Y", strtotime($model->credited_date)); ?>
                                </td>
                            <?php } else { ?>
                                <td>&nbsp;</td>
                                <?php } ?>
                            <td>
    <?php echo $model->file_id; ?>
                            </td>
                            <td>
    <?php echo $invoice_no; ?>
                            </td>
                            <td>
    <?php echo $model->id; ?>
                            </td>
                            <td class="nw">
    <?php echo $model->customer->customer_name; ?>
                            </td>
                            <td>
    <?php echo $model->getCreated_user(); ?>
                            </td>
                            <td><?php echo $model->reason; ?></td> 
                            <td><?php echo Yii::app()->numberFormatter->formatCurrency($model->invoice->grand_total, " "); ?></td> 
                            <td><?php echo Yii::app()->numberFormatter->formatCurrency($model->total_tax_amount, " "); ?></td> 

                            <td class="text-right">
                                <?php
                                $model_currency = MasCurrency::model()->findByPk($model->currency);
                                echo $model_currency->currency_code . ' ' . Yii::app()->numberFormatter->formatCurrency($model->credited_amount, " ");
                                ?>
                            </td>
                            <?php
                            $model_currency = MasCurrency::model()->findByPk($model->currency);
                            $total_bc = $model->credited_amount * $model_currency->exchange_rate;
                            $total += $total_bc
                            ?>
                            <td class="text-right">
    <?php echo Yii::app()->numberFormatter->formatCurrency($total_bc, " "); ?>
                            </td>                 


                        </tr>
<?php } ?>
                    <tr>
                        <td colspan="11"> </td>
                        <td class="text-right"><b> <?php echo Yii::app()->numberFormatter->formatCurrency($total, " "); ?></b> </td>
<!--                            <td colspan="1"> </td>-->
                    </tr>
                </tbody>
            </table>
            <br>
            <div class="btn-wrap text-center">
<?php echo CHtml::link('<i class="fa fa-file-pdf-o"></i> PDF', array('reports/PrintCreditNoteReportPDF', 'from_date' => $from_date, 'to_date' => $to_date, 'customer_id' => $customer_id, 'inv_type' => $inv_type, 'created_by' => $created_by), array('title' => 'Print Credit List', 'target' => '_blank', 'class' => 'btn btn-theme')); ?>
                <button type="button" class="btn btn-theme" onclick="excelCreditnoteList();"><i class="fa fa-file-excel-o"></i> &nbsp;Excel</button>
                <input type="hidden" value="<?= $from_date ?>" id="from_date">
                <input type="hidden" value="<?= $to_date ?>" id="to_date">
                <input type="hidden" value="<?= $customer_id ?>" id="customer_id">
                <input type="hidden" value="<?= $inv_type ?>" id="inv_type">
                <input type="hidden" value="<?= $created_by ?>" id="created_by">
            </div>
        </div>
    </div>
</div>
<?php
$cs = Yii::app()->getClientScript();

$cs->registerScript("excelCreditnoteList", "function excelCreditnoteList(){

    var url= '" . Yii::app()->createUrl('reports/PrintDeliveryListExcel') . "';

    var from_date = $('#from_date').val();

    var to_date = $('#to_date').val(); 

var customer_id = $('#customer_id').val();

    var inv_type = $('#inv_type').val();
    var created_by = $('#created_by').val();

    window.open($('#liveSite').val()+'index.php?r=reports/PrintCreditnoteExcel&from_date='+from_date+'&to_date='+to_date+'&customer_id='+customer_id+'&inv_type='+inv_type +'&created_by=' + created_by, '_blank');

}", CClientScript::POS_HEAD);
