<html>
    <head>
        <title>Service Store List</title>
    </head>
    <body>
    
    
        <div class="heading">
             <div class="logo col-6">
                <img src="images/pdf/logo.png">
            </div> 
            <div class="col-12 text-center" style="margin: 0 auto;">
                <h1><u>SERVICE STORE LIST</u></h1>
            </div>
            <div class="col-12">
                    <div class="details-box">

                        <table class="table" style="width:100%">
                            <?php
                            if ($from_date != '') {
                            ?>
                                <tr>
                                    <td><b>Transfer From Date</b></td>
                                    <td>
                                        <?php echo date('d/m/Y', strtotime($from_date)); ?>
                                    </td>
                                </tr>
                            <?php
                            }
                            ?>
                            <?php
                            if ($to_date != '') {
                            ?>
                                <tr>
                                    <td><b>Transfer To Date</b></td>
                                    <td>
                                        <?php echo date('d/m/Y', strtotime($to_date)); ?>
                                    </td>
                                </tr>
                            <?php
                            }
                            ?>
                            <?php
                            if ($reference != '') {
                            ?>
                                <tr>
                                    <td><b>Reference</b></td>
                                    <td>
                                        <?php echo $reference; ?>
                                    </td>
                                </tr>
                            <?php
                            }
                            ?>
                        </table>


                </div>
            </div>
        </div>
    
    
        
        <div class="clearfix"></div>
        <div class="panel">            
            <div class="panel-body">
                <div class="table-responsive">
                    <table id="tbl_order_table" class="table table-fixed table-bordered table-primary dataTable">
                        <thead>
                            <tr>
                                <th>No</th>
                                <th>Transfer No</th>


                                <th>Transfer Date</th>
                                <th>Reference</th>
                                <th>Item</th>
                                <th>Description</th>
                                <th>Qty</th>
                                <th>Unit</th>
                                

                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $condition = ' 1=1 ';
                            if ($reference != '') {
                                $condition .= " AND servicestore_details.reference LIKE '%" . $reference . "%' ";
                            }
                            if ($from_date != '' && $to_date != '') {
                                $from_date = str_replace('/', '-', $from_date);
                                $from_date = date('Y-m-d', strtotime($from_date));

                                $to_date = str_replace('/', '-', $to_date);
                                $to_date = date('Y-m-d', strtotime($to_date));

                                $condition .= " AND servicestore_details.transfer_date >= '" . $from_date . "' ";
                                $condition .= " AND servicestore_details.transfer_date <= '" . $to_date . "' ";
                            }
                            $model_order = ServiceStoreDetails::model()->with('servicestore_details')->findAll(array(
                                'condition' => $condition
                            ));
                            foreach ($model_order as $i => $model) {
                                ?>
                                <tr>
                                    <td><?php echo ($i + 1); ?></td>
                                    <td><?php echo $model->servicestore_details->id; ?></td>


                                    <td><?php echo date('d-m-Y', strtotime($model->servicestore_details->transfer_date)); ?></td>
                                    <td><?php echo $model->servicestore_details->reference; ?></td>
                                    <td><?php echo $model->product->part_number; ?></td>
                                    <td><?php echo $model->product->description; ?></td>
                                    <td><?php echo number_format((float)$model->quantity, 2, '.', ''); ?> </td>
                                    <td><?php echo $model->unitdetails->name; ?></td>                                    
                                </tr>
                                <?php
                            }
                            ?>
                    </table>


                </div>
            </div>

        </div>
    </body>
</html>


