<html>
<head>
    <title>List of Activity</title>
    <style>
        /* Add styles to ensure no overlapping */
        .table-fixed {
            table-layout: fixed;
            width: 100%;
            border-collapse: collapse;
        }
        .table-fixed th, .table-fixed td {
            word-wrap: break-word;
            text-align: left;
            padding: 8px;
        }
        .table-fixed th {
            background-color: #f2f2f2;
        }
        .table-fixed td {
            vertical-align: top;
        }
        .table-fixed th, .table-fixed td {
            border: 1px solid #ddd;
        }
        .filter-item {
            display: inline-block;
            margin-right: 15px;
        }
    </style>
</head>
<body>
    <div class="heading">
        <div class="header" style="width:100%;float:left;padding-bottom:10px;">
            <img src="<?php echo 'images/logo/' . Yii::app()->user->pdf_company_logo; ?>" />
        </div>
    </div>
    <div class="panel">
        <div class="panel-heading panel-theme clearfix report-head">
            List of Activity
            <div class="pull-right">
                <div class="filter_details">
                    <?php if ($activity_closing_from_date != '') { ?>
                        <div class="filter-item">
                            <label>Activity From:</label>
                            <?php echo date("d/m/Y", strtotime($activity_closing_from_date)); ?>
                        </div>
                    <?php } ?>
                    <?php if ($activity_closing_to_date != '') { ?>
                        <div class="filter-item">
                            <label>Activity To:</label>
                            <?php echo date("d/m/Y", strtotime($activity_closing_to_date)); ?>
                        </div>
                    <?php } ?>
                    <?php if ($activity_user != '') { ?>
                        <div class="filter-item">
                            <label>User:</label>
                            <?php
                            $c = User::model()->findByPK($activity_user);
                            echo $c->first_name . ' ' . $c->last_name;
                            ?>
                        </div>
                    <?php } ?>
                    <?php if ($customer_id != '') { ?>
                        <div class="filter-item">
                            <label>Customer:</label>
                            <?php echo Customer::model()->findByPK($customer_id)->customer_name; ?>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>
        <div class="panel-body">
            <div class="table-responsive">
                <table id="tbl_invoice_table" class="table table-fixed table-bordered table-primary dataTable">
                    <thead>
                        <tr>
                            <th style="width:5%;">No</th>
                            <th style="width:10%;">From</th>
                            <th style="width:15%;">Customer</th>
                            <th style="width:10%;">Ref#</th>
                            <th style="width:15%;">Type</th>
                            <th style="width:15%;">Date of Activity</th>
                            <th style="width:10%;">Assigned</th>
                            <th style="width:10%;">Follow Up Date</th>
                            <th style="width:10%;">Notes</th>
                            <th style="width:10%;">Activity</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $condition = '1=1';
                        if ($activity_closing_from_date != '') {
                            $activity_closing_from_date = str_replace('/', '-', $activity_closing_from_date);
                            $activity_closing_from_date = date('Y-m-d', strtotime($activity_closing_from_date));
                            $condition .= ' AND DATE(t.task_date_time) >="' . $activity_closing_from_date . '"';
                        }
                        if ($activity_closing_to_date != '') {
                            $activity_closing_to_date = str_replace('/', '-', $activity_closing_to_date);
                            $activity_closing_to_date = date('Y-m-d', strtotime("+1 day", strtotime($activity_closing_to_date)));
                            $condition .= ' AND DATE(t.task_date_time) <="' . $activity_closing_to_date . '"';
                        }
                        if ($customer_id > 0) {
                            $condition .= ' AND t.customer_id ="' . $customer_id . '"';
                        }
                        if ($activity_user > 0) {
                            $condition .= ' AND t.assigned_to ="' . $activity_user . '"';
                        }
                        if ($activity != '') {
                            $condition .= ' AND t.added_from ="' . $activity . '"';
                        }
                        if ($activity_type != '') {
                            $condition .= ' AND t.task_type ="' . $activity_type . '"';
                        }
                        if ($added_from != '') {
                            $condition .= ' AND t.added_from ="' . $added_from . '"';
                        }
                        if (((int)Yii::app()->user->havePermissionOn["activity_view_all"]) == 0) {
                            $condition .= ' AND (t.assigned_from="' . Yii::app()->user->id . '" OR t.assigned_to="' . Yii::app()->user->id . '")';
                        }
                        $modelActivity = Activity::model()->with('customer', 'assignedTo', 'tasktype')->findAll(array('condition' => $condition, 'order' => 't.task_date_time DESC'));
                        foreach ($modelActivity as $i => $model) {
                            $display_added_from = ActivityMasAddedFrom::getActivityFromByCode($model['added_from']);
                            $type = ($model['added_from'] == 'DI') ? "Dispute" : "Task";
                            $customer_name = $model->customer->customer_name;
                            if ($model['added_from'] == 'LE') {
                                $customer_name = $model['customer_name'];
                            }
                        ?>
                            <tr>
                                <td><?php echo $i + 1; ?></td>
                                <td><?php echo $display_added_from; ?></td>
                                <td><?php echo $customer_name; ?></td>
                                <td><?php echo $model->header_id; ?></td>
                                <td><?php echo $model->tasktype->type; ?></td>
                                <td><?php echo ($model->task_date_time != '0000-00-00') ? date("d/m/Y H:i:s", strtotime($model->task_date_time)) : ''; ?></td>
                                <td><?php echo $model->assignedTo->FullName; ?></td>
                                <td><?php echo ($model->task_date_time != '0000-00-00') ? date("d/m/Y H:i:s", strtotime($model->task_date_time)) : ''; ?></td>
                                <td><?php echo $model->notes; ?></td>
                                <td><?php echo $type; ?></td>
                            </tr>
                        <?php } ?>
                    </tbody>
                </table>
                <br>
            </div>
        </div>
    </div>
    <htmlpagefooter name="myfooter">
        <div style="text-align:center;width:100%;font-size:10px">
            <?= Yii::app()->user->footer_autogenerated; ?>
            <?php date_default_timezone_set("Asia/Dubai"); echo date('d/m/Y') . " " . date("h:i:sa"); ?>
        </div>
        <div style="border-top: 1px dotted #000000; font-size:12px; text-align:center; padding-top:10px; background-color:#d7faeb;">
            <div><b><?= Yii::app()->user->footer_line_1 ?></b><br><?= Yii::app()->user->footer_line_2 ?></div>
            <div>Page {PAGENO} of {nb}</div>
        </div>
    </htmlpagefooter>
    <sethtmlpagefooter name="myfooter" page="all" value="on" />
</body>
</html>
