<head>
    <title>CUSTOMER LIST</title>
</head>

<body>
    <div class="heading">
        <div class="header" style="width:100%;float: left;padding-bottom:10px;">
            <img src="<?php echo 'images/logo/' . Yii::app()->user->pdf_company_logo; ?>" />
        </div>
    </div>
    <div class="clearfix"></div>
    <div class="title">
        <div class="col-6">
            <div style="height: 10px;"></div>
        </div>
        <div class="col-6 text-center" style="margin: 0 auto;">
            <h1>CUSTOMER LIST</h1>
            <div class="details-box">
                <?php
                // Display filters used
                if (!empty($customer_details['customer_name'])) {
                    echo "<div class='filter-item'><label>Customer :</label> {$customer_details['customer_name']}</div>";
                }
                if (!empty($customer_details['country'])) {
                    $country_name = MasCountry::getFilledCountryName($customer_details['country']);
                    echo "<div class='filter-item'><label>Country :</label> {$country_name}</div>";
                }
                if (!empty($customer_details['industry'])) {
                    $industry_name = MasIndustry::getIndustriesName($customer_details['industry']);
                    echo "<div class='filter-item'><label>Industry :</label> {$industry_name}</div>";
                }
                if (!empty($customer_details['create_from_date']) && !empty($customer_details['create_to_date'])) {
                    $created_from_date = date('d/m/Y', strtotime(str_replace('/', '-', $customer_details['create_from_date'])));
                    $created_to_date = date('d/m/Y', strtotime(str_replace('/', '-', $customer_details['create_to_date'])));
                    echo "<div class='filter-item'><label>Created from :</label> {$created_from_date} to {$created_to_date}</div>";
                }
                if (!empty($customer_details['customer_phoneno'])) {
                    echo "<div class='filter-item'><label>Phone No :</label> {$customer_details['customer_phoneno']}</div>";
                }
                if (!empty($customer_details['customer_email'])) {
                    echo "<div class='filter-item'><label>E-mail :</label> {$customer_details['customer_email']}</div>";
                }
                if (!empty($customer_details['lead_owner'])) {
                    $lead_owner_name = User::model()->findByPk($customer_details['lead_owner'])->fullname;
                    echo "<div class='filter-item'><label>Lead Owner :</label> {$lead_owner_name}</div>";
                }
                ?>
            </div>
        </div>
    </div>
    <div class="clearfix"></div>
    <div class="table-body">
        <table id="tbl_customer_table" class="table table-stripped">
            <thead>
                <tr>
                    <th>No</th>
                    <th>Name</th>
                    <th>Credit Limit</th>
                    <th>Address</th>
                    <th>City</th>
                    <th>Postal Code</th>
                    <th>State</th>
                    <th>Country</th>
                    <th>Currency</th>
                    <th>Industry</th>
                    <th>LeadOwner</th>
                    <th>Created Date/Time</th>
                    <th>Last Updated Date/Time</th>
                </tr>
            </thead>
            <tbody>
                <?php
                // Query logic with conditions similar to PrintCustomerExcel
                $criteria = new CDbCriteria;

                if (!empty($customer_details['customer_name'])) {
                    $criteria->addCondition('t.customer_name LIKE "%' . $customer_details['customer_name'] . '%"');
                }
                if (!empty($customer_details['country'])) {
                    $criteria->addCondition('t.customer_country = "' . $customer_details['country'] . '"');
                }
                if (!empty($customer_details['industry'])) {
                    $criteria->addCondition('t.customer_industry = "' . $customer_details['industry'] . '"');
                }
                if (!empty($customer_details['create_from_date']) && !empty($customer_details['create_to_date'])) {
                    $create_from_date = date('Y-m-d', strtotime(str_replace('/', '-', $customer_details['create_from_date'])));
                    $create_to_date = date('Y-m-d', strtotime(str_replace('/', '-', $customer_details['create_to_date'])));
                    $criteria->addCondition('DATE(t.created_date_time) >= "' . $create_from_date . '"');
                    $criteria->addCondition('DATE(t.created_date_time) <= "' . $create_to_date . '"');
                }
                if (!empty($customer_details['customer_phoneno'])) {
                    $criteria->addCondition('t.customer_phone_no LIKE "%' . $customer_details['customer_phoneno'] . '%"');
                }
                if (!empty($customer_details['customer_email'])) {
                    $criteria->addCondition('t.customer_email_id LIKE "%' . $customer_details['customer_email'] . '%"');
                }
                if (!empty($customer_details['lead_owner'])) {
                    $criteria->addCondition('t.lead_owner_id = "' . $customer_details['lead_owner'] . '"');
                }
                // if (User::isSalesman() == 'Y') {
                //     $criteria->addCondition('t.lead_owner_id = "' . Yii::app()->user->id . '"');
                // }
                echo $customers = Customer::model()->with('country', 'currency_detail', 'industry_details', 'user')->findAll($criteria);

                foreach ($customers as $i => $customer) {
                    echo "<tr>
                        <td>" . ($i + 1) . "</td>
                        <td>{$customer->customer_name}</td>
                        <td>{$customer->customer_credit_limit}</td>
                        <td>{$customer->customer_address}</td>
                        <td>{$customer->customer_city}</td>
                        <td>{$customer->customer_postal_code}</td>
                        <td>{$customer->customer_state}</td>
                        <td>{$customer->country->country_name}</td>
                        <td>{$customer->currency_detail->currency}</td>
                        <td>{$customer->industry_details->name}</td>
                        <td>{$customer->user->fullname}</td>
                        <td>" . date('d/m/Y h:i:s', strtotime($customer->created_date_time)) . "</td>
                        <td>" . date('d/m/Y h:i:s', strtotime($customer->updated_date_time)) . "</td>
                    </tr>";
                }
                ?>
            </tbody>
        </table>
    </div>

    <htmlpagefooter name="myfooter">
        <div style="border-top: 1px dotted #000000; font-size: 12px; text-align: center; padding-top: 10px;">
            <div>This report is auto-generated by Bluesky ERP on <?php echo date('d/m/Y h:i:sa'); ?></div>
            <div>Page {PAGENO} of {nb}</div>
        </div>
    </htmlpagefooter>
    <sethtmlpagefooter name="myfooter" page="all" value="on" />
</body>

</html>
