<script>
    $(document).ready(function () {
    var table_id = "#tbl_fuel_sub_charges";
    var table = $(table_id).on("preXhr.dt", function (e, settings, data) {
    data.display_type = $("#display_type").val();
    return data;
    }).DataTable({
    scrollY: "645px",
            pageLength: 50,
            processing: true,
            ajax: {
            url: "<?php echo Yii::app()->createUrl('fuelsubcharges/GetList') ?>",
                    type: "POST",
                    cache: false,
            },
            serverSide: true,
            fixedColumns: true,
            processing: true,
            "fnCreatedRow": function (nRow, aData, iDataIndex) {
            $(nRow).addClass("context-menu");
            },
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
            AddContextMenu(nRow, aData);
            if (aData[5].status == "N")  {
            $("td", nRow).addClass("bg-danger");
            }
            }
    });
    });
    function AddContextMenu(row, datas) {
        var mas_edit=0;
        var mas_disable=0;
        <?php if (isset(Yii::app()->user->havePermissionOn['fuel_charge_edit']) || Yii::app()->user->authorised_user == 1) { ?>
            var mas_edit=1;
        <?php } ?>
        <?php if (isset(Yii::app()->user->havePermissionOn['fuel_charge_disable']) || Yii::app()->user->authorised_user == 1) { ?>
            var mas_disable=1;
        <?php } ?> 
      
        $(row).contextMenu({
        selector: 'td',
            items: {
            "edit": {

                name: "Edit",
                        icon: "edit",
                        accesskey: "e",
                        callback: function () {
                        loadPopupModal("fuelsubcharges/create&id=" + datas[6].id, datas[6].code, "lg");
                        }, 
                    disabled: function(key, opt) { 
                        // this references the trigger element
                        if(mas_edit=='0'){
                            return !this.data('editDisabled'); 
                        }
                    }
                },
                "Disable_Enable":{
                        name: (datas[6].status == "Y") ?"Disable" : "Enable",
                                icon: "edit",
                                accesskey: "d",
                                callback: function () {
                                Disable(datas[6].id, datas[6].status);
                                },
                    disabled: function(key, opt) { 
                            // this references the trigger element
                            if(mas_disable=='0'){
                                return !this.data('Disable_EnableDisabled'); 
                            }
                    }
                }

            }
    });
    }
</script>
<script>
    function Disable(id, status){
    var r = confirm((status == "Y") ? 'Are you sure to disable this?' : 'Are you sure to enable this?');
    if (r == true)
    {
    jQuery.ajax({
    'type'  : 'post',
            'datatype' :'json',
            'data'  : 'id=' + id + "&status=" + status,
            'url'  : $('#liveSite').val() + 'index.php?r=fuelsubcharges/Disable',
            'cache': false,
            'success':function(data){
            if (data.status == 'fail'){
            t8.error('Error while Delete');
            } else {
            $('#tbl_fuel_sub_charges').DataTable().ajax.reload()
                    t8.success(' Success!');
            }
            }
    });
    }


    }
</script>
<section class="panel" style="background-color:#F6F3EE;">
    <header class="panel-heading clearfix panel-theame">
        <i class="fa fa-slack"></i> Fuel Sur Charge  
        <div class="pull-right">
            <?php if (isset(Yii::app()->user->havePermissionOn['fuel_charge_add']) || Yii::app()->user->authorised_user == 1) { ?>

                <button class="btn btn-sm btn-theme" onclick="loadPopupModal('fuelsubcharges/create', 'Add Sur Charge', 'lg')"><i class="fa fa-plus"></i> ADD</button>

            <?php } ?></div>

    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_fuel_sub_charges" style="font-size:13px;">
                <thead>
                    <tr>
                        <th>SI No</th>
                        <th>Agent</th>
                        <th>From Date</th>
                        <th>To Date</th>
                        <th>Sur Charge</th>
                    </tr>
                </thead>
                <tfoot>
                    <tr>
                        <th>SI No</th>
                        <th>Agent</th>
                        <th>From Date</th>
                        <th>To Date</th>
                        <th>Sur Charge</th>
                        
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>
</section>
