<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("loaddetails", 'function filterDataTable(branch_id,id,desg,dept,status)
    {
        var table_id ="#tbl_employee_details";
        var table = $(table_id).DataTable({
            scrollY         : "645px",
            scrollX         : "true",
           // scrollCollapse  : true,
            pageLength      : 50,
            processing: true,           
           // bSort: false,
            ajax: {
                url: "' . Yii::app()->createUrl('employee/GetEmployeeList') . '",
                type: "POST",
                "data" : {
                    "id" : id,"desg" : desg,"dept" : dept,"branch_id":branch_id,"status":status               
                },
                cache : false,
            },
            columnDefs: [
                       {
                          "targets": [10],"visible": false,
                       },
            ],
            order: [[ 10, "asc" ],[ 3, "asc" ]],
            "rowCallback": function ( row, data ){ 
                if(data[10]=="B" ){
                    $("td", row).css("background-color", "#ffcccb");
                }
            },	
            serverSide:     true,
            fixedColumns:   true,
            processing: true,
            
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            },
            
        });
        $(".dataTables_scrollFoot").hide();
    }	
		
    $(document).ready(function() {  	 	
        var branch_id= $("#branch_id_val").val();
        var employee_id= $("#employee_id_val").val();	
        var desg= $("#employee_designation_val").val();	
        var dept= $("#employee_department_id_val").val();
        var status = $("#active_emp_val").val();
        filterDataTable(branch_id,employee_id,desg,dept,status);
    });', CClientScript::POS_HEAD);
$cs->registerScript("employeedetails", "function employeedetails(){  
    $('#tbl_employee_details').DataTable().destroy();
    var branch_id= $('#branch_id_val').val();
    var employee_id = $('#employee_id_val').val();
    var desg = $('#employee_designation_val').val();
    var dept = $('#employee_department_id_val').val();
     var status = $('#active_emp_val').val();
    filterDataTable(branch_id,employee_id,desg,dept,status); 
};", CClientScript::POS_HEAD);
$cs->registerScript("BlockEmployee", "function BlockEmployee(id){

    var r = confirm('Are you sure to Block this Employee?');

        if(r==true)

        {

            jQuery.ajax({

              'type'  : 'post',

              'data'  : 'id=' + id,

              'url'  : $('#liveSite').val()+'index.php?r=employee/Block',

              'cache': false,

              'success':function(data){

                if(data=='fail'){

                    t8.error('This Employee cant be Blocked');

                }else {
                    
                    reloadTable('#tbl_employee_details');
                    t8.success('Employee Blocked SuccessFully!');

                }

               }

            });

        }





};", CClientScript::POS_HEAD);
$cs->registerScript("UnBlockEmployee", "function UnBlockEmployee(id){

    var r = confirm('Are you sure to UnBlock this Employee?');

        if(r==true)

        {

            jQuery.ajax({

              'type'  : 'post',

              'data'  : 'id=' + id,

              'url'  : $('#liveSite').val()+'index.php?r=employee/UnBlock',

              'cache': false,

              'success':function(data){

                if(data=='fail'){

                    t8.error('This Employee cant be UnBlocked');

                }else {
                    
                    reloadTable('#tbl_employee_details');
                    t8.success('Employee UnBlocked SuccessFully!');

                }

               }

            });

        }





};", CClientScript::POS_HEAD);
?>
<section class="panel">
    <header class="panel-heading clearfix panel-theame">
        <i class="fa fa-users"></i> Employee Details
        <div class="pull-right">
            <?php echo CHtml::dropdownlist('active_emp_val', '', array('Y' => 'Current', 'B' => 'Old'), array('empty' => 'All Employees', 'class' => 'col-sm-2 form-control_1', 'title' => 'Employee Status', 'onchange' => 'employeedetails();', 'data-search' => true)); ?>                   
            <?php echo CHtml::dropdownlist('branch_id_val', '', MasCompanyBranchSponsor::getCompanyBranches(), array('empty' => 'All Branches', 'class' => 'col-sm-3 form-control_1', 'title' => 'Please Select Branch', 'onchange' => 'employeedetails();', 'data-search' => true)); ?>                   
            <?php echo CHtml::dropdownlist('employee_id_val', '', Employee::getEmployee(), array('empty' => 'All Employees', 'class' => 'col-sm-3 form-control_1', 'title' => 'Please Select Employee', 'onchange' => 'employeedetails();', 'data-search' => true)); ?>                   
            <?php echo CHtml::dropdownlist('employee_department_id_val', '', MasDepartment::getDepartment(), array('empty' => 'All Department', 'class' => 'col-sm-2 form-control_1', 'title' => 'Please Select Department', 'onchange' => 'employeedetails();', 'data-search' => true)); ?>                   
            <?php echo CHtml::dropdownlist('employee_designation_val', '', MasDesignation::getDesignation(), array('empty' => 'All Designation', 'class' => 'col-sm-2 form-control_1', 'title' => 'Please Select Designation', 'onchange' => 'employeedetails();', 'data-search' => true)); ?>                   

            <?php if (isset(Yii::app()->user->haveHrPermissionOn['hr_employee_details_add']) || Yii::app()->user->authorised_user == 1) { ?>
                <button class="btn btn-sm btn-theme" onclick="loadPopupModal('employee/create', 'Add New Employee', 'lg')"><i class="fa fa-plus"></i></button>  &nbsp;
            <?php } ?>
            <?php if (isset(Yii::app()->user->haveHrPermissionOn['hr_employee_details_upload']) || Yii::app()->user->authorised_user == 1) { ?>
                <button class="btn btn-sm btn-theme" onclick="loadPopupModal('employee/uploademployee', 'Upload Employees', 'lg')"><i class="fa fa-upload"></i></button>  
            <?php } ?>
        </div>
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_employee_details" style="width: 100%;">
                <thead>
                    <tr>
                        <th class="text-center">No</th>
                        <th class="text-center">Branch</th>
                        <th class="text-center">Code</th>
                        <th class="text-center">Employee Name</th>
                        <th class="text-center">MOL No</th>
                        <th class="text-center">Department</th>  
                        <th class="text-center">Designation</th>  
                        <th class="text-center">Joining Date</th>
                        <th class="text-center">Reporting Manager</th>
                        <th class="text-center">Actions</th>
                        <th></th>
                    </tr>
                </thead>
                <tfoot>
                <th class="text-center">No</th>
                <th class="text-center">Branch</th>
                <th class="text-center">Code</th>
                <th class="text-center">Employee Name</th>
                <th class="text-center">MOL No</th>
                <th class="text-center">Department</th>  
                <th class="text-center">Designation</th>  
                <th class="text-center">Joining Date</th>
                <th class="text-center">Reporting Manager</th>
                <th class="text-center">Actions</th>
                <th></th>
                </tfoot>
            </table>
        </div>
        <div class="color-indicator">
            <span style="display: inline-block;width:30px;height:30px;background:#ffffff; box-shadow: 0px 2px 10px 2px #b7b5b5"></span><span class="verti"> Active</span>
            <span style="display: inline-block;width:30px;height:30px;background:#ffcccb; box-shadow: 0px 2px 10px 2px #b7b5b5"></span><span class="verti"> Inactive</span>
        </div>
    </div>
</section>
