<?php
$today_date = (int) date('d');
$month = date("m");
$current_year = date("Y");
function getDaysInMonth($month, $year) {
    return cal_days_in_month(CAL_GREGORIAN, $month, $year);
}

function getLastDayOfMonth($year, $month) {
    // Create a date string for the first day of the given month and year
    $dateStr = sprintf('%04d-%02d-01', $year, $month);
    // Create a DateTime object for the date
    $date = new DateTime($dateStr);
    // Modify the date to the last day of the month
    $date->modify('last day of this month');
    
    return $date->format('d');
}

// Example usage



$days_in_current_month = getDaysInMonth($month, $current_year);

$monthNames = [];
$currentMonth = (int)date('n');

for ($month = 1; $month <= $currentMonth; $month++) {
    $monthName = DateTime::createFromFormat('!m', $month)->format('F');
    $monthNames[$month] = $monthName;
}

$startYear = ((int) $current_year - 3);
$years = [];
for ($year = $startYear; $year <= $current_year; $year++) {
    $years[$year] = $year;
}


$format = 'd'; // Day only
/*$lastDay = getLastDayOfMonth($sel_year, $sel_month);
if($sel_month==(int) date("m")){*/
    $lastDay = $today_date;
//}
//echo $lastDay;
$start_date = date($sel_year.'-'.$sel_month.'-01');
$end_date = date($sel_year.'-'.$sel_month.'-'.$lastDay);

//echo $start_date."=====".$end_date;

?>
<style>
    .trhover:hover{
        background-color: #d1deec;
    }
</style>
<div class="panel-body">
    <div class="table-responsive">
        
        <div>
             <ul class="clearfix form-ul material">
                    <li class="col-sm-3">
                        <div class="material">
                            <?php echo CHtml::dropDownList('sales_target_year', (int) $sel_year, $years, array('data-label' => 'Select Year', 'onchange' => 'setgraphdate(this.value);')); ?>
                        </div>
                    </li>
                    <li class="col-sm-3">
                        <div class="material">
                            <?php echo CHtml::dropDownList('sales_target_month', (int) $sel_month, $monthNames, array('data-label' => 'Select Month', 'onchange' => 'setgraphdate(this.value);')); ?>
                        </div>
                    </li>
                    <li class="col-sm-6">
                        <button type="button" onclick="loadMonthlySalesTarget('MonthlySalesTarget', 'monthly-sales-target-accordion','','');" class='plan-save-btn btn btn-theme'>Load</button>
                    </li>
                </ul>
            
        </div>
        <table id="tbl_invoice_table" class="table table-fixed table-bordered table-primary dataTable" style="font-size:12px;">
            <thead>
                <tr>
                    <th>Sales Person</th>
                    <th width="12%">Target</th>
                    <th width="12%">Daily Target</th>
                    <th width="12%">Acheived</th>
                    <th width="12%">Performance</th>
                    <th width="12%" >Performance(%)</th>
                    <?php
                    if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["dashboard_view_all_trend"])) {
                        $condition = " isActive = 'Y' AND is_lead_owner ='Y' ";
                    } else {
                        $condition = "id=" . Yii::app()->user->id;
                    }
                    $userList = User::model()->findAll([
                        "condition" => $condition,
                        'order' => 'first_name asc']);
                   /* for ($index = 0; $index < $month; $index++) {
                        $increment = $index + $month;
                        $new_month = ((($increment) % $month ) + 1);
                        $start_date = "";
                        if ($increment < $month) {
                            $start_date = date("M-y", strtotime("$current_year-$new_month-01"));
                        } else {
                            $start_date = date("M-y", strtotime("$current_year-$new_month-01"));
                        }
                        ?>
                        <th class="text-center">
                            <?php echo $start_date ?>
                        </th>
                        <?php
                    }*/
                    ?>
                </tr>
            </thead>
            <tbody>
                <?php
                $totat_amount = [];
                foreach ($userList as $key => $user) {
                    ?>
                    <tr class="trhover">
                        <td>
                            <?php echo $user->first_name . " " . $user->last_name; ?>
                        </td>
                        <td class="text-right">
                            <?php echo Yii::app()->numberFormatter->formatCurrency($user->target,""); ?>
                        </td>
                        <?php
                        
                        $SQL = "SELECT SUM(planned_selling_price) AS total_selling_price, SUM(planned_cost) AS total_planned_cost, SUM(actual_cost) AS total_actual_cost FROM erp_job_order_agent_details agent 
                                    INNER JOIN erp_job_order JO ON( agent.job_order_id = JO.id )  
                                    WHERE job_order_status!='CN' AND `activity_type` != 40 AND JO.lead_owner_id = $user->id AND JO.job_date >= '$start_date' AND   JO.job_date <= '$end_date' ; ";
                       
                        $arr_job_order = Yii::app()->db->createCommand($SQL)->queryRow();
                         //echo "test=".$arr_job_order['total_selling_price'];
                        $planned_selling_price = $arr_job_order['total_selling_price'];
                        $planned_cost = $arr_job_order['total_planned_cost'];
                        $actual_cost = $arr_job_order['total_actual_cost'];
                        $acheived = $planned_selling_price - $planned_cost;
                         
                        
                        $daily_target = round((($user->target / $days_in_current_month) * $today_date),2);
                        
                        $performance = round(($acheived - $daily_target),2);
                        
                        // if($performance > 0){
                        //     $style='style="color:green;font-weight:bold"';
                            
                        //     $performance_percent = round((($performance / $daily_target) *100),2);
                        // }
                        // else{
                        //     $style='style="color:red;font-weight:bold"';
                        //     $performance_percent = round((($performance / $acheived) *100),2);
                        // }
                        if ($performance > 0) {
                            $style = 'style="color:green;font-weight:bold"';
                        
                            // Check if $daily_target is non-zero
                            if (!empty($daily_target) && $daily_target != 0) {
                                $performance_percent = round((($performance / $daily_target) * 100), 2);
                            } else {
                                $performance_percent = 0; // Default value when $daily_target is zero or undefined
                            }
                        } else {
                            $style = 'style="color:red;font-weight:bold"';
                        
                            // Check if $acheived is non-zero
                            if (!empty($acheived) && $acheived != 0) {
                                $performance_percent = round((($performance / $acheived) * 100), 2);
                            } else {
                                $performance_percent = 0; // Default value when $acheived is zero or undefined
                            }
                        }
                        
                        
                        
                        
                        ?>
                        <td class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($daily_target,"");?></td>
                        <td class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($acheived,"");?></td>
                        <td class="text-right" <?php echo $style;?>><?php echo Yii::app()->numberFormatter->formatCurrency($performance,"");?></td>
                        <td class="text-right" <?php echo $style;?>><?php echo Yii::app()->numberFormatter->formatCurrency($performance_percent,"");?></td>
                        </tr>
                        <?php } ?>
        </table>
    </div>
</div>