<?php
$today_date = date('d');
$month = date("m");
$current_year = date("Y");
$previous_year = $current_year - 1;
?>
<style>
    .trhover:hover{
        background-color: #d1deec;
    }
</style>
<div class="panel-body">
    <div class="table-responsive">
        <table id="tbl_invoice_table" class="table table-fixed table-bordered table-primary dataTable" style="font-size:12px;">
            <thead>
                <tr>
                    <th>Sales person</th>
                    <?php
                    if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["dashboard_view_all_trend"])) {
                        $condition = " isActive = 'Y' AND is_lead_owner ='Y' ";
                    } else {
                        $condition = "id=" . Yii::app()->user->id;
                    }
                    $userList = User::model()->findAll([
                        "condition" => $condition,
                        'order' => 'first_name asc']);
                    for ($index = 0; $index < 12; $index++) {
                        $increment = $index + $month;
                        $new_month = ((($increment) % 12 ) + 1);
                        $start_date = "";
                        if ($increment < 12) {
                            $start_date = date("M-y", strtotime("$previous_year-$new_month-01"));
                        } else {
                            $start_date = date("M-y", strtotime("$current_year-$new_month-01"));
                        }
                        ?>
                        <th class="text-center">
                            <?php echo $start_date ?>
                        </th>
                        <?php
                    }
                    ?>
                </tr>
            </thead>
            <tbody>
                <?php
                $totat_amount = [];
                foreach ($userList as $key => $user) {
                    ?>
                    <tr class="trhover">
                        <td>
                            <?php echo $user->first_name . " " . $user->last_name ?>
                        </td>
                        <?php
                        $data = [];
                        for ($index = 0; $index < 12; $index++) {
                            $increment = $index + $month;
                            $new_month = ((($increment) % 12 ) + 1);
                            $start_date = "";
                            $end_date = "";
                            if ($increment < 12) {
                                $start_date = "$previous_year-$new_month-01";
                                $end_date = "$previous_year-$new_month-$today_date";
                            } else {
                                $start_date = "$current_year-$new_month-01";
                                $end_date = "$current_year-$new_month-$today_date";
                            }
                            $SQL = "SELECT SUM(planned_selling_price) AS total_selling_price, SUM(planned_cost) AS total_planned_cost, SUM(actual_cost) AS total_actual_cost FROM erp_job_order_agent_details JOIN erp_job_order ON( erp_job_order_agent_details.job_order_id = erp_job_order.id )  WHERE job_order_status!='CN' AND `activity_type` != 40 AND erp_job_order.lead_owner_id = $user->id AND erp_job_order.job_date >= '$start_date' AND   erp_job_order.job_date <= '$end_date' ; ";
                            $arr_totals = Yii::app()->db->createCommand($SQL)->queryAll();
                            $planned_selling_price = $arr_totals[0]['total_selling_price'];
                            $planned_cost = $arr_totals[0]['total_planned_cost'];
                            $actual_cost = $arr_totals[0]['total_actual_cost'];
                            $planned_profit = $planned_selling_price - $planned_cost;
                            $data[$index] = $planned_profit;
                            $totat_amount[$index] = (isset($totat_amount[$index]) ? (float) $totat_amount[$index] : 0) + $planned_profit;
                        }
                        $max_amount = max($data);
                        $min_amount = min($data);
                        for ($index = 0; $index < 12; $index++) {
                            $planned_profit = $data[$index];
                            ?>
                            <td
                            <?php
                            if (!empty($max_amount)) {
                                if ($max_amount == $planned_profit) {
                                    echo 'style="color:green;font-weight:bold"';
                                } else if ($min_amount == $planned_profit) {
                                    echo 'style="color:red;font-weight:bold"';
                                }
                            }
                            ?>
                                class="text-right">
                                    <?php echo number_format((float) $planned_profit, 2); ?>
                            </td>
                            <?php
                        }
                        ?>
                    </tr>
                    <?php
                }
                ?>
            </tbody>
            <thead>
                <tr>
                    <th>Total</th>
                    <?php for ($index1 = 0; $index1 < 12; $index1++) {
                        ?>
                        <th class="text-right">
                            <?php echo number_format((float) $totat_amount[$index1], 2); ?>
                        </th>
                        <?php
                    }
                    ?>
                </tr>
            </thead>
        </table>
    </div>
</div>