<?php
$cs = Yii::app()->getClientScript();
?>
<?php
$currentyear = date('Y');
$userList = User::model()->findAll([
    "condition" => $condition,
    'order' => 'first_name asc']);
?>
<div class="clearfix"></div>
<br>
<div class="clearfix">
    <div class="col-lg-4" data-initial-class="col-lg-4" id="pieChartParent">
        <section class="panel">
            <!--            <header class="panel-heading">
                              Lead- Lead Owner
                        </header>-->
            <div class="panel-body text-center">
                <div class="clearfix canvas-holder" id="lead_container_1">
                    <canvas id="lead_ownr_1" width="400" height="400"></canvas>
                </div>
            </div>
        </section>
    </div>
    <div class="col-lg-8">
        <input type="hidden" id="invoice_datefrom_1" name="invoice_datefrom_1" value="<?php echo $fromdate; ?>"/>
        <input type="hidden" id="invoice_dateto_1" name="invoice_dateto_1" value="<?php echo $todate; ?>"/>
        <table class="table table-hover table-bordered personal-task" id="tbl_graph_lead_details">
            <thead>
                <tr>

                    <th>Invoice Owner</th>
                    <th>Invoice Count</th>
                    <th>Amount</th>

                </tr>
            </thead>
            <tbody>
                <?php
                $data_array = [];
                foreach ($userList as $key => $user) {
                    $SQL = "SELECT COUNT(*) qty, SUM(erp_invoice_item.net_amount + erp_invoice_item.tax_vat_amount) AS invoice_amount FROM erp_invoice JOIN erp_invoice_item ON (erp_invoice_item.invoice_id = erp_invoice.id) JOIN erp_job_order ON (erp_invoice.order_id = erp_job_order.id )  where invoice_status!='C'  AND  erp_job_order.lead_owner_id = " . $user->id . "  AND   YEAR(invoice_date  ) = '$currentyear' ";
                    //echo $SQL;
                    $rawData = Yii::app()->db->createCommand($SQL)->queryAll();
                    $data = $rawData[0];

                    if (!empty($data) && !empty($data['qty'])) {
                        $color = substr(md5(rand()), 0, 6);
                        $data_array[] = [
                            "color" => "#" . $color,
                            "value" => $data['invoice_amount'],
                            "label" => $user->getFullname()
                        ];
                        ?>
                        <tr >
                            <td><?php echo $user->getFullname(); ?></td>
                            <td class="text-right"><?php echo $data['qty'] ?></td>
                            <td class="text-right"><?php echo number_format($data['invoice_amount'], 2) ?></td>
                        </tr>
                        <?php
                    }
                }
                $plot = json_encode($data_array);
                ?>
            </tbody>
        </table>

    </div>
    <div class="col-lg-12" id="lead_info"></div>
    <div class="col-lg-12" id="lead_month_info"></div>
    <div class="col-lg-12" id="quotes_month_owner_info"></div>
    <?php
    $cs->registerScript("loadgraph", "
    $(document).ready(function() {
    setTimeout(function() {
            var canvas1 =document.getElementById('lead_ownr_1');
        Chart.defaults.global.responsive = true;
        var ctx = canvas1.getContext('2d');
        var pieChart = new Chart(ctx).Pie(" . $plot . ");
          }, 300);
});", CClientScript::POS_HEAD);
    $cs->registerScript("getMonthDetails", "function getMonthDetails(month,year,ownerid){

         $('#loader').show();
            jQuery.ajax({
              'type'  : 'post',
              'data'  : 'month='+month+'&year='+year+'&ownerid='+ownerid,
              'url'  : $('#liveSite').val()+'index.php?r=dashboard/InvoiceGetMonthDetails',
              'cache': false,
              'success':function(data){
                $('#loader').hide();
                $('#lead_month_info').html(data);
                $('#quotes_month_owner_info').html('');
               }
            });



};", CClientScript::POS_HEAD);
    $cs->registerScript("getInvoiceItems", "function getInvoiceItems(invoice_id){

         $('#loader').show();
        // alert(orderid);
            jQuery.ajax({
              'type'  : 'post',
              'data'  : 'invoice_id='+invoice_id,
              'url'  : $('#liveSite').val()+'index.php?r=dashboard/getInvoiceItems',
              'cache': false,
              'success':function(data){
                $('#loader').hide();
                $('#quotes_month_owner_info').html(data);
               }
            });



};", CClientScript::POS_HEAD);
    ?>
