<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("disableCurrency",  "function disableCurrency(id){
    var r = confirm('Are you sure to disable/enable this?');
        if(r==true)
        {
            jQuery.ajax({
              'type'  : 'post',
              'data'  : 'id=' + id,
              'url'  : $('#liveSite').val()+'index.php?r=currency/disableCurrency',
              'cache': false,
              'success':function(data){
                if(data=='fail'){
                    t8.error('Error while Delete');
                }else {
                    location.href=$('#liveSite').val()+'index.php?r=currency/index';
                    t8.success('Currency Disabled/Enabled SuccessFully!');
                }
               }
            });
        }

   
};", CClientScript::POS_HEAD);
?>

<script>
    $(document).ready(function () {
        var table_id = "#tbl_currency_details";
        var table = $(table_id).on("preXhr.dt", function (e, settings, data) {
            data.display_type = $("#display_type").val();
            return data;
        }).DataTable({
            scrollY: "645px",
            pageLength: 50,
            processing: true,
            ajax: {
                url: "<?php echo Yii::app()->createUrl('currency/GetCurrencyList') ?>",
                type: "POST",
                cache: false,
            },
            serverSide: true,
            fixedColumns: true,
            processing: true,
            "fnCreatedRow": function (nRow, aData, iDataIndex) {
                $(nRow).addClass("context-menu");
            },
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                AddContextMenu(nRow, aData);
                if ( aData[5].isActive == "N" )  {  
                    $("td", nRow).addClass("bg-danger");
                } 
            }
        });
    });
    function AddContextMenu(row, datas) {
        var mas_edit=0;
        var mas_disable=0;
        <?php if (isset(Yii::app()->user->havePermissionOn['currency_edit']) || Yii::app()->user->authorised_user == 1) { ?>
            var mas_edit=1;
        <?php } ?>
        <?php if (isset(Yii::app()->user->havePermissionOn['currency_disable']) || Yii::app()->user->authorised_user == 1) { ?>
            var mas_disable=1;
        <?php } ?>  
        $(row).contextMenu({
            selector: 'td',

            items: {
                "edit": {
                    
                    
                    name: "Edit",
                    icon: "edit",
                    accesskey: "e",
                    callback: function () {
                        loadPopupModal("currency/create&id=" + datas[5].id, datas[5].code, "lg");
                    }, disabled: function(key, opt) { 
                            // this references the trigger element
                            if(mas_edit=='0'){
                                return !this.data('editDisabled'); 
                            }
			        }
                },
               
                "disable": {
                    name: "Enable/Disable",
                    icon: "fa-trash",
                    accesskey: "e",
                    callback: function () {
                        disableCurrency( datas[5].id);
                    },disabled: function(key, opt) { 
                            // this references the trigger element
                            if(mas_disable=='0'){
                                return !this.data('Disable_EnableDisabled'); 
                            }
			        }
                },
                                  
            }
        });
    }
</script>
    <section class="panel" style="background-color:#F6F3EE;">
        <header class="panel-heading clearfix panel-theame">
            <i class="fa fa-users"></i> Currency
            <div class="pull-right">
                <?php if (isset(Yii::app()->user->havePermissionOn['currency_add']) ||  Yii::app()->user->authorised_user == 1) {?>

                <button class="btn btn-sm btn-theme" onclick="loadPopupModal('currency/create','Add New Currency','lg')"><i class="fa fa-plus"></i> ADD</button>
                <?php } ?> </div>
        </header>
        <div class="panel-body">
            <div class="custom-data-table">
                <table class="table table-hover table-bordered personal-task" id="tbl_currency_details" style="font-size:13px;">
                    <thead>
                        <tr>
                            <th>SI No</th>
                            <th>Currency</th>
                            <th>Currency Code</th>
                            <th>Exchange Rate</th>
                            
                        </tr>
                    </thead>
                    <tfoot>
                        <tr>
                            <th>SI No</th>
                            <th>Currency</th>
                            <th>Currency Code</th>
                            <th>Exchange Rate</th>
                            
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </section>
