<script>
    $(document).ready(function () {

        var table_id = "#tbl_branch_details";
        var table = $(table_id).DataTable({
            scrollY: "380px",
            // scrollX         : "true",
            // scrollCollapse  : true,
            pageLength: 50,
            processing: true,
            ajax: {
                url: 'index.php?r=workspace/master/GetList',
                type: "POST",
                cache: false,
            },
            serverSide: true,
            fixedColumns: true,
            processing: true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            }
        });
        $(".dataTables_scrollFoot").hide();
    });
</script>
<section class="panel">
    <header class="panel-heading clearfix panel-theame">
        <i class="fa fa-users"></i> Workspace
        <div class="pull-right">
            <button class="btn btn-sm btn-theme" onclick="loadPopupModal('workspace/master/create', 'Add New Workspace', 'lg')"><i class="fa fa-plus"></i> ADD</button>
        </div>


    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_branch_details">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Workspace Name</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tfoot>
                    <tr>
                        <th>No</th>
                        <th>Workspace Name</th>
                        <th>Actions</th>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>
</section>
<script>

    function deleteWorkspaces(id) {
        var msg = "Are you sure you want to delete this item?";
        var dr = confirm(msg);
        if (dr) {
            $.ajax({
                url: "index.php?r=workspace/master/deleteItem",
                type: 'POST',
                dataType: 'json',
                data: {id: id},
                beforeSend: function (xhr) {
                    $("#loader").show();
                },
                success: function (data, textStatus, jqXHR) {
                     reloadTable("#tbl_branch_details");
                    $("#loader").hide();
                   
                }
            });
        }
    }
</script>
