<?php

$cs = Yii::app()->getClientScript();

$baseUrl = Yii::app()->baseUrl;

$form = $this->beginWidget('CActiveForm', array(
    'id' => 'excel-upload-lead-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
    ));

$model=new Lead();

?>
         

<div class="row">
<ul class="clearfix form-ul material">
    <li class="col-sm-6">
      <?php echo $form->hiddenField($model, 'id');?>
					<?php echo $form->labelEx($model,'uploadfile',array('label'=>'Document'));?>
                    <?php echo $form->hiddenField($model, 'uploadfile'); ?>
                    <?php echo $form->error($model,'uploadfile'); ?>
    
                <?php
                    $allowedExtensions = array("csv");
                    $this->widget('ext.EAjaxUpload.EAjaxUpload', array(
                        'id' => rand(),
                        'config' => array(
                            'action' => Yii::app()->createUrl('logistics/'.Yii::app()->controller->id . '/UploadDocuments',
                                array('folder' => 'upload/lead')),
                            'multiple' => false,
                            'allowedExtensions' => $allowedExtensions,
                            'sizeLimit' => 8 * 1024 * 1024,
                            'onStart' => "js:function(){}",
                            'class' => 'pull-right',
                            'onComplete' => "js:function(id, fileName, responseJSON){
                                 $('#Lead_uploadfile').val(responseJSON.filename);
                                $('.qq-upload-list').html(responseJSON.filename);
                            }",
                            )));
                ?>
                      
       
        <div class="icon_images">
            <input type="hidden" id="uploadfile" />
          
        </div>
        <?php //echo CHtml::hiddenField('update_customer_price','');?>
    </li>
    
     <li class="col-sm-6">
        <?php echo CHtml::link("<i class='fa fa-download'></i> Download Format", Yii::app()->createUrl('logistics/lead/DownloadLeadFormat'),array('class'=>'btn btn-link')); ?>
     </li>
</ul>

            <span id="success_message"></span>
            <span id="error_message" ></span>
</div>

   <div class="form-group" id="process" style="display:none;">
        <div class="progress">
       <div class="progress-bar progress-bar-striped active" role="progressbar" aria-valuemin="0" aria-valuemax="100" style="">
       </div>
      </div>
       </div>


<div class="modal-footer">
         <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>        
     
        <?php
               $url = Yii::app()->createUrl('logistics/lead/SaveLeadUpload');
                echo CHtml::ajaxSubmitButton('Save', $url, array(
                            'dataType' => 'json',
                            'type' => 'post',
                            'success' => 'function(data) {
                                var percentage = 0;
                                var success_msg = data.msg;
                                var error_msg = data.errors;
                                
                                
                                var timer = setInterval(function(){
                                   percentage = percentage + 20;
                                   progress_bar_process(percentage, timer,success_msg,error_msg);
                                 }, 1000);
                                
                            }',
                            'beforeSend' => 'function(){
                                var file         = $("#Lead_uploadfile").val();
                                if(file==""){
                                    t8.error("Please Upload a csv file"); 
                                    return false;
                                }
                                else{
                                    $("#process").css("display", "block");
                                    $("#excel-upload-lead-form .lead-save-btn").prop("disabled", true);                                
                                    //$("#excel-upload-lead-form .lead-save-btn").removeClass("btn-theme").addClass("btn_loding");
                                    
                                    
                                }

                               $(".toast8-error").hide();
                            }',
                            'complete' => 'function(){
                                
                            }'
                                
                    ), array('id' => 'mybtn' . rand(), 'class' => 'lead-save-btn btn btn-theme'));
          
    ?>
             <?php //} ?>   
    </div>


<?php $this->endWidget(); ?>
<script>
         
         function progress_bar_process(percentage, timer,success_msg,error_msg)
          {
           $('.progress-bar').css('width', percentage + '%');
           if(percentage > 100)
           {
            clearInterval(timer);
            //$('#job-order-form')[0].reset();
            $('#process').css('display', 'none');
            $('.progress-bar').css('width', '0%');
            $('.lead-save-btn').attr('disabled', false);
            $('#success_message').html("<div class='alert alert-success'>"+success_msg+"</div>");
            reloadTable("#tbl_lead_details");
            if(error_msg!=''){
                $('#error_message').html("<div class='alert alert-danger'>"+error_msg+"</div>");
            }
            setTimeout(function(){
             $('#success_message').html('');
             $('#error_message').html('');
            }, 10000);
           }
          }

     </script>