<?php

$form = $this->beginWidget('CActiveForm', array(

    'id' => 'job-order-form',

    'enableAjaxValidation' => false,

    'enableClientValidation' => false,

    ));
    
    $model = new JobOrderAgentDetails();

?>

 <div class="tab-content">
        <div class="tab-pane active">
            <ul class="clearfix form-ul material">
                <li class="col-sm-6">
                     <?php echo $form->dropDownList($model, 'shipper_id', Vendor::getVendors(), array('title' => 'Agent','data-label'=>'Agent <span style="color:red">*</span>','empty'=>'--Select--')); ?>
                </li>
        
                
               
    		</ul>
        </div>
        
                    <span id="success_message"></span>
                    <span id="error_message" ></span>
      
    </div>

    <div class="form-group" id="process" style="display:none;">
        <div class="progress">
       <div class="progress-bar progress-bar-striped active" role="progressbar" aria-valuemin="0" aria-valuemax="100" style="">
       </div>
      </div>
       </div>

      

    <div class="modal-footer">

            <button type="button" class="btn btn-danger" id="joborder_close" data-dismiss="modal">Close</button>
            <button type="button" class="joborder-save-btn btn btn-theme" onclick="updateShipperStatus();return false;">Update Status</button>
           
    </div>

    <?php $this->endWidget(); ?>
<?php

    $cs = Yii::app()->getClientScript();
    
    

 $cs->registerScript("updateShipperStatus", "function updateShipperStatus(){
 
    var shipper_id  =   $('#JobOrderAgentDetails_shipper_id').val();
    if(shipper_id==''){
        t8.error('Please select a shipper');
        return false;
    }
    else{
        jQuery.ajax({
            'data' :{'shipper_id':shipper_id},
            'type':'post',
            'dataType' : 'json',
            'url': '" . Yii::app()->createUrl('logistics/joborder/updatebulktracking') . "',
            'beforeSend':function()
             {
              $('.joborder-save-btn').attr('disabled', 'disabled');
              $('#process').css('display', 'block');
             },
            'success': function(data) {
              var percentage = 0;
              
              var success_msg = data.success;
              var error_msg = data.error;
    
                  var timer = setInterval(function(){
                   percentage = percentage + 20;
                   progress_bar_process(percentage, timer,success_msg,error_msg);
                  }, 1000);
              
            }
        });
    }
}", CClientScript::POS_HEAD); 


     ?>
     
     <script>
         
         function progress_bar_process(percentage, timer,success_msg,error_msg)
          {
           $('.progress-bar').css('width', percentage + '%');
           if(percentage > 100)
           {
            clearInterval(timer);
            //$('#job-order-form')[0].reset();
            $('#process').css('display', 'none');
            $('.progress-bar').css('width', '0%');
            $('.joborder-save-btn').attr('disabled', false);
            $('#success_message').html("<div class='alert alert-success'>"+success_msg+"</div>");
            reloadTable("#tbl_job_order_details");
            if(error_msg!=''){
                $('#error_message').html("<div class='alert alert-danger'>"+error_msg+"</div>");
            }
            setTimeout(function(){
             $('#success_message').html('');
             $('#error_message').html('');
            }, 10000);
           }
          }

     </script>