<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'inventory-service-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
    ));
?>
<div class="tab-content">
        <ul class="clearfix form-ul material">
            
            <li class="col-sm-6">
                <?php echo $form->hiddenField($model, 'id'); ?> 
                <?php echo $form->textField($model, 'part_number', array('data-label' => 'Part Number <span style="color:red;">*</span>')); ?>
                <?php echo $form->hiddenField($model, 'type',array('value'=>'S')); ?> 
            </li>
            <li class="col-sm-6">
                <?php echo $form->textArea($model, 'description', array('data-label' => 'Description <span style="color:red;">*</span>')); ?>
            </li>
            
            <li class="col-sm-6">
            <?php echo $form->dropdownlist($model,'brand',MasBrand::getAllBrands(), array('class' => 'tooltipster', 'data-label' => 'Brand <span style="color:red;">*</span>'));?>
            </li>
            <li class="col-sm-6">
            <?php echo $form->dropdownlist($model,'generic_id',MasGeneric::getAllGeneric(), array('class' => 'tooltipster', 'data-label' => 'Generic <span style="color:red;">*</span>'));?>
            </li>
            <li class="col-sm-4">
            <?php 
                if($stype_readonly){
                    echo $form->dropdownlist($model,'unit',MasUnit::getAllBaseUnits(), array('class' => 'tooltipster', 'data-label' => 'Unit<span style="color:red;"> *</span>','disabled'=>true));
                    echo $form->hiddenField($model,'unit');
                }else{
                    echo $form->dropdownlist($model,'unit',MasUnit::getAllBaseUnits(), array('class' => 'tooltipster', 'data-label' => 'Unit'));
                }
            ?>
            </li>
            
            <li class="col-sm-4">
             <?php echo $form->dropdownlist($model,'tax_code',MasInvTax::getTax(), array('class' => 'tooltipster', 'data-label' => 'Tax<span style="color:red;"> *</span>'));?>
            </li>
            
            
            <li class="col-sm-4">
            <?php 
            if($model->default_service=='Y'){
               echo $form->dropdownlist($model,'default_service',array('N'=>'No','Y'=>'Yes'), array('class' => 'tooltipster', 'data-label' => 'Is Default? <span style="color:red;">*</span>','disabled'=>true));
               echo $form->hiddenField($model, 'default_service');
            }
            else{
                echo $form->dropdownlist($model,'default_service',array('N'=>'No','Y'=>'Yes'), array('class' => 'tooltipster', 'data-label' => 'Is Default? <span style="color:red;">*</span>'));
            }
            ?>
            </li>
            
        </ul>
    </div>
    <div class="modal-footer">
    <button type="button" class="btn btn-default" id="inv_close" data-dismiss="modal">Close</button>
    <?php 
                $url = Yii::app()->createUrl('logistics/inventory/SaveInventoryService');
                echo CHtml::ajaxSubmitButton('Save', $url, array(
                            'dataType' => 'json',
                            'type' => 'post',
                            'success' => 'function(data) {
                                if(data.status=="success"){  
                                    $("#inv_close").click();                                        
                                    t8.success("Inventory Details Saved Successfully!");
                                    reloadTable("#tbl_service_inventory");
                                } else { 
                                    $("#inventory-service-form .inventory-service-save-btn").prop("disabled", false);
                                    $("#inventory-service-form .inventory-service-save-btn").addClass("btn-theme").removeClass("btn_loading");
                                    $.each(data, function(key, val) {
                                        $("#inventory-service-form #"+key+"_em_").text(val).show(); 
                                        t8.error(""+val+""); 
                                    }); 
                                } 
                            }',
                            'beforeSend' => 'function(){
                                $(".toast8-error").hide(); 
                                $("#loader").show();
                                $("#inventory-service-form .inventory-service-save-btn").prop("disabled", true);                                
                                $("#inventory-service-form .inventory-service-save-btn").addClass("btn_loading").removeClass("btn-theme");
                                
                            }',
                            'complete' => 'function(){
                                $("#loader").hide();
                                $("#inventory-service-form .inventory-service-save-btn").prop("disabled", false);                                
                                $("#inventory-service-form .inventory-service-save-btn").addClass("btn-theme").removeClass("btn_loading");
                            }'
                                
                    ), array('id' => 'mybtn' . rand(), 'class' => 'inventory-service-save-btn btn btn-theme'));
           
    ?>
</div>
<?php $this->endWidget(); ?>