<?php
$currentYear = date('Y');
$previousYear = $currentYear - 1;
$month = date('m');
$customerId = (int) $model->id;
$data = [];
for ($index = 0; $index < 12; $index++) {
    $year = $previousYear;
    $newMonth = (($month + $index) % 12) + 1;
    if ($month + $index > 11) {
        $year = $currentYear;
    }
    $sql = "SELECT COUNT(*) as qty FROM `erp_quotation` WHERE  YEAR(quotation_date) = '$year' AND MONTH(quotation_date) = '$newMonth' AND quotation_status !='CA' AND customer_id = '$customerId'";
    $rawData = Yii::app()->db->createCommand($sql)->queryAll();
    $count = 0;
    $amount = 0;

    if (!empty($rawData)) {
        $count = (int) $rawData[0]['qty'];
        $amount = 1;
    }
    $sql = "SELECT COUNT(*) FROM `erp_job_order` where YEAR(job_date) = '$year' AND MONTH(job_date) = '$newMonth' AND customer_id = '$customerId' AND job_order_status !='CN' ";
    $qty = (float) Yii::app()->db->createCommand($sql)->queryScalar();

    $sql = "SELECT SUM(selling_price) FROM `erp_job_order` where YEAR(job_date) = '$year' AND MONTH(job_date) = '$newMonth' AND customer_id = '$customerId' AND job_order_status !='CN' ";
    $value = (float) Yii::app()->db->createCommand($sql)->queryScalar();

    $datetime = new DateTime();
    $datetime->setDate($year, $newMonth, 1);
    $data[] = ["date" => $datetime->format("c"),
        'hits' => $count,
        'job_order' => $qty,
        'job_value' => $value
    ];
//    $data[] = [
//        "date" => "01-$month-$year",
//        'quote_qty' => $count,
//        'quote_amount' => $amount,
//        "hits" => '2909', ​​
//        'views' => '8710', ​​
//        'visits' => '1607'];
}
?>
<div class="row">
    <div class="col-sm-12" style="height: 500">
        <div id="chartdiv"></div>
    </div>
</div>
<!-- Chart code -->
<script>
    am4core.ready(function () {

// Themes begin
        am4core.useTheme(am4themes_animated);
// Themes end

// Create chart instance
        var chart = am4core.create("chartdiv", am4charts.XYChart);

//

// Increase contrast by taking evey second color
        chart.colors.step = 2;

// Add data
        chart.data = <?= json_encode($data); ?>;//generateChartData();

// Create axes
        var dateAxis = chart.xAxes.push(new am4charts.DateAxis());
        dateAxis.renderer.minGridDistance = 50;

// Create series
        function createAxisAndSeries(field, name, opposite, bullet) {
            var valueAxis = chart.yAxes.push(new am4charts.ValueAxis());
            if (chart.yAxes.indexOf(valueAxis) != 0) {
                valueAxis.syncWithAxis = chart.yAxes.getIndex(0);
            }

            var series = chart.series.push(new am4charts.LineSeries());
            series.dataFields.valueY = field;
            series.dataFields.dateX = "date";
            series.strokeWidth = 2;
            series.yAxis = valueAxis;
            series.name = name;
            series.tooltipText = "{name}: [bold]{valueY}[/]";
            console.log(series);
            series.tensionX = 0.8;
            series.showOnInit = true;

//            valueAxis.renderer.line.stroke = series.stroke;
//            valueAxis.renderer.labels.template.fill = series.stroke;

            var interfaceColors = new am4core.InterfaceColorSet();

            switch (bullet) {
                case "triangle":
                    var bullet = series.bullets.push(new am4charts.Bullet());
                    bullet.width = 12;
                    bullet.height = 12;
                    bullet.horizontalCenter = "middle";
                    bullet.verticalCenter = "middle";

                    var triangle = bullet.createChild(am4core.Triangle);
                    triangle.stroke = am4core.color("#2F4858");
                    triangle.fill = am4core.color("#2F4858");
                    valueAxis.renderer.line.stroke = am4core.color("#2F4858");
                    valueAxis.renderer.labels.template.fill = am4core.color("#2F4858");
                    console.log(valueAxis.renderer);
//                    triangle.stroke = interfaceColors.getFor("background");
                    triangle.strokeWidth = 2;
                    triangle.direction = "top";
                    triangle.width = 12;
                    triangle.height = 12;
                    break;
                case "rectangle":
                    var bullet = series.bullets.push(new am4charts.Bullet());
                    bullet.width = 10;
                    bullet.height = 10;
                    bullet.horizontalCenter = "middle";
                    bullet.verticalCenter = "middle";

                    var rectangle = bullet.createChild(am4core.Rectangle);
                    //rectangle.stroke = interfaceColors.getFor("background");
                    rectangle.stroke = am4core.color("#f70000");
                    rectangle.fill = am4core.color("#f70000");
                    rectangle.strokeWidth = 2;
                    rectangle.width = 10;
                    rectangle.height = 10;
                    valueAxis.renderer.line.stroke = am4core.color("#f70000");
                    valueAxis.renderer.labels.template.fill = am4core.color("#f70000");
                    break;
                default:
                    var bullet = series.bullets.push(new am4charts.CircleBullet());
                    //bullet.circle.stroke = interfaceColors.getFor("background");
                    bullet.circle.strokeWidth = 2;
                    bullet.stroke = am4core.color("#007c00");
                    bullet.fill = am4core.color("#007c00");
                    valueAxis.renderer.line.stroke = am4core.color("#007c00");
                    valueAxis.renderer.line.fill = am4core.color("#007c00");
                    valueAxis.renderer.labels.template.fill = am4core.color("#007c00");
                    break;
            }

            valueAxis.renderer.line.strokeOpacity = 1;
            valueAxis.renderer.line.strokeWidth = 2;

            valueAxis.renderer.opposite = opposite;
        }

        createAxisAndSeries("job_order", "Job Order", false, "circle");
        createAxisAndSeries("job_value", "Job Value", true, "triangle");
        createAxisAndSeries("hits", "Quotation", true, "rectangle");

// Add legend
        chart.legend = new am4charts.Legend();

// Add cursor
        chart.cursor = new am4charts.XYCursor();

// generate some random data, quite different range
        function generateChartData() {
            var chartData = [];
            var firstDate = new Date();
            firstDate.setDate(firstDate.getDate() - 100);
            firstDate.setHours(0, 0, 0, 0);

            var visits = 1600;
            var hits = 2900;
            var views = 8700;

            for (var i = 0; i < 15; i++) {
                // we create date objects here. In your data, you can have date strings
                // and then set format of your dates using chart.dataDateFormat property,
                // however when possible, use date objects, as this will speed up chart rendering.
                var newDate = new Date(firstDate);
                newDate.setDate(newDate.getDate() + i);

                visits += Math.round((Math.random() < 0.5 ? 1 : -1) * Math.random() * 10);
                hits += Math.round((Math.random() < 0.5 ? 1 : -1) * Math.random() * 10);
                views += Math.round((Math.random() < 0.5 ? 1 : -1) * Math.random() * 10);

                chartData.push({
                    date: newDate,
                    visits: visits,
                    hits: hits,
                    views: views
                });
            }
            return chartData;
        }

    }); // end am4core.ready()
</script>

<!-- HTML -->
