<?php

/**
 * This is the model class for table "{{purchasing_requisition_stock_item}}".
 *
 * The followings are the available columns in table '{{purchasing_requisition_stock_item}}':
 * @property integer $id
 * @property integer $purchasing_enquiry_id
 * @property integer $stock_item_id
 * @property string $stock_item_name
 * @property string $stock_item_description
 * @property string $stock_item_unit
 * @property string $stock_item_quantity
 */
class PurchasingEnquiryStockItemtemp extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
    
    public $unit_id;
	public function tableName()
	{
		return '{{purchasing_enquiry_stock_item_temp}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('purchasing_enquiry_id, stock_item_id, stock_item_name, stock_item_description, stock_item_unit, stock_item_quantity', 'required'),
			array('purchasing_enquiry_id, stock_item_id', 'numerical', 'integerOnly'=>true),
			array('stock_item_name, stock_item_description, stock_item_unit', 'length', 'max'=>255),
			array('stock_item_quantity', 'length','max'=>15),
                        array('stock_item_quantity', 'length','min'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, purchasing_enquiry_id, stock_item_id, stock_item_name, stock_item_description, stock_item_unit, stock_item_quantity', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		 return array(
            'purchasingenquiry' => array(self::BELONGS_TO, 'PurchasingEnquiry', 'purchasing_enquiry_id'),
            'product' => array(self::BELONGS_TO, 'Store', 'stock_item_id'),
            'requisitionunit' => array(self::BELONGS_TO, 'Unit', 'stock_item_name'),
        );
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'purchasing_enquiry_id' => 'Purchasing Enquiry',
			'stock_item_id' => 'Stock Item',
			'stock_item_name' => 'Stock Item Name',
			'stock_item_description' => 'Stock Item Description',
			'stock_item_unit' => 'Stock Item Unit',
			'stock_item_quantity' => 'Stock Item Quantity',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('purchasing_enquiry_id',$this->purchasing_enquiry_id);
		$criteria->compare('stock_item_id',$this->stock_item_id);
		$criteria->compare('stock_item_name',$this->stock_item_name,true);
		$criteria->compare('stock_item_description',$this->stock_item_description,true);
		$criteria->compare('stock_item_unit',$this->stock_item_unit,true);
		$criteria->compare('stock_item_quantity',$this->stock_item_quantity,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return PurchasingRequisitionStockItem the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
