<?php
class MasUnit extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{mas_unit}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('unit_name,base_unit_id,unit_exchange_rate,base_unit,label', 'required'),
			array('created_by, updated_by, base_unit_id', 'numerical', 'integerOnly'=>true),
			array('unit_exchange_rate', 'numerical'),
			array('unit_name,label', 'length', 'max'=>50),
			array('active,is_default,base_unit', 'length', 'max'=>1),
			array('created_time, updated_time', 'safe'),
			array('unit_name', 'checkUniqueness'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, unit_name, created_by, created_time, updated_by, updated_time, active', 'safe', 'on'=>'search'),
		);
	}
	public function checkUniqueness($attribute,$params)
    {
			if($this->id>0)
			{
			$model = MasUnit::model()->find('unit_name = "'.$this->unit_name.'" AND id!='.$this->id);
			}
            else {
			$model = MasUnit::model()->find('unit_name = "'.$this->unit_name.'"');	
			}
			if(is_array($model) && count($model)>0)	
			{
			$this->addError('id','This Unit already exist'); 
			}
    }
	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		  
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'unit_name' => 'Unit Name',
			'created_by' => 'Created By',
			'created_time' => 'Created Date',
			'updated_by' => 'Updated By',
			'updated_time' => 'Updated Date',
			'active' => 'N : No, Y : Yes',
			'unit_exchange_rate' => 'Exchange Quantity',
			'label' => 'Print Label'
		);
	}

	public function search()
	{

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('unit_name',$this->brand_name,true);
		$criteria->compare('base_unit',$this->base_unit,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_time',$this->created_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_time',$this->updated_time,true);
		$criteria->compare('active',$this->active,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	public static function model($className=__CLASS__)
	{
	return parent::model($className);
	}
	public static function getAllUnits(){
	return CHtml::listData(self::model()->findAll( array( 'condition' => 'active="Y"', 'order' => 'is_default ASC, unit_name ASC' ) ), 'id', 'unit_name');
	}
	public static function getAllBaseUnits($id=""){
	if($id>0)
	{
	return CHtml::listData(self::model()->findAll( array( 'condition' => 'active="Y" AND base_unit="Y" AND id!='.$id, 'order' => 'is_default ASC, unit_name ASC' ) ), 'id', 'unit_name');
	}
	else {
	return CHtml::listData(self::model()->findAll( array( 'condition' => 'active="Y" AND base_unit="Y"', 'order' => 'is_default ASC, unit_name ASC' ) ), 'id', 'unit_name');
	}
	}
	public static function getSimilarUnits($id=""){
	    if($id>0){
	        $base_unit=self::model()->findByPK($id)->base_unit_id;
	        $arr_units =self::model()->findAll( array( 'condition' => 'active="Y"  AND (base_unit_id='.(int)$base_unit.' OR id='.(int)$base_unit.')', 'order' => 'is_default ASC, unit_name ASC' ) );
	    }else{
	        $arr_units =self::model()->findAll( array( 'condition' => 'active="Y"', 'order' => 'is_default ASC, unit_name ASC' ) );
	    }
	    return CHtml::listData($arr_units, 'id', 'unit_name');
	}
	public function getBaseUnit(){
	    if($this->base_unit=='N'){
	        $base_unit = self::model()->findByPk($this->base_unit_id)->unit_name;
	    }else{
	        $base_unit = $this->unit_name;
	    }
	    return $base_unit;
	}     
        public function findByUnitname($unit = NULL) {
        $model = new self;
        if (strtoupper(trim($unit)) != NULL) {
        $unit=strtoupper(trim($unit));    
        $model = self::model()->find(array('condition' => 't.unit_name="' . trim($unit) . '" AND t.active="Y"'));
        }
        return $model;
    }
}
