<?php

/**
 * This is the model class for table "{{mas_inv_unit}}".
 *
 * The followings are the available columns in table '{{mas_inv_unit}}':
 * @property integer $id
 * @property string $unit
 * @property string $isActive
 *
 * The followings are the available model relations:
 * @property InventoryItems[] $inventoryItems
 */
class MasInvUnit extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{mas_inv_unit}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('unit', 'required'),
            array('unit', 'unique'),
            array('unit', 'filter', 'filter'=>'trim'),
            array('unit', 'length', 'max' => 255),
            array('isActive', 'length', 'max' => 1),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, unit, isActive,created_by,updated_by,created_datetime,updated_datetime', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'inventoryItems' => array(self::HAS_MANY, 'InventoryItems', 'unit'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'unit' => 'Unit',
            'isActive' => 'Is Active',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('unit', $this->unit, true);
        $criteria->compare('isActive', $this->isActive, true);
        //$criteria->compare('company_id', Yii::app()->user->master_user_company_id, true);
        //$criteria->compare('company_branch_id', Yii::app()->user->master_user_branch_id, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return MasInvUnit the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public static function getUnits() {

        $condition = 'isActive =  "Y"';

        $model = self::model()->findAll(array('condition' => $condition));

        return CHtml::listData($model, 'id', 'unit');
    }

}
