<?php

/**
 * This is the model class for table "{{job_order_status_history}}".
 *
 * The followings are the available columns in table '{{job_order_status_history}}':
 * @property integer $id
 * @property integer $job_order_id
 * @property integer $job_order_agent_id
 * @property integer $current_status
 * @property string $status_description
 * @property string $status_type
 * @property string $status_code
 * @property string $status_city
 * @property string $status_state_province
 * @property string $status_postal_code
 * @property string $status_country
 * @property string $status_date
 * @property string $status_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class JobOrderStatusHistory extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{job_order_status_history}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('job_order_id, job_order_agent_id, status_description', 'required'),
			array('job_order_id, job_order_agent_id, current_status, updated_by', 'numerical', 'integerOnly'=>true),
			array('status_description', 'length', 'max'=>1000),
			array('status_type, status_code, status_city, status_state_province, status_postal_code, status_country', 'length', 'max'=>50),
			array('status_date, status_time', 'length', 'max'=>10),
			array('status_updation', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, job_order_id, job_order_agent_id, current_status, status_description, status_type, status_code, status_city, status_state_province, status_postal_code, status_country, status_date, status_time, updated_by, updated_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		    'owner' => array(self::BELONGS_TO, 'User', 'updated_by'),
		    'joborder' => array(self::BELONGS_TO, 'JobOrder', 'job_order_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'job_order_id' => 'Job Order',
			'job_order_agent_id' => 'Job Order Agent',
			'current_status' => 'Current Status',
			'status_description' => 'Status Description',
			'status_type' => 'Status Type',
			'status_code' => 'Status Code',
			'status_city' => 'Status City',
			'status_state_province' => 'Status State Province',
			'status_postal_code' => 'Status Postal Code',
			'status_country' => 'Status Country',
			'status_date' => 'Status Date',
			'status_time' => 'Status Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('job_order_id',$this->job_order_id);
		$criteria->compare('job_order_agent_id',$this->job_order_agent_id);
		$criteria->compare('current_status',$this->current_status);
		$criteria->compare('status_description',$this->status_description,true);
		$criteria->compare('status_type',$this->status_type,true);
		$criteria->compare('status_code',$this->status_code,true);
		$criteria->compare('status_city',$this->status_city,true);
		$criteria->compare('status_state_province',$this->status_state_province,true);
		$criteria->compare('status_postal_code',$this->status_postal_code,true);
		$criteria->compare('status_country',$this->status_country,true);
		$criteria->compare('status_date',$this->status_date,true);
		$criteria->compare('status_time',$this->status_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return JobOrderStatusHistory the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
