<?php
class GoodsIssue extends CActiveRecord {
public $customer_name;
    public function tableName() {
        return '{{goods_issue}}';
    }
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('transaction_date,reference,customer_id', 'required'),
            array('issue_no,file_id, customer_id', 'numerical', 'integerOnly' => true),
            array('active', 'length', 'max' => 1),
            array('reference', 'length', 'max' => 100),
            array('notes,reference,receiver_name', 'length', 'max' => 255),
            array('receiver_address', 'length', 'max' => 1000),
            array('id,  transaction_date, file_id, notes, active, reference, customer_id', 'safe', 'on' => 'search'),
        );
    }

    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'file' => array(self::BELONGS_TO, 'MasterFile', 'file_id'),
            'customer' => array(self::BELONGS_TO, 'Customer', 'customer_id'),
            'items' => array(self::HAS_MANY, 'GoodsReceiptItems', 'header_id'),
        );
    }

    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'transaction_date' => 'Transaction Date',
            'file_id' => 'File',
            'notes' => 'Notes',
            'active' => 'Is Active',
            'reference' => 'Reference',
            'customer_id' => 'Customer',
            'created_by' => 'Created By',
            'updated_by' => 'Updated By',
            'updated_date_time' => 'Updated Date',
            'created_date_time' => 'Created Date',
        );
    }
    
    public function search($searchterm = null) {
        $criteria = new CDbCriteria;
        $searchterm = empty($searchterm) ? trim(Yii::app()->request->getParam('search')) : $searchterm;
        $criteria->with = array('file','customer');
        if (!empty($searchterm)) {
            $criteria->addCondition('t.issue_no like "%' . $searchterm . '%" OR 
                                        t.file_id like "%' . $searchterm . '%" OR 
                                        t.reference like "%' . $searchterm . '%" OR 
                                        t.notes like "%' . $searchterm . '%" OR 
                                        customer.company_name like "%' . $searchterm . '%" OR 
                                        file.file_title like "%' . $searchterm . '%"', 'AND');
        }
        //((int) Yii::app()->session['company_id'] > 0 && !isset($_GET['month'])) ? $criteria->addCondition('t.company_id=' . Yii::app()->session['company_id'], 'AND') : '';
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.transaction_date DESC,t.issue_no DESC',
            ),
            'pagination' => array('pageSize' => 20),
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return InventoryGoodsReceipt the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public function getCustomername(){
        return 'N/A';
    }

    public function getCurrency(){
        return MasCurrency::base_currency_code();
    }

    public function getExchange_rate(){
        return MasCurrency::base_exchange_rate();
    }

}
