<?php
class UploadstockController extends Controller
{
        public function accessRules() {

            return array(

                array('allow', // allow all users to perform 'index' and 'view' actions

                  'actions' => array('login', 'error', 'logout'),

                  'users' => array('*'),

                  ),

                array('allow', // allow authenticated user to perform 'create' and 'update' actions

                  'actions' => array('UploadInventory','DownloadInventoryUploadFormat','LoadInventoryData','SaveInventoryUpload','UploadDocuments'),

                  'expression' => '$user->isMember()',

                  ),

                array('deny', // deny all users

                  'users' => array('*'),

                  ),

                );

        }

	public function actionIndex()
	{
		$this->render('index');

	}
    
    public function actionUploadInventory() {
            $model= new Inventory();
            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('upload_inventory_form',array('model'=>$model));
    }
    
    public function readCSV($csvFile) {
        $file_handle = fopen($csvFile, 'r');
        while (!feof($file_handle)) {
            $contents = fgetcsv($file_handle, 1024, ',');
            if ($contents[1] == "")
                $contents = explode(';', $contents[0]);
            $line_of_text[] = $contents;
            //print_r($line_of_text);
            //die();
        }
        fclose($file_handle);
        return $line_of_text;
    }
  
  public function actionDownloadInventoryUploadFormat() {
    	$data = array();    
    	$data[0][0]     = 'Product (*)';
    	$data[0][1]     = 'Description (*)';
    	$data[0][2]     = 'Type [I/S] (*)';
    	$data[0][3]     = 'Brand (*)';
        $data[0][4]     = "Generic (*)";
    	$data[0][5]     = "Unit (*)";
    	$data[0][6]     = "Sales Price"; 
    	$data[0][7]     = "Tax (*)";   	
    	$data[0][8]     = "Barcode";
    	$data[0][9]     = "Length";
    	$data[0][10]    = "Width";
    	$data[0][11]    = "Height";
    	$data[0][12]    = "Weight";
        $data[0][13]    = "Thickness";
    	$data[0][14]    = "Material";
    	$data[0][15]    = "Finish";
    	$data[0][16]    = "Re-Order Level";
    	$data[0][17]    = "Hs-Code";
    	$data[0][18]    = "Notes"; 
    	$data[0][19]    = "Serial Yes/No[Y/N] (*)"; 
    	$data[0][20]    = "Expiry Yes/No[Y/N] (*)";
    	
    
    	
    	$this->array_to_csv_download($data,"UPLOAD_INVENTORY.csv");
    
    }
    
    public function actionLoadInventoryData(){
        $model= new Inventory();
        
        $customer_id = (int) $_POST['customer_id'];
        $customer_name = $_POST['customer_name'];
        if($customer_id==0){
            $jsonData['errors']='Please select a customer';
        }
        else{
            if(isset($_POST['file_name'])){
               
                
                    $file_name          = $_POST['file_name'];
                    
                    
                    $arr_file_data          = $this->readCSV("upload/inventory/".$file_name);
                    $jsonData           = array();
                    
                    $table = '<div style="width:100%;overflow: scroll;">         
                        
                        <table class="table table-hover table-bordered personal-task" id="tbl_customer_details">
                            <thead>
                               <tr>
                                    <th>#</th>
                                    <th>Product</th>
                                    <th>Description</th>
                                    <th>Type</th>
                                    <th>Brand</th>
                                    <th>Generic</th>
                                    <th>Unit</th>
                                    <th>Sales Price</th>
                                    <th>Tax</th>
                                    <th>Barcode</th>
                                    <th>Length</th>
                                    <th>Width</th>
                                    <th>Height</th>
                                    <th>Weight</th>
                                    <th>Thickness</th>
                                    <th>Material</th>
                                    <th>Finish</th>
                                    <th>Re-Order Level</th>
                                    <th>Hs-Code</th>
                                    <th>Notes</th>
                                    <th>Serial No</th>
                                    <th>Expiry</th>
                                </tr>
                            </thead>
                                           
                        <tbody>';
                        
                 
                        $flag=0;
                        
                        $str_product_name='';
                        $arr_product_details=array();
                        $arr_repeated_product=array();
                        $flag=0;
                        foreach (array_slice($arr_file_data, 1) as $i => $eachItem) {
                            
                                $product_name           = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[0]), '"'));
                                $description            = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[1]), '"'));
                                $inventory_type         = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[2]), '"'));
                                $brand_name             = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[3]), '"'));
                                $generic_name           = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[4]), '"'));
                                $unit_name              = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[5]), '"'));  
                                $sales_price            = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[6]), '"'));                    
                                $tax_code               = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[7]), '"'));
                                $bar_code               = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[8]), '"'));
                                $length                 = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[9]), '"'));
                                $width                  = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[10]), '"'));
                                $height                 = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[11]), '"'));
                                $weight                 = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[12]), '"'));                
                                $thickness              = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[13]), '"'));
                                $material               = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[14]), '"'));
                                $finish                 = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[15]), '"'));
                                $reorder_level          = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[16]), '"'));
                                $hs_code                = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[17]), '"'));
                                $notes                  = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[18]), '"'));
                                $serial_no              = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[19]), '"'));
                                $expiry                 = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[20]), '"'));
                                
                                
                                
                                if(in_array($product_name,$arr_product_details)){
                                    $arr_repeated_product[] = $product_name;
                                    $flag=1;
                                }
                                else{
                                    $arr_product_details[]  = $product_name;
                                    $flag=0;
                                }
                                
                            
                            
                                $modelInventory = new Inventory();
                                
                                //$count          = Customer::model()->count(array('condition' => 'customer_name="'.$customer_name.'"'));
                                
                                $cnt_product=0;
                                if($customer_id > 0 && !empty($product_name)){
                                    $cnt_product          = Inventory::model()->count(array('condition' => 'customer_id="'.$customer_id.'" AND part_number="'.$product_name.'"'));
                                }
                               
                                $brand_id       = (int) MasBrand::model()->find(array('condition'=>'brand_name="'.$brand_name.'"'))->id; 
                                $generic_id     = (int) MasGeneric::model()->find(array('condition'=>'generic_name="'.$generic_name.'"'))->id;
                                $unit_id        = (int) MasUnit::model()->find(array('condition'=>'unit_name="'.$unit_name.'"'))->id;
                                $tax_id         = (int) MasInvTax::model()->find(array('condition'=>'tax_code="'.$tax_code.'"'))->id;
                                
                                $product_name_color="";
                                $description_color="";
                                $brand_name_color="";
                                $generic_name_color="";
                                $tax_code_color="";
                                $unit_color="";
                                $product_exist_color="";
                                
                                 if(!empty($eachItem[0])){
                                    
                                    if(empty($product_name)){
                                        $product_name_color="#eb9b9b";
                                        $flag=1;
                                    }
                                    
                                    if(empty($description)){
                                        $description_color="#eb9b9b";
                                        $flag=1;
                                    }
                                    
                                    if($brand_id==0){
                                        $brand_name_color="#eb9b9b";
                                        $flag=1;
                                    }
                                    
                                    
                                    if($generic_id==0){
                                        $generic_name_color="#eb9b9b";
                                        $flag=1;
                                    }
                                    
                                    if($unit_id==0){
                                        $unit_color="#eb9b9b";
                                        $flag=1;
                                    }
                                    
                                    if($tax_id==0){
                                        $tax_code_color="#eb9b9b";
                                        $flag=1;
                                    }
                                    if($cnt_product >0){
                                        $product_exist_color="#eb9b9b";
                                        
                                        $arr_product_exist[]=$product_name;;
                                    }
                                    
                                    
                                    if($flag == 1){
                                        $product_exist_color="#eb9b9b";
                                        
                                    }
                                    
                                    $cbm_length=1;
                                    if(!empty($length)){
                                        $cbm_length=$length;
                                    }
                                    
                                    $cbm_breadth=1;
                                    if(!empty($width)){
                                        $cbm_breadth=$width;
                                    }
                                    
                                    $cbm_height=1;
                                    if(!empty($height)){
                                        $cbm_height=$height;
                                    }
                                    
                                    
                                    $cbm = ($cbm_length*$cbm_breadth*$cbm_height)/1000000;
                                    
                                  
                                    $table.='<tr style="background-color:'.$product_exist_color.'">
                                        <td>'.($i+1);
                                    /*$table.=CHtml::hiddenField("Inventory[" . $i . "][customer_id]",$customer_id);  
                                    $table.=CHtml::hiddenField("Inventory[" . $i . "][part_number]",$product_name);    
                                    $table.=CHtml::hiddenField("Inventory[" . $i . "][description]",$description);    
                                    $table.=CHtml::hiddenField("Inventory[" . $i . "][type]",$inventory_type);    
                                    $table.=CHtml::hiddenField("Inventory[" . $i . "][brand]",$brand_id);    
                                    $table.=CHtml::hiddenField("Inventory[" . $i . "][generic_id]",$generic_id);    
                                    $table.=CHtml::hiddenField("Inventory[" . $i . "][unit]",$unit_id);    
                                    $table.=CHtml::hiddenField("Inventory[" . $i . "][rate]",$sales_price);    
                                    $table.=CHtml::hiddenField("Inventory[" . $i . "][tax_code]",$tax_id);    
                                    $table.=CHtml::hiddenField("Inventory[" . $i . "][barcode]",$bar_code);    
                                    $table.=CHtml::hiddenField("Inventory[" . $i . "][cost]",0);    
                                    $table.=CHtml::hiddenField("Inventory[" . $i . "][length]",$length);    
                                    $table.=CHtml::hiddenField("Inventory[" . $i . "][width]",$width);    
                                    $table.=CHtml::hiddenField("Inventory[" . $i . "][height]",$height);    
                                    $table.=CHtml::hiddenField("Inventory[" . $i . "][weight]",$weight);    
                                    $table.=CHtml::hiddenField("Inventory[" . $i . "][volume]",$cbm);    
                                    $table.=CHtml::hiddenField("Inventory[" . $i . "][thickness]",$thickness);    
                                    $table.=CHtml::hiddenField("Inventory[" . $i . "][material]",$material);     
                                    $table.=CHtml::hiddenField("Inventory[" . $i . "][finished]",$finish);    
                                    $table.=CHtml::hiddenField("Inventory[" . $i . "][have_expiry_date]",$expiry);    
                                    $table.=CHtml::hiddenField("Inventory[" . $i . "][have_serial_no]",$serial_no);    
                                    $table.=CHtml::hiddenField("Inventory[" . $i . "][reorder_level]",$reorder_level);     
                                    $table.=CHtml::hiddenField("Inventory[" . $i . "][hs_code]",$hs_code);    
                                    $table.=CHtml::hiddenField("Inventory[" . $i . "][notes]",$notes);    */
                                    
                                    if($inventory_type=='I'){
                                        $display_inventory_type="Inventory";
                                    }
                                    else{
                                        $display_inventory_type="Service";
                                    }
                                    
                                    if($serial_no=='Y'){
                                        $display_serial_no="Yes";
                                    }
                                    else{
                                        $display_serial_no="No";
                                    }
                                    
                                    if($expiry=='Y'){
                                        $display_expiry="Yes";
                                    }
                                    else{
                                        $display_expiry="No";
                                    }
                                    
                                    $table.='</td>
                                        <td style="background-color:'.$product_name_color.'">'.$product_name.'</td>
                                        <td style="background-color:'.$description_color.'">'.$description.'</td>
                                        <td>'.$display_inventory_type.'</td>
                                        <td style="background-color:'.$brand_name_color.'">'.$brand_name.'</td>
                                        <td style="background-color:'.$generic_name_color.'">'.$generic_name.'</td>
                                        <td style="background-color:'.$unit_color.'">'.$unit_name.'</td>
                                        <td>'.$sales_price.'</td>
                                        <td style="background-color:'.$tax_code_color.'">'.$tax_code.'</td>
                                        <td>'.$bar_code.'</td>
                                        <td>'.$length.'</td>
                                        <td>'.$width.'</td>
                                        <td>'.$height.'</td>
                                        <td>'.$weight.'</td>
                                        <td>'.$thickness.'</td>
                                        <td>'.$material.'</td>
                                        <td>'.$finish.'</td>
                                        <td>'.$reorder_level.'</td>
                                        <td>'.$hs_code.'</td>
                                        <td>'.$notes.'</td>
                                        <td>'.$display_serial_no.'</td>
                                        <td>'.$display_expiry.'</td>
                                    </tr>';
                                 }
                                            
                        }
                        
                        $table.='</tbody>
                         </table>
                         </div>';      
                         
                         $jsonData['table'] = $table;
                         
                         if($flag==1){
                            $jsonData['errors']='Please enter correct data in red color columns';
                         }
                         else{
                             $jsonData['errors']='';
                             $jsonData['success']='success';
                         }
                         
            }
            else{
                $jsonData['errors']='Please upload a csv file';
            }
            
        	// if(count($arr_product_exist) > 0 && $arr_product_exist!="")
            // {
            // 		$jsonData['errors']=ltrim("The following product name(s) <br>".implode(",", $arr_product_exist)." are already exist for this customer ".$customer_name." ",",");
            // }
            if (is_array($arr_product_exist) && count($arr_product_exist) > 0) {
                $jsonData['errors'] = ltrim(
                    "The following product name(s) <br>" . implode(",", $arr_product_exist) . 
                    " are already exist for this customer " . $customer_name . " ",
                    ","
                );
            }
            
            
            if(count($arr_repeated_product) > 0 && $arr_repeated_product!="")
            {
            		$jsonData['errors']=ltrim("The following product name(s) <br>".implode(",", $arr_repeated_product)." are repeated",",");
            }
        }
        echo CJSON::encode($jsonData);
    }
    
    
    
    
    public function actionSaveInventoryUpload(){
        
            $model= new Inventory();
            
            $customer_id = (int) $_POST['Upload_customer_id'];
            $customer_name = $_POST['Upload_customer_name'];
            if($customer_id==0){
                $jsonData['errors']='Please select a customer';
            }
            else{
                
                $file_name=$_POST['UploadInventory']['upload_file'];
                if(isset($file_name) && $file_name!=''){
                   
                    
                        $arr_file_data          = $this->readCSV("upload/inventory/".$file_name);
                        
                         $modelInventory = array(new Inventory());
                         
                         //$p=0;
                         foreach (array_slice($arr_file_data, 1) as $i => $eachItem) {
                                
                                    $product_name           = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[0]), '"'));
                                    $description            = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[1]), '"'));
                                    $inventory_type         = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[2]), '"'));
                                    $brand_name             = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[3]), '"'));
                                    $generic_name           = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[4]), '"'));
                                    $unit_name              = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[5]), '"'));  
                                    $sales_price            = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[6]), '"'));                    
                                    $tax_code               = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[7]), '"'));
                                    $bar_code               = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[8]), '"'));
                                    $length                 = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[9]), '"'));
                                    $width                  = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[10]), '"'));
                                    $height                 = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[11]), '"'));
                                    $weight                 = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[12]), '"'));                
                                    $thickness              = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[13]), '"'));
                                    $material               = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[14]), '"'));
                                    $finish                 = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[15]), '"'));
                                    $reorder_level          = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[16]), '"'));
                                    $hs_code                = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[17]), '"'));
                                    $notes                  = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[18]), '"'));
                                    $serial_no              = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[19]), '"'));
                                    $expiry                 = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[20]), '"'));
                                    
                                
                                
                                    
                                    $cnt_product=0;
                                    if($customer_id > 0 && !empty($product_name)){
                                        $cnt_product          = Inventory::model()->count(array('condition' => 'customer_id="'.$customer_id.'" AND part_number="'.$product_name.'"'));
                                    }
                                   
                                    $brand_id       = (int) MasBrand::model()->find(array('condition'=>'brand_name="'.$brand_name.'"'))->id; 
                                    $generic_id     = (int) MasGeneric::model()->find(array('condition'=>'generic_name="'.$generic_name.'"'))->id;
                                    $unit_id        = (int) MasUnit::model()->find(array('condition'=>'unit_name="'.$unit_name.'"'))->id;
                                    $tax_id         = (int) MasInvTax::model()->find(array('condition'=>'tax_code="'.$tax_code.'"'))->id;
                                    
                                    if(!empty($product_name) && $cnt_product==0){
         
                                        $cbm_length=1;
                                        if(!empty($length)){
                                            $cbm_length=$length;
                                        }
                                        
                                        $cbm_breadth=1;
                                        if(!empty($width)){
                                            $cbm_breadth=$width;
                                        }
                                        
                                        $cbm_height=1;
                                        if(!empty($height)){
                                            $cbm_height=$height;
                                        }
                                        
                                        
                                        $cbm = ($cbm_length*$cbm_breadth*$cbm_height)/1000000;
                                        
                                        
                                        $modelInventory[$p] = new Inventory; 
                                        $modelInventory[$p]['customer_id'] = $customer_id;
                                      
                                        
                                        $modelInventory[$p]['part_number'] = $product_name;    
                                        $modelInventory[$p]['description'] = $description;    
                                        $modelInventory[$p]['type'] = $inventory_type;    
                                        $modelInventory[$p]['brand'] = $brand_id;    
                                        $modelInventory[$p]['generic_id'] = $generic_id;    
                                        $modelInventory[$p]['unit'] = $unit_id;    
                                        $modelInventory[$p]['rate'] = $sales_price;    
                                        $modelInventory[$p]['tax_code'] = $tax_id;    
                                        $modelInventory[$p]['barcode'] = $bar_code;    
                                        $modelInventory[$p]['cost'] = 0;    
                                        $modelInventory[$p]['length'] = $length;    
                                        $modelInventory[$p]['width'] = $width;    
                                        $modelInventory[$p]['height'] = $height;    
                                        $modelInventory[$p]['weight'] = $weight;    
                                        $modelInventory[$p]['volume'] = $cbm;    
                                        $modelInventory[$p]['thickness'] = $thickness;    
                                        $modelInventory[$p]['material'] = $material;     
                                        $modelInventory[$p]['finished'] = $finish;    
                                        $modelInventory[$p]['have_expiry_date'] = $expiry;    
                                        $modelInventory[$p]['have_serial_no'] = $serial_no;    
                                        $modelInventory[$p]['reorder_level'] = $reorder_level;     
                                        $modelInventory[$p]['hs_code'] = $hs_code;    
                                        $modelInventory[$p]['notes'] = $notes;    
                                        $valid = $modelInventory[$p]->validate();
                                        $p++;
                                        
                                        
                            }
            
            }
            
            if ($valid) {
              
                 foreach ($modelInventory as $eachItem) {
                            $eachItem->save(false);
                            StockLedger::model()->deleteAll(array('condition'=>'product_id='.$eachItem->id.' AND type="OB" AND transaction_type="IN"'));
                            $stockledger = new StockLedger;
                            $stockledger->transaction_date=date('Y-m-d');
                            $stockledger->transaction_type='IN';
                            $stockledger->type='OB';
                            $stockledger->customer_vendor_id=$_POST['Inventory']['customer_id'];
                            $stockledger->header_id=0;
                            $stockledger->item_id=0;
                            $stockledger->product_id=$eachItem->id;
                            $stockledger->rate=0;
                            $stockledger->currency=1;
                            $stockledger->exchange_rate=1;
                            $stockledger->quantity=0;
                            $stockledger->unit=$eachItem->unit;
                            $stockledger->default_product_unit=$eachItem->units->base_unit_id;
                            $stockledger->unit_exchange_rate=$eachItem->units->unit_exchange_rate;
                            $stockledger->created_by=Yii::app()->user->id;
                            $stockledger->created_time=date('Y-m-d H:i:s');
                            $stockledger->save(false);
                            $jsonData['success'] = 'success';
                            
                        }
                        
                        echo CJSON::encode($jsonData);
            }
            else {
                    $error1 = json_decode(CActiveForm::validate($modelInventory, '', false), true);
                    $error = CJSON::encode(array_merge_recursive($error1));
                    if ($error != '[]')
                        echo $error;    
                }
            }
        }
    }
    
    
    /*public function actionSaveInventoryUpload(){
        $modelInventory = array(new Inventory());
        
        $p=0;
         if (is_array($_POST['Inventory'])) {
                $prod_id=0;
                
                foreach ($_POST['Inventory'] as $i => $item) {     
                    
                            $modelInventory[$p] = new Inventory; 
                        
                            $modelInventory[$p]->attributes              =   $_POST['Inventory'][$i];
                            
                            $modelInventory[$p]->created_by             = Yii::app()->user->id;
                            $modelInventory[$p]->created_time           = date('Y-m-d H:i:s');
                            
                            $valid = $modelInventory[$p]->validate();
                            $p++;
                }
            }  
        
        
        if ($valid) {
          
             foreach ($modelInventory as $eachItem) {
                        //$tax_code=MasInvTax::model()->findByPk($modelInventory->tax_code)->percentage;
                        //$part_number=strtoupper(trim($modelInventory->part_number));    
                        $eachItem->save(false);
                        StockLedger::model()->deleteAll(array('condition'=>'product_id='.$eachItem->id.' AND type="OB" AND transaction_type="IN"'));
                        $stockledger = new StockLedger;
                        $stockledger->transaction_date=date('Y-m-d');
                        $stockledger->transaction_type='IN';
                        $stockledger->type='OB';
                        $stockledger->customer_vendor_id=$_POST['Inventory']['customer_id'];
                        $stockledger->header_id=0;
                        $stockledger->item_id=0;
                        $stockledger->product_id=$eachItem->id;
                        $stockledger->rate=0;
                        $stockledger->currency=1;
                        $stockledger->exchange_rate=1;
                        $stockledger->quantity=0;
                        $stockledger->unit=$eachItem->unit;
                        $stockledger->default_product_unit=$eachItem->units->base_unit_id;
                        $stockledger->unit_exchange_rate=$eachItem->units->unit_exchange_rate;
                        $stockledger->created_by=Yii::app()->user->id;
                        $stockledger->created_time=date('Y-m-d H:i:s');
                        $stockledger->save(false);
                        $jsonData['success'] = 'success';
                        
                    }
                    
                    echo CJSON::encode($jsonData);
        }
        else {
                $error1 = json_decode(CActiveForm::validate($modelInventory, '', false), true);
                $error = CJSON::encode(array_merge_recursive($error1));
                if ($error != '[]')
                    echo $error;    
            }
    }*/
  
    
    /**************************   END INVENTORY UPLOAD *********************************/
    
    
    
        
        
}