<?php

class ReceiptsController extends Controller
{
        public function accessRules() {
            return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                  'actions' => array('login', 'error', 'logout'),
                  'users' => array('*'),
                  ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                  'actions' => array('Index','Create','GetList','SaveReceipt','Delete','GetProducts','DeleteReceiptItem','DeleteReceipt','Append',
                                      'AddStock','GetRow','GetFactor','Getunitdrop' ,'PrintReceiptPDF'),
                  'expression' => '$user->isMember()',
                  ),/**copied by jisha from bouleward on 8-11-17**/
                array('deny', // deny all users
                  'users' => array('*'),
                  ),
                );
        }
	public function actionIndex()
	{
		$this->render('index');
	}

	
	
	public function filters()
        {
            return array(
                'accessControl', // perform access control for CRUD operations
                );
        }
        /**copied by jisha from bouleward on 8-11-17**/
        public function actionGetList()
        {
                $model=new InventoryGoodsReceipt();
                $draw    = $_POST['draw'];
                $offset = $_POST['start'];
                $limit  = $_POST['length'];
                $columns = array(
                // datatable column index  => database column name
                   0 =>'goods_receipt_date',
                   1 =>'customer_id',
                    2 => 'project'
                   
                   );
                $filterColumn = $columns[$_POST['order'][0]['column']];
                $filterOrder  = $_POST['order'][0]['dir'];
                $orderBy   = $filterColumn." ".$filterOrder;
                $condition = 't.isActive="Y" AND t.stock_updated="Y"';
                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
                {
                  $searchString = $_POST['search']['value'];
                  $condition.=" and (id LIKE '%".$searchString."%' OR goods_receipt_date LIKE '%".$searchString."%' OR project_id LIKE '%".$searchString."%')";
                }
                $count = $model->count(array('condition'=>$condition));
                $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>'id desc'));
                $recordsTotal = $count;
                $recordsFiltered = $count;
                $data['draw'] = $draw;
                $data['recordsTotal'] = $recordsTotal;
                $data['recordsFiltered'] = $recordsFiltered;
                $rowData=array();
                $m = 1;
                foreach ($model as $row)
                {
                    $date_d=date("d/m/Y", strtotime($row->goods_receipt_date));
                    $rowData[]=array($row['id'],$date_d,$row->customer->customer_name,$row['reference']);
                    $m++;
                }
                $data['data'] = $rowData;
                echo json_encode($data);
        }
        /**copied by jisha from bouleward on 8-11-17**/
         public function actionCreate()
        {
            $model=new InventoryGoodsReceipt();
            $model_item = array(new InventoryGoodsReceiptItem());
            $id = (int) Yii::app()->request->getParam('id');
            if($id>0){
                $model=$model->findByPk($id);
                $model_item = InventoryGoodsReceiptItem::model()->findAll(array('condition'=>'inventory_goods_receipt_id = ' . $model->id .''));
                
            }
                Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('receipts_form', array('model' => $model,'model_item' => $model_item,'model_material_stock' => $model_material_stock), false, false);
        }
  
        
        public function actionSaveReceipt()
        {
            $model = new InventoryGoodsReceipt();
             
            if (isset($_POST['InventoryGoodsReceipt']))
            {
                $scenario='';
                if ((int) @$_POST['InventoryGoodsReceipt']['id'] > 0)
                {   
                    $id= (int) @$_POST['InventoryGoodsReceipt']['id'];
                    $model=$model->findByPk($id);  
                    $model->updated_by = Yii::app()->user->id;
                    $model->updated_date_time =date('Y-m-d h:i:s');
                    $scenario='update';
                    $audit_type = 'UPDATED';
                }
                else{
                    $model->created_by = Yii::app()->user->id;
                    $model->created_date_time =date('Y-m-d h:i:s');
                    $scenario='add';
                    $audit_type = 'CREATED';
                }
                
                $model->attributes=$_POST['InventoryGoodsReceipt'];
                if($_POST['InventoryGoodsReceipt']['goods_receipt_date']!='00/00/0000'){
                            $model->goods_receipt_date = str_replace('/', '-', $_POST['InventoryGoodsReceipt']['goods_receipt_date']);
                            $model->goods_receipt_date= date("Y-m-d", strtotime($model->goods_receipt_date));
                }
                $valid = $model->validate();
                $date = date("Y-m-d H:i:s");
                if(is_array($_POST['InventoryGoodsReceiptItem'])) {
                   
                       foreach ($_POST['InventoryGoodsReceiptItem'] as $k => $rowItem) {
                            $model_item[$k] = new InventoryGoodsReceiptItem;
                            //$storeModel = Store::model()->findBypk( (int) $rowItem['product_id'] );
                            if($rowItem['id'] > 0){
                                $model_item[$k] = InventoryGoodsReceiptItem::model()->findByPk($rowItem['id']);
                                $model_item[$k]->updated_by = Yii::app()->user->id; 
                                $model_item[$k]->updated_date_time = $date;
                             }else{
                                 $model_item[$k]->created_by = Yii::app()->user->id; 
                                 $model_item[$k]->created_date_time = $date;

                            }
                            $model_item[$k]->product_id = $rowItem['product_id'];
                            $model_item[$k]->product_name = $rowItem['product_name'];
                            $model_item[$k]->description = $rowItem['description'];
                            $model_item[$k]->picked_qty = $rowItem['picked_qty'];
                            $model_item[$k]->unit = $rowItem['unit']; 
                            $model_item[$k]->rate = $rowItem['rate'];
                            $model_item[$k]->bill_of_entry = $rowItem['bill_of_entry'];
                            $valid = $model_item[$k]->validate() && $valid;

                        }
                       
                   }
                
                if ($valid)
                {   
                         $model->save(false);

                          // inserting to audit log
                        AuditLog::saveAuditLogs(
                            'RECEIPTS',
                            Yii::app()->user->id,
                            $audit_type,
                            " with Checkin No: - {$model->id}  "
                        );
                        // end audit log 

                         foreach ($model_item as $eachitem){
                               $eachitem->inventory_goods_receipt_id = $model->id;
                               $eachitem->save(false);
                        }
                        if($scenario=='add'){
                            $model_mail_setting=Notification::model()->find(array('condition' => 'event_id="21"'));
                             Yii::import('application.controllers.front.MasternotificationController'); 
                            if($model_mail_setting->mail_required=='Y'){       
                                MasternotificationController::sendmail(21,$model->id);
                            }
                            if($model_mail_setting->notification_required=='Y'){                    
                                MasternotificationController::sendnotification(21,$model->id);
                            }
                            if($model_mail_setting->sms_required=='Y'){                    
                                MasternotificationController::sendsms(21,$model->id);
                            }
                        }
                        $jsonData['status'] = 'success';
                        echo CJSON::encode($jsonData);
                }
                else
                {
                        $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                        if ($model_item[0]->product_id > 0)
                                $error2 = json_decode(CActiveForm::validateTabular($model_item, '', false), true);
                            else
                                $error2[] = "Please add atleast one line item";
                           $error = CJSON::encode(array_merge_recursive($error1, $error2));
                           if ($error != '[]')
                                echo $error;
                }
          
            }
        }
        /**copied by jisha from bouleward on 8-11-17**/
        public function actionDeleteReceipt(){
		$id = $_POST['id'];
                $model=new InventoryGoodsReceipt();
                $model->deleteByPk($id);
                echo "success";
    }
    /**copied by jisha from bouleward on 8-11-17**/
    public function actionDeleteReceiptItem() {

        $id = $_POST['id'];

        $model = new InventoryGoodsReceiptItem();

        $model->deleteByPk($id);

        $jsonData['status'] = 'success';

        $jsonData['id'] = $id;

        echo CJSON::encode($jsonData);

    }
    
    /*jo*/
    public function actionGetunitdrop(){
        $row = $_POST['row_field'];
        $unit_id = $_POST['unit'];
        $arr_units=MasUnit::getSimilarUnits($unit_id);
        $drop = array();
        $modelOrder = new InventoryGoodsReceiptItem;
            $modelOrder->unit = $unit_id;
            $drop['drop'] = CHtml::activedropdownlist($modelOrder, "[" . $row . "]unit",$arr_units, array('class'=>'unit go','onchange' => 'getFactor(this.id,this.value)'));
        echo CJSON::encode($drop);
    }
    
    public function actionGetFactor(){
        $factor = 1;
        if((int) $_POST['value'] > 0){
            $factor = UnitOfMeasurement::getFactor($_POST['value']);
        }
        echo $factor;
    }
    
    public function actionPrintReceiptPDF() {

        //$model = new PurchasingRequisition();
        $id = Yii::app()->request->getParam('id');
        if($id>0)
        {
           $model = InventoryGoodsReceipt::model()->findByPk($id);
        }
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.receipts_print', array('model' => $model, 'id' => $id, 'title' => $title),true));
        $mPDF1->Output("Receipts.pdf", 'I');
    }
    /*end*/
    
}