<?php

class PurchaseInvoiceController extends Controller {

    public $layout = 'layout';

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout', 'Forgotpassword', 'Recover', 'companyFieldDetails'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'GetVendors', 'GetInvoiceList', 'Create', 'PurchasedFiles',
                    'GetPurchasingInvoiceDetails', 'Saveinvoice', 'GetReceiptsDetails', 'PrintInvoiceReportPDF', 'AddLandedCost', 'SaveLandedCost',
                    'Directinvoice', 'SaveDirectinvoice', 'PurchasedInvoices', 'getPurchaseInvoiceDetails',
                    'CalculateLandingCost', 'CalculateLandingCostInvoice', 'GetAllServices', 'CalculateLandingCostInvoices', 'EditInvoice', 'UpdateInvoice',
                    'ViewLandingCost', 'UploadDocuments', 'logisticindex', 'GetAirWayBillno', 'SaveInvoice', 'LoadPurchase', 'DownloadPurchaseInvoiceFormat', 'LoadPurchaseItemDetails', 'UploadInventoryFile', 'CancelPurchaseInvoice', 'DeletePurchaseItem',
                    'Getpurchaseinvoicedetails', 'UpdateCostDetails', 'Updatecost', 'GetPurchaseInvoice', 'GetAWBHistory'
                ),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array('accessControl'); // perform access control for CRUD operations
    }

    public function actionIndex() {
        $this->render('index');
    }

    /* public function actionGetInvoiceList()
      {
      $model = new PurchasingInvoice();
      $draw = $_POST['draw'];
      $offset = $_POST['start'];
      $limit = $_POST['length'];
      $columns = array(
      // datatable column index  => database column name
      0 => 't.file_id',
      1 => 't.id',
      2 => 't.awb_no',
      3 => 'vendor_details.vendor_name',
      4 => 't.invoice_date',
      5 => 't.grand_total',
      6 => 'file.current_process_status',
      8 => '',
      );
      $filterColumn = $columns[$_POST['order'][0]['column']];
      $filterOrder = $_POST['order'][0]['dir'];
      $orderBy = $filterColumn . " " . $filterOrder;
      $condition = 't.isActive="Y"';
      if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
      $searchString = $_POST['search']['value'];
      //materialreceived
      $condition .= " AND ( vendor_details.vendor_name LIKE '%" . $searchString . "%' OR  t.materialreceived LIKE '%" . $searchString . "%' OR  t.file_id LIKE '%" . $searchString . "%' OR t.id LIKE '%" . $searchString . "%' OR awb_no LIKE '%" . $searchString . "%' OR t.po_id LIKE '%" . $searchString . "%')";
      }
      $count = $model->with('file', 'vendor_details')->count(array('condition' => $condition));
      $model = $model->with('file', 'vendor_details')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 't.id desc'));
      $recordsTotal = $count;
      $recordsFiltered = $count;
      $data['draw'] = $draw;
      $data['recordsTotal'] = $recordsTotal;
      $data['recordsFiltered'] = $recordsFiltered;
      $rowData = array();
      foreach ($model as $row) {

      $count_item = PurchasingInvoiceItem::model()->count(array('condition' => 'purchasing_invoice_id='. $row['id'].' AND rate > 0'));

      $status=$row['file']['status'];
      if($row['posted']=='Y')
      {
      $status.='/Posted';
      $color='green';
      }
      else {
      $status.='/Unposted';
      $color='red';
      }
      $status='<span title="'.$status.'" style="background-color:'.$color.'; color:#fff;">'.$status.'</span>';
      $rowData[] = array($row['file_id'], $row['id'], $row['vendor_details']['vendor_name'], date("d/m/Y", strtotime($row['invoice_date'])),$row->currencyname->currency_code,  '<div class="text-right">' . Yii::app()->numberFormatter->formatCurrency($row['total_tax_amount'], "") . '</div>','<div class="text-right">' . Yii::app()->numberFormatter->formatCurrency($row['grand_total'], "") . '</div>',$status,$row['crm_user_id'],$row['posted'],$row['purchase_invoice'],$count_item);
      }
      $data['data'] = $rowData;
      echo json_encode($data);

      } */

    public function actionGetInvoiceList() {
        $model = new PurchasingInvoice();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'file_id',
            1 => 'id',
            2 => 'awb_no',
            3 => 'vendor_name',
            4 => 'invoice_date',
            5 => 'grand_total',
            6 => 'current_process_status',
            8 => '',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = "1=1";
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            //materialreceived
            $condition .= " AND (vendor_name LIKE '%" . $searchString . "%' OR  file_id LIKE '%" . $searchString . "%' OR id LIKE '%" . $searchString . "%' OR awb_no LIKE '%" . $searchString . "%' OR po_id LIKE '%" . $searchString . "%' OR job_order_ids LIKE '%" . $searchString . "%')";
        }
        //$count = $model->with('file', 'vendor_details','currencyname','items')->count(array('condition' => $condition));
        //$model = $model->with('file', 'vendor_details','currencyname','items')->findAll(array('select'=>'file_id,t.id,invoice_date,total_tax_amount,grand_total,crm_user_id,posted,purchase_invoice,GROUP_CONCAT(awb_no) AS awb_no','condition' => $condition, 'group'=>'t.id','limit' => $limit, 'offset' => $offset, 'order' => 't.id desc'));

        $SQL = " SELECT * FROM view_purchase_invoice_list WHERE $condition GROUP BY id ORDER BY id DESC LIMIT $offset,$limit";

        //echo $SQL;
        //$SQL1="SELECT * FROM view_job_order_list WHERE $condition ORDER BY ".$orderBy." LIMIT $offset,$limit";
        //echo $SQL1;
        $model = Yii::app()->db->createCommand($SQL)->queryAll();

        //print_r($model);

        $SQL_CNT = "SELECT COUNT(*) FROM view_purchase_invoice_list WHERE $condition";
        $count = Yii::app()->db->createCommand($SQL_CNT)->queryScalar();

        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        foreach ($model as $row) {

            $count_item = PurchasingInvoiceItem::model()->count(array('condition' => 'purchasing_invoice_id=' . $row['id'] . ' AND rate > 0'));

            $status = MasterFile::model()->getStatus($row['current_process_status']);
            if ($row['posted'] == 'Y') {
                $status .= '/Posted';
                $color = 'green';
            } else {
                $status .= '/Unposted';
                $color = 'red';
            }
            $status = '<span title="' . $status . '" style="background-color:' . $color . '; color:#fff;">' . $status . '</span>';
            $rowData[] = array($row['file_id'], $row['id'], $row['vendor_name'], $row['awb_no'], $row['job_order_ids'], date("d/m/Y", strtotime($row['invoice_date'])), $row['currency_name'], '<div class="text-right">' . Yii::app()->numberFormatter->formatCurrency($row['total_tax_amount'], "") . '</div>', '<div class="text-right">' . Yii::app()->numberFormatter->formatCurrency($row['grand_total'], "") . '</div>', $status, $row['crm_user_id'], $row['posted'], $row['purchase_invoice'], $count_item);
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate() {
        $model = new PurchasingInvoice();
        $id = (int) Yii::app()->request->getParam('id');
        $mr_id = (int) Yii::app()->request->getParam('mr_id');
        $file_id = (int) Yii::app()->request->getParam('file_id');

        $modelItems = array(new PurchasingInvoiceItem);
        if ($id > 0) {
            $model = $model->findByPk($id);
            $modelMasterFilefile = MasterFile::model()->findByPk($file_id);
            $modelItems = PurchasingInvoiceItem::model()->findAll(array('condition' => 'purchasing_invoice_id="' . $id . '"'));
            if (empty($modelItems)) {
                $modelItems = array(new PurchasingInvoiceItem);
            }
        }




        if ($file_id > 0) {
            $model->file_id = $file_id;
            $modOrder = PurchasingOrder::model()->find(array('condition' => 'file_id =' . $file_id));
            $model->vendor_id = $modOrder->vendor_id;
            $model->vendor_name = $modOrder->vendor_details->vendor_name;
            $model->po_id = $modOrder->id;
            $model->currency = $model_order->currency;
            $model->exchange_rate = $model_order->exchange_rate;
            $model->notes = $modOrder->start_text;
            $model->invoice_type = $modOrder->invoice_type;
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('create', array('model' => $model, 'file_id' => $file_id, 'modelInvoiceItems' => $modelItems,
            'modelAdd' => $modelAdd, 'modelNotes' => $modelNotes, 'modelDed' => $modelDed, 'modelmasterfile' => $modelMasterFilefile));
    }

    public function actionGetAirWayBillno() {
        $searchTerm = Yii::app()->request->getParam('term');
        $shipper_id = (int) Yii::app()->request->getParam('shipper_id');
        $activity_type = (int) Yii::app()->request->getParam('activity_type');
        $frm = (int) Yii::app()->request->getParam('frm');

        if ($frm == 2) {
            $awb_no = Yii::app()->request->getParam('awb_no');
            //$condition      = 'awb_no="' . $awb_no . '" AND t.shipper_id='.$shipper_id.' AND status!=11 AND activity_type='.$activity_type;
            $condition = 'awb_no="' . $awb_no . '" AND t.shipper_id=' . $shipper_id . ' AND activity_type=' . $activity_type . ' AND joborder.job_order_status!="CN"';
            //$condition      = 'awb_no="' . $awb_no . '" AND t.shipper_id='.$shipper_id;
            //echo $condition;
            $model = new JobOrderAgentDetails();
            $model = $model->with('joborder')->find(array('condition' => $condition));

            $data['job_order_no'] = $model['job_order_id'];
            $data['job_order_agent_id'] = $model['id'];
            $data['actual_cost'] = $model['actual_cost'];

            echo CJSON::encode($data);
            Yii::app()->end();
        } else {
            //$condition      = '(awb_no LIKE "%' . $searchTerm . '%") AND t.shipper_id='.$shipper_id.' AND status!=11 AND activity_type='.$activity_type;
            $condition = '(awb_no LIKE "%' . $searchTerm . '%") AND t.shipper_id=' . $shipper_id . ' AND activity_type=' . $activity_type;
            $model = new JobOrderAgentDetails();
            $model = $model->with('joborder')->findAll(array('condition' => $condition));
            $i = 0;
            foreach ($model as $eachModel) {
                $data[$i]['value'] = $eachModel->id;
                $data[$i]['label'] = $eachModel->awb_no . ' : ' . $eachModel->job_order_id;
                $i++;
            }
            echo CJSON::encode($data);
            Yii::app()->end();
        }
    }

    public function actionSaveInvoice() {
        $modelInvoice = new PurchasingInvoice();
        $others = array();
        if (isset($_POST['PurchasingInvoice'])) {

            $total = $net_total = $tot_tax = 0;

            if ((int) @$_POST['PurchasingInvoice']['id'] > 0) {
                $modelInvoice->id = (int) $_POST['PurchasingInvoice']['id'];
                $modelInvoice->updated_by = Yii::app()->user->id;
                $modelInvoice->updated_datetime = date('Y-m-d h:i:s');
                $modelInvoice = $modelInvoice->findByPK($_POST['PurchasingInvoice']['id']);
                $modelInvoice->scenario = 'update';
                $scenario = 'update';
            } else {
                $modelInvoice->created_by = Yii::app()->user->id;
                $modelInvoice->created_datetime = date('Y-m-d h:i:s');
                $modelInvoice->scenario = 'add';
                $scenario = 'add';
            }

            $modelInvoice->attributes = $_POST['PurchasingInvoice'];
            $modelInvoice->exchange_rate = $_POST['PurchasingInvoice']['exchange_rate'];
            $modelInvoice->currency = $_POST['PurchasingInvoice']['currency'];
            $modelInvoice->storekeeper_notes = $_POST['PurchasingInvoice']['storekeeper_notes'];
            $modelInvoice->title = $_POST['PurchasingInvoice']['title'];

            if ($_POST['PurchasingInvoice']['invoice_date'] != '') {
                $modelInvoice->invoice_date = str_replace('/', '-', $_POST['PurchasingInvoice']['invoice_date']);
                $modelInvoice->invoice_date = date("Y-m-d", strtotime($modelInvoice->invoice_date));
            }

            if ($_POST['PurchasingInvoice']['payment_date'] != '') {
                $modelInvoice->payment_date = str_replace('/', '-', $_POST['PurchasingInvoice']['payment_date']);
                $modelInvoice->payment_date = date("Y-m-d", strtotime($modelInvoice->payment_date));
            }

            //$modelInvoice->invoice_type = $_POST['PurchasingInvoice']['invoice_type'];
            $modelInvoice->crm_user_id = Yii::app()->user->id;
            $other_errors = array();
            $grand_total = $total_net_value = 0;
            $valid = $modelInvoice->validate();
            if (is_array($_POST['PurchasingInvoiceItem'])) {
                foreach ($_POST['PurchasingInvoiceItem'] as $i => $item) {

                    if ($item['id'] > 0) {
                        $modelItem[$i] = PurchasingInvoiceItem::model()->findByPK($item['id']);
                    } else {
                        $modelItem[$i] = new PurchasingInvoiceItem;
                    }

                    $job_id = (int) $item['job_order_id'];

                    if ($job_id > 0) {
                        $modelJobOrder = new JobOrder();
                        $modelJobOrder = $modelJobOrder->findByPk($job_id);
                        if (empty($modelJobOrder)) {
                            $others[] = "Please enter a valid Job Order# instead of - " . $job_id;
                            $valid = false;
                        }
                    }
                    /*  else{
                      $others[]="Job# cannot be blank";
                      $valid = false;
                      } */

                    //if (!empty($item['job_order_id'])) {


                    $modelItem[$i]->attributes = $_POST['PurchasingInvoiceItem'][$i];

                    $modelItem[$i]->product_id = "999999";
                    $modelItem[$i]->tax_amount = $item['tax_amount'];
                    $modelItem[$i]->job_order_id = $item['job_order_id'];
                    $modelItem[$i]->order_item_id = $item['order_item_id'];
                    $modelItem[$i]->job_order_agent_id = $item['job_order_agent_id'];
                    $modelItem[$i]->weight = $item['weight'];
                    $modelItem[$i]->volume = $item['volume'];
                    $modelItem[$i]->awb_no = $item['awb_no'];

                    $total += $item['net_amount'];
                    $net_total += $item['net_amount'];
                    $tot_tax += $item['tax_amount'];
                    $valid = $modelItem[$i]->validate() && $valid;
                    $total_net_value += ($item['net_amount'] + $item['tax_amount']);

                    //}
                    //code added by mereena on 17/07/2024 to avoid duplication
                    $modelPurchasingInvoiceItemCount=new PurchasingInvoiceItem();
                    $count_job_order_agent = (int) $modelPurchasingInvoiceItemCount->with('purchasinginvoice')->count(array('condition' => 'job_order_id='.(int) $item['job_order_id'].' AND vendor_id='.(int) @$_POST['PurchasingInvoice']['vendor_id'].' AND job_order_activity_type='.$item['job_order_activity_type'].' AND t.awb_no="'.$item['awb_no'].'"'));
                    if($count_job_order_agent > 0 && (int) $item['id']==0){
                        $SQL_PI='SELECT GROUP_CONCAT(purchasing_invoice_id) FROM `erp_purchasinginvoice_item` WHERE awb_no="'.$item['awb_no'].'"';
                        $pi_no = Yii::app()->db->createCommand($SQL_PI)->queryScalar();
                        $others[]='Purchase Invoice(s) ['.$pi_no.'] already generated for this item [Job Order#'.$item['job_order_id'].'/ AWB#:'.$item['awb_no'].']';
                        $valid=false;
                    }
                    //end
                    
                }
            }
/*echo '<pre>';
print_r($others);exit;*/

            if ($valid) {
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);

                if ((int) @$_POST['PurchasingInvoice']['id'] == 0) {
                    $modelMasterFile = new MasterFile();
                    $modelMasterFile->customer_id = 0;
                    $modelMasterFile->is_approved = "Y";
                    $modelMasterFile->current_process_status = "P_I";
                    $modelMasterFile->crm_user_id = Yii::app()->user->id;
                    $modelMasterFile->created_by = Yii::app()->user->id;
                    $modelMasterFile->created_datetime = date('Y-m-d h:i:s');
                    $modelMasterFile->file_title = "";
                    $modelMasterFile->lead_owner_id = 0;
                    $modelMasterFile->save(false);
                    $file_id = $modelMasterFile->id;
                    $modelInvoice->file_id = $file_id;
                }

                $modelInvoice->purchase_invoice_type = "LI";
                $modelInvoice->save();

                // inserting to audit log
                AuditLog::saveAuditLogs(
                        'PURCHASE_INVOICE',
                        Yii::app()->user->id,
                        'CREATED',
                        " INV No: - {$modelInvoice->id} "
                );
                // end audit log
                $invoice_id = $modelInvoice->id;

                $tot_of_net = $tot_tax = 0;
                $old_total_qty = $old_rate = array();

                $total_actual_weight = 0;
                $total_actual_volume = 0;
                $total_actual_cost = 0;

                $job_order_id = "";
                if (!empty($modelItem)) {
                    foreach ($modelItem as $eachItem) {
                        $eachItem->purchasing_invoice_id = $modelInvoice->id;
                        $eachItem->save(false);

                        $actual_cost = $eachItem->net_amount * $modelInvoice->exchange_rate;

                        $job_order_id = (int) $eachItem->job_order_id;
                        //if(isset($eachItem->activitytype->to_show_invoice) && $eachItem->activitytype->to_show_invoice=='Y'){
                        /*$modelJobOrderAgentDetails = new JobOrderAgentDetails();
                        $modelAgentDetails = $modelJobOrderAgentDetails->findByPk($eachItem->job_order_agent_id);
                        $existing_actual_cost = $modelAgentDetails->actual_cost;
                        if ((int) @$_POST['PurchasingInvoice']['id'] == 0) {
                            if ((int) $existing_actual_cost == 0 && $eachItem->job_order_agent_id > 0) {
                                //$actual_cost=$actual_cost+$existing_actual_cost;
                                $modelJobOrderAgentDetails->updateByPk($eachItem->job_order_agent_id, array('actual_weight' => $eachItem->weight, 'actual_volume' => $eachItem->volume, 'actual_cost' => $actual_cost, 'notes' => 'Added from Purchase Invoice# ' . $invoice_id/* ,'activity_type' => $eachItem->job_order_activity_type,'status'=>'11' ));
                            } else {
    
                                $modelJobOrderAgentDetails = new JobOrderAgentDetails();
                                $modelJobOrderAgentDetails->job_order_id = $job_order_id;
                                $modelJobOrderAgentDetails->shipper_id = $_POST['PurchasingInvoice']['vendor_id'];
                                $modelJobOrderAgentDetails->awb_no = $eachItem->awb_no;
                                $modelJobOrderAgentDetails->activity_type = $eachItem->job_order_activity_type;
                                $modelJobOrderAgentDetails->planned_weight = 0;
                                $modelJobOrderAgentDetails->planned_volume = 0;
                                $modelJobOrderAgentDetails->planned_cost = 0;
                                $modelJobOrderAgentDetails->planned_selling_price = 0;
                                $modelJobOrderAgentDetails->actual_weight = $eachItem->weight;
                                $modelJobOrderAgentDetails->actual_volume = $eachItem->volume;
                                $modelJobOrderAgentDetails->actual_cost = $actual_cost;
                                $modelJobOrderAgentDetails->status = 0;
                                $modelJobOrderAgentDetails->notes = 'Added from Purchase Invoice# ' . $invoice_id;
                                $modelJobOrderAgentDetails->last_updated_status = 0;
                                $modelJobOrderAgentDetails->last_status_api_content = '';
                                $modelJobOrderAgentDetails->save(false);
                            }
                        }*/
                        //}
                        
                        
                           $modelJobOrderAgentDetails=new JobOrderAgentDetails();
                            //$modelAgentDetails = $modelJobOrderAgentDetails->findByPk($eachItem->job_order_agent_id);
                            //$existing_actual_cost = $modelAgentDetails->actual_cost;
                            
                            $modelAgentDetails = $modelJobOrderAgentDetails->find(array('condition'=>'job_order_id='.$job_order_id.' AND activity_type='.$eachItem->job_order_activity_type.' AND awb_no="'.$eachItem->awb_no.'"'));
                            $existing_actual_cost = $modelAgentDetails->actual_cost;
                            //if ((int) @$_POST['PurchasingInvoice']['id'] == 0) {
                                //if(((int) $existing_actual_cost==0 && (int) $modelAgentDetails->id > 0)){
                              if((int) $modelAgentDetails->id > 0){    
                                //$actual_cost=$actual_cost+$existing_actual_cost;
                                    $modelJobOrderAgentDetails->updateByPk((int) $modelAgentDetails->id, array('actual_weight' => $eachItem->weight,'actual_volume' => $eachItem->volume,'actual_cost' => $actual_cost,'notes'=>'Added from Purchase Invoice# '.$invoice_id/*,'activity_type' => $eachItem->job_order_activity_type,'status'=>'11'*/));
                                    $job_order_agent_id = $modelJobOrderAgentDetails->id;
                                    
                                     // inserting to audit log
                                     AuditLog::saveAuditLogs(
                                        'PURCHASE_INVOICE',
                                        Yii::app()->user->id,
                                        'CREATED',
                                        " Purchase Invoice#: ".$modelInvoice->id." AWB#: - $eachItem->awb_no cost changed from $existing_actual_cost to  $actual_cost"
                                    );
                                    // end audit log 
                                }
                                else{
                                    
                                   if(((int) @$_POST['PurchasingInvoice']['id'] > 0 && $modelAgentDetails->id==0) || (int) @$_POST['PurchasingInvoice']['id']==0){
                                    
                                        $modelJobOrderAgentDetails                          = new JobOrderAgentDetails();
                                        $modelJobOrderAgentDetails->job_order_id            = $job_order_id;
                                        $modelJobOrderAgentDetails->shipper_id              = $_POST['PurchasingInvoice']['vendor_id'];
                                        $modelJobOrderAgentDetails->awb_no                  = $eachItem->awb_no;
                                        $modelJobOrderAgentDetails->activity_type           = $eachItem->job_order_activity_type;
                                        $modelJobOrderAgentDetails->planned_weight          = 0;
                                        $modelJobOrderAgentDetails->planned_volume          = 0;
                                        $modelJobOrderAgentDetails->planned_cost            = 0;
                                        $modelJobOrderAgentDetails->planned_selling_price   = 0;
                                        $modelJobOrderAgentDetails->actual_weight           = $eachItem->weight;
                                        $modelJobOrderAgentDetails->actual_volume           = $eachItem->volume;
                                        $modelJobOrderAgentDetails->actual_cost             = $actual_cost;
                                        $modelJobOrderAgentDetails->status                  = 0;
                                        $modelJobOrderAgentDetails->notes                   = 'Added from Purchase Invoice# '.$invoice_id;
                                        $modelJobOrderAgentDetails->last_updated_status     = 0;
                                        $modelJobOrderAgentDetails->last_status_api_content = '';
                                        $modelJobOrderAgentDetails->save(false);
                                        $job_order_agent_id = $modelJobOrderAgentDetails->id;
                                        //update purchase invoice
                                        
                                        
                                        
                                   }
                                }
                                
                                $modelPurchasingInvoiceItem = new PurchasingInvoiceItem();
                                $modelPurchasingInvoiceItem->updateByPk($eachItem->id,array('job_order_agent_id'=>$job_order_agent_id));




                        /* $total_actual_weight+=$eachItem->weight;
                          $total_actual_volume+=$eachItem->volume;
                          $total_actual_cost+=$actual_cost; */


                        /* $modelJOAgentDetails=new JobOrderAgentDetails();

                          $count_status = $modelJOAgentDetails->count(array('condition' => 'job_order_id='.$eachItem->job_order_id.' AND status<11'));

                          $modelJobOrderDetails = new JobOrder();
                          if($count_status==0){
                          $modelJobOrderDetails->updateByPk($eachItem->job_order_id, array('job_order_status' =>'D'));
                          }
                          else{
                          $modelJobOrderDetails->updateByPk($eachItem->job_order_id, array('job_order_status' =>'PD'));
                          } */


                        //$eachItem->fill_up_previous();

                        $grand_total += $eachItem->net_amount;
                        $tot_of_net += $eachItem->net_amount;
                        $tot_tax += $eachItem->tax_amount;
                    }

                    if ($job_order_id > 0) {
                        $modelJobOrder = new JobOrder();
                        $modelJobOrder->updateActualCost($job_order_id);
                        //$modelJobOrder->updateByPk($job_order_id, array('total_actual_weight' => $total_actual_weight,'total_actual_volume' => $total_actual_volume,'total_actual_cost' => $total_actual_cost));
                    }
                }


                $tot_of_net += $tot_tax;
                $total_net_value = $tot_of_net;
                $net_total += $tot_tax;
                $grand_total += $tot_tax;
                $modelInvoice->updateByPk($modelInvoice->id, array('grand_total' => $grand_total, 'total_tax_amount' => $tot_tax));
            } else {
                $error1 = $error2 = $error3 = $error4 = array();
                $error1 = json_decode(CActiveForm::validate($modelInvoice, '', false), true);
                if (!empty($modelItem[0]->product_id)) {
                    $error2 = json_decode(CActiveForm::validateTabular($modelItem, '', false), true);
                } else {
                    $error2[] = "Please add atleast one line item";
                }

                if (!empty($modelInvoiceAddition)) {
                    $error3 = json_decode(CActiveForm::validateTabular($modelInvoiceAddition, '', false), true);
                }

                if (!empty($modelInvoiceDeduction)) {
                    $error4 = json_decode(CActiveForm::validateTabular($modelInvoiceDeduction, '', false), true);
                }

                $error = CJSON::encode(array_merge_recursive($error1, $error2, $error3, $error4, $others));

                if ($error != '[]') {
                    echo $error;
                }
            }
            Yii::app()->end();
        } else {
            echo 'error';
        }
    }

    public function actionEditInvoice() {
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = PurchasingInvoice::model()->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('edit_invoice', array('model' => $model));
    }

    public function actionUpdateInvoice() {
        if (isset($_POST['PurchasingInvoice'])) {
            $id = $_POST['PurchasingInvoice']['id'];
            //Audit Log
            PurchasingInvoice::model()->updateByPk($id, array('invoice_no' => $_POST['PurchasingInvoice']['invoice_no'], 'updated_by' => Yii::app()->user->id, 'updated_datetime' => date('Y-m-d h:i:s')));
            AuditLog::saveAuditLogs(
                    'PURCHASE_INVOICE',
                    Yii::app()->user->id,
                    'UPDATED',
                    " with ID: - {$id}  "
            );
            $jsonData['status'] = 'success';
            echo CJSON::encode($jsonData);
        }
    }

    public function actionPrintInvoiceReportPDF() {

        $id = Yii::app()->request->getParam('id');
        $c_id = Yii::app()->request->getParam('c_id');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4-L');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.logistics.views.pdf.purchase_invoice_list_individual', array('model' => $model, 'id' => $id, 'c_id' => $c_id, 'title' => $title), true));
        $mPDF1->Output("PurchaseInvoice.pdf", 'I');
    }

    public function actionLoadPurchaseItemDetails() {
        $file_name = Yii::app()->request->getParam('file_id');
        $shipper_id = Yii::app()->request->getParam('shipper_id');
        $from_file = $this->readCSV("upload/purchaseinvoice/" . $file_name);
        $jsonData = array();

        $total_tax_amount = 0;
        $total_amount = 0;
        $grand_total = 0;

        $table = '<table class="table table-hover table-bordered personal-task" id="order_item_table" style="font-size:12px;">
            <tr>
                <th style="width:2%">No</th>
                <th style="width:27%">AWB#</th>
                <th style="width:10%">Type</th>
                <th style="width:8%">Job Order#</th>
                <th style="">Description</th>
                <th style="width:8%">Weight</th>
                <th style="width:8%">Volume</th>
                <th style="width:5%">Quantity</th>
                <th style="width:5%">Rate</th>
                <th style="width:5%">Tax(%)</th>
                <th style="width:5%">Amount</th>
                <th class="text-center" style="width:5%">
                    <a class="btn btn-xs btn-theme " href="#" onclick="addOrderRow($(\'#order_item_table\'));"><i class="fa fa-plus"></i></a>
                </th>
            </tr>';
        foreach (array_slice($from_file, 1) as $i => $eachItem) {

            $model = new PurchasingInvoiceItem();

            $awb_no = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[0]), '"'));
            $job_order_type = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[1]), '"'));
            $description = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[2]), '"'));
            $weight = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[3]), '"'));
            $volume = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[4]), '"'));
            $quantity = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[5]), '"'));
            $rate = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[6]), '"'));
            $tax_percentage = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[7]), '"'));

            $amount = $quantity * $rate;
            $tax_amount = 0;
            if ($tax_percentage > 0) {
                $tax_amount = ($amount * $tax_percentage) / 100;
            }

            $total_tax_amount += $tax_amount;
            $total_amount += $amount;

            $grand_total = $total_tax_amount + $total_amount;

            if (!empty($awb_no) && !empty($job_order_type) && !empty($quantity) && !empty($rate) && (int) $job_order_type > 0) {

                $condition = 'awb_no="' . $awb_no . '" AND t.shipper_id=' . $shipper_id . ' AND t.activity_type=' . $job_order_type;
                $modelAgentDetails = new JobOrderAgentDetails();
                $modelAgentDetails = $modelAgentDetails->with('joborder')->find(array('condition' => $condition));

                $model->job_order_activity_type = $job_order_type;
                $table .= '<tr>';
                $table .= '<td><label>' . ($i + 1) .
                        CHtml::activeHiddenField($model, "[$i]id") .
                        CHtml::activeHiddenField($model, "[$i]order_item_id") .
                        CHtml::activeHiddenField($model, "[$i]job_order_agent_id", array('value' => $modelAgentDetails['id'])) . '</label></td>';
                $table .= '<td>' . CHtml::activeTextField($model, "[$i]awb_no", array('class' => 'go cell-center text-left', 'value' => $awb_no, 'OnKeyup' => 'getJobOrderNo(this.id,this.value);')) . '</td>';
                $table .= '<td>' . CHtml::activeDropdownlist($model, "[$i]job_order_activity_type", MasJobOrderActivityType::GetJobOrderActivityType(), array('class' => 'tooltipster go', 'onchange' => 'getJobOrderNo(this.id,this.value);')) . '</td>';
                $table .= '<td>' . CHtml::activeTextField($model, "[$i]job_order_id", array('class' => 'qty go cell-center text-right', 'readonly' => true, 'value' => $modelAgentDetails['job_order_id'])) . '</td>';
                $table .= '<td>' . CHtml::activeTextArea($model, "[$i]description", array('class' => 'tooltipster desc go en-text-area', 'value' => $description)) . '</td>';
                $table .= '<td>' . CHtml::activeTextField($model, "[$i]weight", array('class' => 'qty go cell-center text-right', 'value' => $weight)) . '</td>';
                $table .= '<td>' . CHtml::activeTextField($model, "[$i]volume", array('class' => 'qty go cell-center text-right', 'value' => $volume)) . '</td>';
                $table .= '<td>' . CHtml::activeTextField($model, "[$i]quantity", array('class' => 'qty go cell-center text-right', 'onkeypress' => 'return isNumberKey(event)', 'onkeyup' => 'calculatestockValues($("#order_item_table"),this.id);', 'value' => $quantity)) . '</td>';
                $table .= '<td>' . CHtml::activeTextField($model, "[$i]rate", array('class' => 'qty go cell-center text-right', 'value' => $rate, 'onkeypress' => 'return isNumberKey(event)', 'onkeyup' => 'calculatestockValues($("#order_item_table"),this.id);')) . '</td>';
                $table .= '<td>' . CHtml::activeTextField($model, "[$i]tax_percentage", array('class' => 'qty go cell-center text-right', 'onkeypress' => 'return isNumberKey(event)', 'value' => $tax_percentage, 'onkeyup' => 'calculatestockValues($("#order_item_table"),this.id);')) .
                        CHtml::activeHiddenField($model, "[$i]tax_amount", array('value' => $tax_amount)) . '</td>';
                $table .= '<td>' . CHtml::activeTextField($model, "[$i]amount", array('class' => 'qty go cell-center text-right', 'value' => $amount, 'onkeypress' => 'return isNumberKey(event)', 'readonly' => true)) .
                        CHtml::activeHiddenField($model, "[$i]net_amount", array('value' => $amount)) . '</td>';
                $table .= '<td>' . CHtml::link('<i class="fa fa-times"></i>', 'javascript:void(0);', array('class' => 'btn btn-xs btn-danger cell-center', 'onclick' => 'removeTable($(\'#order_item_table\'),this,this.id)', 'title' => 'Remove this item', 'id' => 'order_' . $i)) . '</td>';
                $table .= '</tr>';
            }
        }

        $table .= '</table>';

        $table .= '<table class="table table-hover table-bordered table-nexted order_total">
            <tr class="bg-total">


                <td width="50%" class="text-right table_total_title">
                    <h2>Total</h2>
                </td>
                <td width="30%" class="text-right table_total">
                    <h2 class="total" class="text-right">' . Yii::app()->numberFormatter->formatCurrency($total_amount, " ") . '</h2>
                </td>
            </tr>
        </table>';

        $stockgrand_total = $stocktotal;

        $table .= '<table class="table table-hover table-bordered table-nexted order_grand_total">

            <tr class="summary_tr bg-total">
                <td width="70%" class="text-right table_total_title"><h2>VAT</h2></td>
                <td width="30%" class="table_total">
                    <h2 class="vattotal text-right">' . Yii::app()->numberFormatter->formatCurrency($total_tax_amount, " ") . '</h2>
                </td>
            </tr>
            <tr class="summary_tr bg-total">
                <td width="70%" class="text-right table_total_title">
                    <h1>Grand Total</h1></td>
                <td width="30%" class="text-right table_total">
                    <h1 class="grandtotal" class="text-right">' . Yii::app()->numberFormatter->formatCurrency($grand_total, " ") . '</h1></td>
            </tr>
        </table>';

        $jsonData['tbl'] = $table;

        echo CJSON::encode($jsonData);
        Yii::app()->end();
    }

    public function actionDownloadPurchaseInvoiceFormat() {
        $data = array();
        $data[0][0] = 'AWB No';
        $data[0][1] = 'Type';
        $data[0][2] = 'Description';
        $data[0][3] = "Weight";
        $data[0][4] = "Volume";
        $data[0][5] = "Quantity";
        $data[0][6] = "Rate";
        $data[0][7] = "Tax(%)";

        $this->array_to_csv_download($data, "UPLOAD_PURCHASE_INVOICE.csv");
    }

    public function readCSV($csvFile) {
        $file_handle = fopen($csvFile, 'r');
        while (!feof($file_handle)) {
            $contents = fgetcsv($file_handle, 1024, ',');
            //print_r($contents);
            /* if ($contents[1] == "")
              $contents = explode(';', $contents[0]); */
            $line_of_text[] = $contents;
            //print_r($line_of_text);
            //die();
        }
        fclose($file_handle);
        return $line_of_text;
    }

    public function actionCancelPurchaseInvoice() {
        $id = (int) Yii::app()->request->getParam('id');

        $model = new PurchasingInvoice();

        $model->updateByPk($id, array('purchase_invoice' => 'CA'));

        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
        Yii::app()->end();
    }

    public function actionDeletePurchaseItem() {
        $id = $_POST['id'];
        if ($id > 0) {
            PurchasingInvoiceItem::model()->deleteByPk($id);
            $status['status'] = 'success';
        } else {
            $status['status'] = 'error';
        }
        echo CJSON::encode($status);
    }

    public function actionGetpurchaseinvoicedetails() {
        $purchase_invoice_id = $_POST['purchase_invoice_id'];
        $model = PurchasingInvoice::model()->findByPk($purchase_invoice_id);
        // $model= new PurchasingInvoice();
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderpartial('update_actual_cost_details', array('model' => $model, 'purchase_invoice_id' => $purchase_invoice_id));
    }

    public function actionUpdateCostDetails() {
        $this->render('update_actual_cost');
    }

    public function actionUpdatecost() {
        $id = $_POST['id'];
        $job_order_id = $_POST['job_order_id'];
        $amount = $_POST['amount'];
        JobOrderAgentDetails::model()->updateByPk($id, array('actual_cost' => $amount));
    }

    public function actionGetPurchaseInvoice() {

        $from = $_GET['frm'];

        $searchTerm = $_GET['term'];

        $model = new PurchasingInvoice();

        $condition = 'id LIKE "%' . $searchTerm . '%" AND t.isActive="Y"';

        $model = $model->findAll(array('condition' => $condition));

        $i = 0;

        $data = array();

        foreach ($model as $eachModel) {

            $data[$i]['value'] = $eachModel->id;

            $data[$i]['label'] = $eachModel->id;

            $i++;
        }

        echo CJSON::encode($data);

        Yii::app()->end();
    }

    public function actionGetAWBHistory() {
        $awb_no = trim(Yii::app()->request->getParam('awb_no'));

        $modelPurchaseInvoiceItem = new PurchasingInvoiceItem();
        $modelPurchaseInvoiceItem = $modelPurchaseInvoiceItem->findAll(array('condition' => 'awb_no="' . $awb_no . '"'));
        $table = '<table class="table table-sm table-theme table-bordered">

                              <thead>

                                <tr>

                                    <th>Purchase Invoice#</th>

                                </tr>

                              </thead>

                              <tbody>';

        if (!empty($modelPurchaseInvoiceItem)) {

            foreach ($modelPurchaseInvoiceItem as $each) {

                $table .= '<tr>';

                $table .= '<td><b>' . $each->purchasing_invoice_id . '</b></td>';

                $table .= '</tr>';
            }
        } else {

            $table .= '<tr>';

            $table .= '<td>No Data</td>';

            $table .= '</tr>';
        }



        $table .= '</tbody></table>';

        $jsonData['table'] = $table;

        echo CJSON::encode($jsonData);
    }

}
