<?php

class MigrationController extends Controller
{
	
    public function accessRules() {
            return array(
                            array('allow', // allow all users to perform 'index' and 'view' actions
                                            'actions' => array('login', 'error', 'logout'),
                                            'users' => array('*'),
                            ),
                            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                                            'actions' => array('BuildMasterFileFromJobOrder','BuildJobOrderStatusHistory','BuildInvoiceItemDetailsFromJoborderAgent','ActivityGenerateFileIds','MigrateAWBNoJobOrder','MigrateShipperInInvoice'),
                                            'expression' => '$user->isMember()',
                            ),
                            array('deny', // deny all users
                                            'users' => array('*'),
                            ),
            );
    }
    
    
    
     public function actionBuildMasterFileFromJobOrder(){
        
        
        $modelJobOrder          = new JobOrder();
        $arr_job_order_details  = $modelJobOrder->findAll();
        
        $i=1;
        foreach($arr_job_order_details as $eachJobOrder){
            $modelMasterFile    = new MasterFile();
            
            $modelMasterFile->crm_user_id               = Yii::app()->user->id;       
            $modelMasterFile->customer_id               = $eachJobOrder->customer_id; 
            $modelMasterFile->file_title                = "";               
            $modelMasterFile->start_from                = "O";  
            $modelMasterFile->current_process_status    = "O";         
            $modelMasterFile->lead_owner_id             = $eachJobOrder->lead_owner_id;
            $modelMasterFile->is_approved               = "Y";   
            $modelMasterFile->approved_by               = $eachJobOrder->lead_owner_id;   
            $modelMasterFile->date_of_approval          = $eachJobOrder->job_date;   
            $modelMasterFile->isActive                  = "Y"; 
            $modelMasterFile->created_by                = Yii::app()->user->id;
            $modelMasterFile->created_datetime          = date('Y-m-d h:i:s');
            $modelMasterFile->updated_by                = 0;
            $modelMasterFile->updated_datetime          = "0000-00-00 00:00:00";
            //$modelMasterFile->save(false);
            
            
            $i++;
        }
        
       
        
    }
    
    
     public function actionBuildJobOrderStatusHistory(){
        
        
        $modelJobOrder          = new JobOrder();
        $arr_job_order_details  = $modelJobOrder->findAll();
        
        $i=1;
        foreach($arr_job_order_details as $eachJobOrder){
            
                $arr_job_order_agent_details    = JobOrderAgentDetails::model()->find(array('condition'=>'t.job_order_id='.$eachJobOrder->id));
                
                if(!empty($arr_job_order_agent_details->last_updated_status)){
                    $model                          = new JobOrderStatusHistory();
                    $model->job_order_id            = $eachJobOrder->id;
                    $model->job_order_agent_id      = $arr_job_order_agent_details->id;
                    $model->current_status          = MasJobOrderStatus::getStatusOfJobOrderByApiStatus($shipper_id,$arr_job_order_agent_details->last_updated_status);
                    $model->status_description      = $arr_job_order_agent_details->last_updated_status;
                    $model->status_type             = "";
                    $model->status_code             = "";
                    $model->status_city             = "";
                    $model->status_state_province   = "";
                    $model->status_postal_code      = "";
                    $model->status_country          = "";
                    $model->status_date             = date('Ymd');
                    $model->status_time             = "060000";
                    $model->updated_by              = Yii::app()->user->id;
                    $model->updated_date_time       = date('Y-m-d H:i:s',strtotime($model->status_time));
                    //$model->save(false);
                    
                    
                    
                    $modelMailStatus                = new JobOrderMailStatus();
                
                    $modelMailStatus->job_order_id                      = $eachJobOrder->id;
                    $modelMailStatus->job_order_agent_id                = $arr_job_order_agent_details->id;
                    $modelMailStatus->job_order_agent_shipper_id        = $arr_job_order_agent_details->shipper_id;
                    $modelMailStatus->shipper_awb_no                    = $arr_job_order_agent_details->awb_no;
                    $modelMailStatus->status_updated_date               = date('Y-m-d H:i:s');
                    $modelMailStatus->status_updated_count              = 1;
                    $modelMailStatus->status_mail_send                  = "N";
                    $modelMailStatus->last_status                       = $arr_job_order_agent_details->last_updated_status;
                    //$modelMailStatus->save(false);
                    
                    /*echo '<pre>';
                    print_r($modelMailStatus);*/
                }
            
              
            
            
            $i++;
        }
        
       
        
    }
    
    
    public function actionBuildInvoiceItemDetailsFromJoborderAgent(){
        
        
        /*$modelInvoice          = new Invoice();
        $arr_invoice_details  = $modelInvoice->findAll();*/
        
         $modelInvoiceItem          = new InvoiceItem();
        $arr_invoice_details  = $modelInvoiceItem->with('invoice')->findAll();
        
        /*echo '<pre>';
        print_r($arr_invoice_details);
        exit;*/
        
        $i=1;
        $activity_type="";
        foreach($arr_invoice_details as $eachInvoice){
            
                $arr_job_order_agent_details    = JobOrderAgentDetails::model()->find(array('condition'=>'t.job_order_id='.$eachInvoice->invoice->order_id));
                
                if((int) $arr_job_order_agent_details->id > 0){
                    
                    //$modelInvoiceItem->updateByPk($eachInvoice->id, array('order_item_id' => $arr_job_order_agent_details->id));
                    
                    //echo "job order=".$eachInvoice->order_id."#####".$arr_job_order_agent_details->activity_type."<br>";
                    //$activity_type.=$arr_job_order_agent_details->activity_type.",";
                    
                    //echo $arr_job_order_agent_details->id."<br>";
                    
                    //echo $i."<br>";
                    
                }
            
              
            
            
            $i++;
        }
        
        //echo $activity_type;
        
       
        
    }
    
    public function actionActivityGenerateFileIds(){
        
        $model=new Activity();
        
        $model=$model->findAll();
        
        foreach($model as $eachActivity){
            
            if($eachActivity->added_from=="TA" && $eachActivity->header_id>10000){
                $file_id = Lead::model()->findByPk($eachActivity->header_id)->file_id;
                Activity::model()->updateByPk($eachActivity->id, array('file_id' => $file_id,'customer_name'=>$eachActivity->customer_name));
            }
            
            /*switch($eachActivity->added_from){
                case "LE":
                    if($eachActivity->header_id>10000)
                    $file_id = Lead::model()->findByPk($eachActivity->header_id)->file_id;
                    //echo $eachActivity->header_id."<br>".$file_id."<br>";
                    break;
                case "QN":
                    $file_id = Quotes::model()->findByPk($eachActivity->header_id)->file_id;
                    break;
                case "OR":
                    $file_id = JobOrder::model()->findByPk($eachActivity->header_id)->file_id;
                    break;
                case "IN":
                    $file_id = Invoice::model()->findByPk($eachActivity->header_id)->file_id;
                    break;
                default:
                    $file_id = 0;
                    break;
            }
           //echo $file_id."<br>";   
            Activity::model()->updateByPk($eachActivity->id, array('file_id' => $file_id));
            if($file_id > 0){
            echo "Done=".$file_id."<br>";
            }*/
            
            
            
            
        }
        
    }
    
    public function actionMigrateAWBNoJobOrder(){
         $arr_job_order_details  = JobOrder::model()->findAll();
        
        $i=1;
        foreach($arr_job_order_details as $j=>$eachJobOrder){
            
                $arr_job_order_agent_details    = JobOrderAgentDetails::model()->find(array('condition'=>'t.job_order_id='.$eachJobOrder->id));
                
                $modelJobOrder=new JobOrder();
                $modelJobOrder->updateByPk($eachJobOrder->id, array('job_awb_no' => $arr_job_order_agent_details->awb_no));
                
                $modelInvoice                = new Invoice();
            
                $modelInvoice->updateAll(array('awb_no' => $arr_job_order_agent_details->awb_no), 'order_id ='.$eachJobOrder->id);
                echo  $j="Done";
        }
    }
    
    public function actionMigrateShipperInInvoice(){
        $arr_invoice_item_details  = InvoiceItem::model()->findAll();
        
        $i=1;
        foreach($arr_invoice_item_details as $j=>$eachItem){
            
            if($eachItem->order_item_id > 0){
                $arr_job_order_agent_details    = JobOrderAgentDetails::model()->findByPk($eachItem->order_item_id);
                
                $modelInvoiceItem=new InvoiceItem();
                $modelInvoiceItem->updateByPk($eachItem->id, array('shipper_id' => $arr_job_order_agent_details->shipper_id));
                echo  $j."=Done";
            }
                
        }
    }
    
    
    
    
}
?>