<?php

class IssuesController extends Controller
{
        public function accessRules() {
            return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                  'actions' => array('login', 'error', 'logout'),
                  'users' => array('*'),
                  ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                  'actions' => array('Index','Create','GetList','SaveIssue','DeleteIssue','GetProducts','DeleteIssueItem','Append','GetTotal',
                                     'GetStockDetails','GetSortedStockDetails','Getunitdrop','GetFactor','PrintPDF'),
                  'expression' => '$user->isMember()',
                  ),/**copied by jisha from bouleward on 8-5-17**/
                array('deny', // deny all users
                  'users' => array('*'),
                  ),
                );
        }
	public function actionIndex()
	{
		$this->render('index');
	}

	
	
	public function filters()
        {
            return array(
                'accessControl', // perform access control for CRUD operations
                );
        }
        /**copied by jisha from bouleward on 8-11-17**/
        public function actionGetList()
        {
                $model=new InventoryGoodsIssue();
                $draw    = $_POST['draw'];
                $offset = $_POST['start'];
                $limit  = $_POST['length'];
                $columns = array(
                // datatable column index  => database column name
                   0 =>'goods_issue_date',
                   1 =>'customer_id',
                    2 => 'project'
                   
                   );
                $filterColumn = $columns[$_POST['order'][0]['column']];
                $filterOrder  = $_POST['order'][0]['dir'];
                $orderBy   = $filterColumn." ".$filterOrder;
                $condition = 't.stock_updated="Y"';
                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
                {
                  $searchString = $_POST['search']['value'];
                  $condition.=" AND (id LIKE '%".$searchString."%' OR goods_issue_date LIKE '%".$searchString."%' OR project_id LIKE '%".$searchString."%')";
                }
                $count = $model->count(array('condition'=>$condition));
                $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>'id desc'));
                $recordsTotal = $count;
                $recordsFiltered = $count;
                $data['draw'] = $draw;
                $data['recordsTotal'] = $recordsTotal;
                $data['recordsFiltered'] = $recordsFiltered;
                $rowData=array();
                $m = 1;
                foreach ($model as $row)
                {
                    $date_d=date("d/m/Y", strtotime($row->goods_issue_date));
                    $rowData[]=array($row['id'],$date_d,$row->customer->customer_name,$row['reference']);
                    $m++;
                }
                $data['data'] = $rowData;
                echo json_encode($data);
        }
        /**copied by jisha from bouleward on 8-5-17**/
         public function actionCreate()
        {
            $model=new InventoryGoodsIssue();
            $model_item = array(new InventoryGoodsIssueItem());
            $id = (int) Yii::app()->request->getParam('id');
            if($id>0){
                $model=$model->findByPk($id);
                $model_item = InventoryGoodsIssueItem::model()->findAll(array('condition'=>'inventory_goods_issue_id = ' . $model->id .''));
                
            }
                Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('issues_form', array('model' => $model,'model_item' => $model_item), false, false);
        }
  

        public function actionSaveIssue()
        {
            $otherErrors = array();
            $model = new InventoryGoodsIssue();
            $scenario='';
            if ((int) @$_POST['InventoryGoodsIssue']['id'] > 0)
            {   
                $id= (int) @$_POST['InventoryGoodsIssue']['id'];
                $model=$model->findByPk($id);  
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time =date('Y-m-d h:i:s');
                $scenario='update';
                $audit_type = 'UPDATED';
            } else{
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time =date('Y-m-d h:i:s');
                $scenario='add';
                $audit_type = 'CREATED';
            }
            $model->attributes=$_POST['InventoryGoodsIssue'];
            $model->goods_issue_date= ( count( explode('/', $_POST['InventoryGoodsIssue']['goods_issue_date']) ) == 3 ) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['InventoryGoodsIssue']['goods_issue_date']))) : date('Y-m-d');
            $valid= $model->validate();
            $model_item = array();        
            $k =0;
            foreach ($_POST['InventoryGoodsIssueItem'] as $rowItem) {
                if( $rowItem['product_id'] > 0 ){
                    $model_item[$k] = new InventoryGoodsIssueItem();
                    $model_item[$k]->created_by = Yii::app()->user->id; 
                    $model_item[$k]->created_date_time = date("Y-m-d H:i:s");
                    $model_item[$k]->product_id = $rowItem['product_id'];
                    $model_item[$k]->product_name = $rowItem['product_name'];
                    $model_item[$k]->description = $rowItem['description'];
                    $model_item[$k]->picked_qty = $rowItem['picked_qty'];
                    $model_item[$k]->unit = $rowItem['unit']; 
                    $model_item[$k]->rate = $rowItem['rate'];
                    $valid = $model_item[$k]->validate() && $valid;
                    $productModel = Store::model()->findByPk($rowItem['product_id']);
                    if( (float) $rowItem['picked_qty'] > (float) ( $productModel->totalQuantity - $productModel->total_allocated_quantity ) ){
                        $otherErrors[] = 'Available Quantity for '.$productModel->part_number.' is '.(float) ( $productModel->totalQuantity - $productModel->total_allocated_quantity );
                        $valid = false;
                    }
                    $k++;
                }
            }
            
            if($valid && count($model_item) > 0 ){
                $model->issue_type = $_POST['InventoryGoodsIssue']['issue_type'];
                echo CJSON::encode(array('status' => 'success'));
                $model->save();

                // inserting to audit log
                AuditLog::saveAuditLogs(
                    'ISSUES',
                    Yii::app()->user->id,
                    $audit_type,
                    " with PKG No: - {$model->id}  "
                );
                // end audit log 


                foreach ($model_item as $eachitem){
                    $eachitem->inventory_goods_issue_id = $model->id;
                    $eachitem->save();   
                }
                if($scenario=='add'){
                    $model_mail_setting=Notification::model()->find(array('condition' => 'event_id="20"'));
                    Yii::import('application.controllers.front.MasternotificationController'); 
                    if($model_mail_setting->mail_required=='Y'){    
                        // MasternotificationController::sendmail(20,$model->id);
                    }
                    if($model_mail_setting->notification_required=='Y'){                    
                        // MasternotificationController::sendnotification(20,$model->id);
                    }
                    if($model_mail_setting->sms_required=='Y'){                    
                        // MasternotificationController::sendsms(20,$model->id);
                    }
                }
            }else{
                $error2 = array();
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                if ( count($model_item) > 0 )
                    $error2 = json_decode(CActiveForm::validateTabular($model_item, '', false), true);
                else
                    $error2[] = "Please add atleast one line item";
                    echo CJSON::encode(array_merge_recursive($error1, $error2, $otherErrors));
            }
        }
        
        public function actionDeleteIssue(){
		$id = $_POST['id'];
                $model=new InventoryGoodsIssue();
                $model->deleteByPk($id);
                echo "success";
    }
    /**copied by jisha from bouleward on 8-11-17**/
    public function actionDeleteIssueItem() {

        $id = $_POST['id'];

        $model = new InventoryGoodsIssueItem();

        $model->deleteByPk($id);

        $jsonData['status'] = 'success';

        $jsonData['id'] = $id;

        echo CJSON::encode($jsonData);

    }
    /**copied by jisha from bouleward on 8-11-17**/
     public function actionGetProducts() {
        $from = $_GET['frm'];
        $searchTerm = $_GET['term'];
        $condition = 'active = "Y" AND ( type ="I") AND (part_number LIKE "%' . $searchTerm . '%" OR description LIKE "%' . $searchTerm . '%")';
        $model = new Inventory();
        $model = $model->findAll(array('condition' => $condition, 'limit' => 200));
        $i = 0;
        foreach ($model as $eachModel) {
            $in_qty=Yii::app()->db->createCommand('select sum(quantity*exchange_rate) AS qty from {{stock_ledger}} where transaction_type="IN"');
            $out_qty=Yii::app()->db->createCommand('select sum(quantity*exchange_rate) AS qty from {{stock_ledger}} where transaction_type="OUT"');
            $qty=$in_qty-$out_qty;
            $data[$i]['value'] = $eachModel->id;
            $data[$i]['label'] = $eachModel->part_number.' : '. $eachModel->description;
            $data[$i]['part_number'] = $eachModel->part_number;
            $data[$i]['description'] = $eachModel->description;
            $data[$i]['unit_id'] = $eachModel->unit;
            $data[$i]['unit_name'] = $eachModel->units->unit_name;
            $data[$i]['free_qty'] = (float) $qty;
            $data[$i]['rate'] = $eachModel->rate;
            $data[$i]['volume'] = $eachModel->volume;
            $i++;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }
    /**copied by jisha from bouleward on 8-11-17**/
     public function actionAppend(){
            $id=Yii::app()->request->getparam("id");  
            $i=Yii::app()->request->getparam("order");  
            $model=new InventoryGoodsIssueItem();
            $data = ProductLocation::getProductWarehouses($id); 
            $drop = CHtml::activedropDownList($model,'[' . $i . ']product_location_id' , $data,array('class' => 'go', 'prompt' => '--select--', 'title' => '--select--','data-label'=>'Location *','onChange' => 'getQuantity(this.id,this.value)'));    
            $status=array("drop" => $drop);    
            echo CJSON::encode($status);
            
         }
         /**copied by jisha from bouleward on 8-11-17**/
           public function actionGetTotal(){
            $product = $_POST['product_id'];
            $warehouse =  $_POST['warehouse'];
            $status= array();
            if($product > 0 && $warehouse > 0){
                $loc = ProductLocation::model()->find(array('condition' => 'stock_id ='.$product.' AND warehouse_id='.$warehouse));
                if(!empty($loc))
                    $status['total'] = $loc->quantity;
                else
                    $status['total'] = 0 ;
            }
            echo CJSON::encode($status);
            
         }

         public function actionGetStockDetails(){
            
            $product_id = $_POST['product_id'];
            $quantity = $_POST['Qty'];
            $length = $_POST['length'];
            $stock_details = array(new MaterialReceiptStockDetails);
            
            if((int) $product_id > 0){
                $product = Store::model()->findBypk($product_id);
                $stock_details = MaterialReceiptStockDetails::model()->findAll(array('condition' => 'product_id = '.$product_id.' AND quantity > 0'));
            }
            
            $table = '';
            if($stock_details[0]->id > 0){
                
                foreach($stock_details as $each){
//                    $mod_alloc=new AllocatedMaterial();
//                    $alloc_qty=$mod_alloc->find(array('select'=>'SUM(quantity)AS quantity ','condition'=>'product_id = '.$product_id.' AND warehouse_id ='.$each->warehousename->id))->quantity;
//                    $free_qty=(float)((float)$each->quantity-(float)$alloc_qty);
                    $class = '';
                    if($each->expiry_date != '0000-00-00'){
                        $expire = date('d/m/Y',strtotime($each->expiry_date));
                        if(strtotime($each->expiry_date) < strtotime(date('Y-m-d'))){
                            $class = 'bg-danger';
                        }
                    }else{
                        $expire = '-';
                    }
                    if($each->stock_affect_date != '0000-00-00'){
                        $purchased = date('d/m/Y',strtotime($each->stock_affect_date));
                    }else{
                        $purchased = '-';
                    }
                     
                    $table .= '<tr class="'.$class.' TR-'.$length.'">';
                    $table .= '<td>'.$each->warehousename->warehouse_name.'</td>';
                    $table .= '<td>'.$product->part_number.CHtml::hiddenfield('Data['.$length.'][product_id]',$product_id).CHtml::hiddenfield('Data['.$length.'][material_receipt_id]',$each->id).'</td>';
                    $table .= '<td>'.$each->rack->name.CHtml::hiddenfield('Data['.$length.'][rack_id]',$each->rack_id).'</td>';
                    $table .= '<td>'.$each->bin->name.CHtml::hiddenfield('Data['.$length.'][bin_id]',$each->bin_id).'</td>';
                    $table .= '<td>'.$each->batch_no.'</td>';
                    $table .= '<td>'.$each->serial_no.'</td>';
                    $table .= '<td>'.$purchased.'</td>';
                    $table .= '<td>'.$expire.'</td>';
                    $table .= '<td>'.CHtml::textfield('Data['.$length.'][bill_of_exit]','',array('class' => 'form-control')).'</td>';
                    $table .= '<td>'.CHtml::textfield('Data['.$length.'][qty_available]',$each->quantity,array('class' => 'form-control text-right','readonly' => 'readonly')).'</td>';
                    $table .= '<td>'.CHtml::textfield('Data['.$length.'][picked_qty]','',array('class' => 'form-control text-right','onkeyup' => 'verifyQty(this.id,this.value);')).'</td>';
                    $table .= '</tr>';
                    $length++;
                }

            }else{ 
                if($length == 0)
                    $table .= '<tr class="no-data-tr"><td colspan="11" class="text-center"> No Data </td></tr>';
            }

            echo $table;
        }

        public function actionGetSortedStockDetails(){
            
            $products = array();
            if(is_array($_POST['products'])){
                foreach($_POST['products'] as $i => $each){
                    $products[$i] = (int) $each;
                }
            }
            
            $attr = $_POST['attr'];

            if($_POST['toggle'] == 1)
                $toggle = 'DESC';
            else
                $toggle = 'ASC';

            
            if(!empty($products))
                $stock_details = MaterialReceiptStockDetails::model()->findAll(array('condition' => 'product_id IN ('.implode(',',$products).') AND quantity > 0','order' => $attr.' '.$toggle));
            else
                $stock_details = array(new MaterialReceiptStockDetails);

            $table = '';
            if($stock_details[0]->id > 0){
                
                foreach($stock_details as $length => $each){
                    
                    $class = '';
                    if($each->expiry_date != '0000-00-00'){
                        $expire = date('d/m/Y',strtotime($each->expiry_date));
                        if(strtotime($each->expiry_date) < strtotime(date('Y-m-d'))){
                            $class = 'bg-danger';
                        }
                    }else{
                        $expire = '-';
                    }
                    if($each->stock_affect_date != '0000-00-00'){
                        $purchased = date('d/m/Y',strtotime($each->stock_affect_date));
                    }else{
                        $purchased = '-';
                    }
                     
                    $table .= '<tr class="'.$class.' TR-'.$length.'">';
                    $table .= '<td>'.$each->warehousename->warehouse_name.'</td>';
                    $table .= '<td>'.$each->product->part_number.CHtml::hiddenfield('Data['.$length.'][product_id]', $each->product_id).CHtml::hiddenfield('Data['.$length.'][material_receipt_id]',$each->id).'</td>';
                    $table .= '<td>'.$each->rack->name.CHtml::hiddenfield('Data['.$length.'][rack_id]',$each->rack_id).'</td>';
                    $table .= '<td>'.$each->bin->name.CHtml::hiddenfield('Data['.$length.'][bin_id]',$each->bin_id).'</td>';
                    $table .= '<td>'.$each->batch_no.'</td>';
                    $table .= '<td>'.$each->serial_no.'</td>';
                    $table .= '<td>'.$purchased.'</td>';
                    $table .= '<td>'.$expire.'</td>';
                    $table .= '<td>'.CHtml::textfield('Data['.$length.'][bill_of_exit]','',array('class' => 'form-control')).'</td>';
                    $table .= '<td>'.CHtml::textfield('Data['.$length.'][qty_available]',$each->quantity,array('class' => 'form-control text-right','readonly' => 'readonly')).'</td>';
                    $table .= '<td>'.CHtml::textfield('Data['.$length.'][picked_qty]','',array('class' => 'form-control text-right','onkeyup' => 'verifyQty(this.id,this.value);')).'</td>';
                    $table .= '</tr>';
                    $length++;
                }

            }else{ 
                if($length == 0)
                    $table .= '<tr class="no-data-tr"><td colspan="11" class="text-center"> No Data </td></tr>';
            }

            echo $table;
        }
        
         /*jo*/
        public function actionGetunitdrop(){
            $row = $_POST['row_field'];
            $product = $_POST['product_id'];
            $drop = array();
            $modelOrder = new InventoryGoodsIssueItem;
            if($product > 0){
                $modelOrder->unit = UnitOfMeasurement::getBaseunit($product);
                $drop['drop'] = CHtml::activedropdownlist($modelOrder, "[" . $row . "]unit",UnitOfMeasurement::getUnits($product), array('class'=>'unit go','onchange' => 'getFactor(this.id,this.value)'));
            }
            echo CJSON::encode($drop);
        }
        
        public function actionGetFactor(){
            $factor = 1;
            if((int) $_POST['value'] > 0){
                $factor = UnitOfMeasurement::getFactor($_POST['value']);
            }
            echo $factor;
        }
        
        public function actionPrintPDF() {

        //$model = new PurchasingRequisition();
        $id = Yii::app()->request->getParam('id');
        if($id>0)
        {
           $model = InventoryGoodsIssue::model()->findByPk($id);
        }
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.issues_print', array('model' => $model, 'id' => $id, 'title' => $title),true));
        $mPDF1->Output("GoodsIssue.pdf", 'I');
    }
        /*end*/
}