<?php

class InvreportsController extends Controller {

    public function accessRules() {

        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('PrintInvStockLedgerReport', 'PrintInvStockLedgerReportPDF', 'GetCustomer', 'GetProduct',
                    'PrintInventoryReport', 'PrintInvLedgerReport', 'PrintInvLedgerReportPDF', 'PrintInvStockSummaryReport', 'PrintInvStockAsOfReport', 'PrintWarehouseStockReport', 'PrintWarehouseStockReportPDF',
                    'PrintWarehouseVerticalReport', 'PrintWarehouseVerticalReportPDF', 'PrintRackStockReport', 'ExportRackExcel', 'PrintRackStockReportPDF', 'PrintInvStockStateReportPDF', 'StockStateasof', 'PrintWarehouseStockReportList',
                    'PrintInvStockSummaryReportPDF', 'PrintInvStockSummaryReportExcel', 'PrintInvStockLedgerReportExcel','GetSerialNoProduct','GetSampleTrack','PrintHiringTransactionLedger',
                    'Printtransactiondetails','PrintHiringTransactionLedgerPDF','PrintHiringTransactionLedgerExcel','GetHiringProduct','PrintItemHistory'
                ),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionPrintInvStockLedgerReport() {

        $from_date = $_POST['from_date'];
        $to_date   = $_POST['to_date'];
        $product_id   = $_POST['part_no'];
        $id = $_POST['id'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->render('//reports/print_inv_stockledger', array('product_id' => $product_id, 'from_date' => $from_date, 'to_date' => $to_date), false, true);
    }

    public function actionPrintInventoryReport() {

        $model = new StockLedger();
        $type = $_POST['type'];
        $tax_code = $_POST['tax_code'];
        $part_no = $_POST['part_no'];
        $inv_type = $_POST['inv_type'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->render('//reports/print_inv_report', array('model' => $model, 'part_no' => $part_no, 'tax_code' => $tax_code, 'type' => $type, 'inv_type' => $inv_type, 'title' => $title), false, true);
    }

    public function actionPrintInvLedgerReportPDF() {

        $model = new StockLedger();
        $from_date = Yii::app()->request->getParam('from_date');
        $to_date = Yii::app()->request->getParam('to_date');
        $type = Yii::app()->request->getParam('type');
        $part_no = Yii::app()->request->getParam('part_no');
        $product_id = Yii::app()->request->getParam('product_id');
        //invledger_report
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.invledger_report', array('model' => $model, 'from_date' => $from_date, 'to_date' => $to_date, 'customer_id' => $customer_id, 'type' => $type, 'product_id' => $product_id, 'part_no' => $part_no, 'title' => $title), true));

        $mPDF1->Output("InvLedgerReport.pdf", 'I');
    }

    public function actionPrintInvLedgerReport() {

        $model = new StockLedger();
        $from_date = $_POST['from_date'];
        $to_date = $_POST['to_date'];
        $product_id = $_POST['product_id'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->render('//reports/print_invledger_report', array('model' => $model, 'product_id' => $product_id, 'from_date' => $from_date, 'to_date' => $to_date, 'part_no' => $part_no, 'type' => $type, 'title' => $title), false, true);
    }

    public function actionPrintInvStockSummaryReport() {

        $model = new StockLedger();
        $from_date = Yii::app()->request->getParam('from_date');
        $to_date = Yii::app()->request->getParam('to_date');
        $part_no = Yii::app()->request->getParam('part_no');
        $product_id = Yii::app()->request->getParam('product_id');
        $brand = Yii::app()->request->getParam('brand');
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->render('//reports/print_invsummary_report', array('model' => $model, 'part_no' => $part_no, 'from_date' => $from_date, 'to_date' => $to_date, 'type' => $type, 'title' => $title, 'product_id' => $product_id, 'brand' => $brand), false, true);
    }

    public function actionPrintInvStockSummaryReportExcel() {
        $model = new StockLedger();
        $from_date = Yii::app()->request->getParam('from_date');
        $to_date = Yii::app()->request->getParam('to_date');
        $part_no = Yii::app()->request->getParam('part_no');
        $product_id = Yii::app()->request->getParam('product_id');
        $brand = Yii::app()->request->getParam('brand');
        $heading = 'Part No,Brand,Description,Opening Qty,In Qty,Out Qty,Bal Qty,Unit,Rate,Total Value';
        $j = 0;
        $list[$j++] = $heading;
        $condition = '1=1';
        $cond1 = '1=1';
        if ($product_id != '') {

            $condition .= ' AND t.id=' . $product_id;
        }
        if ($from_date != '') {
            $from_date = str_replace('/', '-', $from_date);
            $from_date = date('Y-m-d', strtotime($from_date));
            $cond1 .= ' AND transaction_date >="' . $from_date . '"';
        }
        if ($to_date != '') {
            $to_date = str_replace('/', '-', $to_date);
            $to_date = date('Y-m-d', strtotime($to_date));
            $cond1 .= ' AND transaction_date <="' . $to_date . '"';
        }
        if ($brand != '') {
            $condition .= ' AND t.brand_class_id="' . $brand . '"';
        }
        $condition .= ' AND t.inventory_item_type!="2"';

        $total = 0;
        $model_stock = Store::model()->findAll(array('condition'=>$condition,'group'=>'t.id','order'=>'t.part_number'));
        $total_value = 0;
        foreach ($model_stock as $i => $model) {
            $line = '';
            $condn = $cond1 . ' AND product_id ="' . $model->id . '"';
            
            $openingStock  = (float) Yii::app()->db->createCommand('SELECT SUM(quantity) AS quantity FROM erp_stock_ledger L 
                                                        WHERE L.product_id='.$model->id.' AND  
                                                                L.transaction_date < "'.$from_date.'" ')->queryScalar();
                                                                
            $balance = $openingStock;
            $arr_in_qty = StockLedger::model()->find(array('select'=>'IFNULL(SUM(quantity),0) AS quantity','condition'=>$condn.' AND transaction_type="IN"','group'=>'t.product_id'));
            $arr_out_qty = StockLedger::model()->find(array('select'=>'IFNULL(SUM(quantity),0) AS quantity','condition'=>$condn.' AND transaction_type="OUT"','group'=>'t.product_id'));

            $arr_stock_bet = Yii::app()->db->createCommand('SELECT SUM(summary_qty) AS summary_qty FROM view_stock_ledger_summary 
                                            WHERE '.$condn.' group BY product_id ASC')->queryRow();

            $in_qty = $arr_in_qty->quantity;
            $out_qty = -($arr_out_qty->quantity);
            $balance +=  $in_qty+$out_qty;
            /*$arr_stock_bet = Yii::app()->db->createCommand('SELECT SUM(summary_qty) AS summary_qty FROM view_stock_ledger_summary 
                                            WHERE '.$condn.' group BY product_id ASC')->queryRow();
            
            $in_qty = ( $arr_stock_bet['summary_qty'] > 0 ) ? abs($arr_stock_bet['summary_qty']) : '';
            $out_qty = ( $arr_stock_bet['summary_qty'] < 0 ) ? abs($arr_stock_bet['summary_qty']) : '';
            $balance =  ( $in_qty - $out_qty ) + $balance;*/
            
            $zero_flag = 0;
            
           if((float)$balance > 0 ) :
                $line = $model->part_number;
                $line .=',' . $model->brand_detail->product_class;
                $line .=',' . $model->description;
                $line .=',' . $openingStock;
                $line .=',' . (float)$in_qty;
                $line .=',' . (float)$out_qty;
                $line .=',' . (float)$balance;
                $line .=',' . $model->unit->symbol;
                $line .=',' . $model->rate;

                $total = ((int) $balance) * $model->rate;
                $total_value+=$total;
                $line .=',' . $total;
                $list[$j++] = $line;
            endif;             
        }


        $file = fopen("uploads/csvs/inventoryledger.csv", "w");
        foreach ($list as $line) {
            fputcsv($file, explode(',', $line));
        }

        fclose($file);
        $filename = 'uploads/csvs/inventoryledger.csv'; 
        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';
        header('Content-Type: application/csv');
        header("Content-disposition: attachment; filename=\"inventoryledger.csv\"");
        readfile($filename);
        Yii::app()->end();
        return;
    }

    public function actionPrintInvStockSummaryReportPDF() {

        $model = new StockLedger();
        $from_date = Yii::app()->request->getParam('from_date');
        $to_date = Yii::app()->request->getParam('to_date');
        $part_no = Yii::app()->request->getParam('part_no');
        $product_id = Yii::app()->request->getParam('product_id');
        $brand = Yii::app()->request->getParam('brand');

        $param = array(
            'from_date' => $from_date,
            'to_date' => $to_date,
            'part_no' => $part_no,
            'product_id' => $product_id,
            'brand' => $brand,
        );
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        set_time_limit(0);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.invsummary_report', $param, true));

        $mPDF1->Output("invsummary_report", 'I');
    }

    public function actionPrintInvStockAsOfReport() {

        $model = new StockLedger();
        $to_date = $_POST['to_date'];
        $part_no = $_POST['part_no'];
        $type = $_POST['type'];
        $brand_id = $_POST['brand_id'];
        $product_id = $_POST['product_id'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->render('//reports/print_invstockstate_report', array('model' => $model, 'to_date' => $to_date, 'part_no' => $part_no, 'type' => $type, 'title' => $title, 'brand_id' => $brand_id, 'product_id' => $product_id), false, true);
    }

    public function actionPrintInventoryReportPDF() {

        $model = new StockLedger();
        $type = Yii::app()->request->getParam('type');
        $part_no = Yii::app()->request->getParam('part_no');

        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.inv_report', array('model' => $model, 'from_date' => $from_date, 'to_date' => $to_date, 'customer_id' => $customer_id, 'type' => $type, 'title' => $title), true));

        $mPDF1->Output("InventoryReport.pdf", 'I');
    }

    public function actionPrintInvStockStateReportPDF() {
        ini_set('memory_limit', '1024M');
        set_time_limit(1200);
        $model = new Inventory();

        $to_date = Yii::app()->request->getParam('to_date');
        $type = Yii::app()->request->getParam('type');
        $part_no = Yii::app()->request->getParam('part_no');
        $brand_id = Yii::app()->request->getParam('brand_id');

        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.inv_stockstateasof', array('model' => $model, 'to_date' => $to_date, 'part_no' => $part_no, 'type' => $type, 'title' => $title, 'brand_id' => $brand_id), true));

        $mPDF1->Output("InvStockStateReport.pdf", 'I');
    }

    public function actionPrintInvStockLedgerReportExcel() {
        $from_date = Yii::app()->request->getParam('from_date');
        $to_date = Yii::app()->request->getParam('to_date');
        $reference_id = (int) Yii::app()->request->getParam('reference_id');
        $product_id = (int) Yii::app()->request->getParam('product_id');
        $type = Yii::app()->request->getParam('type');

        $from_date = ( count( explode('/', $from_date) ) == 3 ) ? date('Y-m-d', strtotime( str_replace('/', '-', $from_date) )) : date('Y-m-01');
        $to_date = ( count( explode('/', $to_date) ) == 3 ) ? date('Y-m-d', strtotime( str_replace('/', '-', $to_date) )) : date('Y-m-d');
        if( $product_id > 0 ) {
            $filename = 'transaction'.date('dmYhis').'.xls';
            $data = '<html>
                        <head>
                            <style>
                                table{
                                    width:100%;
                                }
                                .head{
                                    background-color : yellow;
                                    font-weight: bold;
                                    font-size: 14px;
                                }
                                .total{
                                    text-align: right;
                                    font-weight: bold;
                                    font-size: 14px;
                                }
                            </style>
                        </head>
                        <body>
                            <table border=1>
                                <thead>
                                        <th>No</th>
                                        <th>Tran.Date</th>
                                        <th>Tran.No</th>
                                        <th>Tran.Type</th>
                                        <th>Reference</th>
                                        <th>Rate</th> 
                                        <th>+</th>
                                        <th>-</th> 
                                        <th>Balance</th> 
                                </thead>
                                <tbody>';
                $allstockItems = Yii::app()->db->createCommand('SELECT * FROM view_stock_ledger_summary WHERE product_id='.$product_id.' AND transaction_date BETWEEN "'.$from_date.'" AND "'.$to_date.'" ORDER BY transaction_date,id ASC')->queryAll();
                $openingStock  = (float) Yii::app()->db->createCommand('SELECT SUM(quantity) AS quantity FROM erp_stock_ledger L WHERE L.product_id='.$product_id.' AND  L.transaction_date < "'.$from_date.'" ')->queryScalar();
                $balance = $openingStock;
                $total_in = $total_out = 0;

                $data .= '  <tr>
                                <td colspan="8" class="text-right"> Opening balance</td>
                                <td class="text-center">'.$openingStock.'</td>
                            </tr>';
                foreach ( $allstockItems as $i => $model)  {
                    
                    $reference = array( 
                        'DELIVERY_NOTE' => DeliveryNote::model()->findBypk($model['header_id'])->customer->customer_name,
                        'DELIVERY_NOTE_CANCEL' => DeliveryNote::model()->findBypk($model['header_id'])->customer->customer_name,
                        'PURCHASE' => PurchasingMaterialreceipt::model()->findBypk($model['header_id'])->vendor_details->vendor_name,
                        'DEBIT_NOTE' => Purchasingdebitnote::model()->findBypk($model['header_id'])->vendor_details->vendor_name,
                        'CREDIT_NOTE' => Creditnote::model()->findBypk($model['header_id'])->customer_details->customer_name,
                    );

                     $in_qty = ( $model['transaction_type'] =='IN' ) ? abs($model['summary_qty']) : '';
                    $out_qty = ( $model['transaction_type'] =='OUT' ) ? abs($model['summary_qty']) : '';
                    $balance =  ( $in_qty - $out_qty ) + $balance;

                    $total_in += $in_qty;
                    $total_out += $out_qty;

                    $data .= '<tr>
                                <td> '.($i+1).'</td>
                                <td> '.date('d/m/Y', strtotime($model['transaction_date'])).'</td>
                                <td> '.$model['header_id'].'</td>
                                <td> '.$model['transaction_type'].'</td>
                                <td> '.$reference[$model['transaction_type']].'</td>
                                <td> '.$model['cost_price'].'</td>
                                <td class="text-center"> '.$in_qty.'</td>
                                <td class="text-center"> '.$out_qty.' </td>
                                <td class="text-center"> '.$balance.' </td>
                            </tr>';
                }

                $data .= ' <tr>
                                <td colspan="6"></td>
                                <td  class="text-center">'.Yii::app()->numberFormatter->formatCurrency($total_in, " ").'</td>
                                <td  class="text-center">'.Yii::app()->numberFormatter->formatCurrency($total_out, " ").'</td>
                                <td  class="text-center">'.Yii::app()->numberFormatter->formatCurrency($balance, " ").'</td>
                            </tr>';

                $data .= '      </tbody>
                                </table>
                            </body>
                        </html>';
                
                    header ( "Content-type: application/vnd.ms-excel" );
                    header ( "Content-Disposition: attachment; filename=\"".$filename."\"" );
                    echo $data;
                    Yii::app()->end();
                    return;
        }else{
            echo 'select product';
        }
    }

    public function actionPrintInvStockLedgerReportPDF() {
        
        $from_date = Yii::app()->request->getParam('from_date');
        $to_date = Yii::app()->request->getParam('to_date');
        $reference_id = (int) Yii::app()->request->getParam('reference_id');
        $product_id = (int) Yii::app()->request->getParam('product_id');
        $type = Yii::app()->request->getParam('type');

        $from_date = ( count( explode('/', $from_date) ) == 3 ) ? date('Y-m-d', strtotime( str_replace('/', '-', $from_date) )) : date('Y-m-01');
        $to_date = ( count( explode('/', $to_date) ) == 3 ) ? date('Y-m-d', strtotime( str_replace('/', '-', $to_date) )) : date('Y-m-d');

        $param = array(
            'from_date' => $from_date,
            'to_date' => $to_date,
            'reference_id' => $reference_id,
            'product_id' => $product_id,
            'type' => $type
        );

        if( $product_id > 0 ) {
            $mpdf = Yii::app()->ePdf->mpdf('', 'A4');
            $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
            $mpdf->WriteHTML($stylesheet, 1);
            $mpdf->WriteHTML($this->renderPartial('application.views.front.reports.pdf.inv_stockledger', $param, true));
            $mpdf->Output("invstockledger".date('dmYhis').".pdf", 'I');
        }else
            echo 'Select Product';
    }

    public function actionGetCustomer() {
        $searchTerm = trim($_GET['term']);
        $condition = 'name LIKE "%' . $searchTerm . '%"';
        $model = Yii::app()->db->createCommand('SELECT * FROM view_stock_ledger_customer_vendor WHERE name LIKE "%'.$searchTerm.'%"')->queryAll();
        $i = 0;
        foreach ($model as $eachModel) {
            $data[$i]['value'] = $eachModel['id'];
            $data[$i]['label'] = $eachModel['name'];
            $data[$i]['description'] = $eachModel['type'];
            $i++;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }

    public function actionGetProduct() {
        $from = $_GET['frm'];
        $searchTerm = $_GET['term'];
        $condition = 'part_number LIKE "%' . $searchTerm . '%" OR description LIKE "%' . $searchTerm . '%"';
        if ($frm == 'changerack'){
            $condition .= ' AND have_expiry_date = "N" AND have_serial_no = "N"';
        }
            
        $model = new Inventory();
        $model = $model->findAll(array('select' => 'id, part_number, description', 'condition' => $condition, 'limit' => 200));
        $i = 0;
        foreach ($model as $eachModel) {
            $data[$i]['value'] = $eachModel->part_number;
            $data[$i]['label'] = $eachModel->part_number.' : '.$eachModel->description;
            $data[$i]['product_id'] = $eachModel->id;
            $i++;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }
    
    public function actionGetSerialNoProduct() {
        $from = $_GET['frm'];
        $searchTerm = $_GET['term'];
        $condition = 'part_number LIKE "%' . $searchTerm . '%" AND have_serial_no = "Y"';        
        $model = new Inventory();
        $model = $model->findAll(array('condition' => $condition));
        $i = 0;
        foreach ($model as $eachModel) {
            $data[$i]['value'] = $eachModel->part_number;
            $data[$i]['label'] = $eachModel->part_number;
            $data[$i]['product_id'] = $eachModel->id;
            $i++;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }

	
	    public function actionGetSampleTrack() {
        $from = $_GET['frm'];
        $searchTerm = $_GET['term'];
        $condition = 'part_number LIKE "%' . $searchTerm . '%"';        
        $model = new Inventory();
        $model = $model->findAll(array('condition' => $condition));
        $i = 0;
        foreach ($model as $eachModel) {
            $data[$i]['value'] = $eachModel->part_number;
            $data[$i]['label'] = $eachModel->part_number;
            $data[$i]['product_id'] = $eachModel->id;
            $i++;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }

    public function actionPrintWarehouseStockReport() {

        $model = new Inventory();
        $part_no = Yii::app()->request->getParam('part_no');
        $brand_id = Yii::app()->request->getParam('brand_id');
        $page_size = Yii::app()->request->getParam('page_size');
        $page_no = Yii::app()->request->getParam('page_no');
        $loc = Yii::app()->request->getParam('loc');
        if ((strlen($loc) > 1) && (!is_numeric($loc[0])) && ($loc != 'null')) {
            $loc = substr($loc, 1);
        }


        if (!is_numeric($page_no)) {
            $page_no = 1;
        } else if ($page_no < 1) {
            $page_no = 1;
        }

        if ($page_size == '' || !is_numeric($page_size)) {
            $page_size = 100;
        }
        $param = array('model' => $model,
            'part_no' => $part_no,
            'brand_id' => $brand_id,
            'page_size' => $page_size,
            'page_no' => $page_no,
            'loc' => $loc,
            'title' => $title);

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->render('//reports/print_warehouse_stock', $param, false, true);
    }

    public function actionPrintWarehouseStockReportPDF() {
        $model = new Inventory();
        $part_no = Yii::app()->request->getParam('part_number');
        $brand_id = Yii::app()->request->getParam('brand_id');
        $page_size = Yii::app()->request->getParam('page_size');
        $page_no = Yii::app()->request->getParam('page_no');
        $loc = Yii::app()->request->getParam('loc');

        $param = array('model' => $model,
            'part_no' => $part_no,
            'brand_id' => $brand_id,
            'page_size' => $page_size,
            'page_no' => $page_no,
            'loc' => $loc,
            'title' => $title);

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.warehouse_stock', $param, true));

        $mPDF1->Output("RackStockReport.pdf", 'I');
    }

    public function actionPrintWarehouseStockReportList() {
       
        $model = new Inventory();
        $part_no = Yii::app()->request->getParam('part_no');
        $brand_id = Yii::app()->request->getParam('brand_id');
        $page_size = Yii::app()->request->getParam('page_size');
        $page_no = Yii::app()->request->getParam('page_no');
        $loc = Yii::app()->request->getParam('loc');
        $j = 1;

        $header = 'No,Part Number,Brand123';
        $model_warehouse = new MasInventoryWarehouse();
        $model_warehouse_param = null;
        if ($loc == '' || $loc == 'null') {
            $model_warehouse_param = array('condition' => 't.isActive="Y"', 'order' => 'warehouse_name asc');
        } else {
            $model_warehouse_param = array('condition' => ' t.id in (' . $loc . ')', 'order' => 'warehouse_name asc');
        }

        $model_warehouse = $model_warehouse->findAll($model_warehouse_param);
        if (!empty($model_warehouse)) {
            foreach ($model_warehouse as $k => $each) {
                $total[$k] = 0;
                $header.=',' . $each->warehouse_name;
                $header.=', Rack';
            }
        }
        $header.=',Total';
        $list[$j++] = $header;
        $toalval = 0;
        $offset = ($page_no - 1) * $page_size;
        $condition = '1=1';
        ;
        if ($part_no != '') {
            $condition .= ' AND t.id="' . $part_no . '"';
        }
        if ($brand_id != '') {
            $condition .= ' AND t.brand_class_id="' . $brand_id . '"';
        }
        $condition .= ' AND t.type="I"';
        $criteria = new CDbCriteria();
        $criteria->condition = $condition;
        $criteria->order = 'part_number asc';
        $item_count = Inventory::model()->count($criteria);

        $model_inventory = Inventory::model()->findAll($criteria);

        foreach ($model_inventory as $i => $model) {
            $line = '';
            $line = ($i + 1) . ',' . $model->part_number . ',' . $model->brand->brand_name;

            if (!empty($model_warehouse)) {
                $toalval = 0;
                foreach ($model_warehouse as $n => $each) {
                    $warehouse_id = $each->id;
                    $location_qty = Yii::app()->db->createCommand('SELECT IFNULL(SUM(quantity),0)  as quantity FROM erp_stock_ledger WHERE warehouse_id = ' . $warehouse_id . ' AND  product_id='.$model->id.' AND stock_updated="Y" GROUP BY warehouse_id')->queryScalar();
                                    /*$location_qty = Yii::app()->db->createCommand('SELECT IFNULL(SUM(quantity),0) FROM erp_product_location_details 
                                                                                            WHERE warehouse_id = ' . $warehouse_id . ' AND 
                                                                                            product_id = ' . $model->id.'
                                                                                            AND isActive="Y"')->queryScalar();*/
                    $total[$n]+=$location_qty;
                    $toalval+=$location_qty;
                    $line .= ',' . number_format($location_qty,2);
                    
                    $SQL = 'SELECT CONCAT(name," : ",SUM(quantity)) AS rack_name FROM `erp_stock_ledger` AS ST INNER JOIN erp_mas_inv_rack AS RA ON rack_id=RA.id WHERE product_id='.$model->id.' AND ST.warehouse_id=' . $warehouse_id . ' AND rack_id>0 GROUP By rack_id';
                    $arr_rack_name = Yii::app()->db->createCommand($SQL)->queryAll();
                    foreach($arr_rack_name as $eachRack){
                        $line .= ',' . $eachRack['rack_name'];
                    }
                    
                    
                }
            }
            $line.=',' . number_format($toalval,2);
            $list[$j++] = $line;
        }

        $file = fopen("uploads/csvs/test.csv", "w");
        foreach ($list as $line) {
            fputcsv($file, explode(',', $line));
        }
        fclose($file);
        $filename = Yii::app()->getBaseUrl(true) . '/uploads/csvs/test.csv';
        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';
        header('Content-Type: application/csv');
        header("Content-disposition: attachment; filename=\"Warehouse_Stock_Report_Horizontal .csv\"");
        readfile($filename);
        Yii::app()->end();
        return;
    }

    public function actionPrintWarehouseVerticalReport() {

        $model = new Inventory();
        $part_no = $_POST['part_no'];
        $brand_id = $_POST['brand_id'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->render('//reports/print_warehouse_vertical', array('model' => $model, 'part_no' => $part_no, 'brand_id' => $brand_id, 'title' => $title), false, true);
    }

    public function actionPrintWarehouseVerticalReportPDF() {

        $model = new Inventory();
        $part_no = Yii::app()->request->getParam('part_no');
        $brand_id = Yii::app()->request->getParam('brand_id');

        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.warehouse_vertical', array('model' => $model, 'part_no' => $part_no, 'warehouse' => $warehouse, 'fromrack' => $fromrack, 'torack' => $torack, 'brand_id' => $brand_id, 'title' => $title), true));

        $mPDF1->Output("WarehouseVerticalReport.pdf", 'I');

//        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
//        $this->render('//reports/print_warehouse_vertical', array('model' => $model,'part_no' => $part_no,'brand_id' => $brand_id,  'title' => $title), false, true);
    }

    public function actionPrintRackStockReport() {

        $model = new Inventory();
        $part_no = Yii::app()->request->getParam('part_no');
        $warehouse = Yii::app()->request->getParam('warehouse');
        $fromrack = Yii::app()->request->getParam('fromrack');
        $torack = Yii::app()->request->getParam('torack');
        $brand_id = Yii::app()->request->getParam('brand_id');
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->render('//reports/print_rack_stock', array('model' => $model, 'part_no' => $part_no, 'warehouse' => $warehouse, 'fromrack' => $fromrack, 'torack' => $torack, 'brand_id' => $brand_id, 'title' => $title), false, true);
    }

    public function actionPrintRackStockReportPDF() {
        $model = new Inventory();

        $part_no = Yii::app()->request->getParam('part_no');
        $warehouse = Yii::app()->request->getParam('warehouse');
        $fromrack = Yii::app()->request->getParam('fromrack');
        $torack = Yii::app()->request->getParam('torack');
        $brand_id = Yii::app()->request->getParam('brand_id');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.print_rack_stock', array('model' => $model, 'part_no' => $part_no, 'warehouse' => $warehouse, 'fromrack' => $fromrack, 'torack' => $torack, 'brand_id' => $brand_id, 'title' => $title), true));

        $mPDF1->Output("RackStockReport.pdf", 'I');
    }

    public function actionExportRackExcel() {
        $model = new Inventory();
        $part_no = $_GET['part_no'];
        $warehouse = $_GET['warehouse'];
        $fromrack = $_GET['rack_fromrack'];
        $torack = $_GET['rack_torack'];
        $brand_id = $_GET['inv_rack_brand_name'];
        $model_location = new ProductLocation();
         $condition = 'quantity >0  '; 
        
        if ($part_no != '') {
            $condition .= ' AND S.part_number LIKE "%' . $part_no . '%" ';
        }
        if ($warehouse > 0) {
            $condition .= ' AND PL.warehouse_id=' . $warehouse;
        }
        if ($fromrack != '') {
            $condition .= ' AND PL.rack_id="'.$fromrack.'"';
        }
        if ($brand_id != '') {
            $condition .= ' AND S.brand_class_id="' . $brand_id . '"';
        }
        $condition .= ' AND S.inventory_item_type="1" AND PL.isActive="Y"';
        
        $sql = 'SELECT S.brand_class_id,S.part_number,S.description,IFNULL(W.warehouse_name,"None") AS warehouse,IFNULL(R.name,"None") AS rack,IFNULL(SUM(PL.quantity),0)AS quantity 
                        FROM erp_product_location_details  PL
                        LEFT JOIN erp_store S
                        ON S.id=PL.product_id
                        LEFT JOIN erp_mas_inv_rack R
                        ON R.id=PL.rack_id
                        LEFT JOIN erp_mas_inv_warehouse W
                        ON W.id=PL.warehouse_id
                        WHERE '.$condition.'
                        GROUP BY PL.warehouse_id,PL.rack_id,PL.product_id
                ';
        $model_location = Yii::app()->db->createCommand($sql)->queryAll();
        $file = fopen("uploads/csvs/rackwise.csv", "w");
        $list = array();
        $list[] = 'No$Product$Brand$Description$Warehouse$Rack$Quantity';
        foreach ($model_location as $i => $eachItem) {
            $brand_id = $eachItem['brand_class_id'];
            $model_brand = ProductClass::model()->findByPk($brand_id);
            $list[] = ($i + 1) . '$' . $eachItem['part_number'] . '$' . $model_brand['product_class'] . '$' . $eachItem['description'] . '$' . $eachItem['warehouse'] . '$' . $eachItem['rack'] . '$' . $eachItem['quantity'];
        }
        foreach ($list as $line) {
            fputcsv($file, explode('$', $line));
        }
        fclose($file);
        $filename = 'uploads/csvs/rackwise.csv';
        $path = 'uploads/csvs';
        header('Content-Type: application/csv');
        header("Content-disposition: attachment; filename=\"rackwise.csv\"");
        readfile($filename);
        Yii::app()->end();
        return;
    }

    public function actionStockStateasof() {

        $model = new Inventory();

        $to_date = Yii::app()->request->getParam('to_date');
        $type = Yii::app()->request->getParam('include_zero');
        $part_no = Yii::app()->request->getParam('part_no');
        $include_zero = Yii::app()->request->getParam('include_zero');
        $brand_id = Yii::app()->request->getParam('brand_id');



        $condition = '1=1';
        $condition1 = '1=1';
        // if($part_no != '' ){
        //     $condition .= ' AND t.part_number LIKE "%'.$part_no.'%"';
        // }

        $condition = '1=1';
        $condition1 = '1=1';
        if ($part_no != '') {

            $condition .= ' AND t.part_number LIKE "%' . $part_no . '%"';
        }
        if ($brand_id != '') {
            $condition .= ' AND t.brand_class_id=' . $brand_id;
        }



        if ($to_date != '') {
            $to_date = str_replace('/', '-', $to_date);
            $to_date = date('Y-m-d', strtotime($to_date));
            $condition1 .= ' AND t.transaction_date <="' . $to_date . '"';
        }
        $model_stock = Store::model()->with('opening')->findAll(array('condition' => $condition, 'order' => 't.part_number'));

        $total_value = 0;
        $list = array();
        $list[] = 'No$Part No$Description$Category$Total Qty$Unit$Rate$Total Value$actual cost';
        foreach ($model_stock as $i => $model) {
            $cur_qty = 0;
            $total = 0;
            $mod_stock_till = new StockLedger();
            $cndn1 = $condition1 . ' AND t.product_id ="' . $model->id . '"';
            $mod_stock_till = StockLedger::model()->with('stock')->find(array('select' => 'SUM(in_qty)-SUM(out_qty) AS net_qty,SUM(in_qty) AS in_qty,SUM(out_qty) AS out_qty', 'condition' => $cndn1, 'group' => 't.product_id', 'order' => 't.transaction_date DESC'));
            $cur_qty = (int) $mod_stock_till->net_qty + $model->opening->opening_quantity;
            $zero_flag = 0;
            // $rate = $model->rate;
            if ($type == 'N') {
                if ($cur_qty == 0) {
                    $zero_flag = 1;
                }
            } else {
                $zero_flag = 0;
            }
            if ($zero_flag == '0') {

                if (empty($mod_stock_till)) {
                    $rate = $model->opening->rate;
                } else {
                    $con_stock = 'product_id = ' . $model->id . ' AND transaction_date <= "' . $to_date . '" ';
                    $stock = StockLedger::model()->find(array('condition' => $con_stock, 'order' => 'transaction_date DESC'));
                    $rate = $stock->cost_rate;
                    $id = $stock->id;
                }
                if (empty($mod_stock_till)) {
                    $total_value = $model->opening->total_value;
                } else {
                    $total_value = ((int) $cur_qty) * $rate;
                }

                $list[] = ($i + 1) . '$' . $model->part_number . '$' . $model->description .'$'. $model->brand_detail->product_class . '$' . $cur_qty . '$' . $model->unit->symbol . '$' . $rate . '$' . $total_value;
            }
        }

        $file = fopen("uploads/csvs/stockstateasof.csv", "w");
        foreach ($list as $line) {
            fputcsv($file, explode('$', $line));
        }

        fclose($file);
        $filename = 'uploads/csvs/stockstateasof.csv';
        $path =  'uploads/csvs';
        header('Content-Type: application/csv');
        header("Content-disposition: attachment; filename=\"stockstateasof.csv\"");
        readfile($filename);
        Yii::app()->end();
        return;
    }

    public function actionPrinttransactiondetails() {
        
        $from_date = Yii::app()->request->getParam('from_date');
        $to_date = Yii::app()->request->getParam('to_date');
        $product_id = (int) Yii::app()->request->getParam('product_id');
        $type = Yii::app()->request->getParam('type');

        $from_date = ( count( explode('/', $from_date) ) == 3 ) ? date('Y-m-d', strtotime( str_replace('/', '-', $from_date) )) : date('Y-m-01');
        $to_date = ( count( explode('/', $to_date) ) == 3 ) ? date('Y-m-d', strtotime( str_replace('/', '-', $to_date) )) : date('Y-m-d');
        
        if( $product_id > 0 ) {

            $stockledger = StockLedger::model()->findAll( array( 'condition' => 'product_id = '.$product_id.' AND transaction_date BETWEEN "'.$from_date.'" AND "'.$to_date.'" ','order'=>'transaction_date','order'=>'transaction_date'   ) );
            $openingStock  = (float) Yii::app()->db->createCommand('SELECT SUM(quantity) AS quantity FROM erp_stock_ledger L WHERE L.product_id='.$product_id.' AND  L.transaction_date < "'.$from_date.'" ')->queryScalar();

            if( $type == 'pdf' ){
                $mpdf = Yii::app()->ePdf->mpdf('', 'A4');
                $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
                $mpdf->WriteHTML($stylesheet, 1);
                $mpdf->WriteHTML($this->renderPartial('application.views.front.reports.pdf.invledger_report', array( 'stockledger' => $stockledger, 'openingStock' => $openingStock, 'from_date' => $from_date, 'to_date' => $to_date, 'product_id' => $product_id ), true));
                $mpdf->Output("invstockledger".date('dmYhis').".pdf", 'I');
            }else{
                $filename = 'transaction_details_'.date('dmYhis').'.xls';
                $data = '<html>
                            <head>
                                <style>
                                    table{
                                        width:100%;
                                    }
                                    .head{
                                        background-color : yellow;
                                        font-weight: bold;
                                        font-size: 14px;
                                    }
                                    .total{
                                        text-align: right;
                                        font-weight: bold;
                                        font-size: 14px;
                                    }
                                </style>
                            </head>
                            <body>
                                <table border=1>
                                    <thead>
                                        <th>No</th>
                                        <th>Date</th> 
                                        <th>Trans.No</th> 
                                        <th>Trans.type</th> 
                                        <th>Warehouse</th>
                                        <th>Rack</th>
                                        <th>Bin</th>
                                        <th>Batch</th>
                                        <th>Serial</th>
                                        <th>Rate</th> 
                                        <th>+</th>
                                        <th>-</th>
                                        <th>Balance</th>
                                    </thead>
                                    <tbody>';
                 $data .= ' <tr>
                                <td colspan="12" class="text-right"> Opening balance</td>
                                <td class="text-center">'.$openingStock.'</td>
                            </tr>';
                
                $balance = $openingStock;
                $total_in = $total_out = 0;

                foreach ( $stockledger as $i => $eachLedger ) { 

                    $in_qty = ( $eachLedger->quantity > 0 ) ? abs($eachLedger->quantity) : '';
                    $out_qty = ( $eachLedger->quantity < 0 ) ? abs($eachLedger->quantity) : '';
                    $balance =  ( $in_qty - $out_qty ) + $balance;

                    $total_in += $in_qty;
                    $total_out += $out_qty;

                   $data .= '<tr>
                        <td> '.($i+1).'</td>
                        <td> '.date('d/m/Y', strtotime($eachLedger->transaction_date)).'</td>
                        <td> '.$eachLedger->header_id.'</td>
                        <td> '.$eachLedger->transaction_type.'</td>
                        <td> '.$eachLedger->warehouse->warehouse_name.'</td>
                        <td> '.$eachLedger->rack->name.'</td>
                        <td> '.$eachLedger->bin->name.'</td>
                        <td> '.$eachLedger->batch_no.'</td>
                        <td> '.$eachLedger->serial_no.'</td>
                        <td> '.$eachLedger->cost_price.'</td>
                        <td class="text-center"> '.$in_qty.'</td>
                        <td class="text-center"> '.$out_qty.' </td>
                        <td class="text-center"> '.$balance.' </td>
                    </tr>';
                
                }

                $data .= '<tr>
                            <td colspan="10" class="text-right">Total</td>
                            <td class="text-right">'.$total_in.'</td>
                            <td class="text-right">'.$total_out.'</td>
                            <td class="text-right">'.$balance.'</td>
                        </tr>';
                            $data .= '      </tbody>
                            </table>
                        </body>
                    </html>';
                
                header ( "Content-type: application/vnd.ms-excel" );
                header ( "Content-Disposition: attachment; filename=\"".$filename."\"" );
                echo $data;
                Yii::app()->end();
                return;
            }
        }else
            echo 'Select Product';
    }
    
     public function actionPrintHiringTransactionLedger() {

        $from_date = $_POST['from_date'];
        $to_date   = $_POST['to_date'];
        $product_id   = $_POST['part_no'];
        $id = $_POST['id'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->render('//reports/print_hiring_transaction_ledger', array('product_id' => $product_id, 'from_date' => $from_date, 'to_date' => $to_date), false, true);
    }
    
    public function actionGetHiringProduct() {
        $from = $_GET['frm'];
        $searchTerm = $_GET['term'];
        $condition = 'hiring_part_number LIKE "%' . $searchTerm . '%" OR description LIKE "%' . $searchTerm . '%"';
        if ($frm == 'changerack'){
            $condition .= ' AND have_expiry_date = "N" AND have_serial_no = "N"';
        }
            
        $model = new Inventory();
        $model = $model->findAll(array('select' => 'id, hiring_part_number, description', 'condition' => $condition, 'limit' => 200));
        $i = 0;
        foreach ($model as $eachModel) {
            $data[$i]['value'] = $eachModel->hiring_part_number;
            $data[$i]['label'] = $eachModel->hiring_part_number.' : '.$eachModel->description;
            $data[$i]['product_id'] = $eachModel->id;
            $i++;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }
    public function actionPrintItemHistory() {
        $from_date = $_POST['from_date'];
        $to_date   = $_POST['to_date'];
        $product_id   = $_POST['product_id'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->render('//reports/print_item_history', array('product_id' => $product_id, 'from_date' => $from_date, 'to_date' => $to_date), false, true);
    }
    /*public function actionPrintHiringTransactionLedgerPDF() {
        
        $from_date = Yii::app()->request->getParam('from_date');
        $to_date = Yii::app()->request->getParam('to_date');
        $product_id = (int) Yii::app()->request->getParam('product_id');

        $from_date = ( count( explode('/', $from_date) ) == 3 ) ? date('Y-m-d', strtotime( str_replace('/', '-', $from_date) )) : date('Y-m-01');
        $to_date = ( count( explode('/', $to_date) ) == 3 ) ? date('Y-m-d', strtotime( str_replace('/', '-', $to_date) )) : date('Y-m-d');

        $param = array(
            'from_date' => $from_date,
            'to_date' => $to_date,
            'product_id' => $product_id
        );

        if( $product_id > 0 ) {
            $mpdf = Yii::app()->ePdf->mpdf('', 'A4');
            $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
            $mpdf->WriteHTML($stylesheet, 1);
            $mpdf->WriteHTML($this->renderPartial('application.views.front.reports.pdf.hiring_transaction_ledger', $param, true));
            $mpdf->Output("HiringTransactionLedger".date('dmYhis').".pdf", 'I');
        }else
            echo 'Select Product';
    }
    public function actionPrintHiringTransactionLedgerExcel() {
        $from_date = Yii::app()->request->getParam('from_date');
        $to_date = Yii::app()->request->getParam('to_date');
        $product_id = (int) Yii::app()->request->getParam('product_id');

        $from_date = ( count( explode('/', $from_date) ) == 3 ) ? date('Y-m-d', strtotime( str_replace('/', '-', $from_date) )) : date('Y-m-01');
        $to_date = ( count( explode('/', $to_date) ) == 3 ) ? date('Y-m-d', strtotime( str_replace('/', '-', $to_date) )) : date('Y-m-d');
        if( $product_id > 0 ) {
            $filename = 'hiringledger'.date('dmYhis').'.xls';
            $data = '<html>
                        <head>
                            <style>
                                table{
                                    width:100%;
                                }
                                .head{
                                    background-color : yellow;
                                    font-weight: bold;
                                    font-size: 14px;
                                }
                                .total{
                                    text-align: right;
                                    font-weight: bold;
                                    font-size: 14px;
                                }
                            </style>
                        </head>
                        <body>
                            <table border=1>
                                <thead>
                                        <th>No</th>
                                        <th>Tran.Date</th>
                                        <th>Tran.No</th>
                                        <th>Tran.Type</th>
                                        <th>Reference</th>
                                        <th>Rate</th> 
                                        <th>+</th>
                                        <th>-</th> 
                                        <th>Balance</th> 
                                </thead>
                                <tbody>';
                $allstockItems = Yii::app()->db->createCommand('SELECT * FROM view_hiring_ledger_summary WHERE product_id='.$product_id.' AND transaction_date BETWEEN "'.$from_date.'" AND "'.$to_date.'" ORDER BY transaction_date,id ASC')->queryAll();
                $openingStock  = (float) Yii::app()->db->createCommand('SELECT SUM(quantity) AS quantity FROM erp_stock_ledger_hiring L WHERE L.product_id='.$product_id.' AND  L.transaction_date < "'.$from_date.'" ')->queryScalar();
                $balance = $openingStock;
                $total_in = $total_out = 0;

                $data .= '  <tr>
                                <td colspan="8" class="text-right"> Opening balance</td>
                                <td class="text-center">'.$openingStock.'</td>
                            </tr>';
                foreach ( $allstockItems as $i => $model)  {
                    
                    $reference = array( 
                            'HIRING_TRANSFER_IN' => InventoryHiringTransfer ::model()->findBypk($model['header_id'])->reference,
                            'HIRING_TRANSFER_OUT' =>  InventoryHiringTransfer ::model()->findBypk($model['header_id'])->reference,
                        );

                    $in_qty = ( $model['summary_qty'] > 0 ) ? abs($model['summary_qty']) : '';
                    $out_qty = ( $model['summary_qty'] < 0 ) ? abs($model['summary_qty']) : '';
                    $balance =  ( $in_qty - $out_qty ) + $balance;

                    $total_in += $in_qty;
                    $total_out += $out_qty;

                    $data .= '<tr>
                                <td> '.($i+1).'</td>
                                <td> '.date('d/m/Y', strtotime($model['transaction_date'])).'</td>
                                <td> '.$model['header_id'].'</td>
                                <td> '.$model['transaction_type'].'</td>
                                <td> '.$reference[$model['transaction_type']].'</td>
                                <td> '.$model['cost_price'].'</td>
                                <td class="text-center"> '.$in_qty.'</td>
                                <td class="text-center"> '.$out_qty.' </td>
                                <td class="text-center"> '.$balance.' </td>
                            </tr>';
                }

                $data .= ' <tr>
                                <td colspan="6"></td>
                                <td  class="text-center">'.Yii::app()->numberFormatter->formatCurrency($total_in, " ").'</td>
                                <td  class="text-center">'.Yii::app()->numberFormatter->formatCurrency($total_out, " ").'</td>
                                <td  class="text-center">'.Yii::app()->numberFormatter->formatCurrency($balance, " ").'</td>
                            </tr>';

                $data .= '      </tbody>
                                </table>
                            </body>
                        </html>';
                
                    header ( "Content-type: application/vnd.ms-excel" );
                    header ( "Content-Disposition: attachment; filename=\"".$filename."\"" );
                    echo $data;
                    Yii::app()->end();
                    return;
        }else{
            echo 'select product';
        }
    }*/


}
