<?php

class ExcelController extends Controller {

    public function accessRules() {

        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'PrintEmployeeAttendanceExcel',
                    'printWorkingHoursdailyExcel', 'printWorkingHoursweeklyExcel',
                    'printWorkingHoursMonthlyExcel', 'PrintLeavelistExcel', 'PrintLeavehistoryExcel',
                    'PrintEmployeeListExcel', 'PrintEmployeeblockListExcel',
                    'PrintEmployeedepartmentListExcel', 'PrintEmployeedocumentListExcel',
                    'PrintEmployeesalaryExcel', 'PrintEmployeedesignationListExcel',
                    'PrintEmployeeExpiredDocumentExcel', 'PrintEmployeeAssetlistExcel',
                    'PrintEmployeeLoanExcel', 'PrintEmployeeTicketExcel', 'PrintEmployeeGratuityExcel',
                    'PrintEmployeeLeaveSettlementExcel', 'PrintEmployeeNewHirelistExcel', 'PrintEmployeeEOSExcel', 
                    'PrintBranchListExcel', 'PrintInOutExcel', 'PrintSalaryBeforeLockExcel', 'PrintPrintSalarySlipExcel', 
                    'PrintSalarySlipExcel', 'PrintSalaryIncrementExcel', 'PrintOvertimelistExcel', 'PrintSalaryBeforeExcel', 'PrintEmployeeYearlyAttendanceExcel',
                    'PrintMonthlyAttendanceReport', 'PrintLeaveLedgerExcel','Printexcelbranchdetail','excelleaveyeardetails',
                    'excelLeaveBalance','PrintAdvanceExcel','PrintOrderAnnexureReportExcel','PrintTrainingExcel','PrintDirectTransferReportExcel','PrintInventoryItemCustomerReportExcel','PrintCustomerProductStockTransactionExcel'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionPrintEmployeeAttendanceExcel() {
        $from_date = $_GET['from_date'];
        $to_date = $_GET['to_date'];
        $emp_id = $_GET['emp_id'];
        $attend_emp_sponsor = $_GET['attend_emp_sponsor'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'list_employee_attendence.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_employeeattendence_excel', array('from_date' => $from_date, 'to_date' => $to_date, 'emp_id' => $emp_id, 'attend_emp_sponsor' => $attend_emp_sponsor), false, true);
        Yii::app()->end();
    }

    public function actionPrintEmployeeYearlyAttendanceExcel() {
        $leavetype = $_GET['leavetype'];
        $year = $_GET['year'];
        $employee_id = $_GET['employee_id'];
        $branch_id = $_GET['branch_id'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'list_employee_attendence.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_leave_yearly_excel', array('leavetype' => $leavetype, 'year' => $year, 'employee_id' => $employee_id, 'branch_id' => $branch_id), false, true);
        Yii::app()->end();
    }

   public function actionprintWorkingHoursdailyExcel() {
        $branch_id = $_GET['branch_id'];
        $month = $_GET['month'];
        $year = $_GET['year'];
        $employee_id = $_GET['employee_id'];
        $working_report_type = $_GET['working_report_type'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'list_employee_workingHours.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_employeeworkinhHoursdaily_excel', array('year'=>$year,'branch_id' => $branch_id, 'month' => $month, 'employee_id' => $employee_id, 'working_report_type' => $working_report_type), false, true);
        Yii::app()->end();
    }

    public function actionprintWorkingHoursweeklyExcel() {
        $branch_id = $_GET['branch_id'];
        $month = $_GET['month'];
        $year = $_GET['year'];
        $employee_id = $_GET['employee_id'];
        $working_report_type = $_GET['working_report_type'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'list_employee_workingHours.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_employeeworkinhHoursweekly_excel', array('year'=>$year,'branch_id' => $branch_id, 'month' => $month, 'employee_id' => $employee_id, 'working_report_type' => $working_report_type), false, true);
        Yii::app()->end();
    }

    public function actionprintWorkingHoursMonthlyExcel() {
        $branch_id = $_GET['branch_id'];
        $month = $_GET['month'];
        $year = $_GET['year'];
        $employee_id = $_GET['employee_id'];
        $working_report_type = $_GET['working_report_type'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'list_employee_workingHours.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_employeeworkingHoursmonthly_excel', array('year'=>$year,'branch_id' => $branch_id, 'month' => $month, 'employee_id' => $employee_id, 'working_report_type' => $working_report_type), false, true);
        Yii::app()->end();
    }

    public function actionPrintLeavelistExcel() {
        $branch_id = $_GET['branch_id'];
        $leave_name = $_GET['leave_name'];
        $employee_id = $_GET['employee_id'];
        $from_date = $_GET['from_date'];
        $to_date = $_GET['to_date'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'employee_leavelist.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_employeeleavelist_excel', array('branch_id' => $branch_id, 'leave_name' => $leave_name, 'employee_id' => $employee_id, 'from_date' => $from_date, 'to_date' => $to_date), false, true);
        Yii::app()->end();
    }

    public function actionPrintLeavehistoryExcel() {
        $leave_id = $_GET['leave_id'];
        $employee_id = $_GET['employee_id'];
        $from_date = $_GET['from_date'];
        $to_date = $_GET['to_date'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'employee_leavehistory.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_employeeleavehistory_excel', array('leave_id' => $leave_id, 'employee_id' => $employee_id, 'from_date' => $from_date, 'to_date' => $to_date), false, true);
        Yii::app()->end();
    }

    public function actionPrintEmployeeListExcel() {
        $Branch = $_GET['Branch'];
        $employee_id = $_GET['employee_id'];
        $department_id = $_GET['department_id'];
        $designation_id = $_GET['designation_id'];
        $reportmanager_id = $_GET['reportmanager_id'];
        $status= $_GET['status'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'employeelist.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_employeelist_excel', array('Branch' => $Branch, 'employee_id' => $employee_id,'department_id' => $department_id,'designation_id' => $designation_id,'reportmanager_id' => $reportmanager_id,'status'=>$status), false, true);
        Yii::app()->end();
    }

    public function actionPrintEmployeeblockListExcel() {
        $Branch = $_GET['Branch'];
        $employee_id = $_GET['employee_id'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'employeeblocklist.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_employeeblocklist_excel', array('Branch' => $Branch, 'employee_id' => $employee_id), false, true);
        Yii::app()->end();
    }

    public function actionPrintEmployeedepartmentListExcel() {
        $Branch = $_GET['Branch'];
        $employee_id = $_GET['employee_id'];
        $department_name = $_GET['department_name'];
        $reportman_id = $_GET['reportman_id'];
        
       // echo "ok".$reportman_id;
       // die();
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'employee_department_list.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_employeedepartmentlist_excel', array('Branch' => $Branch, 'employee_id' => $employee_id, 'department_name' => $department_name,'reportman_id'=>$reportman_id), false, true);
        Yii::app()->end();
    }

    public function actionPrintEmployeedocumentListExcel() {
        $employee_id = $_GET['employee_id'];
        $document_id = $_GET['document_id'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'employee_docuemnt_list.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_employeedocumentlist_excel', array('document_id' => $document_id, 'employee_id' => $employee_id), false, true);
        Yii::app()->end();
    }

    public function actionPrintEmployeedesignationListExcel() {
        $Branch = $_GET['Branch'];
        $employee_id = $_GET['employee_id'];
        $designation_name = $_GET['designation_name'];
        $report_id = $_GET['report_id'];
       // echo "ok".$report_id;
       // die();
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'employee_designation_list.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_employeedesignationlist_excel', array('Branch' => $Branch, 'employee_id' => $employee_id, 'designation_name' => $designation_name,'report_id'=>$report_id), false, true);
        Yii::app()->end();
    }

    public function actionPrintEmployeeExpiredDocumentExcel() {
        $document_id = $_GET['document_id'];
        $employee_id = $_GET['employee_id'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'employee_documnt_Expired.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_employeeExpireddocument_excel', array('document_id' => $document_id, 'employee_id' => $employee_id), false, true);
        Yii::app()->end();
    }

    public function actionPrintEmployeeAssetlistExcel() {
        $branch_id = $_GET['branch_id'];
        $employee_id = $_GET['employee_id'];
        $status = $_GET['status'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'employee_assetlist.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_employeeAssetlist_excel', array('branch_id' => $branch_id, 'employee_id' => $employee_id, 'status' => $status), false, true);
        Yii::app()->end();
    }

    public function actionPrintEmployeesalaryExcel() {
        $branch_id = $_GET['branch_id'];
        $employee_id = $_GET['employee_id'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'employee_salary.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_employeeSalarylist_excel', array('branch_id' => $branch_id, 'employee_id' => $employee_id), false, true);
        Yii::app()->end();
    }

    public function actionPrintEmployeeLoanExcel() {
        $branch_id = $_GET['branch_id'];
        $employee_id = $_GET['employee_id'];
        $status= $_GET['status'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'employee_loan.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_employeeloan_excel', array('branch_id' => $branch_id, 'employee_id' => $employee_id, 'status' => $status), false, true);
        Yii::app()->end();
    }

    public function actionPrintEmployeeTicketExcel() {
        $employee_id = $_GET['employee_id'];
        $year = $_GET['year'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'employee_ticket.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_employeeticket_excel', array('employee_id' => $employee_id,'year'=>$year), false, true);
        Yii::app()->end();
    }

    public function actionPrintEmployeeGratuityExcel() {

        $employee_id = $_GET['employee_id'];

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'employee_gratuity.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_employeegratuity_excel', array('employee_id' => $employee_id), false, true);
        Yii::app()->end();
    }

    public function actionPrintEmployeeLeaveSettlementExcel() {
        $employee_id = $_GET['employee_id'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'employee_leavesettlement.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_employeeleave_settlement_excel', array('employee_id' => $employee_id), false, true);
        Yii::app()->end();
    }

    public function actionPrintSalaryBeforeExcel() {
        $sponser_id = $_GET['sponser_id'];
        $year = $_GET['year'];
        $month = $_GET['month'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'salarydetails.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('Print_salary_before_excel', array('sponser_id' => $sponser_id, 'year' => $year, 'month' => $month), false, true);
        Yii::app()->end();
    }

    public function actionPrintEmployeeNewHirelistExcel() {
        $branch_id = $_GET['branch_id'];
        $from_date = $_GET['from_date'];
        $department = $_GET['department'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'employee_NewHirelist.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_employeeNewHirelist_excel', array('branch_id' => $branch_id,'department' => $department,'from_date'=>$from_date), false, true);
        Yii::app()->end();
    }
    public function actionPrintEmployeeEOSExcel() {
        $employee_id = $_GET['employee_id'];
        $branch_id = $_GET['branch_id'];
        $department_name = $_GET['department_name'];
        $designation_name = $_GET['designation_name'];
        $from_date = $_GET['from_date'];
        $to_date = $_GET['to_date'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'employee_EOSlist.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_employeeEOS_excel', array('employee_id' => $employee_id, 'branch_id' => $branch_id, 'department_name' => $department_name, 'designation_name' => $designation_name, 'from_date' => $from_date, 'to_date' => $to_date), false, true);
        Yii::app()->end();
    }

    public function actionPrintSalaryBeforeLockExcel() {
        $branch = $_GET['branch'];
        $month = $_GET['month'];
        $year = $_GET['year'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'salary_before.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_salaryBeforelock_excel', array('branch' => $branch, 'month' => $month, 'year' => $year), false, true);
        Yii::app()->end();
    }

    public function actionPrintSalarySlipExcel() {
        $branch = $_GET['branch'];
        $month = $_GET['month'];
        $year = $_GET['year'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'salary_slip.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_salaryslip_excel', array('branch' => $branch, 'month' => $month, 'year' => $year), false, true);
        Yii::app()->end();
    }

    public function actionPrintSalaryIncrementExcel() {
        $branch = $_GET['branch'];
        $month = $_GET['month'];
        $salary_type = $_GET['salary_type'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'salary_increment.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_salaryincrement_excel', array('branch' => $branch, 'month' => $month, 'salary_type' => $salary_type), false, true);
        Yii::app()->end();
    }

    public function actionPrintBranchListExcel() {
        $branchname = $_GET['branchname'];
        $location = $_GET['location'];
        $currency = $_GET['currency'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'employee_Branchlist.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_branchlist_excel', array('branchname' => $branchname, 'location' => $location, 'currency' => $currency), false, true);
        Yii::app()->end();
    }

    public function actionPrintOvertimelistExcel() {
        $overtime_from_date = $_GET['overtime_from_date'];
        $overtime_to_date = $_GET['overtime_to_date'];
        $emp_id = $_GET['emp_id'];
        $overtime_emp_sponsor = $_GET['overtime_emp_sponsor'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'employee_overtimelist.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_overtimelist_excel', array('overtime_from_date' => $overtime_from_date, 'overtime_to_date' => $overtime_to_date, 'emp_id' => $emp_id, 'overtime_emp_sponsor' => $overtime_emp_sponsor), false, true);
        Yii::app()->end();
    }

    public function actionPrintInOutExcel() {
        $employee_id = $_GET['employee_id'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'In_Out.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_inoutdocument_excel', array('employee_id' => $employee_id), false, true);
        Yii::app()->end();
    }

    public function actionPrintMonthlyAttendanceReport() {
        $attend_emp_sponsor = $_POST['branch_id'];
        $month = $_POST['month'];
        $year = $_POST['year'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'In_Out.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('//hrreports/print_employee_monthly_attendance_list', array('model' => $model, 'year' => $year, 'month' => $month, 'attend_emp_sponsor' => $attend_emp_sponsor, 'title' => $title), false, true);
        Yii::app()->end();
    }

    public function actionPrintLeaveLedgerExcel() {
        $employee_id = $_GET['employee_id'];
        $year = $_GET['year'];
        $leavetype = $_GET['leavetype'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'LeaveLedger.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('//excel/print_leaveledgerlist_excel', array('employee_id' => $employee_id, 'year' => $year, 'leavetype' => $leavetype, 'title' => $title), false, true);
        Yii::app()->end();
    }
    public function actionPrintexcelbranchdetail() {
        $branch = $_GET['branch'];
        $employee_id = $_GET['employee_id'];
        $date_from = $_GET['date_from'];
        $date_to = $_GET['date_to'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'employee_branchdetails.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_employeebranch_excel', array('branch'=>$branch,'employee_id' => $employee_id,'date_from'=>$date_from,'date_to'=>$date_to), false, true);
        Yii::app()->end();
    }
    public function actionExcelleaveyeardetails() {
        $employee_id = $_GET['employee_id'];
        $year = $_GET['year'];
        $leavetype = $_GET['leavetype'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'LeaveDetails.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('//excel/print_leavedetails_excel', array('employee_id' => $employee_id, 'year' => $year, 'leavetype' => $leavetype, 'title' => $title), false, true);
        Yii::app()->end();
    }
    public function actionExcelLeaveBalance() {
        $employee_id = $_GET['employee_id'];
        $branch_id = $_GET['branch_id'];
        $leavetype = $_GET['leave_name'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'Leavebalance.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('//excel/print_leavebalance_excel', array('employee_id' => $employee_id, 'branch_id' => $branch_id, 'leavetype' => $leavetype, 'title' => $title), false, true);
        Yii::app()->end();
    }
    public function actionPrintAdvanceExcel() {
        $employee_id = $_GET['employee_id'];
        $branch_id = $_GET['branch_id'];
        $status= $_GET['status'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'Salaryadvance.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('//excel/print_advance_excel', array('employee_id' => $employee_id, 'branch_id' => $branch_id, 'status' => $status, 'title' => $title), false, true);
        Yii::app()->end();
    }
    
     public function actionPrintOrderAnnexureReportExcel() {
        $id = $_GET['id'];
       
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'order_annexure.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('//excel/order_annexure_individual_excel', array('id' => $id, 'status' => $status, 'title' => $title), false, true);
        Yii::app()->end();
    }
    public function actionPrintTrainingExcel() {
        $employee_id = $_GET['employee_id'];
        $course_id = $_GET['course_id'];
        $type= $_GET['type'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'Training List.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        if($type=='T'){
            $this->renderPartial('//excel/print_training_excel', array('course_id' => $course_id), false, true);
        }else{
            $this->renderPartial('//excel/print_competency_excel', array('employee_id' => $employee_id,'course_id' => $course_id), false, true);
        }
        Yii::app()->end();
    }
    
    public function actionPrintDirectTransferReportExcel()
    {
        $model = new InventoryDirectTransfer();

        $from_warehouse = Yii::app()->request->getParam('from_warehouse');

        $to_warehouse = Yii::app()->request->getParam('to_warehouse');

        $transfer_from_date = Yii::app()->request->getParam('transfer_from_date');

        $transfer_to_date = Yii::app()->request->getParam('transfer_to_date');

        $transfer_no = Yii::app()->request->getParam('transfer_no');
        
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'Direct Transfer List.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('//excel/print_direct_transfer_excel', array('employee_id' => $employee_id,'course_id' => $course_id), false, true);
        Yii::app()->end();
    }
    
    public function actionPrintInventoryItemCustomerReportExcel()
    {
        $model          = new Inventory();
        $customer_id    = $_GET['customer_id'];
        $ware_house_id  = $_GET['ware_house_id'];
        $rack_id        = $_GET['rack_id'];
        $bin_id         = $_GET['bin_id'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'Inventory_Customer_List.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_inventory_customer_excel',array('customer_id'=>$customer_id,'ware_house_id'=>$ware_house_id,'rack_id'=>$rack_id,'bin_id'=>$bin_id));
        Yii::app()->end();
    }
    
    public function actionPrintCustomerProductStockTransactionExcel()
    {
        $model          = new Inventory();
        $customer_id    = $_GET['customer_id'];
        $product_id     = $_GET['product_id'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'Inventory_Customer_Stock_Transaction_List.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('//excel/print_inventory_customer_stock_transaction_excel',array('customer_id'=>$customer_id,'product_id'=>$product_id));
        Yii::app()->end();
    }
    
}
