<?php
class DisputeController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),//,'temp_form','CompanyFieldDetails'
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index','GetList', 'Create','Save'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    /**
     * This is the default 'index' action that is invoked
     * when an action is not explicitly requested by users.
     * //modified by jisha on 15-9-18.
     */
    public function actionIndex() {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('index');
    }
    
    public function actionGetList() {
        $model  = new Dispute();
         //filter
        $filter_task_no         = $_POST['filter_task_no'];
        $filter_customer        = $_POST['filter_customer'];
        $filter_job_order       = $_POST['filter_job_order'];
        $filter_dispute_type    = $_POST['filter_dispute_type'];
        $filter_dispute_status  = $_POST['filter_dispute_status'];
        $filter_notes           = $_POST['filter_notes'];
        
        $draw   = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 'customer_name',
           
        );
        $filterColumn   = $columns[$_POST['order'][0]['column']];
        $filterOrder    = $_POST['order'][0]['dir'];
        $orderBy        = $filterColumn . " " . $filterOrder;
        $condition      = '1=1';
        
        if(!empty($filter_customer)){
                $condition.= ' AND customer_name LIKE"%'.$filter_customer.'%"';
        }
        
        if(!empty($filter_task_no)){
            $condition.= ' AND t.id LIKE"%'.$filter_task_no.'%"';
        }
        
        if(!empty($filter_job_order)){
                $condition.= ' AND job_order_id LIKE"%'.$filter_job_order.'%"';
        }
        
        if((int) $filter_dispute_type >0){
            $condition.= ' AND t.type="'.$filter_dispute_type.'"';
        }
        
        if((int) $filter_dispute_status >0){
            $condition.= ' AND t.status="'.$filter_dispute_status.'"';
        }
        
        if(!empty($filter_notes)){
            $condition.= ' AND t.notes LIKE "%'.$filter_notes.'%"';
        }
        
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition.=" AND (customer_name LIKE '%" . $searchString . "%' OR  t.id LIKE '%" . $searchString . "%' OR job_order_id LIKE '%" . $searchString . "%')";
        }
       
        $count          = $model->with('customer')->count(array('condition' => $condition));
        $model          = $model->with('customer')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 't.id DESC'));
        $recordsTotal   = $count;
        $recordsFiltered        = $count;
        $data['draw']   = $draw;
        $data['recordsTotal']   = $recordsTotal;
        $data['recordsFiltered']= $recordsFiltered;
        $rowData                = array();
        $current                = strtotime(date('y-m-d'));
        $m=1;
        foreach ($model as $row)
        {
            $rowData[]  = array($m,$row['id'], $row['customer']['customer_name'],date("d/m/Y",strtotime($row['dispute_date'])),$row['job_order_id'],$row['disputetype']['dispute_type'],$row['disputestatus']['dispute_status'],$row['notes'],$row['customer_id']);
            $m++;
        } 
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    /*
     * function to create customer details
     * modified by jisha on 15-9-18. 
     */

    public function actionCreate() {
        $model = new Dispute();
       
        $id = (int) Yii::app()->request->getParam('id');
        
        
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
        $this->render('create', array('model' => $model));
    }
    
    public function actionSave() {
        $model = new Dispute();
       
        $id = (int) $_POST['Dispute']['id'];
        if ($id > 0) {
            $model = $model->findByPk($id);
            $model->updated_by          = Yii::app()->user->id;
            $model->created_date_time   = date("Y-m-d H:i:s");
            
        }
        else{
             $model->created_by          = Yii::app()->user->id;
             $model->updated_date_time   = date("Y-m-d H:i:s");
        }
        
        $model->attributes = $_POST['Dispute'];
        if($_POST['Dispute']['dispute_date']!=''){
            $model->dispute_date = str_replace('/', '-', $_POST['Dispute']['dispute_date']);
            $model->dispute_date= date("Y-m-d", strtotime($model->dispute_date));
        }
        if($model->validate()){
            $model->save(false);
            echo CJSON::encode( array('status' => 'success') );
        }
        else{
            $error = CActiveForm::validate($model, '', false);
            if ($error != '[]') {
                echo $error;
            }
        }
       
    }
    
}
?>