<?php

class CustomerinfoController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'), //,'temp_form','CompanyFieldDetails'
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('info', 'invoiceList', 'getorderlist', 'GetQuotationsList', 'Getmaterial', 'GetmaterialYearWise', 'GetmaterialYearMonthWise'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionInfo() {
        $this->renderPartial('info', $_POST);
    }

    public function actionInvoiceList() {

        $model = new Invoice();
        $customer_id = $_POST['id'];
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
// datatable column index  => database column name
            0 => 't.file_id',
            1 => 't.invoice_no',
            2 => 't.id',
            3 => 't.order_id',
            4 => 't.invoice_date',
            5 => 'customer.',
            6 => 'leadowner.first_name',
            7 => 'currencyname.currency_code',
            8 => 't.total_tax_amount',
            9 => 't.grand_total',
            10 => 'file.status',
            11 => 't.id',
            12 => 't.id'
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
//$orderBy = 't.id DESC';
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.isActive="Y"  AND  customer.id = ' . $customer_id;
        if (!isset(Yii::app()->user->havePermissionOn["invoice_view_all"]) && Yii::app()->user->authorised_user != 1) {
            $condition .= ' AND (t.lead_owner_id= "' . Yii::app()->user->id . '" OR file.lead_owner_id="' . Yii::app()->user->id . '")';
        }
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " AND ( t.invoice_no LIKE '%" . $searchString . "%' OR customer.customer_name LIKE '%" . $searchString . "%' OR file.file_title LIKE '%" . $searchString . "%' OR t.file_id LIKE '%" . $searchString . "%' OR t.order_id LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('customer', 'file', 'leadowner', 'currencyname')->count(array('condition' => $condition));
        $model = $model->with('customer', 'file')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 't.id DESC'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $status = '';
        foreach ($model as $row) {
            $div = '';
            if ((Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["invoice_print"]))) {
                $div .= '<a class="btn btn-primary btn-xs" title="Print PDF" target="_blank" href="?r=invoice/PrintInvoiceReportPDF&id=' . $row['id'] . '&c_id=' . $row['crm_user_id'] . '&frm=tax"><i class="fa fa-file-pdf-o"></i></a>';
            }

            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["customer_activity"])) {
                $div .= ' <button class="btn btn-primary btn-xs" title ="Edit Activity" onclick="loadPopupModal(\'activity/create&customer_id=' . $row['customer']['id'] . '\',\'' . $row['customer']['id'] . ' : ' . $row['customer']['customer_name'] . ' - Activities ' . '\',\'lg\')"><i class="fa fa-certificate"></i></button>';
            }
            $creditnote = Creditnote::model()->find(array('condition' => 'invoice_id = ' . $row['id']));
            ( $creditnote->id > 0 ) ? $cn_state = 'Yes' : $cn_state = 'No';

            $rowData[] = array($row['file_id'], $row['id'], $row['order_id'], date("d/m/Y", strtotime($row['invoice_date'])), $row->leadowner->fullname, $row['currencyname']['currency_code'], Yii::app()->numberFormatter->formatCurrency($row['grand_total'], ""), /* $row['file']['status'], */ $cn_state, $row['id'], $row['customer']['id'], $row['crm_user_id']);
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionGetOrderList() {
        $customer_id = $_POST['id'];
        $model = new JobOrder();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
// datatable column index  => database column name
            0 => 't.file_id',
            1 => 't.id',
            2 => 'leadowner.first_name',
            3 => 't.job_date',
            4 => 't.job_awb_no',
            5 => 'currency.currency_code',
            6 => 't.selling_price',
            7 => 't.job_order_status',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.isActive="Y" AND job_order_status!="C" AND job_order_status!="CN" AND customer_id =' . $customer_id;

        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $condition = 't.isActive="Y"';
            $searchString = $_POST['search']['value'];

            $condition .= " AND ( t.total_tax_amount LIKE '%" . $searchString . "%' OR t.grand_total LIKE '%" . $searchString . "%'" . $searchString . "%' OR leadowner.first_name LIKE '%" . $searchString . "%' OR leadowner.last_name LIKE '%" . $searchString . "%' OR t.file_id LIKE '%" . $searchString . "%' OR t.id LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('leadowner')->count(array('condition' => $condition));
        $model = $model->with('leadowner')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 't.id desc'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();

        foreach ($model as $s => $row) {
            
             switch($row['job_order_status']){
                    case 'PD':
                        $row_job_order_status="Partially Delivered";
                        break;
                    case 'D':
                        $row_job_order_status="Delivered";
                        break;
                    case 'C':
                        $row_job_order_status="Completed";
                        break;
                    case 'I':
                        $row_job_order_status="Invoiced";
                        break;
                    case 'CN':
                        $row_job_order_status="Cancel";
                        break;
                    default:
                        $row_job_order_status="Open";
                        break;
                }
           
            $rowData[] = array($row['file_id'], $row['id'], $row['leadowner']['first_name'] . " " . $row['leadowner']['last_name'], date("d/m/Y", strtotime($row['job_date'])), $row['job_awb_no'],$row['currency']['currency_code'],Yii::app()->numberFormatter->formatCurrency(($row['selling_price']), ""), $row_job_order_status);
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionGetQuotationsList() {
        $model = new Quotation();
        $customer_id = $_POST['id'];
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
// datatable column index  => database column name
            1 => 'file_id',
            2 => 't.id',
            3 => 'customer.',
            4 => 't.qtn_date',
            5 => 't.qtn_validity',
            6 => 'currencyname.currency_code',
            7 => 't.grand_total',
            8 => 't.status',
            9 => 'file.current_process_status',
            10 => 't.approve_level'
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.isActive="Y" AND t.quotation_status!="CA"  AND t.quotation_status!="CL" AND customer_id = ' . $customer_id;

        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $condition = 't.isActive="Y" ';
            $searchString = $_POST['search']['value'];
            $condition .= " AND (t.file_id LIKE '%" . $searchString . "%' OR t.id LIKE '%" . $searchString . "%' OR leadowner.first_name LIKE '%" . $searchString . "%' OR leadowner.last_name LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('leadowner')->count(array('condition' => $condition));
        $model = $model->with('leadowner')->findAll(array('condition' => $condition, 'order' => 't.id desc', 'limit' => $limit, 'offset' => $offset));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();

        foreach ($model as $row) {
            
             switch($row['quotation_status']){
                    
                    case 'CL':
                        $row_quotation_status="Closed";
                        break;
                    case 'A':
                        $row_quotation_status="Awaiting";
                        break;
                    case 'CO':
                        $row_quotation_status="Confirmed";
                        break;
                        break;
                    case 'CA':
                        $row_quotation_status="Cancel";
                        break;
                    default:
                        $row_quotation_status="Open";
                        break;
                }
           
            $rowData[] = array($row['file_id'], $row['id'], $row['leadowner']['first_name'] . " " . $row['leadowner']['last_name'], date("d/m/Y", strtotime($row['quotation_date'])), $row['job_order_id'],$row['currency']['currency_code'],Yii::app()->numberFormatter->formatCurrency(($row['selling_price']), ""), $row_quotation_status);
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionGetmaterial() {
        $customer_id = $_POST['id'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $sql = "SELECT
                        erp_store.part_number,
                        erp_store.description,
                        SUM(erp_stock_ledger.quantity) as qty, 
                         AVG(cost_price) as cost_price,
                        SUM(
                            erp_stock_ledger.quantity * erp_stock_ledger.sales_price
                        ) as price
                    FROM
                        `erp_stock_ledger`
                    JOIN erp_store ON(
                            erp_store.id = erp_stock_ledger.product_id
                        )
                    WHERE
                        `customer_vendor_id` = " . $customer_id . "
                    GROUP BY         
                            erp_store.part_number,
                        erp_store.description
            ORDER BY
                erp_store.part_number ASC  
           LIMIT " . $limit . " OFFSET " . $offset;
        $sql_count = "SELECT COUNT(*) from (SELECT
                        erp_store.part_number,
                        erp_store.description,
                        SUM(erp_stock_ledger.quantity),
                        AVG(cost_price),
                        SUM(
                            erp_stock_ledger.quantity * erp_stock_ledger.sales_price
                        )
                    FROM
                        `erp_stock_ledger`
                    JOIN erp_store ON(
                            erp_store.id = erp_stock_ledger.product_id
                        )
                        
                    WHERE
                        `customer_vendor_id` =" . $customer_id . "
                 GROUP BY         
                            erp_store.part_number,
                        erp_store.description
               ) as tbl ";
        $recordsTotal = Yii::app()->db->createCommand($sql_count)->queryScalar();
        $data_invoce = Yii::app()->db->createCommand($sql)->queryAll();

        $data['draw'] = $draw;
        $rowData = array();
        foreach ($data_invoce as $value) {
            $qty = abs($value['qty']);
            $price = abs($value['price']);
            $rate = $price / $qty;
            $cost_price = $value['cost_price'];
            $profit = $price - ($cost_price * $qty);
            $profit_percentage = "  -  ";
            if ($cost_price > 0) {
                $profit_percentage = (($rate - $cost_price) * 100) / ($cost_price);
            }
            $rowData[] = array(
                $value['part_number'], $value['description'], "Invoice", number_format($cost_price, 2), number_format(abs($value['qty']), 2), number_format($rate, 2), number_format(abs($value['price']), 2), number_format($profit, 2), number_format($profit_percentage, 2)
            );
        }
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsTotal;
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionGetmaterialYearWise() {
        $end_year = Yii::app()->request->getParam('end_year');
        $start_year = Yii::app()->request->getParam('start_year');
        $customer_id = Yii::app()->request->getParam('id');
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $where = "`customer_vendor_id` =" . $customer_id;
        $inner_sql = "SELECT erp_stock_ledger.product_id  FROM `erp_stock_ledger`  WHERE " . $where . " GROUP BY product_id ";
        $sql_count = "SELECT COUNT(*) from ( " . $inner_sql . ") as tbl ";
        $inner_sql = $inner_sql . " LIMIT " . $limit . " , " . $offset;
        $recordsTotal = Yii::app()->db->createCommand($sql_count)->queryScalar();
        $sql = "SELECT * FROM ( SELECT erp_stock_ledger.`product_id`, erp_store.part_number, erp_store.description, YEAR(`transaction_date`) as year , SUM(`quantity`) as quantity FROM `erp_stock_ledger` JOIN erp_store ON ( erp_store.id = erp_stock_ledger.product_id ) WHERE `customer_vendor_id` = " . $customer_id . " GROUP BY erp_stock_ledger.`product_id`, erp_store.part_number, erp_store.description, YEAR(`transaction_date`) ORDER BY erp_stock_ledger.product_id ) AS tb LIMIT " . $offset . ", " . $limit;
        $data = Yii::app()->db->createCommand($sql)->queryAll();
        $temp_array = array();
        foreach ($data as $value) {
            $temp_array[$value['product_id']]['part_number'] = $value['part_number'];
            $temp_array[$value['product_id']]['description'] = $value['description'];
            $temp_array[$value['product_id']][$value['year']] = $value['quantity'];
        }
        $rowData = array();

        foreach ($temp_array as $key => $value) {
            $temp = array(
                $value['part_number'],
                $value['description'],
            );
            for ($index = $start_year; $index <= $end_year; $index++) {
                $qty = ( isset($value[$index]) ? $value[$index] : 0) * -1;
                array_push($temp, number_format($qty));
            }
            array_push($temp, $key);
            $rowData[] = $temp;
        }
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsTotal;
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionGetmaterialYearMonthWise() {
        $end_year = (int) Yii::app()->request->getParam('end_year');
        $start_year = (int) Yii::app()->request->getParam('start_year');
        $customer_id = Yii::app()->request->getParam('id');
        $item = Yii::app()->request->getParam('item_id');
        $sql = "SELECT erp_stock_ledger.`product_id`, YEAR(`transaction_date`) AS Y, MONTH(`transaction_date`) AS m, SUM(`quantity`) AS quantity FROM `erp_stock_ledger` JOIN erp_store ON( erp_store.id = erp_stock_ledger.product_id )  WHERE ( `customer_vendor_id` = " . $customer_id . " AND   erp_stock_ledger.`product_id` = " . $item . ")  GROUP BY erp_stock_ledger.`product_id`, YEAR(`transaction_date`), MONTH(`transaction_date`)";
        $data = Yii::app()->db->createCommand($sql)->queryAll();
        $temp_array = array();

        for ($index1 = 1; $index1 <= 12; $index1++) {

            for ($index = $start_year; $index <= $end_year; $index++) {

                $temp_array[$index1][$index] = 0;
            }
        }

        foreach ($data as $value) {
            $temp_array[(int) $value['m']][(int) $value['Y']] = $value['quantity'];
        }
        $month_array = array(
            1 => 'January',
            2 => 'February',
            3 => 'March',
            4 => 'April',
            5 => 'May',
            6 => 'June',
            7 => 'July',
            8 => 'August',
            9 => 'September',
            10 => 'October',
            11 => 'November',
            12 => 'December');
        $total_per_year = array();
         $total_per_year[0] =0;
        foreach ($temp_array as $key => $value) {
            $temp = array($month_array[$key]);
            $right_side_total =0;
            for ($index = $start_year; $index <= $end_year; $index++) {
                $qty = ( isset($value[$index]) ? $value[$index] : 0) * -1;
                $right_side_total = $right_side_total+ $qty;
                array_push($temp, number_format($qty));
                if (!isset($total_per_year[$index])) {
                    $total_per_year[$index] = 0;
                }
                $total_per_year[$index] = (int) $total_per_year[$index] + $qty;
            }      
            $total_per_year[0] = $total_per_year[0] + $right_side_total;
            $temp[] =$right_side_total;
            $rowData[] = $temp;
        }
        $temp = ["Total"];
        for ($index = $start_year; $index <= $end_year; $index++) {
            $temp[] = $total_per_year[$index];
        }
        $temp[]= $total_per_year[0] ;
        $rowData[] = $temp;
        $data['recordsTotal'] = 13;
        $data['recordsFiltered'] = 13;
        $data['data'] = $rowData;
        //$data['sql'] = $sql;
        echo json_encode($data);
    }

}
