<?php

//modified by jisha on 15-9-18.
class CustomerController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'), //,'temp_form','CompanyFieldDetails'
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'GetCustomerList', 'Create', 'SaveCustomer',
                    'GetContactList', 'CustomerContactCreate', 'SaveContact',
                    'getDocsList', 'CreateDocumentForm', 'SaveDocForm',
                    'DeleteShippingItem', 'UploadCustomerDocuments', 'DownloadDocument', 'CheckTrnExistance',
                    'GetCustomerDetails', 'GetCustomerContactdetails', 'info', 'SendCustomerStatement','GetContactDetails',
                    'GetCustomerBalance','printcustomercreditexeedlist','Changeuserorpassword','UpdateUsernamePassword','InventoryReport'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    /**
     * This is the default 'index' action that is invoked
     * when an action is not explicitly requested by users.
     * //modified by jisha on 15-9-18.
     */
    public function actionIndex() {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('index');
    }

    /*
     * function to list all customers
     * modified by jisha on 15-9-18. 
     */

    public function actionGetCustomerList() {
        $model = new Customer();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 'customer_name',
            2 => 'customer_email_id',
            3 => 'nick_name',
            4 => 'customer_phone_no',
            5 => 'user.first_name',
            6 => 'country.country_name',
            7 => 't.id',
            8 => 'isActive'
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;

        $condition = 't.isActive= "Y"';

        if (((int) Yii::app()->user->havePermissionOn["view_all_customer"]) == 0) {
            $condition .= " AND t.lead_owner_id=" . Yii::app()->user->id;
        }

        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " AND (CONCAT(TRIM(user.first_name),' ',TRIM(user.last_name)) LIKE '%" . $searchString . "%' OR customer_name LIKE '%" . $searchString . "%' OR  t.id LIKE '%" . $searchString . "%'  OR customer_address LIKE '%" . $searchString . "%' OR customer_phone_no LIKE '%" . $searchString . "%' OR customer_location LIKE '%" . $searchString . "%'  OR customer_email_id LIKE '%" . $searchString . "%' OR pricinggroup.pricing_group_name LIKE '%" . $searchString . "%' OR paymentmethod.payment_terms LIKE '%" . $searchString . "%' OR customer_trn_no LIKE '%" . $searchString . "%' OR country.country_name LIKE '%" . $searchString . "%')";
        }
        /* if(User::isSalesman()=='Y'){
          $condition.=" AND t.lead_owner_id=".Yii::app()->user->id;
          } */
        $count = $model->with('pricinggroup', 'paymentmethod', 'user', 'country')->count(array('condition' => $condition));
        $model = $model->with('pricinggroup', 'paymentmethod', 'user', 'country')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $current = strtotime(date('y-m-d'));

        function getFirstcontact($id) {
            return CustomerContact::model()->find(array('condition' => 'customer_id=' . $id))->person_name;
        }

        // foreach ($model as $row) {
        //     $arr_customer_contact = CustomerContact::model()->find(array('condition' => 'department=6 AND contact_email_id!=""')); //finance department
        //     $cnt_contact = count($arr_customer_contact);
        //     $colour = 0;
        //     $own_flag = 1;
        //     /* if($row['lead_owner_id']==Yii::app()->user->id || Yii::app()->user->authorised_user == 1){
        //       $own_flag=1;
        //       } */
        //     $rowData[] = array($row['id'], substr($row['customer_name'], 0, 45), $row['customer_location'], $row['customer_phone_no'], $row['customer_trn_no'], $row['user']['Fullname'], '<div title="' . $row['paymentmethod']['payment_terms'] . '">' . $row['paymentmethod']['payment_terms'] . '</div>', $colour, $row['isActive'], $row['isCompetitor'], $own_flag, $cnt_contact);
        //     $m++;
        // }
        foreach ($model as $row) {
            // Use findAll to retrieve multiple results as an array
            $arr_customer_contact = CustomerContact::model()->findAll(array(
                'condition' => 'department=6 AND contact_email_id!=""'
            )); // finance department
        
            // Count the number of customer contacts
            $cnt_contact = is_array($arr_customer_contact) ? count($arr_customer_contact) : 0;
        
            $colour = 0;
            $own_flag = 1;
        
            $rowData[] = array(
                $row['id'],
                substr($row['customer_name'], 0, 45),
                $row['customer_location'],
                $row['customer_phone_no'],
                $row['customer_trn_no'],
                $row['user']['Fullname'],
                '<div title="' . $row['paymentmethod']['payment_terms'] . '">' . $row['paymentmethod']['payment_terms'] . '</div>',
                $colour,
                $row['isActive'],
                $row['isCompetitor'],
                $own_flag,
                $cnt_contact
            );
            $m++;
        }
        
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    /*
     * function to create customer details
     * modified by jisha on 15-9-18. 
     */

    public function actionCreate() {
        $model = new Customer();
        $modelcontact = new CustomerContact();
        $modeldoc = new CustomerDocs();
        $id = (int) Yii::app()->request->getParam('id');
        $flag = (int) Yii::app()->request->getParam('flag');
        $industry = Yii::app()->request->getParam('industry');
        $payterms = Yii::app()->request->getParam('payterms');
        $leadform = Yii::app()->request->getParam('frm');
        $lead_id = (int) Yii::app()->request->getParam('leadid');
        $file_id = (int) Yii::app()->request->getParam('fileid');
        if ($lead_id > 0) {

            $modelLead = Lead::model()->findByPk($lead_id);
            $model->customer_name = $modelLead->customer_name;
            $model->customer_email_id = $modelLead->email;
            $model->customer_phone_no = $modelLead->mobile;
            $model->lead_owner_id = $modelLead->lead_owner_id;
        }
        if ($id > 0) {
            $model = $model->findByPk($id);
            $modeldoc = CustomerDocs::model()->findAll(array('condition' => 'customer_id=' . $id));
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
        $this->render('customer_form', array('model' => $model, 'modelcontact' => $modelcontact, 'modeldoc' => $modeldoc, 'flag' => $flag, 'industry' => $industry, 'payterms' => $payterms, 'leadform' => $leadform, 'leadid' => $lead_id, 'file_id' => $file_id));
    }
    
     public function actionEdit() {
         
     }

    /*
     * function to save customer details
     * modified by jisha on 15-9-18. 
     */

    function actionSaveCustomer() {
        $model = new Customer();
        $modelcontact = new CustomerContact();
        $modeldoc = new CustomerDocs();
        $oldship_id_array = array();

        $frm = $_POST['frm'];
        $leadid = $_POST['leadid'];
        $file_id = $_POST['file_id'];

        /*         * ********** START Code for Save ************** */
        if (isset($_POST['Customer'])) {
            $customer_lead_id=0;
            if ($_POST['Customer']['id'] > 0) {
                $id = $_POST['Customer']['id'];
                $model = $model->findByPK($id);
                $oldship_id_array = CustomerShippingDetails::model()->findAll(array('select' => 'id', 'condition' => 'customer_id = "' . $_POST['Customer']['id'] . '"'));
                $scene = 'update';
                $change_type = 'UPDATED';
                $customer_lead_id = (int) $model->lead_id;
                
            } else {
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d H:i:s');
                $scene = 'new';
                $change_type = 'CREATED';
            }
            $model->updated_by = Yii::app()->user->id;
            $model->updated_date_time = date('Y-m-d H:i:s');

            $model->attributes = $_POST['Customer'];
            $model->customer_credit_limit = floatval($_POST['Customer']['customer_credit_limit']);
            $model->isActive = $_POST['Customer']['isActive'];
            $model->isCompetitor = $_POST['Customer']['isCompetitor'];
            $model->customer_remarks = $_POST['Customer']['customer_remarks'];
            if ($_POST['Customer']['customer_country'] != '143') {
                $model->customer_emirates_name = "0";
            } else {
                $model->customer_emirates_name = $_POST['Customer']['customer_emirates_name'];
            }
            $customer_contact_type = ''; // changes for audit log
            if (isset($_POST['CustomerContact'])) {
                if ($_POST['CustomerContact']['id'] > 0) {
                    $id = $_POST['CustomerContact']['id'];
                    $modelcontact = $modelcontact->findByPK($id);
                    $modelcontact->updated_by = Yii::app()->user->id;
                    $modelcontact->updated_date_time = date('Y-m-d h:i:s');
                    $customer_contact_type = 'UPDATED'; // changes for audit log
                } else {

                    $modelcontact->created_by = Yii::app()->user->id;
                    $modelcontact->created_date_time = date('Y-m-d h:i:s');
                    $modelcontact->updated_by = Yii::app()->user->id;
                    $modelcontact->updated_date_time = date('Y-m-d h:i:s');
                    $customer_contact_type = 'CREATED'; // changes for audit log
                }
                $modelcontact->attributes = $_POST['CustomerContact'];
                $modelcontact->person_name = $_POST['CustomerContact']['person_name'];
                $modelcontact->customer_id = 0;
                $modelcontact->isActive = $_POST['CustomerContact']['isActive'];
            }
            if ($_POST['CustomerDocs']['id'] > 0) {
                $docid = $_POST['CustomerDocs']['id'];
                $modeldoc = $modeldoc->findByPK($docid);
                $docs_type = 'UPDATED';
            } else {
                $docs_type = 'CREATED';
            }
            $modeldoc->attributes = $_POST['CustomerDocs'];
            if ($model->id > 0) {
                $valid = $model->validate();
            } else {
                $valid = $model->validate() && $modelcontact->validate();
            }
            if (is_array($_POST['CustomerShippingDetails'])) {
                foreach ($_POST['CustomerShippingDetails'] as $i => $item) {


                    if ($item['id'] > 0) {
                        $modelshipping[$i] = CustomerShippingDetails::model()->findByPk($item['id']);
                        $shipid_array[] = $item['id'];
                    } else {
                        $modelshipping[$i] = new CustomerShippingDetails;
                    }
                    $modelshipping[$i]->attributes = $_POST['CustomerShippingDetails'][$i];
                    $modelshipping[$i]->customer_id = 0;
                    $modelshipping[$i]->state = $item['state'];
                    $modelshipping[$i]->city = $item['city'];
                    $modelshipping[$i]->street_address = $item['street_address'];
                    $modelshipping[$i]->po_box = $item['po_box'];
                    $modelshipping[$i]->postal_code = $item['postal_code'];
                    $modelshipping[$i]->country_id = $item['country_id'];
                    $valid = $modelshipping[$i]->validate() && $valid;
                }
            }

            if ($valid) {
                echo CJSON::encode(array('status' => 'success', 'frm' => $frm, 'leadid' => $leadid, 'file_id' => $file_id));
                $model->save();
                // inserting to audit log
                AuditLog::saveAuditLogs(
                        'CUSTOMERS', Yii::app()->user->id, $change_type, " with ID - {$model->id} "
                );
                // end audit log 
                $model->saveSublegder();

                if ($modelcontact->person_name != '') {
                    $modelcontact->customer_id = $model->id;
                    $modelcontact->save(false);
                    // inserting to audit log
                    AuditLog::saveAuditLogs(
                            'CUSTOMERS', Yii::app()->user->id, $customer_contact_type, " Contact with ID - {$modelcontact->id} "
                    );
                    // end audit log 
                }
                // $modelnote->customer_vendor_id = $model->id;
                // $modelnote->customer_vendor_type = 1;
                if (!empty($modelshipping)) {
                    foreach ($modelshipping as $eachModel) {
                        $eachModel->customer_id = $model->id;
                        $eachModel->save();
                    }
                    if (!empty($oldship_id_array)) {
                        foreach ($oldship_id_array as $eachid) {
                            if (!in_array($eachid->id, $shipid_array)) {
                                CustomerShippingDetails::model()->deleteByPk($eachid->id);
                            }
                        }
                    }
                }
                
                 if((int) $customer_lead_id > 0){
                    
                    $modelLead = new Lead();
                    $modelLead->updateByPk((int) $customer_lead_id, array('customer_name' => $model->customer_name));
                    $modelActivity = new Activity();
                    $modelActivity->updateAll(array("customer_name"=>$model->customer_name),'customer_id='.$model->id);
                }

                if ((int) $leadid > 0) {

                    $modelLead = new Lead();
                    $modelLead = $modelLead->findByPk($leadid);

                    $lead_contact_id = 0;
                    if (!empty($modelLead->contact_name)) {
                        $modelLeadContact = new CustomerContact();
                        $modelLeadContact->customer_id = $model->id;
                        $modelLeadContact->person_name = $modelLead->contact_name;
                        $modelLeadContact->contact_mobile_no = $modelLead->mobile;
                        $modelLeadContact->contact_email_id = $modelLead->email;
                        $modelLeadContact->save(false);
                        $lead_contact_id = $modelLeadContact->id;
                    }

                    $modelLead->updateByPk($modelLead->id, array('customer_id' => $model->id, 'contact_id' => $lead_contact_id,'lead_type'=>'C'));

                    $modelMaster = new MasterFile();

                    $modelMaster->updateByPk($modelLead->file_id, array('customer_id' => $model->id));

                    Customer::model()->updateByPk($model->id, array('lead_id' => $leadid));
                    
                    
                    $modelActivity = new Activity();
                    
                    $modelActivity->updateAll(array("customer_id"=>$model->id,),'header_id='.$leadid.' AND added_from="LE"');
                    AuditLog::saveAuditLogs(
                            'CUSTOMERS', Yii::app()->user->id, 'CREATED', " Contact with ID - {$modelLeadContact->id} "
                    );
                }

                if ($_POST['CustomerDocs']['document'] != '') {
                    if ($_POST['CustomerDocs']['from_date'] != '00/00/0000' && $_POST['CustomerDocs']['from_date'] != '') {
                        $modeldoc->from_date = str_replace('/', '-', $_POST['CustomerDocs']['from_date']);
                        $modeldoc->from_date = date("Y-m-d", strtotime($modeldoc->from_date));
                    }
                    if ($_POST['CustomerDocs']['to_date'] != '00/00/0000' && $_POST['CustomerDocs']['to_date'] != '') {
                        $modeldoc->to_date = str_replace('/', '-', $_POST['CustomerDocs']['to_date']);
                        $modeldoc->to_date = date("Y-m-d", strtotime($modeldoc->to_date));
                    }
                    $modeldoc->customer_id = $model->id;
                    $modeldoc->save(false);

                    // inserting to audit log
                    AuditLog::saveAuditLogs(
                            'CUSTOMERS', Yii::app()->user->id, $docs_type, " Document with ID - {$modeldoc->id} "
                    );
                    // end audit log
                }
                //Mail Settings
                if ($scene == 'new') {
                    if (class_exists('Notification')) {
                        $model_mail_setting = Notification::model()->find(array('condition' => 'event_id="1"'));
                    }
                    
                    Yii::import('application.controllers.front.MasternotificationController');
                    if ($model_mail_setting->mail_required == 'Y') {
                        // MasternotificationController::sendmail(1,$model->id);
                    }
                    if ($model_mail_setting->notification_required == 'Y') {
                        // MasternotificationController::sendnotification(1,$model->id);
                    }
                    if ($model_mail_setting->sms_required == 'Y') {
                        // MasternotificationController::sendsms(1,$model->id);
                    }
                }
            } else {
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                $error2 = json_decode(CActiveForm::validateTabular($modelcontact, '', false), true);
                $error3 = json_decode(CActiveForm::validateTabular($modelshipping, '', false), true);
                $error = CJSON::encode(array_merge_recursive($error1, $error2, $error3));
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    /*
     * function to list customer conatcts
     * modified by jisha on 15-9-18. 
     */

    function actionGetContactList() {
        $model = new CustomerContact();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $customer_id = $_POST['customer_id'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'person_name',
            1 => 'designation',
            2 => 'contact_phone_no',
            3 => 'isActive',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.customer_id = "' . $customer_id . '" AND (t.person_name !="" OR t.designation !="" OR t.contact_phone_no !="")';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " AND (person_name LIKE '%" . $searchString . "%' OR designation LIKE '%" . $searchString . "%' OR contact_phone_no LIKE '%" . $searchString . "%')";
        }
        $or = 't.isActive';
        $count = $model->count(array('condition' => $condition));
        $model = $model->with('customer')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $or));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        foreach ($model as $row) {


            $st = "Blocked";
            if ($row['isActive'] == "Y") {
                $st = "Active";
            }
            $div="";
            if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["customer_edit"])){
                $div ='<div class="btn-wrap text-center"><button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'logistics/customer/customercontactcreate&id=' . $row['id'] . '\',\'Edit Contact\',\'lg\')"><i class="fa fa-pencil"></i></button></div>';
            }

            $rowData[] = array($row['person_name'], $row['designation'], $row['contact_phone_no'], $row['contact_mobile_no'], $row['contact_email_id'], $st,$div, $row['isActive']);
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    /*
     * function to create customer contact using modal pop up
     * modified by jisha on 15-9-18. 
     */

    public function actionCustomerContactCreate() {

        $models = new CustomerContact();
        $id = (int) Yii::app()->request->getParam('id');
        $customer_id = (int) Yii::app()->request->getParam('c_id');
        if ($id > 0) {
            $models = $models->findByPk($id);
        }

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
        $this->render('contact_form', array('models' => $models, 'c_id' => $customer_id));
    }

    /*
     * function to save customer contact
     * modified by jisha on 15-9-18. 
     */

    public function actionSaveContact() {
        $model = new CustomerContact();
        if (isset($_POST['CustomerContact'])) {

            if ($_POST['CustomerContact']['id'] > 0) {
                $id = $_POST['CustomerContact']['id'];
                $model = $model->findByPK($id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('y-m-d');
                $customer_contact_type = 'UPDATED';
            } else {
                $customer_contact_type = 'CREATED';
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('y-m-d');
            }
            $model->customer_id = $_POST['hid_customer_id'];
            $model->attributes = $_POST['CustomerContact'];
            $model->isActive = $_POST['CustomerContact']['isActive'];
            $model->department = implode(",", $_POST['CustomerContact']['department']);
            //$model->notes = $_POST['CustomerContact']['notes'];
            if ($model->save()) {
                // inserting to audit log
                AuditLog::saveAuditLogs(
                        'CUSTOMERS', Yii::app()->user->id, $customer_contact_type, " Contact with ID - {$model->id} "
                );
                // end audit log
                $jsonData['status'] = 'success';
                $jsonData['frm'] = $_POST['customer__form'];
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    /*
     * function to list customer docs
     * modified by jisha on 15-9-18. 
     */

    public function actionGetDocsList() {
        $model = new CustomerDocs();
        $vendor_id = $_POST['vendor_id'];
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 'document_type',
            2 => 'document_no',
            3 => 'to_date',
            4 => 't.id',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        if ($vendor_id > 0) {
            $condition = 't.customer_id=' . $vendor_id;
        } else {
            $condition = '1=1';
        }
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " AND (t.document_no LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('cus_details')->count(array('condition' => $condition));
        $model = $model->with('cus_details')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 't.id DESC'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $to_date = '';
            $edit = '<div class="btn-wrap text-center"><button class="btn btn-primary btn-xs" title ="Edit" onclick="loadPopupModal(\'logistics/customer/createDocumentform&id=' . $row['id'] . '\',\'' . $row['id'] . ' : ' . $row['cus_details']['customer_name'] . '\',\'lg\')"><i class="fa fa-pencil"></i></button> ';
            $edit .= ' <a title= "Download" href ="' . Yii::app()->createUrl('logistics/customer/downloaddocument&id=' . $row['id']) . '" class=" btn btn-primary btn-xs"><i class="fa fa-download"></i></a>';
            if ($row['to_date'] != '' && $row['to_date'] != '0000-00-00') {
                $to_date = date("d/m/Y", strtotime($row['to_date']));
            }
            $rowData[] = array($m, $row['doctype']['document_type'], $row['document_no'], $to_date, $edit);
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    /*
     * function to create customer document using modal pop up
     * modified by jisha on 15-9-18. 
     */

    public function actionCreateDocumentForm() {

        $model = new Customer();
        $modeldoc = new CustomerDocs();
        $id = (int) Yii::app()->request->getParam('id');
        $customer_id = (int) Yii::app()->request->getParam('c_id');
        if ($id > 0) {
            $modeldoc = $modeldoc->findByPk($id);
            $customer_id = $modeldoc->customer_id;
        }
        if ($customer_id > 0) {
            $model = $model->findByPk($customer_id);
            $modeldoc->customer_id = $customer_id;
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
        $this->render('doc_form', array('model' => $model, 'modeldoc' => $modeldoc, 'c_id' => $customer_id));
    }

    /*
     * function to save customer document
     */

    public function actionSaveDocForm() {
        $model = new CustomerDocs();
        $id = $_POST['CustomerDocs']['id'];
        if ($_POST['CustomerDocs']['id'] > 0) {
            $model = $model->findByPk($id);
            $docs_type = 'UPDATED';
        } else {
            $docs_type = 'CREATED';
        }
        $model->attributes = $_POST['CustomerDocs'];
        if ($_POST['CustomerDocs']['from_date'] != '00/00/0000' && $_POST['CustomerDocs']['from_date'] != '') {
            $model->from_date = str_replace('/', '-', $_POST['CustomerDocs']['from_date']);
            $model->from_date = date("Y-m-d", strtotime($model->from_date));
        }
        if ($_POST['CustomerDocs']['to_date'] != '00/00/0000' && $_POST['CustomerDocs']['to_date'] != '') {
            $model->to_date = str_replace('/', '-', $_POST['CustomerDocs']['to_date']);
            $model->to_date = date("Y-m-d", strtotime($model->to_date));
        }
        if ($model->save()) {
            // inserting to audit log
            AuditLog::saveAuditLogs(
                    'CUSTOMERS', Yii::app()->user->id, $docs_type, " Document with ID - {$model->id}"
            );
            // end audit log 
            $jsonData['status'] = 'success';
            $jsonData['frm'] = $_POST['CustomerDocs'];
            $jsonData['id'] = $model->id;
            echo CJSON::encode($jsonData);
        } else {
            $error = CActiveForm::validate($model, '', false);
            if ($error != '[]')
                echo $error;
        }
    }

    public function actionDeleteShippingItem() {
        $id = $_POST['id'];
        if ($id > 0) {
            CustomerShippingDetails::model()->deleteByPk($id);
            $jsonData['status'] = 'success';
            echo CJSON::encode($jsonData);
        }
    }

    public function actionDownloadDocument() {
        $id = (int) Yii::app()->request->getParam('id');
        $arr_employee_doc = CustomerDocs::model()->findByPk($id);
        $file = $arr_employee_doc->document;
        $arr_doc_val = explode(',', $arr_employee_doc->document);
        $path = Yii::getPathOfAlias('webroot') . "/uploads/documents/" . $file;
        header("Content-type:application/octet-stream"); //for txt file
        header("Content-Type: application/download");
        //header('Content-Type:text/plain; charset=ISO-8859-15');
        //if you want to read text file using text/plain header
        header('Content-Disposition: attachment; filename="' . basename($path) . '"');
        header('Content-Length: ' . filesize($path));
        readfile($path);
        Yii::app()->end();
    }

    /*
     * function to create customer details for autocomplete in lead
     * modified by jisha on 17-9-18. 
     */

    public function actionGetCustomerDetails() {
        $from = $_GET['frm'];
        $searchTerm = $_GET['term'];
        $condition = 'customer_name LIKE "%' . $searchTerm . '%" AND t.isActive="Y"';

        if((int) Yii::app()->user->havePermissionOn["job_order_view_all"] == 0 || (int) Yii::app()->user->havePermissionOn["quotation_view_all"]){
                $condition.= ' AND t.lead_owner_id= "'.Yii::app()->user->id.'"';
            }
        
        $model = new Customer();
        $model = $model->with('currency_detail', 'country')->findAll(array('select' => 't.lead_owner_id,t.id,t.customer_name,customer_currency_id,customer_payment_term,customer_address,
            customer_city,customer_postal_code,customer_country,t.customer_location,t.customer_emirates_name, customer_state', 'condition' => $condition, 'limit' => 200));
        $i = 0;
        $data = array();
        foreach ($model as $eachModel) {
            $modDocuments = CustomerDocs::model()->with('doctype')->findAll(array('condition' => 'customer_id=' . $eachModel->id . ' AND to_date<="' . date('Y-m-d') . '"'));
            $modshipaddress = CustomerShippingDetails::model()->find(array('condition' => 'customer_id=' . $eachModel->id));
            $data[$i]['value'] = $eachModel->id;
            $location = "";
            if (!empty($eachModel->customer_location)) {
                $location = " [" . $eachModel->customer_location . " ]";
            }
            $data[$i]['customername'] = $eachModel->customer_name;
            $data[$i]['label'] = $eachModel->customer_name . "" . $location;
            $billing_address = '';
//            if($eachModel->customer_address!=''){
//                $billing_address.=$eachModel->customer_address;
//                $billing_address.="\r\n";
//            }
            if (!empty($eachModel->customer_city)) {
                $billing_address .= $eachModel->customer_city . ", ";
            }
            if ($eachModel->customer_postal_code != '') {
                $billing_address .= 'P.O Box : ' . $eachModel->customer_postal_code;
            }
            $billing_address .= "\r\n";

            if (!empty($eachModel->customer_state)) {
                $billing_address .= $eachModel->customer_state . " - " . $eachModel->country->country_name;
            } else {
                $billing_address .= $eachModel->country->country_name;
            }
            $arr_doc = array();
            $doc_msg = '';
            if (!empty($modDocuments)) {
                foreach ($modDocuments as $each) {
                    $arr_doc[] = $each->doctype->document_type . ' is Expired.<br/>';
                }
                $doc_msg = implode(',', $arr_doc);
            }
            $data[$i]['msg'] = $doc_msg;
            $data[$i]['billaddress'] = $billing_address;
            $data[$i]['shipaddress'] = $modshipaddress->street_address . ", PO Box : " . $modshipaddress->postal_code . "," . $modshipaddress->city . "," . $modshipaddress->country->country_name;
            $data[$i]['currency'] = $eachModel->currency_detail->currency;
            $data[$i]['currency_id'] = $eachModel->currency_detail->id;
            $data[$i]['exchangerate'] = $eachModel->currency_detail->exchange_rate;
            $data[$i]['payment_term'] = $eachModel->customer_payment_term;
            $data[$i]['countryid'] = $eachModel->customer_country;
            $data[$i]['emiratesname'] = $eachModel->customer_emirates_name;
            $data[$i]['contact_id'] = $eachModel->lead_owner_id; //To assign leadowner taking contact
            $i++;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }

    public function actionCheckTrnExistance() {
        $terms = $_POST['trn_no'];
        $term = ltrim($terms);
        $status = array();
        if ($term != '') {
            $store = Customer::model()->findAll(array('condition' => 'customer_trn_no = "' . $term . '"'));
            if (!empty($store)) {
                $status['status'] = 'exist';
            } else {
                $status['status'] = 'not_exist';
            }
        }
        echo CJSON::encode($status);
    }

    public function actionGetCustomerContactdetails() {
        $customer_id = Yii::app()->request->getparam("id");
        $frm = Yii::app()->request->getparam("frm");
        $modelName = Yii::app()->request->getparam("modelName");
        $columnWidth = Yii::app()->request->getparam("columnWidth");


        $model = new $modelName;
        if ($frm == 'joborder' || $frm == 'quotation') {

            $SQL = "SELECT GROUP_CONCAT(contact.`id`) as contact_ids FROM `erp_customer_contact` as contact INNER JOIN erp_mas_department as dept ON contact.department=dept.id WHERE customer_id='.$customer_id.' AND dept.department_code='SU'";
            $arr_customer_contact_details = Yii::app()->db->createCommand($SQL)->queryRow();

            $contact_ids = explode(",", $arr_customer_contact_details['contact_ids']);
            foreach ($contact_ids as $eachValue) {
                $arr_customer_contact_ids[$eachValue] = array('selected' => 'selected');
            }

            $models = CustomerContact::getCustomerStatusUpdateContacts($customer_id);
            $drop = '<li class="col-sm-3">';
            $drop .= CHtml::activedropDownList($model, 'contact_ids', $models, array('class' => 'tooltipster', 'title' => 'Please Select Contact', 'data-label' => 'Contact <span style="color:red">*</span>', 'data-search' => true, 'multiple' => true, 'options' => $arr_customer_contact_ids));
        } else {
            $models = CustomerContact::getCustomerContacts($customer_id);
            $drop = '<li class="col-sm-' . $columnWidth . '">';
            $drop .= CHtml::activedropDownList($model, 'contact_id', $models, array('class' => 'tooltipster', 'title' => 'Please Select Contact', 'data-label' => 'Contact <span style="color:red">*</span>', 'data-search' => true, 'empty' => '-select-'));
        }
        $drop .= '</li>';
        $status = array("dt" => $drop);
        echo CJSON::encode($status);
    }

    //info button details
    public function actioninfo() {
        $this->render('info', $_GET);
    }

    public function actionSendCustomerStatement() {
        $customer_id = (int) Yii::app()->request->getParam('customer_id');
        $customer = new Customer();
        $customer = $customer->find(array('condition' => 'id=' . $customer_id));
        $customer_name = $customer->customer_name;
        $ledger = 11;
        $subledger = FinanceSubledger::model()->find(array('condition' => 'subledger_type_id=1 AND parent_id=' . $customer_id))->id;

        $type = 'customer';
        $from = 'mail';
        $to = (count(explode('/', $_REQUEST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['to']))) : date('Y-m-d');
        $ageing_type = Yii::app()->request->getParam('ageing_type');
        $ageing_type = 1;
        $param = array(
            'ledger' => $ledger,
            'subledger' => $subledger,
            'type' => $type,
            'from' => $from,
            'to' => $to,
            'ageing_type' => $ageing_type,
        );


        $mode = 'A4';
        $mpdf = Yii::app()->ePdf->mpdf('', $mode);
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mpdf->WriteHTML($stylesheet, 1);
        $mpdf->WriteHTML($this->renderPartial('application.modules.finance/views/reports/pdf_statement_base', $param, true));
        $mpdf->Output(Yii::getPathOfAlias('webroot') . "/upload/downloadstatement/"."Statement of Accounts as on"."-".date("d-m-Y")."-" . $customer_name.".pdf", 'F');




        $arr_customer_contact = CustomerContact::model()->findAll(array('condition' => 'department=6 AND contact_email_id!="" AND customer_id=' . $customer_id)); //finance department
$cnt_email=0;
        foreach ($arr_customer_contact as $eachCustomerContact) {

            $email_id = $eachCustomerContact['contact_email_id'];
            $contact_name = $eachCustomerContact['person_name'];

             $salutation = 'Dear  ' ."$contact_name";
            if ($email_id != "") {

                $mailContent['company_name'] = Yii::app()->user->master_company_name;
                $mailContent['salutation'] = $salutation;
                $company_name=Yii::app()->user->master_company_name;
                $due_array = [];
                $due_array["0-30"] = 0;
                for ($index = 1; $index < 6; $index++) {
                    $lower_limit = ($index * 30) + 1;
                    $upper_limit = $lower_limit + 29;
                    $label = "{$lower_limit}-{$upper_limit}";
                    if (!isset($due_array[$label])) {
                        $due_array[$label] = 0;
                    }
                }
                $due_array[">180"] = 0;

                $message = new YiiMailMessage;
                $message->view = 'email_customer_statement';
                $message->setBody(array('mailContent' => $mailContent,'due_array'=>$due_array,'ageing_type' => $ageing_type, 'ledger' => $ledger,'subledger' => $subledger,'type' => $type,'from' => $from, 'to' => $to, 'ageing_type' => $ageing_type), 'text/html');
                $message->subject = 'Statement of Accounts as on' ."-".date("d-m-Y")."-".$company_name;
               
                $message->from = 'Receivables@infinitylogisticsme.com';
                //$message->addTo('mereena.vinod@mailbluesky.com');
                $message->addTo($email_id);
                //$message->addTo('mereena.cumulus@gmail.com');
                $message->addBcc('invoicing@infinitylogisticsme.com');
                $message->addBcc('accounts@infinitylogisticsme.com');
                //$message->attach(Yii::getPathOfAlias('webroot')."/upload/downloadstatement/".$customer_id."_statement" . date("dmY").".pdf");
                $file_path = Yii::getPathOfAlias('webroot') . "/upload/downloadstatement/" ."Statement of Accounts as on"."-".date("d-m-Y")."-" . $customer_name.".pdf";
               
                $swiftAttachment = Swift_Attachment::fromPath($file_path);
                $message->attach($swiftAttachment);
                //$message->attach("upload/downloadstatement/".$customer_id."_statement" . date("dmY").".pdf");
                //$message->addBcc('manu.varghese236@gmail.com');
                //$message->addBcc('dksnrajan@gmail.com');
                //$message->addBcc('arunjv@gmail.com');
                //$message->addBcc('arun@mailbluesky.com');
                

                	 $result = Yii::app()->mail->send($message);
                	 
                	 if($result > 0){
                	     $cnt_email++;
                	 }
                	 
            } 
        }
        
            if($cnt_email > 0){
                $jsonData['status'] = "success";
        	 }
        	 else{
        	      $jsonData['status'] = "Authentication failed";
        	 }
        
        
        
        echo json_encode($jsonData);
    }
    
    public function actionGetContactDetails(){
            $customer_id = Yii::app()->request->getparam("id");
            $arr_invoice_customer_contact_ids=array();
            $arr_job_order_customer_contact_ids=array();
            
            $modelJobOrder = new JobOrder();

            $SQL = "SELECT GROUP_CONCAT(contact.`id`) as contact_ids FROM `erp_customer_contact` as contact INNER JOIN erp_mas_department as dept ON contact.department=dept.id WHERE customer_id='.$customer_id.' AND dept.department_code='SU'";
            $arr_customer_contact_details = Yii::app()->db->createCommand($SQL)->queryRow();
            $contact_ids = explode(",", $arr_customer_contact_details['contact_ids']);
            foreach ($contact_ids as $eachValue) {
                $arr_job_order_customer_contact_ids[$eachValue] = array('selected' => 'selected');
            }
            
           

            $modelJobOrderContacts = CustomerContact::getCustomerStatusUpdateContacts($customer_id);
            $drop_job_order = '<li class="col-sm-3">';
            $drop_job_order .= CHtml::activedropDownList($modelJobOrder, 'contact_ids', $modelJobOrderContacts, array('class' => 'tooltipster', 'title' => 'Please Select Contact', 'data-label' => 'Job Order Contact <span style="color:red">*</span>', 'data-search' => true, 'multiple' => true, 'options' => $arr_job_order_customer_contact_ids));
            $drop_job_order .= '</li>';
            
            $modelInvoice = new Invoice();
            
            $SQL = "SELECT GROUP_CONCAT(contact.`id`) as contact_ids FROM `erp_customer_contact` as contact INNER JOIN erp_mas_department as dept ON contact.department=dept.id WHERE customer_id='.$customer_id.' AND dept.department_code='FN'";
            $arr_customer_contact_details=Yii::app()->db->createCommand($SQL)->queryRow();
            
            $contact_ids = explode(",",$arr_customer_contact_details['contact_ids']);
            foreach ($contact_ids as $eachValue){
                $arr_invoice_customer_contact_ids[$eachValue] = array('selected' => 'selected');
            }   
            
            $modelInvoiceContacts = CustomerContact::getCustomerFinaceContacts($customer_id);
            $drop_invoice = '<li class="col-sm-6">';
            $drop_invoice .= CHtml::activedropDownList($modelInvoice, 'contact_id', $modelInvoiceContacts, array('class' => 'tooltipster', 'title' => 'Please Select Contact', 'data-label' => 'Invoice Contact <span style="color:red">*</span>', 'data-search' => true, 'multiple' => true, 'options' => $arr_invoice_customer_contact_ids));
            $drop_invoice .= '</li>';
            $status = array("drop_job_order" => $drop_job_order,"drop_invoice" => $drop_invoice);
            echo CJSON::encode($status);
    }
    
   /* public function actionGetCustomerBalance() {
        $customer_id = 10003; // Sample Customer id Name : ALBEX DESIGN & DISPLAY
        if($customer_id > 0){
        $subledger_id = FinanceSubledger::model()->find(array('condition'=>'subledger_type_id=1 AND parent_id='.$customer_id))->id;
        $ledger=11; // Receivables Account id; Don't change
        $balance=Yii::app()->db->createCommand("select SUM(amount) AS amount from {{finance_voucher_items}} AS I LEFT JOIN {{finance_voucher_head}} AS H ON I.header_id=H.id where H.is_posted='Y' AND I.ledger_id=".$ledger." AND I.subledger_id=".$subledger_id)->queryScalar();
        echo $balance;
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
        }
    }*/
    
     public function actionGetCustomerBalance() {
        $customer_id         = (int) Yii::app()->request->getParam('customer_id');
        if($customer_id > 0){
            
            $modelCustomer = new Customer();
            
            $modelCustomer = $modelCustomer->findByPk($customer_id);
            
           
            
            $subledger_id = FinanceSubledger::model()->find(array('condition'=>'subledger_type_id=1 AND parent_id='.$customer_id))->id;
            $ledger=11; // Receivables Account id; Don't change
            $balance=Yii::app()->db->createCommand("select SUM(amount) AS amount from {{finance_voucher_items}} AS I LEFT JOIN {{finance_voucher_head}} AS H ON I.header_id=H.id where H.is_posted='Y' AND I.ledger_id=".$ledger." AND I.subledger_id=".$subledger_id)->queryScalar();
            
            if((int) $modelCustomer->customer_credit_limit <= $balance){
                
                 echo "Total credit limit is: ".$modelCustomer->customer_credit_limit." [Current balance is: ".$balance."]";
                 
                 
                 
            }
           
        }
        else{
            echo "failed";
        }
    }
    public function actionprintcustomercreditexeedlist(){
        $param=[];
        $mode = 'A4';
        $mpdf = Yii::app()->ePdf->mpdf('', $mode);
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mpdf->WriteHTML($stylesheet, 1);
        $mpdf->WriteHTML($this->renderPartial('application.modules.logistics/views/customer/print_customer_credit', $param, true));
        $mpdf->Output("CreditExceededlist" . date("d-m-Y").".pdf", 'I');
    }
     public function actionChangeuserorpassword() {
        $model = new Customer();
         $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
           
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
        $this->render('changeusernameorpassword', array('model' => $model));
    }
     public function actionUpdateUsernamePassword() {

        $new_pwd = $_POST['user_new_password'];
        $username = $_POST['Customer']['username'];
        $login_user_id = $_POST['Customer']['id'];
        $arr_user_details = Customer::model()->findByPk($login_user_id);
        $salt = '$2a$10$1qAz2wSx3eDc4rFv5tGb5t';

        if ($username != "") {

            $arr_user_details->username = $username;
            $arr_user_details->save(false);
            $json['status'] = "success";
        } elseif ($new_pwd != "") {
            $new_password = crypt($_POST['user_new_password'], $salt);
            $arr_user_details->password = $new_password;
            $arr_user_details->save(false);
            $json['status'] = "success";
        } else {
            $json['status'] = "fail";
        }
        echo CJSON::encode($json);
    }
    public function actionInventoryReport(){
        $customer = (int) Yii::app()->request->getParam('customer_id');
        $param = array(
            'customer_id' => $customer,
        );
        $customer_details = new Customer();
        $customer_details =  $customer_details->find(array('condition' => 't.id=' . $customer));
        $customer_name =  $customer_details->customer_name;
        $mode = 'A4';
        $mpdf = Yii::app()->ePdf->mpdf('', $mode);
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mpdf->WriteHTML($stylesheet, 1);
        $mpdf->WriteHTML($this->renderPartial('application.modules.logistics/views/customer/print_customer_inventory', $param, true));
        $mpdf->Output("Inventory List"."-" . date("d-m-Y")."-" .$customer_name.".pdf", 'I');
    }

}
