<!DOCTYPE html>
<html>
<head>
    <title><?php echo date('dmYhis'); ?></title>
</head>
<body>
    <div class="">
        <div class="col-6">
                <div class="input-block">
                    <b><?php echo 'Statement of Account'; ?></b>
                </div>
                <?php 
                    $ledgerModel = FinanceLegder::model()->findBypk( (int) $ledger );
                    $subledgerModel = FinanceSubledger::model()->findBypk( (int) $subledger );
                ?>
                <br>
                <small>Statement For :</small><br>
                <b><?php echo strtoupper($subledgerModel->description); ?></b><br>
                <small><?php echo strtoupper(nl2br($subledgerModel->address)); ?></small><br>
                <small><?php echo ( $subledgerModel->phone != '' ) ? 'Phone : '.strtoupper($subledgerModel->phone) : ''; ?></small><br>
        </div>
        <div class="col-5 offset-1" style="color:#101010;">
            <div class="text-right">
                <img src="<?php echo 'images/logo/'.Yii::app()->user->pdf_company_logo; ?>" class="logo">
            </div>
            <br>
            <table class="table" style="width:100%">
                <tr>
                    <td>As on Date</td>
                    <td>
                        <?php echo $to_date;?>
                    </td>
                </tr>
                <tr>
                    <td>Ledger</td>
                    <td>
                        <?php echo $ledgerModel->description;?>
                    </td>
                </tr>
                <tr>
                    <td>Subledger #</td>
                    <td>
                        <?php echo $subledgerModel->account_no;?>
                    </td>
                </tr>
            </table>
        </div>
    </div>
    <br>
    <div class="col-md-12">
        <table id="tbl_reorder_level_table" class="table table-fixed table-bordered table-primary dataTable">
            <thead>
                <tr>
                    <th>Date</th>
                    <th>Due Date</th>
                    <th>Invoice No</th>
                    <th>Narration</th> 
                    <th class="text-right">Total</th> 
                    <th class="text-right">Balance</th>  
                </tr>
            </thead>
            <?php 
                    
                    if( $ledger == FinanceSystemAccountsMapping::getSystemdefault('debtors') ){
                        $query = 'CREATE OR REPLACE VIEW crm_finance_allocated_debit AS SELECT
                                                V.id AS voucher_id,
                                                V.voucher_date AS voucher_date,
                                                V.due_date AS due_date,
                                                V.reference_no AS reference_no,
                                                VI.narration AS narration,
                                                VI.id AS voucher_item_id,
                                                V.voucher_no, 
                                                VI.amount*V.exchange_rate AS amount,
                                                IFNULL(ABS(SUM(AI.amount)), 0) AS allocated,
                                                (VI.amount*V.exchange_rate) - IFNULL(ABS(SUM(AI.amount)), 0) AS balance
                                            FROM crm_finance_voucher_items VI
                                            LEFT JOIN crm_finance_voucher_head V ON V.id = VI.header_id
                                            LEFT JOIN crm_finance_allocation_items AI ON AI.voucher_item_id = VI.id
                                            WHERE V.is_posted ="Y" AND VI.amount > 0 AND VI.ledger_id = ' . $ledger . ' AND VI.subledger_id = ' . $subledger . '
                                            GROUP BY VI.id';
                    }else{
                        $query = 'CREATE OR REPLACE VIEW crm_finance_allocated_credit AS SELECT
                                                V.id AS voucher_id,
                                                V.voucher_date AS voucher_date,
                                                V.due_date AS due_date,
                                                V.reference_no AS reference_no,
                                                VI.narration AS narration,
                                                VI.id AS voucher_item_id,
                                                V.voucher_no, 
                                                ABS(VI.amount*V.exchange_rate) AS amount,
                                                IFNULL(ABS(SUM(AI.amount)), 0) AS allocated,
                                                ABS(VI.amount*V.exchange_rate) - IFNULL(ABS(SUM(AI.amount)), 0) AS balance
                                            FROM crm_finance_voucher_items VI
                                            LEFT JOIN crm_finance_voucher_head V ON V.id = VI.header_id
                                            LEFT JOIN crm_finance_allocation_items AI ON AI.voucher_item_id = VI.id
                                            WHERE V.is_posted ="Y" AND VI.amount < 0 AND VI.ledger_id = ' . $ledger . ' AND VI.subledger_id = ' . $subledger . '
                                            GROUP BY VI.id';
                    }

                    Yii::app()->db->createCommand( $query )->execute();

                    $selectQuery = ( $ledger == FinanceSystemAccountsMapping::getSystemdefault('debtors') ) ? 'SELECT * FROM crm_finance_allocated_debit' :'SELECT * FROM crm_finance_allocated_credit' ;
                    $items = Yii::app()->db->createCommand( $selectQuery )->queryAll();
            ?>

            <tbody>    
            <?php 
                    $totalValue = 0;
                    $balanceTotal = 0;

                    foreach ( $items as $each ){ 
                        if( $each['balance'] > 0 ) :
                            $totalValue += $each['amount'];
                            $balanceTotal += $each['balance'];
                ?>
                            <tr>      
                                <td><?php echo date("d/m/Y",strtotime($each['voucher_date'])); ?></td>
                                <td><?php echo date("d/m/Y",strtotime($each['due_date'])); ?></td>
                                <td><?php echo $each['reference_no']; ?></td>
                                <td><?php echo $each['narration']; ?></td>
                                <td class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($each['amount']," "); ?></td>
                                <td class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($each['balance']," "); ?></td>
                            </tr>
                        <?php endif; ?>
                <?php } ?>
                    <tr>
                        <td colspan="4" class="text-right"><b>Total</b></td>
                        <td  class="text-right"><b><?php echo Yii::app()->numberFormatter->formatCurrency($totalValue," "); ?></b></td>
                        <td  class="text-right"><b><?php echo Yii::app()->numberFormatter->formatCurrency($balanceTotal," "); ?></b></td>
                    </tr>
                    <!-- <tr>
                        <td><b>Outstanding</b></td>
                        <td colspan="5"><b><?php //echo FinanceLegder::baseCurrency() ?> <?php //echo ucfirst($this->widget('ext.NumtoWord.NumtoWord', array('num' => $balanceTotal ))->result) . ' only'; ?> </b></td>
                    </tr> -->
                </tbody>
            </table>
            </div>
            <br>
            
        </div>
    
    <htmlpagefooter name="myfooter">
    <div style="text-align:center;width:100%;font-size:10px"><?= Yii::app()->user->footer_autogenerated; ?>
        <?php
                  date_default_timezone_set("Asia/Dubai");
                 echo date('d/m/Y')." ".date("h:i:sa"); ?>
    </div>

    
        <div style="border-top: 1px dotted #000000; font-size: 12px; text-align: center; padding-top: 10px; background-color: #d7faeb;">
             <div style="text-align:center;width:100%">
                <b><?= Yii::app()->user->footer_line_1 ?></b><br>
                <?= Yii::app()->user->footer_line_2 ?>
            </div>
            <div style="text-align:center;width:100%">Page {PAGENO} of {nb} </div>
        </div>
    </htmlpagefooter>
</body>

</html>

