<!DOCTYPE html>
<html>
<head>
    <title><?php echo date('dmYhis'); ?></title>
</head>
<body>
    <div class="">
        <div class="col-6">
                <div class="input-block">
                    <b><?php echo 'Aging Report'; ?></b>
                </div>
                <br><br>
                <table class="table" style="width:50%">
             <tr>
                    <td>To</td>
                    <td>
                        <?php echo date('d/m/Y', strtotime($to_date));?>
                    </td>
                </tr>
                <tr>
                    <td>Ledger</td>
                    <td>
                        <?php echo FinanceLegder::model()->findBypk( (int) $ledger )->description;?>
                    </td>
                </tr>
            </table>
        </div>
        <div class="col-5 offset-1" style="color:#101010;">
            <div class="text-right">
                <img src="<?php echo 'images/logo/'.Yii::app()->user->pdf_company_logo; ?>" class="logo">
            </div>
        </div>
    </div>
    <br>
    <div class="col-md-12">
        <table class="table table-fixed table-bordered table-primary dataTable">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Subledger</th>
                    <th>0-30</th>
                    <th>31-60</th>
                    <th>61-90</th>
                    <th>91-120</th>
                    <th> > 120</th>
                    <th>Total</th>
                </tr>
            </thead>
                <?php 
                    
                   
                            
                            $one = array('from' => date('Y-m-d', strtotime($to_date . ' -30 days')), 'to' => $to_date);
                            $two = array('from' => date('Y-m-d', strtotime($to_date . ' -60 days')), 'to' => date('Y-m-d', strtotime($to_date . ' -31 days')));
                            $three = array('from' => date('Y-m-d', strtotime($to_date . ' -90 days')), 'to' => date('Y-m-d', strtotime($to_date . ' -61 days')));
                            $four = array('from' => date('Y-m-d', strtotime($to_date . ' -120 days')), 'to' => date('Y-m-d', strtotime($to_date . ' -91 days')));
                            $five = array('from' => '2010-01-01', 'to' => date('Y-m-d', strtotime($to_date . ' -121 days')));
                    
                            $dates_array = array('0_to_30' => $one, '31_to_60' => $two, '61_to_90' => $three, '91_to_120' => $four, 'greaterthan_120' => $five);
                    
                            foreach ($dates_array as $key => $each_date_pair) {
                                
                                $condition = 'V.is_posted="Y" AND VI.ledger_id = "' . (int) $ledger . '"';
                                
                                if ( $subledger > 0 ) {
                                    $condition .= 'AND VI.subledger_id = "' . (int) $subledger . '"';
                                }

                                if( $ledger == FinanceSystemAccountsMapping::getSystemdefault('debtors') ){
                                    $condition .= ' AND VI.amount > 0';
                                }else{
                                    $condition .= ' AND VI.amount < 0';
                                }
    
                                $query = 'CREATE OR REPLACE VIEW {{finance_ageing_' . $key . '}} AS SELECT
                                                       VI.ledger_id AS ledger_id,
                                                       VI.subledger_id AS subledger_id,
                                                       IFNULL(S.description, "No Subledger") AS subledger,
                                                       V.id AS voucher_id,
                                                       V.voucher_date AS voucher_date,
                                                       V.due_date AS due_date,
                                                       V.reference_no AS reference_no,
                                                       VI.narration AS narration,
                                                       VI.id AS voucher_item_id,
                                                       V.voucher_no, 
                                                       ABS(VI.amount*V.exchange_rate) AS total_amount,
                                                       IFNULL(ABS(SUM(AI.amount)), 0) AS allocated,
                                                       ABS(VI.amount*V.exchange_rate) - IFNULL(ABS(SUM(AI.amount)), 0) AS amount
                                                   FROM {{finance_voucher_items}} VI
                                                   LEFT JOIN {{finance_voucher_head}} V ON V.id = VI.header_id
                                                   LEFT JOIN {{finance_allocation_items}} AI ON AI.voucher_item_id = VI.id
                                                   LEFT JOIN {{finance_subledger}} S ON S.id = VI.subledger_id
                                                   WHERE V.voucher_date BETWEEN "' . $each_date_pair['from'] . '" AND "' . $each_date_pair['to'] . '" AND
                                                   ' . $condition . '
                                                   GROUP BY VI.id, VI.subledger_id';

                                Yii::app()->db->createCommand($query)->execute();
                            }
                       
                            $query = 'SELECT
                            ledger_id,
                            subledger_id,
                            subledger,
                            SUM(0_30) AS 0_30,
                            SUM(31_60) AS 31_60,
                            SUM(61_90) AS 61_90,
                            SUM(91_120) AS 91_120,
                            SUM(greater_120) AS greater_120
                        FROM ( SELECT
                            ledger_id,
                            subledger_id,
                            subledger,
                            SUM(amount) AS 0_30,
                            0 AS 31_60,
                            0 AS 61_90,
                            0 AS 91_120,
                            0 AS greater_120
                        FROM {{finance_ageing_0_to_30}} GROUP BY subledger_id 
                        UNION
                        SELECT
                            ledger_id,
                            subledger_id,
                            subledger,
                            0 AS 0_30,
                            SUM(amount) AS 31_60,
                            0 AS 61_90,
                            0 AS 91_120,
                            0 AS greater_120
                        FROM {{finance_ageing_31_to_60}} GROUP BY subledger_id 
                        UNION
                        SELECT
                            ledger_id,
                            subledger_id,
                            subledger,
                            0 AS 0_30,
                            0 AS 31_60,
                            SUM(amount) AS 61_90,
                            0 AS 91_120,
                            0 AS greater_120
                        FROM {{finance_ageing_61_to_90}} GROUP BY subledger_id 
                        UNION
                        SELECT
                            ledger_id,
                            subledger_id,
                            subledger,
                            0 AS 0_30,
                            0 AS 31_60,
                            0 AS 61_90,
                            SUM(amount) AS 91_120,
                            0 AS greater_120
                        FROM {{finance_ageing_91_to_120}} GROUP BY subledger_id 
                        UNION
                        SELECT
                            ledger_id,
                            subledger_id,
                            subledger,
                            0 AS 0_30,
                            0 AS 31_60,
                            0 AS 61_90,
                            0 AS 91_120,
                            SUM(amount) AS greater_120
                        FROM {{finance_ageing_greaterthan_120}} GROUP BY subledger_id ) AS A GROUP BY A.subledger_id ORDER BY A.subledger ASC';

                    $aging_report =  Yii::app()->db->createCommand($query)->queryAll();

                    $data = '<tbody>';
                    $grand_total = 0;
                    $one = 0;
                    $two = 0;
                    $three = 0;
                    $four = 0;
                    $five = 0;
                    foreach ($aging_report as $i => $each):
                        $total = $each['0_30'] + $each['31_60'] + $each['61_90'] + $each['91_120'] + $each['greater_120'];
                        $one += $each['0_30'];
                        $two += $each['31_60'];
                        $three += $each['61_90'];
                        $four += $each['91_120'];
                        $five += $each['greater_120'];
                        $grand_total += $total;
                        if( $total != 0 ) :
                            $data .= '<tr>
                                            <td>' . ($i + 1) . '</td>
                                            <td>' . $each['subledger'] . '</td>
                                            <td class="text-right">' . Yii::app()->numberFormatter->formatCurrency(abs($each['0_30']), " ")  . '</td>
                                            <td class="text-right">' . Yii::app()->numberFormatter->formatCurrency(abs($each['31_60']), " ") . '</td>
                                            <td class="text-right">' . Yii::app()->numberFormatter->formatCurrency(abs($each['61_90']), " ")  . '</td>
                                            <td class="text-right">' . Yii::app()->numberFormatter->formatCurrency(abs($each['91_120']), " ")  . '</td>
                                            <td class="text-right">' . Yii::app()->numberFormatter->formatCurrency(abs($each['greater_120']), " ")  . '</td>
                                            <td class="text-right">' . Yii::app()->numberFormatter->formatCurrency(abs($total), " ") . '</td>
                                        </tr>';
                        endif;
                    endforeach;
            
                    $data .= '<tr>
                                                        <td colspan="2" class="text-right"><b>Total</b></td>
                                                        <td class="text-right"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($one), " ") . '</b></td>
                                                        <td class="text-right"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($two), " ") . '</b></td>
                                                        <td class="text-right"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($three), " ") . '</b></td>
                                                        <td class="text-right"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($four), " ") . '</b></td>
                                                        <td class="text-right"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($five), " ") . '</b></td>
                                                        <td class="text-right"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($grand_total), " ") . '</b></td>
                                                    </tr>';
                    $data .= ' </tbody>';

                    echo $data;
            
               ?>
            </table>
            </div>
    
    <htmlpagefooter name="myfooter">
    <div style="text-align:center;width:100%;font-size:10px"><?= Yii::app()->user->footer_autogenerated; ?>
        <?php
                  date_default_timezone_set("Asia/Dubai");
                 echo date('d/m/Y')." ".date("h:i:sa"); ?>
    </div>

    
        <div style="border-top: 1px dotted #000000; font-size: 12px; text-align: center; padding-top: 10px; background-color: #d7faeb;">
             <div style="text-align:center;width:100%">
                <b><?= Yii::app()->user->footer_line_1 ?></b><br>
                <?= Yii::app()->user->footer_line_2 ?>
            </div>
            <div style="text-align:center;width:100%">Page {PAGENO} of {nb} </div>
        </div>
    </htmlpagefooter>
</body>

</html>

