<script src="js/jquery.aCollapTable.js"></script>

<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("loadPage", "function loadPage(){
                $('#loader').show();
                jQuery.ajax({
                    'type': 'post',
                    'url': '" . Yii::app()->createUrl('finance/reports/statement_html') . "',
                    'data' : { 'ledger_id' : $('#ledger_id').val(), 'from' : $('#fn_report_from').val(), 'to' : $('#fn_report_to').val(), 'subledger_id' : $('#subledger_id').val(), 'currency' : $('#currency').val(), 'type' : '".$type."' },
                    'success': function(data) {
                        $('#data_div').show();
                        $('#statement_detailed_li').hide();
                        $('#statement_detailed').empty();
                        $('#statement_li').show();
                        $('#statement_li').addClass('active');
                        $('#statement_tab').addClass('active');
                        $('#gl_table').html(data);
                        $('#loader').hide();
                    }
                });
        }", CClientScript::POS_HEAD);
        $cs->registerScript("getSublegders", "function getSublegders(field_id)
        {
           account_id = $('#ledger_id').val();
           $('#subledger_id').val(0);
           if( account_id > 0 ){
                var url = '" . Yii::app()->createUrl('finance/vouchers/subledgerlist') . "&ledger='+account_id;
                $('#'+field_id).autocomplete({
                    minLength   : 1,
                    source      : function (request, response) { autoCompleteSource(request, response, url) },
                    focus       : function( event, ui ) {},
                    select          : function( event, ui ) {
                        event.preventDefault();
                        $('#subledger_name').val(ui.item.label);
                        $('#subledger_id').val(ui.item.value);
                    }
                })
            }else{
                t8.error('Choose Ledger First!');
                $('#subledger_name').val('');
                return false;
            }
        }", CClientScript::POS_HEAD); 
        
?>

<style>
table {
  font-family: arial, sans-serif !important;
  border-collapse: collapse !important;
  width: 100% !important;
  font-size: 12px;
}

td, th {
  border: 1px solid #dddddd !important;
  text-align: left !important;
  padding: 8px !important;
}

table th{
	padding-top: 12px;
    padding-bottom: 12px;
    text-align: left;
    background-color: #1f67b2;
    color: white;
}

tr:nth-child(even) {
  background-color: #f2f2f2 !important;
}
</style>
<div class="row">
    <div class="col-sm-12">
        <section class="panel">
            <header class="panel-heading clearfix">
                <ul class="clearfix form-ul material">
<!--                    <li class="col-sm-2">
                        <?php //echo CHtml::textField('fn_report_from', date('d/m/Y'), array('class' => 'datepicker tooltipster', 'data-label' => 'From')); ?>
                    </li>-->
                    <li class="col-sm-2">
                        <?php echo CHtml::textField('fn_report_to', date('d/m/Y'), array('class' => 'datepicker tooltipster', 'data-label' => 'To')); ?>
                    </li>
                    <li class="col-sm-6">
                        <?php echo CHtml::hiddenfield("ledger_id", $ledger_id ); ?>
                        <?php
                        $display='none';
                        if($customer_id>0)
                        {
                        $subledger=FinanceSubledger::model()->find(array('condition'=>'subledger_type_id=1 AND parent_id='.$customer_id));    
                        $subledger_id=$subledger->id;
                        $subledger_name=$subledger->description;
                        $display='block';
                        $from_date = date('Y-m-01');
                        $to_date = date('Y-m-d');

        $currency = 1;
        $cur=MasCurrency::model()->findByPk($currency);
        $exchange_rate=1;
        $currency_code=$cur->currency_code;
            $amountType = 'VI.amount > 0';
            $paidType = 'VI.amount < 0';

        function generateUrl($childModel)
        {
            $url = '#';
            $code = $childModel->parent->vtype->code;
            if ($code == 'SI') {
                $headModel = $childModel->parent->vtype->header_table;
                $vat_field = $childModel->parent->vtype->vat_value;
                $inv = $headModel::model()->findBypk($childModel->parent->header_table_id);
                $tax=$inv->$vat_field;
                $taxType = ($tax > 0) ? 'tax' : 'taxnil';
                $hire = $inv->invoice_nature=='H' ? '&hiring=Y' : '';
                $url = "window.open($('#liveSite').val()+'index.php?r=invoice/PrintInvoiceReportPDF&id=" . $childModel->parent->header_table_id .$hire."&frm=" . $taxType . "&type=1', '_blank');";
            } else if ($code == 'PI') {
                $url = "window.open($('#liveSite').val()+'index.php?r=purchaseinvoice/PrintInvoiceReportPDF&id=" . $childModel->parent->header_table_id . "', '_blank');";
            } else if ($code == 'DN') {
                $url = "window.open($('#liveSite').val()+'index.php?r=debitnote/printfile&id=" . $childModel->parent->header_table_id . "', '_blank');";
            } else if ($code == 'CN') {
                $url = "window.open($('#liveSite').val()+'index.php?r=creditnote/printfile&id=" . $childModel->parent->header_table_id . "', '_blank');";
            } else {
                $url = "window.open($('#liveSite').val()+'index.php?r=finance/core/print&id=" . $childModel->header_id . "', '_blank');";
            }
            return $url;
        }

        $items = array();
        $table = '<table class="table table-hover table-fixed table-bordered" id="gl_table">
                    <thead>
                        <tr>
                            <th style="width:10%">Date</th>
                            <th style="width:10%">Invoice No</th>
                            <th style="width:10%">Due Date</th>
                            <th style="width:10%">Invoice value</th>
                            <th style="width:10%">Paid</th>
                            <th style="width:10%">Balance</th>
                            <th style="width:10%">Activity</th>
                        </tr>
                    </thead>
                    <tbody>';
    $query = 'CREATE OR REPLACE VIEW {{finance_statement}} AS (SELECT
    V.id AS voucher_id,
    V.voucher_date AS voucher_date,
    V.due_date AS due_date,
    V.reference_no AS reference_no,
    VI.narration AS narration,
    VI.id AS voucher_item_id,
    V.voucher_no,
    ROUND(ABS(VI.amount*VI.exchange_rate), 4) AS amount,
    ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 4) AS allocated,
    ROUND(ABS(VI.amount*VI.exchange_rate), 4) - ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 4) AS balance
FROM {{finance_voucher_items}} VI
LEFT JOIN {{finance_voucher_head}} V ON V.id = VI.header_id
LEFT JOIN {{finance_allocation_items}} AI ON AI.voucher_item_id = VI.id
WHERE V.is_posted ="Y" AND V.voucher_date<="'.$to_date.'"  AND ' . $amountType . ' AND VI.ledger_id = ' . $ledger_id . ' AND VI.subledger_id = ' . $subledger_id . '
GROUP BY VI.id)
UNION
(SELECT
    V.id AS voucher_id,
    V.voucher_date AS voucher_date,
    V.due_date AS due_date,
    V.reference_no AS reference_no,
    VI.narration AS narration,
    VI.id AS voucher_item_id,
    V.voucher_no,
    -(ROUND(ABS(VI.amount*VI.exchange_rate), 4)) AS amount,
    -(ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 4)) AS allocated,
    -(ROUND(ABS(VI.amount*VI.exchange_rate), 4) - ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 4)) AS balance
FROM {{finance_voucher_items}} VI
LEFT JOIN {{finance_voucher_head}} V ON V.id = VI.header_id
LEFT JOIN {{finance_allocation_items}} AI ON AI.voucher_item_id = VI.id
WHERE V.is_posted ="Y" AND V.voucher_date>="'.$from_date.'" AND V.voucher_date<="'.$to_date.'"  AND ' . $paidType . ' AND VI.ledger_id = ' . $ledger_id . ' AND VI.subledger_id = ' . $subledger_id . '
GROUP BY VI.id)';
        if ($ledger_id > 0 && $subledger_id > 0) {
            Yii::app()->db->createCommand($query)->execute();
            $items = Yii::app()->db->createCommand('SELECT * FROM {{finance_statement}} order by voucher_date')->queryAll();
        }
        $amount=0;
        $allocated=0;
        $balanced=0;
//        $table .= '<tr>
//                            <td colspan="3">Opening Balance</td>
//                            <td style="text-align:right !important;">'.$currency_code . Yii::app()->numberFormatter->formatCurrency(($opening_bal/$exchange_rate), " ") . '</td>
//                            <td style="text-align:right !important;">'.$currency_code . Yii::app()->numberFormatter->formatCurrency((0/$exchange_rate), " ") . '</td>
//                            <td style="text-align:right !important;">'.$currency_code . Yii::app()->numberFormatter->formatCurrency(($opening_bal/$exchange_rate), " ") . '</td>
//                        </tr>';
        $amount+=$opening_bal;
        $allocated+=0;
        $balanced+=$opening_bal;
        if (!empty($items)) {
            foreach ($items as $each) {
                if(round($each['balance'],2)!=0)
                {
                if ($_POST['type'] == 'customer') {
                $vouchreformat = '<a href="#" onclick="' . generateUrl(FinanceVoucherItems::model()->findBypk((int) $each['voucher_item_id'])) . '">' . $each['voucher_no'] . '</a>';
                }
                else {
                $head=FinanceVoucherHead::model()->findByPk($each['voucher_id']);
                if($head->voucher_type==8)
                {
                $ref=PurchasingInvoice::model()->findByPk($head->voucher_no)->invoice_no;    
                }
                else {
                $ref=$each['reference_no'];    
                }
                if(empty($ref))
                {
                $ref=$head->voucher_no;    
                }
                $vouchreformat = '<a href="#" onclick="' . generateUrl(FinanceVoucherItems::model()->findBypk((int) $each['voucher_item_id'])) . '">' . $ref . '</a>';
                }
                $childMod=FinanceVoucherItems::model()->findBypk((int) $each['voucher_item_id']);
                $code = $childMod->parent->vtype->code;
            if ($code == 'SI') {
                $inv = Invoice::model()->findBypk($childMod->parent->header_table_id);
                $file_id=$inv->file_id;
                $contact_id=$inv->contact_id;
            }
                $table .= '<tr>
                            <td>' . date("d/m/Y", strtotime($each['voucher_date'])) . '</td>
                            <td>' . $vouchreformat . '</td>
                            <td>' . date("d/m/Y", strtotime($each['due_date'])) . '</td>
                            <td style="text-align:right !important;">'.$currency_code . Yii::app()->numberFormatter->formatCurrency(($each['amount']/$exchange_rate), " ") . '</td>
                            <td style="text-align:right !important;">'.$currency_code . Yii::app()->numberFormatter->formatCurrency(($each['allocated']/$exchange_rate), " ") . '</td>
                            <td style="text-align:right !important;">'.$currency_code . Yii::app()->numberFormatter->formatCurrency(($each['balance']/$exchange_rate), " ") . '</td>
                            <td style="text-align:right !important;"><a onclick="loadPopupModal(\'logistics/activity/create&frm=C&customer_id='.$customer_id.'&file_id='.$file_id.'&contact_id='.$contact_id.'\','.'\'Activities\' ,\'lg\');">Activity'.'</a></td>
                        </tr>';
                        $amount+=$each['amount']/$exchange_rate;
                        $allocated+=$each['allocated']/$exchange_rate;
                        $balanced+=$each['balance']/$exchange_rate;
                }
            }
            $table .= '<tr>
                            <td colspan="3"></td>
                            <td style="text-align:right !important;">'.$currency_code . Yii::app()->numberFormatter->formatCurrency(($amount/$exchange_rate), " ") . '</td>
                            <td style="text-align:right !important;">'.$currency_code . Yii::app()->numberFormatter->formatCurrency(($allocated/$exchange_rate), " ") . '</td>
                            <td style="text-align:right !important;">'.$currency_code . Yii::app()->numberFormatter->formatCurrency(($balanced/$exchange_rate), " ") . '</td><td></td>
                        </tr>';
        } else {
            $table .= '<tr>
                            <td colspan="7" style="text-align:center !important;">No Data</td>
                      </tr>';
        }
                        }
                        else {
                        $table = '<table class="table table-hover table-fixed table-bordered" id="gl_table">
                    <thead>
                        <tr>
                            <th style="width:10%">Date</th>
                            <th style="width:10%">Invoice No</th>
                            <th style="width:10%">Due Date</th>
                            <th style="width:10%">Invoice value</th>
                            <th style="width:10%">Paid</th>
                            <th style="width:10%">Balance</th>
                            <th style="width:10%">Activity</th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                    </table>';    
                        }
                        ?>
                        <?php echo CHtml::hiddenField("subledger_id",$subledger_id); ?>
                        <?php echo CHtml::textField("subledger_name",$subledger_name, array('data-label' => Ucfirst($type), 'class' => 'tooltipster', 'onKeyup' => 'js:getSublegders(this.id);')); ?>
                    </li>
<!--                    <li class="col-sm-2">
                    <?php 
                    //echo CHtml::dropDownList("currency","",MasCurrency::getCurrency(), array('class' => 'tooltipster', 'title' => 'Currency', 'data-label' => 'Currency', 'value' => MasCurrency::base_currency_id()));
                    ?> 
            </li>-->
                    <div class="btn-wrap text-center">
                        <a type="button" class="btn btn-theme" onclick="loadPage();">HTML</a>
                        <!-- <a type="button" class="btn btn-theme" onclick="loadPopupModal('finance/reports/statement_pdf_filter&ledger_id='+$('#ledger_id').val()+'&subledger_id='+$('#subledger_id').val()+'&type=<?php echo $type ?>','Layout','sm')">PDF</a> -->
                        <a type="button" class="btn btn-theme" onclick="window.open($('#liveSite').val()+'index.php?r=finance/reports/statement_pdf&layout=1&from='+$('#fn_report_from').val()+'&to='+$('#fn_report_to').val()+'&ledger_id='+$('#ledger_id').val()+'&subledger_id='+$('#subledger_id').val()+'&currency='+$('#currency').val()+'&type=<?php echo $type ?>', '_blank');">Pdf</a>
                        <a type="button" class="btn btn-theme" onclick="window.open($('#liveSite').val()+'index.php?r=finance/reports/statement_excel&from='+$('#fn_report_from').val()+'&to='+$('#fn_report_to').val()+'&ledger_id='+$('#ledger_id').val()+'&subledger_id='+$('#subledger_id').val()+'&currency='+$('#currency').val()+'&type=<?php echo $type ?>', '_blank');">XLS</a>
                    </div>
                </ul>
            </header>
            <div class="panel-body" id="data_div" style="display:<?php echo $display; ?>;" >
               <?php
               echo $table;
               ?>
            </div>
        </section>
    </div>
</div>
