<script src="js/jquery.aCollapTable.js"></script>

<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("loadPage", "function loadPage(){
                $('#loader').show();
                jQuery.ajax({
                    'type': 'post',
                    'url': '" . Yii::app()->createUrl('finance/reports/aging_html') . "',
                    'data' : { 'ledger_id' : $('#ledger_id').val(),'subledger_id' : $('#subledger_id').val(), 'to' : $('#fn_report_to').val(), 'brand' : 0, 'category' : $('#category').val(),
                                'salesman_id': $('#salesman_id').val()

                    },
                    'success': function(data) {
                        $('#data_div').show();
                        $('#aging_detailed_li').hide();
                        $('#aging_detailed').empty();
                        $('#aging_li').show();
                        $('#aging_li').addClass('active');
                        $('#aging_tab').addClass('active');
                        $('#aging_tab').html(data);
                        $('#loader').hide();
                    }
                });
        }", CClientScript::POS_HEAD);
$cs->registerScript("loadVouchers", "function loadVouchers(ledger_id, subledger_id, tail, mode){
            $('#loader').show();
            jQuery.ajax({
                'type': 'post',
                'url': '" . Yii::app()->createUrl('finance/reports/aging_vouchers_html') . "',
                'data' : { 'ledger_id' : ledger_id, 'subledger_id' : subledger_id, 'tail' : tail, 'mode' : mode },
                'success': function(data) {
                    $('#aging_detailed_li').show();
                    $('#aging_detailed').html(data);
                    $('#aging_li').removeClass('active');
                    $('#aging_tab').removeClass('active');
                    $('#aging_detailed_li').addClass('active');
                    $('#aging_detailed').addClass('active');
                    $('#loader').hide();
                    return false;
                }
            });
        }", CClientScript::POS_HEAD);

$cs->registerScript("getSublegders", "function getSublegders(field_id)
        {
           account_id = $('#ledger_id').val();
           $('#subledger_id').val(0);
           if( account_id > 0 ){
                var url = '" . Yii::app()->createUrl('finance/vouchers/subledgerlist') . "&ledger='+account_id;
                $('#'+field_id).autocomplete({
                    minLength   : 1,
                    source      : function (request, response) { autoCompleteSource(request, response, url) },
                    focus       : function( event, ui ) {},
                    select          : function( event, ui ) {
                        event.preventDefault();
                        $('#subledger_name').val(ui.item.label);
                        $('#subledger_id').val(ui.item.value);
                    }
                })
            }else{
                t8.error('Choose Ledger First!');
                $('#subledger_name').val('');
                return false;
            }
        }", CClientScript::POS_HEAD);
?>

<style>
    table {
        font-family: arial, sans-serif !important;
        border-collapse: collapse !important;
        width: 100% !important;
        font-size: 12px;
    }

    td, th {
        border: 1px solid #dddddd !important;
        text-align: left !important;
        padding: 8px !important;
    }

    table th{
        padding-top: 12px;
        padding-bottom: 12px;
        text-align: left;
        background-color: #1f67b2;
        color: white;
    }

    tr:nth-child(even) {
        background-color: #f2f2f2 !important;
    }
</style>
<div class="row">
    <div class="col-sm-12">
        <section class="panel">
            <header class="panel-heading clearfix">
                <ul class="clearfix form-ul material">
                    <li class="col-sm-2">
                        <?php echo CHtml::textField('fn_report_to', date('d/m/Y'), array('class' => 'datepicker tooltipster', 'data-label' => 'To')); ?>
                    </li>
                    <li class="col-sm-3">
                        <?php echo CHtml::dropdownlist("ledger_id", '', $filter_array, array('class' => 'tooltipster', 'data-label' => 'Ledgers', 'data-search' => true)); //getAll   ?>
                        <?php echo CHtml::hiddenfield("category", $category); ?>
                    </li>

                    <li class="col-sm-2">
                        <?php echo CHtml::hiddenField("subledger_id"); ?>
                        <?php echo CHtml::textField("subledger_name", '', array('data-label' => 'Subledger', 'class' => 'tooltipster', 'onKeyup' => 'js:getSublegders(this.id);', 'data-label' => 'Sub ledger')); ?>
                    </li>
                    <li class="col-sm-2">
                        <?php
                        if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["view_all_users_finance"] )) {
                            echo CHtml::dropDownList('salesman_id', Yii::app()->user->id, User::getLeadOwners(), array('class' => 'tooltipster', 'data-label' => 'Salesman', 'data-search' => 'true', 'empty' => 'Select'));
                        } else {
                            //echo CHtml::dropDownList('provisional_leadowner_id', Yii::app()->user->id, User::getLeadOwners(Yii::app()->user->id), array('class' => 'tooltipster', 'data-label' => 'Lead Owner', 'data-search' => 'true'));
                        
                            echo CHtml::dropDownList('salesman_id', Yii::app()->user->id, User::getLeadOwners(Yii::app()->user->id), array('class' => 'tooltipster', 'data-label' => 'Lead Owner', 'data-search' => 'true'));

                        }
                        ?>
                    </li>

                    <div class="btn-wrap text-center">
                        <a type="button" class="btn btn-theme" onclick="loadPage();">HTML</a>
                        <a type="button" class="btn btn-theme" onclick="window.open($('#liveSite').val() + 'index.php?r=finance/reports/aging_pdf&to_date=' + $('#fn_report_to').val() + '&ledger=' + $('#ledger_id').val() + '&subledger_id=' + $('#subledger_id').val() + '&brand=' + $('#brand_id').val() + '&category=' + $('#category').val() + '&salesman_id=' + $('#salesman_id').val(), '_blank');">PDF</a>
                        <a type="button" class="btn btn-theme" onclick="window.open($('#liveSite').val() + 'index.php?r=finance/reports/aging_excel&to_date=' + $('#fn_report_to').val() + '&ledger=' + $('#ledger_id').val() + '&subledger_id=' + $('#subledger_id').val() + '&brand=' + $('#brand_id').val() + '&category=' + $('#category').val() + '&salesman_id=' + $('#salesman_id').val(), '_blank');">XLS</a>
                    </div>
                </ul>
            </header>
            <div class="panel-body" id="data_div" style="display:none;" >
                <ul class="nav nav-tabs company-nav-tabs nav-tab-theme">
                    <li id="aging_li" style="display:none;"><a href="#aging_tab" data-toggle="tab" ><?php echo ucfirst(strtolower($category)); ?> Aging </a></li>
                    <li id="aging_detailed_li" style="display:none;"><a href="#aging_detailed" data-toggle="tab" >Vouchers <i onclick="$('#aging_li').addClass('active'); $('#aging_tab').addClass('active');  $('#aging_detailed_li').hide();$('#aging_detailed').empty();" class="fa fa-remove"></i></a></li>
                </ul>
                <div class="tab-content">
                    <div class="tab-pane" id="aging_tab">
                    </div>
                    <div class="tab-pane" id="aging_detailed">
                    </div>
                </div>
            </div>
        </section>
    </div>
</div>
