
<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("updatevoucher", "function updatevoucher(id, type){
    var r = confirm('Are you sure?');
    if(r==true)
        jQuery.ajax({
            'type'  : 'post',
            'data'  : {'id' : id, 'type' : type},
            'url'  : $('#liveSite').val()+'index.php?r=finance/vouchers/updatevoucher',
            'cache': false,
            'success':function(data){
                if(data=='success'){
                    t8.success('Done!');
                    reloadTable('#fin_voucher_table');
                }else{
                    t8.error(data);
                }
            }
        });
};", CClientScript::POS_HEAD);

$cs->registerScript("load",
    '$(document).ready(function() {
                    var table_id ="#fin_voucher_table";
                    var table = $(table_id).on("preXhr.dt", function (e, settings, data) {
                        data.from_date = $("#start_date").val();
                        data.to_date = $("#end_date").val();
                        data.voucher_type = $("#voucher_type").val();
                        data.posting_type = $("#posting_type").val();
                        data.amounts = $("#amounts").val();
                        return data;
                    }).DataTable({
                    scrollY         : "1000px",
                    pageLength      : 100,
                    columns: [
                        {className: "nw sl col-max-1"},
                        {className: "nw sl col-max-1"},
                        {className: "nw sl col-max-3"},
                        {className: "nw sl col-max-5"},
                        {className: "nw sl col-max-1"},
                        {className: "nw sl col-max-1 text-right"},
                        {className: "nw sl col-max-3 text-right"},
                        {className: "nw sl col-max-1"},
                        {className: "nw sl col-max-1"},
                    ],
                    ajax: {
                        url: "' . Yii::app()->createUrl('finance/core/getvouchers') . '",
                        type: "POST",
                        cache : false,
                    },
                    "columnDefs": [
                        {
                           "targets": [7],
                           "visible": false,
                        }
                    ],
                    "rowCallback": function ( row, data ){
                        if ( data[7] == "Yes" ){
                            $("td", row).css("background-color", "#e4ffce");
                        }
                    },
                    serverSide:     true,
                    fixedColumns:   true,
                    processing: true,
                    order: [[ 6, "desc"],[ 6, "desc"]],
                });
            });', CClientScript::POS_HEAD);

?>
    <section class="panel" style="background-color:#F6F3EE;">
        <header class="panel-heading clearfix panel-theame">
            <?php if( Yii::app()->user->authorised_user == 1 || (int) Yii::app()->user->havePermissionOn["finance_voucher_add"] ) : ?>
                <button class="btn btn-sm btn-theme" title="Add new voucher" onclick="loadPopupModal('finance/vouchers/create','New Voucher','xl')"><i class="fa fa-file"></i> New</button>
            <?php endif; ?>
            <?php if( Yii::app()->user->authorised_user == 1 || (int) Yii::app()->user->havePermissionOn["finance_voucher_import"] ) : ?>
                <button class="btn btn-sm btn-theme" title="Import Vouchers" onclick="loadPopupModal('finance/core/importvouchers','Import','xl')"><i class="fa fa-download"></i> Import</button>
            <?php endif; ?>
            <?php if( Yii::app()->user->authorised_user == 1 || (int) Yii::app()->user->havePermissionOn["finance_post_voucher"] || (int) Yii::app()->user->havePermissionOn["finance_unpost_voucher"]  ) : ?>
                <!--<button class="btn btn-sm btn-theme" title="Bulk post/unpost" onclick="loadPopupModal('finance/core/post_unpost','Bulk Post & Unpost vouchers','lg')"><i class="fa fa-send"></i> Bulk Post & Unpost</button>-->
            <?php endif; ?>
           <?php if( Yii::app()->user->authorised_user == 1 || (int) Yii::app()->user->havePermissionOn["finance_voucher_add"] ) : ?>
                <button class="btn btn-sm btn-theme" title="Add new payment" onclick="loadPopupModal('finance/vouchers/add_payment','New Payment','lg')"><i class="fa fa-file"></i> Add Payment</button>
            <?php endif; ?>
            <?php if( Yii::app()->user->authorised_user == 1 || (int) Yii::app()->user->havePermissionOn["finance_voucher_add"] ) : ?>
                <button class="btn btn-sm btn-theme" title="Add new receipt" onclick="loadPopupModal('finance/vouchers/add_receipt','New Receipt','lg')"><i class="fa fa-file"></i> Add Receipt</button>
            <?php endif; ?>    
            <div class="pull-right" style="display: flex;">
                <?php echo CHtml::textfield('start_date', date('01/m/Y'), array('class' => 'datepicker form-control', 'style' => 'margin-right:10px; width:120px;')); ?>
                <?php echo CHtml::textfield('end_date', date('d/m/Y'), array('class' => 'datepicker form-control', 'style' => 'margin-right:10px; width:120px;')); ?>
                <button class="btn btn-sm btn-theme" style="margin-right: 10px;" title="Reload" onclick="reloadTable('#fin_voucher_table');"><i class="fa fa-retweet"></i></button>
                <?php echo CHtml::dropdownlist('voucher_type', '', FinanceVoucherType::getTypes(true), array('class' => 'form-control', 'onchange' => 'reloadTable("#fin_voucher_table");', 'prompt' => 'All Vouchers')); ?>
                <?php echo CHtml::dropdownlist('posting_type', '', array('Y' => 'Posted', 'N' => 'Unposted'), array('class' => 'form-control', 'onchange' => 'reloadTable("#fin_voucher_table");', 'prompt' => 'All Types')); ?>
                <?php echo CHtml::textfield('amounts','', array('class' => 'form-control', 'style' => 'margin-right:10px; width:120px;','placeholder'=>'Amount','title'=>'Amount','onkeypress' => 'return isNumberKey(event);')); ?>
                <!-- &nbsp;<a type="button" title="Export Excel" class="btn btn-sm btn-theme" onclick="window.open($('#liveSite').val()+'index.php?r=finance/core/export_vouchers&from_date='+$('#start_date').val()+'&to_date='+$('#end_date').val()+'&voucher_type='+$('#voucher_type').val()+'&posting_type='+$('#posting_type').val(), '_blank');">XLS</a> -->
                &nbsp;<a type="button" title="Export Excel" class="btn btn-sm btn-theme" onclick="loadPopupModal('finance/core/print_vouchers&from_date='+$('#start_date').val()+'&to_date='+$('#end_date').val()+'&voucher_type='+$('#voucher_type').val()+'&posting_type='+$('#posting_type').val(),'Print','sm');">Export</a>
            </div>
        </header>
        <div class="panel-body">
            <div class="custom-data-table">
                <table class="table table-hover table-bordered personal-task" id="fin_voucher_table" style="font-size:13px;">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Date</th>
                            <th>Ledgers</th>
                            <th>Subledgers</th>
                            <th>Reference</th>
                            <!-- <th>Curr</th> -->
                            <!-- <th>PO</th> -->
                             <th>Amount</th>
                             <th>Created</th>
                            <th>AL</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
    </section>
