<?php

/**
 * This is the model class for table "{{finance_subledger}}".
 *
 * The followings are the available columns in table '{{finance_subledger}}':
 * @property integer $id
 * @property string $description
 * @property string $account_no
 * @property integer $subledger_type_id
 * @property integer $parent_id
 */
class FinanceSubledger extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{finance_subledger}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('description, account_no, subledger_type_id', 'required'),
			array('subledger_type_id, parent_id', 'numerical', 'integerOnly'=>true),
			array('description', 'length', 'max'=>255),
			array('account_no', 'length', 'max'=>20),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, description, account_no, subledger_type_id, parent_id', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		    'subledgertype'=>array(self::BELONGS_TO, 'FinanceSubledgerType', 'subledger_type_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'description' => 'Description',
			'account_no' => 'Account No',
			'subledger_type_id' => 'Subledger Type',
			'parent_id' => 'Parent',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('description',$this->description,true);
		$criteria->compare('account_no',$this->account_no,true);
		$criteria->compare('subledger_type_id',$this->subledger_type_id);
		$criteria->compare('parent_id',$this->parent_id);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return FinanceSubledger the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	public static function getSubledgers( $account_id ){
		$arr_data = array();
		if( $account_id > 0 ){
			$accounts = FinanceLegder::model()->findbyPk($account_id);
			if( $accounts->subledger_types != '' && $accounts->haveSubledger == 'Y' ){
				$model = self::model()->findAll(array( 'condition' => 'subledger_type_id IN ('.$accounts->subledger_types.')'));
				$arr_data =  CHtml::listData($model, 'id', 'description');
			}
		}
		return $arr_data;
	}
	public function related_ledgers(){
		$query = 'SELECT GROUP_CONCAT(description SEPARATOR "<br>") AS parents FROM {{finance_legder}} WHERE FIND_IN_SET('.$this->subledger_type_id.', subledger_types)';
		$response = Yii::app()->db->createCommand($query)->queryAll();
		return $response[0]['parents'];
	}
        
	public static function getEmployeeSubledgers(){
		$arr_data = array();
		$model = self::model()->findAll(array( 'condition' => 'subledger_type_id=3'));
		$arr_data =  CHtml::listData($model, 'id', 'description');
		return $arr_data;
	}
}
