<?php

class VendorController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login' ,'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index','CreateNote','SaveNote','create','getNotesList','SaveEditedVendor','CreateVendorEdit', 'GetList', 'SaveVendor', 'GetContactList', 'VendorContactCreate', 'SaveContact', 'DeleteContact', 'DeleteVendor','GetCurrency','getVendorCurrency',
                    'GetCustomer', 'GetCustomerActivity','GetVendor','addSubledger','UploadSupplierDocuments','CreateDocumentForm','SaveDocForm','GetDocsList',
                    'DownloadDocument','CheckTrnExistance','GetVendorByType','GetVendorVolumeWeight','GetVendorActivityType'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    /**
     * This is the default 'index' action that is invoked
     * when an action is not explicitly requested by users.
     */
    public function actionIndex() {
        $model = new Vendor();
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('index');
    }

    /*
     * function to list all vendors
     * 
     */

    public function actiongetList() {
        $model = new Vendor();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'vendor_name',
            2 => 'vendor_location',
            3 => 'vendor_country',
            4 => 'vendor_phone_no',
            5 => 'vendor_email_id',
            6 => 'vendor_city',
            7 => 'vendor_trn_no'
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
         $condition = '1=1';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            //$condition.=" AND (vendor_name LIKE '%" . $searchString . "%' OR vendor_location LIKE '%" . $searchString . "%' OR vendor_city LIKE '%" . $searchString . "%' OR vendor_phone_no LIKE '%" . $searchString . "% OR vendor_email_id LIKE '%" . $searchString . "% OR vendor_trn_no LIKE '%" . $searchString . "%')";

            $condition.=" AND (vendor_name LIKE '%" . $searchString . "%' OR vendor_city LIKE '%" . $searchString . "%' OR vendor_phone_no LIKE '%" . $searchString . "%' OR vendor_email_id LIKE '%" . $searchString . "%' OR vendor_trn_no LIKE '%" . $searchString . "%' OR vendor_location LIKE '%" . $searchString . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 'isActive,vendor_name'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        foreach ($model as $row) {
                     
            //$rowData[] = array($row['id'], $row['vendor_name'], $row['vendor_address'], $row['vendor_location'], $row['vendor_country'],$row['vendor_phone_no'], $row['vendor_email_id'], '<div class="btn-wrap text-center"><button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'vendor/createVendorEdit&id='.$row['id'].'\',\'Edit Vendor\',\'lg\')"><i class="fa fa-pencil"></i></button></div>');
            $rowData[] = array($row['id'],
                $row['vendor_name'],
                
                $row['country']['country_name'],
                $row['vendor_phone_no'],
                $row['vendor_email_id'],
                $row['vendor_trn_no'],
                '<div class="btn-wrap text-center"><button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'logistics/vendor/create&id='.$row['id'].'\',\'Edit Vendor\',\'lg\')"><i class="fa fa-pencil"></i></button></div>',
                $row['isActive'],
            array('id' => $row['id'],'code'=>$row['vendor_name']));
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
     public function actiongetNotesList() {
        $model = new FileNotes();
        $vendor_id = $_POST['vendor_id'];
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'notes',
          
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.customer_vendor_id=' . $vendor_id . ' AND t.customer_vendor_type = 2';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition.=" AND (notes LIKE '%" . $searchString . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 'created_datetime DESC'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $model2 = User::model()->find(array('condition'=>'t.id = "'.$row['created_by'].'"'));
            $rowData[] = array($m, $row['notes'],$model2->username,date("d/m/Y h:m:s",strtotime($row['created_datetime'])));
            $m++;
            
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }


    /*
     * function to create vendor details
     */

    public function actionCreate() {
        $model = new Vendor();
        $models = new VendorContact();
        $modelnote = new FileNotes();
        $modeldoc = new SupplierDocs();
        $id = (int) Yii::app()->request->getParam('id');

        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
        $this->render('vendor_form', array('model' => $model, 'models' => $models,'modelnote' => $modelnote,'modeldoc'=>$modeldoc));
    }
    
   public function actionCreateNote() {
        
        $model = new Vendor();
        $modelnote = new FileNotes();
        $id = (int) Yii::app()->request->getParam('id');

        if ($id > 0) {
            $model= $model->findByPk($id);
            $var = $model->id;
        }

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
        $this->render('notes_details_2', array('model' => $model,'modelnote' => $modelnote,'var' => $var));
    }

    /*
     * function to create vendor contact using modal pop up
     */

    public function actionVendorContactCreate() {

        $models = new VendorContact();
        $id = (int) Yii::app()->request->getParam('id');
        $vendor_id = (int) Yii::app()->request->getParam('c_id');
        if ($id > 0) {
            $models = $models->findByPk($id);
        }

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
        $this->render('contact_form_2', array('models' => $models, 'v_id' => $id,'c_id' => $vendor_id));
    }

    /*
     * function to save vendor details
     */

    function actionSaveVendor() {
       
        $model = new Vendor();
        $modelcontact = new VendorContact();
        $modelnote = new FileNotes();
         $modeldoc = new SupplierDocs();
        /*         * ********** START Code for Save ************** */
        if (isset($_POST['Vendor'])) {

            if ($_POST['Vendor']['id'] > 0) {
                $scene = 'update';
                $id =  $_POST['Vendor']['id'];
                $model = $model->findByPK($id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time =date('Y-m-d h:i:s');
                $audit_type = 'UPDATED';
            } else {
                $audit_type = 'CREATED';
               // $model->crm_user_id = Yii::app()->user->id;
                $scene = 'new';
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d h:i:s');
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d h:i:s');
            }
             $approve = $_POST['approve'];
            $model->attributes = $_POST['Vendor'];
            $model->approve  = $_POST['approve'];
            /* if($approve == 1){
                 $model->close_date  = date("Y-m-d H:i:s");
                 $model->closed_by = Yii::app()->user->id;
            }*/
            $model->isActive = $_POST['Vendor']['isActive'];
            $model->type = $_POST['Vendor']['type'];
            $model->vendor_address = $_POST['Vendor']['vendor_address'];
            $model->activity_type = $_POST['Vendor']['activity_type'];
            if($_POST['Vendor']['vendor_emirates_name'] != ''){
                $model->vendor_emirates_name = $_POST['Vendor']['vendor_emirates_name'];
            }
            
             if ($_POST['SupplierDocs']['id'] > 0) {
                $docid =  $_POST['SupplierDocs']['id'];
                $modeldoc = $modeldoc->findByPK($docid);
                
            }
             $modeldoc->attributes = $_POST['SupplierDocs'];
            //$model->notes = $_POST['Vendor']['notes'];
            if(isset($_POST['VendorContact'])){
                if ($_POST['VendorContact']['id'] > 0) {
                    $id =  $_POST['VendorContact']['id'];
                    $modelcontact = $modelcontact->findByPK($id);
                    $modelcontact->updated_by = Yii::app()->user->id;
                    $modelcontact->updated_date_time =date('Y-m-d h:i:s');
                } else {

                    $modelcontact->created_by = Yii::app()->user->id;
                    $modelcontact->created_date_time = date('Y-m-d h:i:s');
                    $modelcontact->updated_by = Yii::app()->user->id;
                    $modelcontact->updated_date_time = date('Y-m-d h:i:s');
                }
                 $modelcontact->attributes = $_POST['VendorContact'];
                 $modelcontact->isActive = $_POST['VendorContact']['isActive'];
            }
             if(isset($_POST['FileNotes']) && $_POST['FileNotes']['notes'] != ''){
                    if ($_POST['FileNotes']['id'] > 0) {
                       $id =  $_POST['FileNotes']['id'];
                       $modelnote = $modelnote->findByPK($id);
                       $modelnote->updated_by = Yii::app()->user->id;
                       $modelnote->updated_datetime =date('Y-m-d h:i:s');
                   } else {

                       $modelnote->created_by = Yii::app()->user->id;
                       $modelnote->created_datetime = date('Y-m-d h:i:s');

                   }
                   $modelnote->attributes = $_POST['FileNotes'];
             }
            $valid = $model->validate();
            if($scene == 'new'){
                    $valid = $modelcontact->validate() && $valid;
            }
            if($valid){
                echo CJSON::encode( array('status' => 'success') );
                $model->save(); 
                // inserting to audit log
                AuditLog::saveAuditLogs(
                    'VENDOR',
                    Yii::app()->user->id,
                    $audit_type,
                    " with No: - {$model->id}  "
                );
                // end audit log
                $model->saveSublegder();
       
                if($scene == 'new'){
                    $modelcontact->vendor_id = $model->id;
                    $modelcontact->person_name = "Sales/Account";
                    $modelcontact->save(false);
                    $modelnote->customer_vendor_id = $model->id;
                    $modelnote->customer_vendor_type = 2;
                    if($modelnote->notes != ''){
                        $modelnote->save(false);
                    }
                    //Mail Settings
                    $model_mail_setting=Notification::model()->find(array('condition' => 'event_id="10"'));
                     Yii::import('application.controllers.front.MasternotificationController'); 
                    if($model_mail_setting->mail_required=='Y'){                       
                        MasternotificationController::sendmail(10,$model->id);
                    }
                    if($model_mail_setting->notification_required=='Y'){                    
                        MasternotificationController::sendnotification(10,$model->id);
                    }
                    if($model_mail_setting->sms_required=='Y'){                    
                        MasternotificationController::sendsms(10,$model->id);
                    }
                 }
                 
                 
                 if($_POST['SupplierDocs']['document']!='')
                {
                    if($_POST['SupplierDocs']['from_date']!='00/00/0000' && $_POST['SupplierDocs']['from_date']!=''){
                            $modeldoc->from_date = str_replace('/', '-', $_POST['SupplierDocs']['from_date']);
                            $modeldoc->from_date= date("Y-m-d", strtotime($modeldoc->from_date));
                    }
                    if($_POST['SupplierDocs']['to_date']!='00/00/0000' && $_POST['SupplierDocs']['to_date']!=''){
                            $modeldoc->to_date = str_replace('/', '-', $_POST['SupplierDocs']['to_date']);
                            $modeldoc->to_date= date("Y-m-d", strtotime($modeldoc->to_date));
                    }
                    $modeldoc->score = $_POST['SupplierDocs']['score'];
                    $modeldoc->supplier_id = $model->id;
                    $modeldoc->save(false);
                }

            } else {
                //echo 'inside error';
                    $error2 = $error3 =array();
                    if($scene == 'new'){
                          $error3 =  json_decode(CActiveForm::validate($modelcontact, '', false),true); 
                    }
                    $error1 = json_decode(CActiveForm::validate($model, '', false),true);
                    //if($modelshipping[0]->street_address == '')
                        //$error2 = json_decode(CActiveForm::validateTabular($modelshipping, '', false), true);
                    $error = CJSON::encode(array_merge_recursive($error1, $error2,$error3));
                        if ($error != '[]')
                            echo $error;

                
            }
        }
    }
   
    /*
     * function to list vendor conatcts
     */

    function actionGetContactList() {
        $model = new VendorContact();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $vendor_id = $_POST['vendor_id'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'person_name',
            1 => 'designation',
            2 => 'contact_phone_no',
            3 => 'isActive',
            4 => 'id',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.vendor_id = "' . $vendor_id . '"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition.=" AND (person_name LIKE '%" . $searchString . "%' OR designation LIKE '%" . $searchString . "%' OR contact_phone_no LIKE '%" . $searchString . "%')";
        }
        $or = 't.isActive ';
        $count = $model->count(array('condition' => $condition));
        $model = $model->with('vendor')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $or));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        foreach ($model as $row) {
            
            $st = "Blocked";
            if( $row['isActive'] =="Y"){
                $st = "Active";
            }

            $rowData[] = array($row['person_name'], $row['designation'], $row['contact_phone_no'], $st,
                '<div class="btn-wrap text-center"><button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'logistics/vendor/vendorcontactcreate&id=' . $row['id'] . '\',\'Edit Contact\',\'lg\')"><i class="fa fa-pencil"></i></button>
            </div>');
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    /*
     * function to save vendor contact
     */

    public function actionSaveContact() {
        $model = new VendorContact();
        $date = date("Y-m-d H:i:s");
        /*         * ********** START Code for Save ************** */
        if (isset($_POST['VendorContact'])) {

            if ((int) @$_POST['VendorContact']['id'] > 0) {
                $model->id = (int) $_POST['VendorContact']['id'];
                $model = $model->findByPK($model->id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = $date;
                $audit_type = 'UPDATED';
            } else {
                $audit_type = 'CREATED';
                //$model->crm_user_id = Yii::app()->user->id;
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = $date;
            }
            $model->vendor_id = $_POST['hid_vendor_id'];
            $model->attributes = $_POST['VendorContact'];
            $model->isActive = $_POST['VendorContact']['isActive'];
            //$model->notes = $_POST['VendorContact']['notes'];
            if ($model->save()) {
                // inserting to audit log
                AuditLog::saveAuditLogs(
                    'VENDOR',
                    Yii::app()->user->id,
                    $audit_type,
                    " Contact with No: - {$model->id}  "
                );
                // end audit log
                $jsonData['status'] = 'success';
                $jsonData['frm'] = $_POST['vendor_contact_form'];
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    public function actionSaveNote() {
        $model = new FileNotes();
        $date = date("Y-m-d H:i:s");
        /*         * ********** START Code for Save ************** */
        if (isset($_POST['FileNotes'])) {

          
                //$model->crm_user_id = Yii::app()->user->id;
            $model->created_by = Yii::app()->user->id;
            $model->created_datetime = $date;
            $model->attributes = $_POST['FileNotes'];
            $model->customer_vendor_type =2;
            //$model->notes = $_POST['VendorContact']['notes'];
            if ($model->save()) {
                //die();
                $jsonData['status'] = 'success';
                $jsonData['frm'] = $_POST['notes_details_2'];
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
                
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    /*
     * function to delete vendor contact
     */

    public function actionDeleteContact() {
        $id = $_POST['id'];
        $model = new VendorContact();
        $model->deleteByPk($id);
        echo "success";
    }

    /*
     * function to delete vendor
     */

    public function actionDeleteVendor() {
        $id = $_POST['id'];
        $model = Vendor::model()->findByPk($id);
        if (!empty($model)) {
            $model->isActive = "N";
            $model->save(false);
            echo "success";
        } else {
            echo "fail";
        }
    }

 public function actionGetVendor() {
        $from = $_GET['frm'];
        $searchTerm = $_GET['term'];
        $condition = 'vendor_name LIKE "%' . $searchTerm . '%"';
        $model = new Vendor();
        $model = $model->findAll(array('condition' => $condition));
        $i = 0;
        foreach ($model as $eachModel) {
            $data[$i]['value'] = $eachModel->id;
            $vendor_location = ucfirst(trim($eachModel->vendor_location));
            $vendor_name = $eachModel->vendor_name;
            if(!empty($customer_location)){
                $vendor_name = $eachModel->vendor_name." [".$vendor_location."]";
            }
            
            $data[$i]['label'] = $vendor_name;
            $i++;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }
    
    public function actionGetCurrency() {
        $vendor_id = $_POST['vendor_id'];
        $data = array();
        $model = new PurchasingOrder;
        if($vendor_id > 0){
             $vendor = Vendor::model()->findByPk($vendor_id);
             //$modshipaddress = VendorShippingDetails::model()->findByPk($vendor_id);
            $data['billaddress'] = $vendor->vendor_address . ", PO Box : " . $vendor->vendor_postal_code . "," . $vendor->vendor_city . "," . $vendor->country->country_name;
            $data['shipaddress'] = $vendor->vendor_address . ", PO Box : " . $vendor->vendor_postal_code . "," . $vendor->vendor_city . "," . $vendor->country->country_name;
            //$data['shipaddress'] = $modshipaddress->street_address . ", PO Box : " . $modshipaddress->postal_code . "," . $modshipaddress->city . "," . $modshipaddress->country->country_name;
            
             $model->currency  = $vendor->vendor_currency_id;
             $model->payment_terms = $vendor->vendor_payment_term;
             $data['currency']  =  CHtml::activedropDownList($model, 'currency', MasCurrency::getCurrency(), array('onChange' => 'getExchangeRate(this.id)','class' => 'tooltipster', 'title' => 'Currency', 'data-label' => 'Currency', 'prompt' => '-select-')); 
             $data['payterm'] = CHtml::activedropDownList($model, 'payment_terms', MasPaymentTerm::getPaymentTerms(), array('class' => '','title' => 'Select Payment Terms','data-label'=>'Payment Terms <span style="color:red;">*</span> ')); 
             $data['exchange_rate']  = $vendor->currency_detail->exchange_rate;
             
             //code added by mereena on 04/02/2020
            $models = VendorContact::getVendorContacts($vendor_id);
            
            $drop = '<li class="col-sm-2">';
            $model = new PurchasingOrder;
            $drop .= CHtml::activedropDownList($model, 'vendor_contact_id', $models, array('empty' => 'Select', 'class' => 'tooltipster', 'title' => 'Please Select Contact', 'data-label' => 'Contact <span style="color:red">*</span>', 'data-search' => true, 'empty' => '--Select--'));
            $drop .= '</li>';
            $data['contact']  = $drop;
             //end
        }
         echo CJSON::encode($data);
    }
    public function actionGetVendorCurrency() {
        $vendor_id = $_POST['vendor_id'];
        $data = array();
        $model = new DirectPurchaseOrderGeneral;
        if($vendor_id > 0){
             $vendor = Vendor::model()->findByPk($vendor_id);
             //$modshipaddress = VendorShippingDetails::model()->findByPk($vendor_id);
            $data['billaddress'] = $vendor->vendor_address . ", PO Box : " . $vendor->vendor_postal_code . "," . $vendor->vendor_city . "," . $vendor->country->country_name;
            $data['shipaddress'] = $vendor->vendor_address . ", PO Box : " . $vendor->vendor_postal_code . "," . $vendor->vendor_city . "," . $vendor->country->country_name;
            
            //$data['shipaddrss'] = $modshipaddress->street_address . ", PO Box : " . $modshipaddress->postal_code . "," . $modshipaddress->city . "," . $modshipaddress->country->country_name;
            
             $model->currency  = $vendor->vendor_currency_id;
             //$model->payment_terms = $vendor->vendor_payment_term;
             $data['currency']  =  CHtml::activedropDownList($model, 'currency', MasCurrency::getCurrency(), array('onChange' => 'getExchangerate(this.value)','class' => 'tooltipster', 'title' => 'Currency', 'data-label' => 'Currency')); 
             //$data['payterm'] = CHtml::activedropDownList($model, 'payment_terms', MasPaymentTerm::getPaymentTerms(), array('class' => '','title' => 'Select Payment Terms','data-label'=>'Payment Terms <span style="color:red;">*</span> ')); 
             $data['exchange_rate']  = $vendor->currency_detail->exchange_rate;
        }
         echo CJSON::encode($data);
    }

    public function actionSetMenu() {
        echo Yii::app()->session['selected_menu'] = $_POST['menu_name'];
    }
    
    
     public function actionUploadSupplierDocuments($folder = null) {
        Yii::import("ext.EAjaxUpload.qqFileUploader");
        $field_id = "";
        if(isset($_GET['field_id']))
        {
            $field_id = Yii::app()->request->getParam('field_id');
        }
        
        $folder = Yii::getPathOfAlias('webroot') . '/' . $folder . '/';
        // make the directory to store the pic:
        if (!is_dir($folder)) {
            mkdir($folder, 0777, TRUE);
        }
        $allowedExtensions = array("jpg","png","doc","docx","xls","xlsx","pdf","bmp","jpeg"); //array("jpg","jpeg","gif","exe","mov" and etc...
        $sizeLimit = 2 * 1024 * 1024; // maximum file size in bytes
        $uploader = new qqFileUploader($allowedExtensions, $sizeLimit);
        $result = $uploader->handleUpload($folder);
        $result['fileType'] = pathinfo($folder . $result['filename'], PATHINFO_EXTENSION);
        $result['field_id'] = $field_id;
        $return = htmlspecialchars(json_encode($result), ENT_NOQUOTES);
        $fileName = $result['filename']; //GETTING FILE NAME
        $imagename	=	Yii::app()->basePath.'/../uploads/supplierdocuments/'.$fileName;
       // $imagename_thumb	=	Yii::app()->basePath.'/../upload/hiring/thumbs/'.$fileName;
       // Yii::import("ext.EPhpThumb.EPhpThumb");
       // $thumb=new EPhpThumb();
       // $thumb->init(); //this is needed
        //chain functions
        //$thumb->create($imagename)->resize(100,100)->save($imagename_thumb);
        echo $return; // it's array
    }
     public function actionCreateDocumentForm() {
        
        $model = new Vendor();
        $modeldoc = new SupplierDocs();
        $id = (int) Yii::app()->request->getParam('id');
        $supplier_id = (int) Yii::app()->request->getParam('c_id');
        if ($id > 0) {
            $modeldoc= $modeldoc->findByPk($id); 
            $supplier_id=$modeldoc->supplier_id ;
        }
        if ($supplier_id > 0) {
            $model= $model->findByPk($supplier_id);
            $modeldoc->supplier_id =$supplier_id;
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
        $this->render('doc_form', array('model' => $model,'modeldoc' => $modeldoc,'c_id' => $supplier_id));
    }
    
    
     public function actionSaveDocForm(){
        $model   = new SupplierDocs();
        $id      = $_POST['SupplierDocs']['id']; 
        if ($_POST['SupplierDocs']['id'] > 0) {
            $model= $model->findByPk($id);            
        }
        $model->attributes = $_POST['SupplierDocs'];
        $model->score = $_POST['SupplierDocs']['score'];
        if($_POST['SupplierDocs']['from_date']!='00/00/0000' && $_POST['SupplierDocs']['from_date']!=''){
            $model->from_date = str_replace('/', '-', $_POST['CustomerDocs']['from_date']);
            $model->from_date= date("Y-m-d", strtotime($model->from_date));
        }
        if($_POST['SupplierDocs']['to_date']!='00/00/0000' && $_POST['SupplierDocs']['to_date']!=''){
            $model->to_date = str_replace('/', '-', $_POST['SupplierDocs']['to_date']);
            $model->to_date= date("Y-m-d", strtotime($model->to_date));
        }
        if ($model->save()) {
            $jsonData['status'] = 'success';
            $jsonData['frm'] = $_POST['SupplierDocs'];
            $jsonData['id'] = $model->id;
            echo CJSON::encode($jsonData);

        } else {
            $error = CActiveForm::validate($model, '', false);
            if ($error != '[]')
                echo $error;
        }
    }
    
    
    public function actionGetDocsList() {
        $model = new SupplierDocs();
        $vendor_id = $_POST['vendor_id'];
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
             1 => 'document_type',
            2 => 'document_no',
           
            3 => 'to_date',
            4=> 't.id',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        if($vendor_id>0){
            $condition = 't.supplier_id=' . $vendor_id;
        }else{
            $condition = '1=1';
        }         
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition.=" AND (t.document_no LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('sup_details')->count(array('condition' => $condition));
        $model = $model->with('sup_details')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 't.id DESC'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $type=$row['document_type'];
            $model1  = MasDocumentType::model()->findAll(array('condition'=>'id=' .$type));
           $document_type=$model1[0]['document_type'];
            $edit ='<div class="btn-wrap text-center"><button class="btn btn-primary btn-xs" title ="Edit" onclick="loadPopupModal(\'vendor/createDocumentform&id='.$row['id'].'\',\''.$row['id'].' : '.$row['sup_details']['vendor_name'].'\',\'lg\')"><i class="fa fa-pencil"></i></button> ';
            $edit .= ' <a title= "Download" href ="'. Yii::app()->createUrl('vendor/downloaddocument&id='.$row['id']).'" class=" btn btn-primary btn-xs"><i class="fa fa-download"></i></a>';
            $rowData[] = array($m,$document_type, $row['document_no'],date("d/m/Y",strtotime($row['to_date'])),$edit);
            $m++;
            
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    
    public function actionDownloadDocument() {
        $id = (int) Yii::app()->request->getParam('id'); 
        $arr_employee_doc = SupplierDocs::model()->findByPk($id);
        $file = $arr_employee_doc->document;
        $arr_doc_val = explode(',', $arr_employee_doc->document);
        $path = Yii::getPathOfAlias('webroot') . "/uploads/supplierdocuments/" . $file;
        header("Content-type:application/octet-stream"); //for txt file
        header("Content-Type: application/download");
        //header('Content-Type:text/plain; charset=ISO-8859-15');
        //if you want to read text file using text/plain header
        header('Content-Disposition: attachment; filename="' . basename($path) . '"');
        header('Content-Length: ' . filesize($path));
        readfile($path);
        Yii::app()->end();        
    }
    public function  actionCheckTrnExistance(){
        $terms = $_POST['trn_no'];
        $term = ltrim($terms);
        $status=array();    
        if($term != ''){
            $store = Vendor::model()->findAll(array('condition' => 'vendor_trn_no = "'.$term.'"'));
            if(!empty($store)){
                $status['status'] = 'exist';
            }else{
                $status['status'] = 'not_exist';
            }
        }
        echo CJSON::encode($status);
    }
    
    
    public function actionGetVendorByType(){
        $agent_id = (int) Yii::app()->request->getParam('agent_id'); 
        $model = new PurchasingOrder();
        $modelVendor = Vendor::model()->findAll(array('condition'=>'type='.$agent_id));
        $vendor_list = CHtml::listData($modelVendor, 'id', 'vendor_name');
        $data['vendorlist']  =  CHtml::activedropDownList($model, 'vendor_id', $vendor_list, array('onChange' => 'getContactCurrencyDetails(this.value)','class' => 'tooltipster', 'title' => 'Supplier', 'data-label'=>'Supplier <span style="color:red;">*</span>','prompt'=>'-select-','data-search' => true)); 
         echo CJSON::encode($data);
    }
    
    public function actionGetVendorVolumeWeight(){
        $vendor_id = (int) Yii::app()->request->getParam('vendor_id'); 
        $arr_vendor_details = Vendor::model()->findByPk($vendor_id);
        $vendor_volume_weight_price = $arr_vendor_details->volume_weight_price;
        $vendor_volume_weight_cbm = $arr_vendor_details->volume_weight_cbm;
        $data['vendor_volume_weight_price'] = $vendor_volume_weight_price;
        $data['vendor_volume_weight_cbm']   = $vendor_volume_weight_cbm;
        echo CJSON::encode($data);
    }
     
    public function actionGetVendorActivityType(){
        $shipper_id = (int) Yii::app()->request->getParam('shipper_id'); 
        $model = new Vendor();
        $model = $model->findByPk($shipper_id);
        $data['activity_type']   = $model->activity_type;
        echo CJSON::encode($data);
    }
    

}
