<?php

class UsersController extends Controller
{
        public function accessRules() {
            return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                  'actions' => array('login', 'error', 'logout'),
                  'users' => array('*'),
                  ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                  'actions' => array('Index','Create','GetList','SaveUsers','DeleteUsers','SalesMaster','GetSalesList','Target','SaveTarget','UploadSignature',
                                    'BlockUser','DocumentsUpload','RemovelineItem','deleteuploadedfile'),
                  'expression' => '$user->isMember()',
                  ),
                array('deny', // deny all users
                  'users' => array('*'),
                  ),
                );
        }
    
	public function filters()
    {
        return array(
            'accessControl', // perform access control for CRUD operations
            );
    }
	public function actionIndex()
	{
		$this->render('index');
	}
        public function actionGetList()
        {
                $model=new User();
                $draw    = $_POST['draw'];
                $offset = $_POST['start'];
                $limit  = $_POST['length'];
                $columns = array(
                // datatable column index  => database column name
                   0 =>'username',
                   1 => 'first_name',
                    2 => 'designation',
                    3 => 'user_group_id',

                   );
                $filterColumn = $columns[$_POST['order'][0]['column']];
                $filterOrder  = $_POST['order'][0]['dir'];
                $orderBy   = $filterColumn." ".$filterOrder;
                //$condition = 't.level!=0 AND t.isActive="Y" ';
                $condition = 't.isActive="Y" AND t.level=1 AND company_id='.Yii::app()->user->master_user_company_id;
               if(isset($_POST['display_type']) && $_POST['display_type']==2){

                    $condition = 't.isActive="Y" AND t.level!=0 AND company_id='.Yii::app()->user->master_user_company_id;
                }
                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
                {
                  $searchString = $_POST['search']['value'];
                  $condition .=" and (username LIKE '%".$searchString."%' OR first_name LIKE '%".$searchString."%' OR designation LIKE '%".$searchString."%' OR user_group_id LIKE '%".$searchString."%')";
                }
                /*else{
                    $condition.=" AND t.level=1";
                }*/

               /* */

                $count = $model->count(array('condition'=>$condition));
                $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=> 'username'));
                $recordsTotal = $count;
                $recordsFiltered = $count;
                $data['draw'] = $draw;
                $data['recordsTotal'] = $recordsTotal;
                $data['recordsFiltered'] = $recordsFiltered;
                $rowData=array();
                $m = 1;

                  foreach ($model as $row)
                {
                    $div = '';
                    if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["admin_users_edit"])){
                      //  $div .= ' <button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'users/create&id='.$row['id'].'\',\'Users\',\'lg\')"><i class="fa fa-pencil"></i></button>';
                    }
//                    if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["admin_users_delete"])){
//                        $div .= ' <a href ="#" class="btn btn-danger btn-xs" onclick="deleteUsers('.$row['id'].')"><i class="fa fa-trash-o "></i></a>';
//                    }
                    $rowData[]=array($m,
                        $row['username'],
                        $row['first_name']." ".$row['last_name'],
                        $row['designation'],
                        $row->userGroup->group_name,
                        '<div class="btn-wrap text-center">'.$div.'</div>',
                       array('id' => $row['id'],'code'=>$row['username'],'level'=>$row['level']));

                    $m++;

                       }


//                foreach ($model as $row)
//                {
//                    $rowData[]=array($m,$row['username'],$row['first_name']." ".$row['last_name'],$row['designation'],$row->userGroup->group_name,'<div class="btn-wrap text-center"><button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'users/create&id='.$row['id'].'\',\'Users\',\'lg\')"><i class="fa fa-pencil"></i></button> '
//             .'<a href ="#" class="btn btn-danger btn-xs" onclick="deleteUsers('.$row['id'].')"><i class="fa fa-trash-o "></i></a></div>');
//                    $m++;
//                }
                $data['data'] = $rowData;
                echo json_encode($data);
        }
         public function actionCreate()
        {
            $model=new User();
            $model_documents = new UserDocument();
            $id = (int) Yii::app()->request->getParam('id');
            if($id>0){
                $model=$model->findByPk($id);
                  $model_documents = $model_documents->findAll(array('condition' => 'user_id="' . $id . '"'));
            }
                Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('users_form', array('model' => $model,'model_documents' => $model_documents), false, false);
        }


        public function actionSaveUsers()
        {
            $model = new User();
           
            if (isset($_POST['User']))
            {
    		    if ((int) @$_POST['User']['id'] > 0)
                {   $model->updated_by = Yii::app()->user->id;
                    $model->updated_date_time =date('Y-m-d h:i:s');
                    $id= (int) @$_POST['User']['id'];
                    $model=$model->findByPk($id);
                    $audit_type = 'UPDATED';
                }
                else{
                    $model->created_by = Yii::app()->user->id;
                    $model->created_date_time =date('Y-m-d h:i:s');
                $model->scenario='add';
                $audit_type = 'CREATED';
                }
                $model->attributes=$_POST['User'];
                $model->is_lead_owner = $_POST['User']['is_lead_owner'];
                $model->signature = $_POST['User']['signature'];
                $model->level='1';
                //$company=MasCompany::model()->findByPk(Yii::app()->user->master_user_company_id);
                $model->company_id=Yii::app()->user->master_user_company_id;
                $valid = $model->validate();
                $p = 0;
           
            $modelDocArray = [];
            if(!empty($_POST["UserDocument"])){
            foreach ($_POST["UserDocument"] as $key => $each) {
                if($each['id']>0){
                    $modelDocArray[$key] = UserDocument::model()->findByPK($each['id']); 
                    $modelDocArray[$key]->updated_by= Yii::app()->user->id;
                    $modelDocArray[$key]->updated_date_time = date('Y-m-d H:i:s');
                }else{
                    $modelDocArray[$key] = new UserDocument(); 
                    $modelDocArray[$key]->created_by= Yii::app()->user->id;
                    $modelDocArray[$key]->created_date_time = date('Y-m-d H:i:s');
                } 

                 $modelDocArray[$key]->attributes = $each;
               
                
               

            }
        }
                 if ($valid) {
               
                $model->save();
                foreach ($modelDocArray as $value) {
                    // print_r($value->document);exit;
                    $value->user_id = $model->id;
                  
                    
                    $value->save();
                }
                          // inserting to audit log
                          AuditLog::saveAuditLogs(
                            'USER',
                            Yii::app()->user->id,
                            $audit_type,
                            " with username: - {$model->username}  ",
                            "",
                            ""
                        );
                        $jsonData['status'] = 'success';
                        $jsonData['frm'] = $_POST['users_form'];
                        $jsonData['id'] = $model->id;
	                echo CJSON::encode($jsonData);
                }
                else
                {
                        $error = CActiveForm::validate($model, '', false);
                        if ($error != '[]')
		               echo $error;
                }

            }
        }
        public function actionDeleteUsers(){
		$id = $_POST['id'];
                $model=new User();
                $model->deleteByPk($id);
                echo "success";
    }
    public function actionGetSalesList() {
        $model = new User();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'username',
            1 => 'first_name',
            2 => 'designation',
            3 => 'user_group_id',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = "userGroup.group_name LIKE '%sale%'  ";
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " and ( username LIKE '%" . $searchString . "%' OR first_name LIKE '%" . $searchString . "%' OR designation LIKE '%" . $searchString . "%' OR user_group_id LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('userGroup')->count(array('condition' => $condition));
        $model = $model->with('userGroup')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        //$model = User::getUserFromSalesGroup($condition, $orderBy, $limit, $offset);
        //$count = count(User::getCountUserFromSalesGroup($condition));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;

        foreach ($model as $row) {
            $div = '';
            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["admin_users_edit"])) {
                $div = ' <button class="btn btn-primary btn-xs" title="Sales Target" onclick="loadPopupModal(\'salestarget/create&id=' . $row['id'] . '\',\'Sales Target - ' . $row['first_name'] . ' ' . $row['last_name'] . ' \',\'xl\')"><i class="fa fa-history"></i></button>';
                $div .= ' <button class="btn btn-primary btn-xs" title="Activity Target" onclick="loadPopupModal(\'users/target&id=' . $row['id'] . '\',\'Activity Target - ' . $row['first_name'] . ' ' . $row['last_name'] . ' \',\'lg\')"><i class="fa fa-tag"></i></button>';
            }
            $rowData[] = array(
                                    $m, 
                                    $row['username'], 
                                    $row['first_name'] . " " . $row['last_name'], 
                                    $row['designation'], 
                                    $row->userGroup->group_name,
                                    '<div class="btn-wrap text-center">' . $div . '</div>');

            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
        public function actionTarget()
	{
               $user_id = Yii::app()->request->getParam('id');
            $model = new SalesManTarget;
            if ($user_id > 0) {
                $model = $model->findAll(array('condition' => 'user_id = ' . $user_id . ' '));
            } else {
                $model = array(new SalesManTarget);
            }
            $targetContents = ProspectsActivityMaster::model()->findAll(array('condition' => 'isActive = "Y" '));
            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('target_form', array('model' => $model, 'targetContents' => $targetContents, 'user_id' => $user_id));
	}
       public function actionSaveTarget() {
        SalesManTarget::model()->deleteAll('user_id=:refer_id', array(':refer_id' => $_POST['SalesManTarget'][0]['user_id']));
        if (is_array($_POST['SalesManTarget'])) {
            foreach ($_POST['SalesManTarget'] as $item) {

                $model = new SalesManTarget();
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('y-m-d h:i:s');
                $model->user_id = $item['user_id'];
                $model->target_type = $item['target_type'];
                $model->target_master_id = $item['target_master_id'];
                $model->target_daily = $item['target_daily'];
                $model->target_weekly = $item['target_weekly'];
                $model->target_monthly = $item['target_monthly'];
                $model->target_quarterly = $item['target_quarterly'];
                $model->target_yearly = $item['target_yearly'];
                $model->save(false);
                
            }
        }
        // inserting to audit log
        $user = new User();
        AuditLog::saveAuditLogs(
           'SALES_TARGET',
           Yii::app()->user->id,
           'UPDATED',
           " for username : - ". $user->findByPk($_POST['SalesManTarget'][0]['user_id'])->username
       );
       // end audit log
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
    }
    public function actionSalesMaster()
	{
		$this->render('sales_list');
	}
    public function actionUploadSignature($folder = null) {
        Yii::import("ext.EAjaxUpload.qqFileUploader");
        $folder = Yii::getPathOfAlias('webroot') . '/' . $folder . '/';
        // make the directory to store the pic:
        if (!is_dir($folder)) {
            mkdir($folder, 0777, TRUE);
        }
        $allowedExtensions = array();
        $sizeLimit = 1 * 1024 * 1024; // maximum file size in bytes
        $uploader = new qqFileUploader($allowedExtensions, $sizeLimit);
        $result = $uploader->handleUpload($folder);
        $result['fileType'] = pathinfo($folder . $result['filename'], PATHINFO_EXTENSION);
        $return = htmlspecialchars(json_encode($result), ENT_NOQUOTES);
        $fileName = $result['filename']; //GETTING FILE NAME
        //$this->CropIfImage($folder, $fileName);
        echo $return; // it's array

    }
    //  function CropIfImage($folder, $fileName) {
    //     $imagefile = getimagesize($folder . $fileName);
    //     if (is_array($imagefile)) {
    //         $width =150;
    //         $height =200;
    //         $thumb = Yii::app()->phpThumb->create($folder . '/' . $fileName);
    //         $thumb->resize($width, $height);
    //         $thumb->save($folder . '/' . $width . $height . '_' . $fileName);
    //     }

    //}
    public function actionBlockUser() {
        $id = $_POST['id'];
        if($id>0){
            User::model()->updateByPK($id, array('isActive' => "N"));
            $status['status'] = 'success';
        }else{
            $status['status'] = 'error';
        }  
        echo CJSON::encode($status);
    }
      public function actionDocumentsUpload($folder = null, $filename = null) {
        Yii::import("ext.EAjaxUpload.qqFileUploader");
        $field_id = "";
        if (isset($_GET['field_id'])) {
            $field_id = Yii::app()->request->getParam('field_id');
        }
        if (empty($filename)) {
            $filename = 'Documents_' . date('YmdHis');
        }
        $folder = Yii::getPathOfAlias('webroot') . '/' . $folder . '/';

        // make the directory to store the pic:
        if (!is_dir($folder)) {
            mkdir($folder, 0777, TRUE);
        }

        $allowedExtensions = array("png", "jpg", "jpeg", "gif", "pdf", "doc", "docx", "xls", "xlsx", "csv");
        $sizeLimit = 20 * 1024 * 1024;

        $uploader = new qqFileUploader($allowedExtensions, $sizeLimit);
        $result = $uploader->handleUpload($folder, FALSE, $filename);
        $result['fileType'] = pathinfo($folder . $result['filename'], PATHINFO_EXTENSION);
        $result['field_id'] = $field_id;
        $return = htmlspecialchars(json_encode($result), ENT_NOQUOTES);
        echo $return;
    }

    
     public function actionRemovelineItem(){
        $id = $_POST['id'];
         if($id>0){        
             UserDocument::model()->deleteByPk($id);
             $status['status'] = 'success';
         }
         else{
            $status['status'] = 'error';
         }
        
         echo CJSON::encode($status);
     
     }
      public function actiondeleteuploadedfile() {
        $id = $_POST['id'];
        $file_name = $_POST['file_name'];
        $key = $_POST['row_field'];
       
        $model = UserDocument::model()->findByPk($id);
         $path = "uploads/user_documents/".$model->document;
        unlink($path);
         if ($id > 0){   
       
           UserDocument::model()->updateByPK($id, array('document' => ""));
            $status['status'] = 'success';
        }
            else{
            $status['status'] = 'error';
        }
       
         echo CJSON::encode($status);
           
        
    }
}